/*
 *  example1.cpp : Defines the entry point for the console application.
 *
 *  An example program which create a new test table, 
 *  and adds new records to this table. Prints column 
 *  info and all inserted records.
 *
 *  This example program demonstrates the use C-style functions, 
 *  which are exported from OCL DLL.
 *  
 *
 */

#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../oracall32.h"

int main(int argc, char* argv[])
{
	printf("Start connect...\n\n");

	// Establish a connection to the given database 
	CConnection* con = SYAllocConnect("med", "med", "");
	
	// Create a test table
	SYExecuteUpdate(con, "DROP TABLE test");
	SYExecuteUpdate(con, "CREATE TABLE test (ID_TEST INTEGER NOT NULL, Details CLOB DEFAULT EMPTY_CLOB() NULL, Name VARCHAR2(20) NULL, NDecimal DECIMAL(6,2) NULL, NFloat FLOAT DEFAULT 0 NULL, Datetime DATE DEFAULT SYSDATE NULL)");
	
	printf("Created the Test table.\n\n");
	
	tm time; 
	time.tm_sec = 1;
	time.tm_min = 50;
	time.tm_hour = 11;
	time.tm_mday = 24;
	time.tm_mon = 3;
	time.tm_year = 91;

	COCIDate date(&time);
	double ndec = 22.13;
	float  nfloat = 23.56;
	char str[] = "Name0";

	// adding new records to the table 
	CStatement* stm = SYPrepare(con, "INSERT INTO test (id_test, name, ndecimal, nfloat, datetime) VALUES(:1, :2, :3, :4, :5)");
	
	for(int i = 0; i < 5; i++)
	{
		str[4] = 0x30 + i;
		ndec = ndec + i;
		nfloat = nfloat + i;
		date.datetime[3] = 1 + i;
		
		SYSetParamInteger(stm, 1, &i);
		SYSetParamString(stm, 2, str);
		SYSetParamDouble(stm, 3, &ndec);
		SYSetParamFloat(stm, 4, &nfloat);
		SYSetParamDate(stm, 5, &date);
		SYExecutePrepared(stm);
		printf("Inserted %d row.\n\n", i);
	}
	
/*	////////////////////////////////////////////////////////
	// test 
	stm = SYPrepare(con, "INSERT INTO test (id_test) VALUES(:1)");
	
	for(; i < 500; i++)
	{
		SYSetParamInteger(stm, 1, &i);
		SYExecutePrepared(stm);
		printf("Inserted %d row.\n\n", i);
	}

	SYFreeConnect(con);
	printf("End connect.\n\n", i);
	return 0;
*/	////////////////////////////////////////////////////////

	CResultSet* rs = SYExecuteSQL(con, "SELECT * FROM test FOR UPDATE");
	
	short fields = SYGetFieldInfoCount(rs);

	// Output column info
	for(i = 0; i < fields; i++)
	{
		CFieldInfo fi;
		SYGetFieldInfo(rs, i, fi);
		printf("column=%s  dtype=%d  dsize=%d  precision=%d  scale=%d\n\n", fi.name, fi.dtype, fi.dsize, fi.precision, fi.scale);
		fflush(stdout);
	}

	printf("-------------------------------\n\n");
	fflush(stdout);
	
	int row = 0, out;
	char buff[256], bclob[18];

	// Output all rows from the test table
	while(!SYNext(rs))
	{
		for(int j = 0; j < fields; j++)
		{
//			SYGetDate(rs, j, &time);
//			strcpy(buff, asctime(&time));
			SYGetString(rs, j, buff, 256);
			
			// write
//			SYWriteClob(rs, j, "This is a simple test string...");

			// read
//			for(bool ready = true; ready; )
//			{
//				ready = SYReadClob(rs, j, bclob, 18);
//				strcat(buff, bclob);
//			}
			
			printf("row=%d, column=%d, lob_lenth=%d, value=%s [%f]\n\n", row, j, SYGetLobLenth(rs, j), buff, SYGetDouble(rs, j));
			fflush(stdout);
		}	

		row++;
	}
	
	// disconnect from database
	SYFreeConnect(con);
	printf("End connect.\n\n", i);

	return 0;
}
