// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: strutil.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 12/16/1997 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The string utilities are a collection of data structures and 
standalone functions used to manipulate and parse null terminated 
character strings.
*/
// ----------------------------------------------------------- //   
#ifndef __GX_STRUTIL_HPP__
#define __GX_STRUTIL_HPP__

// String concatenation routines
char *StringCat(const char *s1=" ", const char *s2= " ", const char *s3=" ");
char *StringCat(char *s1=" ", char *s2= " ", char *s3=" ");

// General purpose string parser 
const int MAXWORDLENGTH = 255;
const int MAXWORDS = 255;

int parse(char *string, char words[MAXWORDS][MAXWORDLENGTH],
	  int *numwords, char sepchar);

// Case insensitive string compare that need to be ported from UNIX to DOS  
int CaseICmp(const char *s1, const char *s2);
int CaseICmp(char *s1, char *s2);

// String searching functions
unsigned FindMatch(const char *str, const char *p, unsigned offset = 0);
unsigned FindMatch(char *str, char *p, unsigned offset = 0);
unsigned IFindMatch(const char *str, const char *p, unsigned offset = 0);
unsigned IFindMatch(char *str, char *p, unsigned offset = 0);

#endif  // __GX_STRUTIL_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
