// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: asprint.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/18/1997  
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

These classes and functions are used to print data to ASCII
text files and format data for various print functions.
*/
// ----------------------------------------------------------- // 
#include "asprint.h"
#include <stdio.h>
#include <string.h>

void ASPrint(const char *s, ostream &stream, int offset, int pos,
	     const char pad)
// Prints a null terminated string to the stream starting at the
// specified position or the current position if the pos variable
// equals zero. The offset variable specifies the number of character
// to pad after the text is printed.
{
  int i = 0;
  int len = strlen(s);
  char *buf = new char[len+1];
  buf[len] = '\0';
  strcpy(buf, s);
  if(len > offset) len = offset-1; // Subtract 1 to avoid overlaps
  if(pos) for(i = 0; i < pos; i++) stream << pad; // Position the text
  for(i = 0; i < len; i++) stream << buf[i];
  if(len < offset) {
    offset = offset - len;
    for(i = 0; i < offset; i++) stream << pad;
  }
  delete[] buf;
}

void ASPrint(const char *s, const char filter, ostream &stream, int offset,
	     int pos, const char pad)
// Prints a null terminated string to the stream starting and filters
// any unwanted characters specified by the filter variable.
{
  int i = 0;
  int len = strlen(s);
  char *buf = new char[len+1];
  buf[len] = '\0';
  strcpy(buf, s);
  if(len > offset) len = offset-1; // Subtract 1 to avoid overlaps
  if(pos) for(i = 0; i < pos; i++) stream << pad; // Position the text
  for(i = 0; i < len; i++) {
    // Filter all unwanted characters
    if(buf[i] != filter) stream << buf[i];
  }
  if(len < offset) {
    offset = offset - len;
    for(i = 0; i < offset; i++) stream << pad;
  }
  delete[] buf;
}

void ASPrint(const char c, ostream &stream, int offset, int pos,
	     const char pad)
// Prints a single character to the stream.
{
  char s[1];
  s[0] = c;    // Copy char into a string buffer
  s[1] = '\0'; // Null terminate the string
  ASPrint(s, stream, offset, pos, pad);
}
  
void ASPrint(int val, ostream &stream, int offset, int pos, const char pad)
{
  char *buf = new char[offset+1];
  buf[offset] = '\0';
  sprintf(buf, "%d", val);
  ASPrint(buf, stream, offset, pos, pad);
  delete[] buf; 
}

void ASPrint(long val, ostream &stream, int offset, int pos, const char pad)
{
  char *buf = new char[offset+1];
  buf[offset] = '\0';
  sprintf(buf, "%d", val);
  ASPrint(buf, stream, offset, pos, pad);
  delete[] buf; 
}

void ASPrint(double val, ostream &stream, int offset, int pos, const char pad)
{
  char *buf = new char[offset+1];
  buf[offset] = '\0';
  sprintf(buf, "%g", val);
  ASPrint(buf, stream, offset, pos, pad);
  delete[] buf; 
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
