// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: edscfg.cpp 
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 10/15/1999 
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Code used to test encrypted data sets. EDS version 2
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include <stdlib.h>
#include "eds201.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

void PrintEDSTable()
{
  eds2String eds;
  for(unsigned i = 0; i < eds2TableSize; i++) 
  cout << setfill('0') << setw(4) << hex << eds.eds2_table[i] << ' ';
  cout << endl;
}

void EncryptString(eds2WORD_t magic_number, const char *s)
{
  char *s1 = (char *)s;
  int len = strlen(s1);
  int i = 0;
  eds2String eds(magic_number);
  
  // Encrypt the string
  eds2WORD *eds_string = new eds2WORD[len];
  for(i = 0; i < len; i++) {
    eds_string[i] = eds.EncryptString((unsigned char)*s1++);
    cout << setfill('0') << setw(4) << hex << eds_string[i] << ' ';
  }
  cout << endl;

  // Decrypt the string
  int eds_len = len * sizeof(eds2WORD);
  int str_len = int((__LWORD__)eds_len/sizeof(eds2WORD));
  char *str = new char[str_len+1];
  for(i = 0; i < str_len; i++) {
    unsigned char c;
    str[i] = 0;
    if(eds.DecryptString(eds_string[i], c)) {
      str[i] = c;
    }
  }
  str[str_len] = 0; // Ensure null termination
  cout << str;
  cout << endl;

  delete eds_string;
  delete str;
}

int main(int argv, char **argc)
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  eds2WORD_t magic_number = eds2MagicNumber;   
  if(argv == 2) magic_number = atoi(argc[1]);

  const char *s1 = "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG 0123456789\n";
  const char *s2 = "the quick brown fox jumps over the lazy dog 0123456789\n";
  const char *s3 = "!@#$%^&*()-_=+[{]}\\|;:\'\",<.>/?`~\n";
  const char *s4 = "\t\n\r\b";
  
  cout << endl;
  cout << "Encrypting/Decrypting string number 1..." << endl;
  EncryptString(magic_number, s1);
  
  cout << "Encrypting/Decrypting string number 2..." << endl;
  EncryptString(magic_number, s2);
  
  cout << "Encrypting/Decrypting string number 3..." << endl;
  EncryptString(magic_number, s3);
    
  cout << "Encrypting/Decrypting string number 4..." << endl;
  EncryptString(magic_number, s4);

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
