/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.Card;
import com.rexbot.game.card.HandCalculator;
import com.rexbot.game.card.Main;
import com.rexbot.game.card.Opts;
import com.rexbot.game.card.Player;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.apache.log4j.Category;

public class Brain {
    public static Random rand = new Random();
    private Color myColor = Color.white;
    private static Category cat = Category.getInstance(class$com$rexbot$game$card$Brain == null ? (class$com$rexbot$game$card$Brain = Brain.class$("com.rexbot.game.card.Brain")) : class$com$rexbot$game$card$Brain);
    private static final int CHARGE = 0;
    private static final int TIP = 1;
    private static final int PULSE = 2;
    private static final int SRC = 3;
    private static final int DEST = 4;
    private static final int LAYERS = 5;
    private static final int ROWS = 50;
    private static final int CELS = 512;
    public int[][][] matrix = new int[50][512][5];
    private static final int FOLD_CEL = 511;
    private static final int BET_CEL = 510;
    private static final int RAISE_CEL = 509;
    private static final int BET_TO_ME_CEL = 200;
    private static final int POT_SIZE_CEL = 201;
    private static final int PLAYER_NUMBER_BASE = 202;
    private static final int RANDOM_CEL = 216;
    private static final int HAND_VALUE_BASE = 220;
    private Player player;
    static /* synthetic */ Class class$com$rexbot$game$card$Brain;

    public Brain(Player player) {
        cat.debug("New Scrambled Brain for player: " + player.getNumber());
        this.setPlayer(player);
        this.scramble();
    }

    public Brain(Player player, String fileName) throws IOException {
        cat.debug("New Brain for player: " + player.getNumber() + " from file: " + fileName);
        this.setPlayer(player);
        this.retrieve(fileName);
    }

    public void setColor(Color color) {
        this.myColor = color;
    }

    public Color getColor() {
        return this.myColor;
    }

    public void calcColor() {
        int even = 0;
        for (int h = 0; h < 50; ++h) {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 512; ++j) {
                    if (this.matrix[h][j][i] % 2 != 0) continue;
                    ++even;
                }
            }
        }
        this.setColor(new Color(even * 16777));
    }

    public static void mate(Brain mate1, Brain mate2, Brain doner, Brain doner2) {
        cat.debug(mate1.getPlayer().getNumber() + "/" + mate2.getPlayer().getNumber() + " are Mating and will replace: " + doner.getPlayer().getNumber() + "/" + doner2.getPlayer().getNumber());
        int mutationRatio = Opts.getInstance().getMutationRate();
        int breakpoint = rand.nextInt(512);
        for (int h = 0; h < 50; ++h) {
            for (int i = 0; i < 5; ++i) {
                int j;
                for (j = 0; j < breakpoint; ++j) {
                    doner.matrix[h][j][i] = mate1.matrix[h][j][i];
                    doner2.matrix[h][j][i] = mate2.matrix[h][j][i];
                    if (rand.nextInt(mutationRatio) == 1) {
                        doner.matrix[h][j][i] = rand.nextInt(512);
                    }
                    if (rand.nextInt(mutationRatio) != 1) continue;
                    doner2.matrix[h][j][i] = rand.nextInt(512);
                }
                for (j = breakpoint; j < 512; ++j) {
                    doner.matrix[h][j][i] = mate2.matrix[h][j][i];
                    doner2.matrix[h][j][i] = mate1.matrix[h][j][i];
                    if (rand.nextInt(mutationRatio) == 1) {
                        doner.matrix[h][j][i] = rand.nextInt(512);
                    }
                    if (rand.nextInt(mutationRatio) != 1) continue;
                    doner2.matrix[h][j][i] = rand.nextInt(512);
                }
            }
        }
        doner.calcColor();
        doner2.calcColor();
    }

    public void scramble() {
        for (int h = 0; h < 50; ++h) {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 512; ++j) {
                    this.matrix[h][j][i] = rand.nextInt(512);
                }
            }
        }
        this.calcColor();
    }

    public void print(int level) {
        for (int h = 0; h < 50; ++h) {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < 512; ++j) {
                sb.append(Long.toString(this.matrix[h][j][level]));
                sb.append(".");
            }
            System.out.println(sb.toString());
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public long makeDecision(long betToMe, long potSize, int playerPos) {
        this.setupInput(betToMe, potSize, playerPos);
        this.think(2);
        return this.getOutput();
    }

    public void setupInput(long betToMe, long potSize, int playerPos) {
        Object[] cards = this.getPlayer().getHand().getCards().toArray();
        for (int h = 0; h < 50; ++h) {
            int i;
            for (i = 0; i < 512; ++i) {
                this.matrix[h][i][0] = 0;
            }
            for (i = 0; i < cards.length; ++i) {
                Card card = (Card)cards[i];
                int pos = card.getSuit();
                this.matrix[h][pos += i * 4][0] = 256;
                pos = 30;
                pos += card.getPokerValue();
                this.matrix[h][pos += i * 20][0] = 256;
            }
            this.matrix[h][202 + playerPos][0] = 256;
            this.matrix[h][200][0] = (int)betToMe;
            this.matrix[h][201][0] = (int)potSize;
            this.matrix[h][216][0] = rand.nextInt(512);
            long value = HandCalculator.getPokerValue(this.getPlayer().getHand().getCards());
            this.matrix[h][HandCalculator.pokerValueToBrainValue((long)value) + 220][0] = 256;
        }
    }

    public void think(int cycles) {
        for (int h = 0; h < 50; ++h) {
            for (int i = 0; i < cycles; ++i) {
                for (int j = 0; j < 512; ++j) {
                    int tip = this.matrix[h][j][1];
                    int pulse = this.matrix[h][j][2];
                    int src = this.matrix[h][j][3];
                    int dest = this.matrix[h][j][4];
                    int charge = this.matrix[h][src][0];
                    if (charge < tip) continue;
                    int[] nArray = this.matrix[h][src];
                    nArray[0] = nArray[0] - pulse;
                    int[] nArray2 = this.matrix[h][dest];
                    nArray2[0] = nArray2[0] + pulse;
                }
            }
        }
    }

    public long getOutput() {
        long raise = 0L;
        long bet = 0L;
        long fold = 0L;
        for (int h = 0; h < 50; ++h) {
            raise += (long)this.matrix[h][509][0];
            bet += (long)this.matrix[h][510][0];
            fold += (long)this.matrix[h][511][0];
        }
        if (raise > bet && raise > fold) {
            return 2L;
        }
        if (bet > fold && bet > raise) {
            return 1L;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String brainName) throws IOException {
        Main main = Main.instance;
        synchronized (main) {
            String fileName = "brains/" + Opts.getInstance().getBrainSetName() + "/" + brainName;
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.matrix);
            oos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(String brainName) throws IOException {
        Main main = Main.instance;
        synchronized (main) {
            String fileName = "brains/" + Opts.getInstance().getBrainSetName() + "/" + brainName;
            cat.debug("retrieving brain: " + fileName);
            if (new File(fileName).length() == 0L) {
                return;
            }
            cat.debug("size brain: " + new File(fileName).length());
            FileInputStream fis = new FileInputStream(fileName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            try {
                this.matrix = (int[][][])ois.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                cat.error(cnfe, cnfe);
                throw new RuntimeException("Unable to find class: " + cnfe);
            }
        }
        this.calcColor();
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

