// Mtools.cpp - DLL for WinMdate
// Copyright (C) 1999,2000 Sean Dwyer <ewe2@cvis.com.au> under GPL.

//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
#include "mtools.h"
//---------------------------------------------------------------------------
//   Important note about DLL memory management:
//
//   If your DLL exports any functions that pass String objects (or structs/
//   classes containing nested Strings) as parameter or function results,
//   you will need to add the library BCBMM.LIB to both the DLL project and any
//   EXE projects that use the DLL.  This will change the DLL and its calling
//   EXE's to use the BCBMM.DLL as their memory manager.  In these cases,
//   the file BCBMM.DLL should be deployed along with your DLL.
//
//   To avoid using BCBMM.DLL, pass string information using "char *" or
//   ShortString parameters.
//---------------------------------------------------------------------------
USERES("mtools.res");
USEASM("drem.asm");
//---------------------------------------------------------------------------
extern "C" double drem(double, double);
// exported functions - put into mtools.h
// and why not

// internal functions - sort out what's needed
// and comment out the rest for now.
double my_mod(double,double);
void get_long_count(double);
double jul_from_date(int,int,int);
int gregorian_leap_year(int);
double get_julian(int,int,int,int);
bool isvalid_gdate(int,int,int);
//---------------------------------------------------------------------------
extern "C" __declspec(dllexport) int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void*)
{
	return 1;
}
//---------------------------------------------------------------------------
void date_from_jul(double j, gregdate *thedate)
{
	int d, m, y;
	double jn;
	int jalpha,ja,jb,jc,jd,je;

	jn = j;


    jalpha = (int)(((jn - 1867216) - 0.25) / 36524.25);
    ja = (int)(jn + 1 + jalpha - ((int)((0.25 * jalpha))));
    jb = (int)(ja + 1524);
    jc = (int)(6680.0 + ((jb - 2439870.0) - 122.1) / 365.25);
    jd = (int)(365.0 * jc + (0.25 * jc));
    je = (int)((jb - jd) / 30.6001);

	d = (jb - jd - ((int)( 30.6001 * je ) ));

	while (d < 0)
		d = d + 7;

	m = je - 1;

	if ( m > 12 )
		m = m - 12;

	while (m < 0)
		m = m + 12;

	y = jc - 4715;

	if (m > 2 )
		y = y - 1;

	thedate->day = d;
	thedate->month = m;
	thedate->year = y;

}
//------------------------------------------------
double jul_from_date(int d, int m, int y)
{
	int mm, dd, yy, jm;
	double jul, ja, jul2, temp1, temp2;
	
	mm = m;
	if (mm > 2) {
		yy = y;
		jm = mm + 1;
	} else {
		yy = y - 1;
		jm = mm + 13;
	}
	dd = d;
	temp1 = 365.25 * yy;
	temp2 = (30.6001 * jm) + (dd + 1720995.0);
	jul = (int) (floor(temp1)) + (floor(temp2));

	ja = (int) (0.01 * yy);
	jul2 = (int)(jul + (2 - ja + ((int)(0.25 * ja))));

	return jul2;

}
//-------------------------------------------------
double my_mod(double x, double y)
{
	double result;

	if ((x < 0) && (y < 0))
		/* both -ve */
		result = fmod(x,y);
	else if	((x > 0) && (y < 0))
		/* x is +ve, y is -ve */
		result = drem(x,y);
	else if ((x < 0) && (y > 0))
		/* x is -ve, y is +ve */
		result = drem(x,y);
	else
		/* both +ve */
		result = fmod(x,y);

	return result;
}
//-------------------------------------------------
const char *get_haab_date(double x, int *haabday)
{
	double lc=x-JD_CORRELATION;
	double doh;
	int day, month;
	static const char *mnth[] =
	    { "START","Pop","Uo","Zip","Zotz","Tzec","Xul","Yaxkin","Mol",
	      "Chen","Yax","Zac","Ceh","Mac","Kankin","Muan","Pax","Kayab",
	      "Cumku","Uayeb" };

	doh = my_mod((lc + 8.0 + 20.0 * (18.0 -1.0)),365.0);
	day = floor(my_mod(doh,20.0));
	month = floor(doh/20.0) + 1;

	*haabday = day;
	return mnth[month];
}
//---------------------------------------------------------------

// take a julian day number and convert it to a tzolkin_date
const char *get_tzolkin_date(double p, int *tzolkinnumber)
{
    double lc=p-JD_CORRELATION;
    int number, name, ilc;
    static const char *mnth[] =
	{ "START","Imix","Ik","Akbal","Kan","Chicchan","Cimi","Manik",
	  "Lamat","Muluc","Oc","Chuen","Eb","Ben","Ix","Men","Cib",
	  "Caban","Eznab","Cauac","Ahau" };

    ilc = floor(lc);
	number = AMOD((ilc+4),13);
	name = AMOD((ilc+20),20);

    *tzolkinnumber = number;
    return mnth[name];
}
//----------------------------------------------------

int gregorian_leap_year(int g_year)
{
   return !(g_year % 100 ? g_year % 4 : g_year % 400);
}

double gregtojdn (int day, int month, int year)
{
    return jul_from_date (day, month, year);
}
//-----------------------------------------------------------
// Take a julian date, and convert it to a Long Count

void jdntolong (double jdn, longdate *thedate)
{
    double lc;
    double r;

    if (jdn > JD_CORRELATION) {
			lc = jdn - JD_CORRELATION;
	} else if (jdn == JD_CORRELATION) {
			lc = 0.0;
	} else {
			lc = jdn - JD_CORRELATION;
	}

	if (lc < 0.0 ) {
		printf("Pre-epoch LC!! ");
	} else {
    	thedate->bak=floor(lc/144000.0);
    	r=my_mod(lc,144000.0);
    	thedate->kat=floor(r/7200);
    	r=my_mod(r,7200.0);
    	thedate->tun=floor(r/360);
    	r=my_mod(r,360.0);
    	thedate->uin=floor(r/20);
    	thedate->kin=my_mod(r,20.0);
	}
}
//------------------------------------------------------------------
// Take a Long Count and convert it to a Julian Day Number

double longtojdn (longdate *thedate)
{
    double result;

    result = (double)((thedate->bak*144000.0) +
		      (thedate->kat*7200.0) +
		      (thedate->tun*360.0) +
		      (thedate->uin*20.0) +
		      (double)thedate->kin);

    return result+JD_CORRELATION;
}
//--------------------------------------------------------------
// auxiliary functions added by CDR

bool isvalid_gdate (int day, int month, int year)
{
  static int daysinmonth[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

  daysinmonth[1] = gregorian_leap_year (year) ? 29 : 28;

  if ( month < 1 || month > 12 ) return FALSE;
  if ( day < 1 || day > daysinmonth[month - 1] ) return FALSE;

  return TRUE;
}
//-------------------------------------------------------------
const char *gmonth_str (int month)
{
  static const char *names[] = {
     "January", "February", "March", "April", "May", "June", "July",
     "August", "September", "October", "November", "December"
  };
  return names[month - 1];
}
//---------------------------------------------------------------
void set_date(mydate *thedate)
{
    long t;
    struct tm *today;

    t = time(NULL);
	today = localtime(&t);
	thedate->gdate.day = today->tm_mday;
	thedate->gdate.month = today->tm_mon+1;
	thedate->gdate.year = today->tm_year + 1900;
	thedate->set = DATE_GREGOK;
    thedate->jdn = gregtojdn (thedate->gdate.day,
        thedate->gdate.month, thedate->gdate.year);
	jdntolong (thedate->jdn, &thedate->ldate);
}