<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">

<HTML>

<HEAD>
	<TITLE>MSI Report</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function monthlySales(month, year, url, disString) {
    if (month.selected == false)
    {
        alert("You must select a month");
        return;
    }
    if (year == null || year <= 0)
    {
        alert("You must select a year");
        return;
    }
    var fullurl = "/msi/servlet/MSIServlet" + disString + "&Month=" + month.options[month.selectedIndex].value + "&Year=" + year.value + "&MonthName=" + month.options[month.selectedIndex].text;
    /* alert(fullurl); */
    var title = "Reports";
    var windowoptions = "resizable=yes,menubar=no,toolbar=no";
    window.open(fullurl, title, windowoptions); 
}
    
function yearlySales(year, url, disString) {
    if (year == null || year <= 0)
    {
        alert("You must select a year");
        return;
    }
    var fullurl = "/msi/servlet/MSIServlet" + disString + "&Year=" + year.value;
    /* alert(fullurl); */
    var title = "Reports";
    var windowoptions = "resizable=yes,menubar=no,toolbar=no";
    window.open(fullurl, title, windowoptions); 
}
function salesYTD(sytdate, url, disString) {
    var fullurl = "/msi/servlet/MSIServlet" + disString + "&SYTDate=" + sytdate.value;
    /* alert(fullurl); */ 
    var title = "Reports";
    var windowoptions = "resizable=yes,menubar=no,toolbar=no";
    window.open(fullurl, title, windowoptions); 
}
    
    
function validate(form) {
   var field = form.Month;
   var disValue = form.submit.disValue;
   if (disValue == 1292 && field.value == '0') {
      alert("You must select a month.");
      return false;
   }
   else {
      return true;
   }
}

function setSelections( thedate, form1) {
    var today = thedate.value;
    var month = today.substring(0, 2);
    var day = today.substring(3, 5);
    var year = today.substring(6, 10);
    form1.Month.selectedIndex = parseInt(month, 10)-1;
    form1.Year.value = year;
}

]]>
</xsl:comment>
</SCRIPT>


<!-- Include this in every page for allowing the colors and attributes to be set -->
<BODY onLoad="setSelections(THEDATE, FORM1)">

<CENTER><H1>Reports Main Menu</H1></CENTER>


<!-- End of Include section -->



<!-- Page Specific Data -->
<!-- ***************************************************************************************** -->

<INPUT TYPE="HIDDEN" NAME="THEDATE"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/TODAY"/></xsl:attribute></INPUT>
<INPUT TYPE="HIDDEN" NAME="SERVLET"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute></INPUT>

<FORM NAME="FORM1" METHOD="POST" onSubmit="return validate(this)">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>
<INPUT TYPE="HIDDEN" NAME="recipient" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="subject" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="redirect" VALUE=""></INPUT>

<!-- INPUT TYPE="HIDDEN" NAME="disValue" VALUE="1291"></INPUT -->


<P ALIGN="CENTER"><B>Select a report</B></P>
<TABLE BORDER="0" WIDTH="100%">

<TR>
	<TD WIDTH="15"></TD>
    <TD WIDTH="300"></TD>
	<TD WIDTH="100"></TD>
    <TD WIDTH="*"></TD>
</TR>

<TR>
	<TD COLSPAN="2"><H3>Sales</H3></TD>
</TR>
<TR>
	<TD WIDTH="15"></TD>
	<TD><INPUT TYPE="BUTTON" NAME="B" VALUE="Monthly Sales       " onClick="monthlySales(Month, Year, '/msi/servlet/MSIServlet', '?disValue=1292')"></INPUT></TD>
    <TD WIDTH="100"><SELECT NAME="Month">
        <OPTION VALUE="01">January</OPTION>
        <OPTION VALUE="02">February</OPTION>
        <OPTION VALUE="03">March</OPTION>
        <OPTION VALUE="04">April</OPTION>
        <OPTION VALUE="05">May</OPTION>
        <OPTION VALUE="06">June</OPTION>
        <OPTION VALUE="07">July</OPTION>
        <OPTION VALUE="08">August</OPTION>
        <OPTION VALUE="09">September</OPTION>
        <OPTION VALUE="10">October</OPTION>
        <OPTION VALUE="11">November</OPTION>
        <OPTION VALUE="12">December</OPTION>
    </SELECT></TD>
	<TD WIDTH="*"></TD>
</TR>

<TR>
    <TD WIDTH="15"></TD>
    <TD WIDTH="300"><INPUT TYPE="BUTTON" NAME="B" VALUE="Yearly Sales         " onClick="yearlySales(Year, '/msi/servlet/MSIServlet', '?disValue=1293')"></INPUT></TD>
    <TD WIDTH="100"><INPUT NAME="Year" SIZE="10"></INPUT></TD>
	<TD WIDTH="*"></TD>
</TR>

<TR>
    <TD WIDTH="15"></TD>
    <TD WIDTH="300"><INPUT TYPE="BUTTON" NAME="B" VALUE="Sales Year-to-date " onClick="salesYTD(YTDATE, '/msi/servlet/MSIServlet', '?disValue=1291')"></INPUT></TD>
    <!-- TD WIDTH="300"><INPUT TYPE="Radio" NAME="disValue" VALUE="1291" CHECKED="true">Sales Year-to-date</INPUT></TD -->
    <TD WIDTH="100"><INPUT NAME="YTDATE" SIZE="10"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/TODAY"/></xsl:attribute></INPUT></TD>
	<TD WIDTH="*"></TD>
</TR>

<TR>
	<TD WIDTH="15"></TD>
	<TD WIDTH="300"></TD>
	<TD WIDTH="100"></TD>
	<TD WIDTH="*"></TD>
</TR>

</TABLE>
<P/>


<TABLE>
<TR>
<TD>
<P><A TARGET="_BLANK"><xsl:attribute name="HREF"><xsl:value-of select="/MSI/LAYOUT/SERVLET"/>?disValue=1294&amp;REPORT=MSIClasses.reports.CustomerCacheReport</xsl:attribute>
Customer Cache Report</A></P>
<P></P>
</TD>
</TR>


<TR>
<TD>
<P><A TARGET="_BLANK"><xsl:attribute name="HREF"><xsl:value-of select="/MSI/LAYOUT/SERVLET"/>?disValue=1294&amp;REPORT=MSIClasses.reports.CustomerInfo</xsl:attribute>
Customer Info Report</A></P>
<P></P>
</TD>
</TR>

<TR>
<TD>
<P><A TARGET="_BLANK"><xsl:attribute name="HREF"><xsl:value-of select="/MSI/LAYOUT/SERVLET"/>?disValue=1294&amp;REPORT=MSIClasses.reports.SupplierInfo</xsl:attribute>
Supplier Info Report</A></P>
<P></P>
</TD>
</TR>


<!-- TR><TD COLSPAN="2"><INPUT TYPE="SUBMIT" VALUE="Generate report"></INPUT><INPUT TYPE="RESET"></INPUT></TD></TR -->

</TABLE>
</FORM>
</BODY>
</HTML>
</xsl:template></xsl:stylesheet>