<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">

			  
<HTML>
<HEAD>
    <TITLE>MySalesInfo Add New Customer</TITLE>
    <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>


<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function validate(form) {
   var field = form.COMPANY_NAME;  
   if (field.value == '') {
      alert("You must enter a company name.");
      return false;
   }
   else {
      return true;
   }
}

function setTab(focusItem) {
    focusItem.focus();
}

]]>
</xsl:comment>
</SCRIPT>


<BODY onLoad="setTab(FORM.COMPANY_NAME)">

<FORM NAME="FORM" METHOD="POST" onSubmit="return validate(this)">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>

<INPUT type="hidden" name="disValue" value="516"></INPUT>


<xsl:if test="MSI/ADDCOMPANY/STATUS[.!='']">

<CENTER><H2 CLASS="status">
			 <xsl:value-of select="MSI/ADDCOMPANY/MESSAGE"/><xsl:text> </xsl:text><xsl:value-of select="MSI/ADDCOMPANY/COMPANY"/></H2></CENTER>
</xsl:if>
<P></P>

<CENTER><H1>Add New Customer</H1></CENTER><P></P>

<SPAN CLASS="required">Red Field</SPAN> - denotes a required field (cannot be blank)<P></P>

<TABLE CELLPADDING="2" WIDTH="450">
<TR>
    <TD CLASS="required">Customer Name:</TD>
    <TD><INPUT NAME="COMPANY_NAME" ALIGN="left" VALUE="" SIZE="30" TABINDEX="5"></INPUT></TD>
</TR>

<TR>
    <TD>Buyer:</TD>
    <TD><INPUT NAME="BUYER" ALIGN="left" VALUE="" SIZE="30" TABINDEX="10"></INPUT></TD>
</TR>
<TR>
    <TD>Billing Address</TD>
    <TD>
      <INPUT ALIGN="left" NAME="BILL_ADDRESS1" VALUE="" SIZE="20" TABINDEX="20"></INPUT></TD>
</TR>
<TR>
    <TD></TD>
    <TD><INPUT ALIGN="left" NAME="BILL_ADDRESS2" VALUE="" SIZE="20" TABINDEX="25"></INPUT></TD>
</TR>
<TR>
    <TD>        City:</TD>
    <TD><INPUT ALIGN="left" NAME="BILL_CITY" VALUE="" SIZE="20" TABINDEX="30"></INPUT></TD>
</TR>
<TR>
    <TD>        State:</TD>
    <TD><INPUT ALIGN="left" NAME="BILL_STATE" VALUE="" SIZE="20" TABINDEX="35"></INPUT></TD>
</TR>
<TR>
    <TD>        Zip:</TD>
    <TD><INPUT ALIGN="left" NAME="BILL_ZIP" VALUE="" SIZE="20" TABINDEX="40"></INPUT></TD>
</TR>

<TR>
    <TD>Shipping Address:</TD>
    <TD><INPUT ALIGN="left" NAME="SHIP_ADDRESS1" VALUE="" SIZE="20" TABINDEX="45"></INPUT></TD>
</TR>
<TR>
    <TD></TD>
    <TD><INPUT ALIGN="left" NAME="SHIP_ADDRESS2" VALUE="" SIZE="20" TABINDEX="50"></INPUT></TD>
</TR>
<TR>
    <TD>         City:</TD>
    <TD><INPUT ALIGN="left" NAME="SHIP_CITY" VALUE="" SIZE="20" TABINDEX="55"></INPUT></TD>
</TR>
<TR>
    <TD>         State:</TD>
    <TD><INPUT ALIGN="left" NAME="SHIP_STATE" VALUE="" SIZE="20" TABINDEX="60"></INPUT></TD>
</TR>
<TR>
    <TD>         Zip:</TD>
    <TD><INPUT ALIGN="left" NAME="SHIP_ZIP" VALUE="" SIZE="20" TABINDEX="65"></INPUT></TD>
</TR>

<TR>
    <TD>Country:</TD>
    <TD><INPUT ALIGN="left" NAME="COUNTRY" VALUE="" SIZE="20" TABINDEX="70"></INPUT></TD>
</TR>

<TR>
    <TD>Phone:</TD>
    <TD><INPUT ALIGN="left" NAME="PHONE" VALUE="" SIZE="20" TABINDEX="75"></INPUT></TD>
</TR>

<TR>
    <TD>Cell Phone:</TD>
    <TD><INPUT ALIGN="left" NAME="CELLPHONE" VALUE="" SIZE="20" TABINDEX="80"></INPUT></TD>
</TR>

<TR>
    <TD>Home Phone:</TD>
    <TD><INPUT ALIGN="left" NAME="HOMEPHONE" VALUE="" SIZE="20" TABINDEX="85"></INPUT></TD>
</TR>

<TR>
    <TD>Fax:</TD>
    <TD><INPUT ALIGN="left" NAME="FAX" VALUE="" SIZE="20" TABINDEX="90"></INPUT></TD>
</TR>

<TR>
    <TD>Email:</TD>
    <TD><INPUT ALIGN="left" NAME="EMAIL" VALUE="" SIZE="20" TABINDEX="95"></INPUT></TD>
</TR>


<TR>
    <TD>Web Site:</TD>
    <TD><INPUT ALIGN="left" NAME="WEBSITE" VALUE="" SIZE="20" TABINDEX="100"></INPUT></TD>
</TR>

<TR>
    <TD VALIGN="TOP">PO Send Directions:</TD>
    <TD><INPUT TYPE="Radio" NAME="SENDAS" VALUE="1" CHECKED="true" TABINDEX="105"> Send with Email<BR></BR></INPUT>
		  <INPUT TYPE="Radio" NAME="SENDAS" VALUE="2" TABINDEX="110"> Send with Fax<BR></BR></INPUT>
		  <INPUT TYPE="Radio" NAME="SENDAS" VALUE="3" TABINDEX="115"> Send with Email and Fax<BR></BR></INPUT>
		  <INPUT TYPE="Radio" NAME="SENDAS" VALUE="0" TABINDEX="120"> Do not Send PO<BR></BR></INPUT>
</TD>
</TR>

<xsl:choose>
<xsl:when test="MSI/AREAINFO/AREA[.!='']">
<TR>
    <TD>Area Assignments</TD>
    <TD>
	 <TABLE>
		<xsl:for-each select="MSI/AREAINFO/AREA">
		   <TR>
				<xsl:choose>
				<xsl:when test="c3[.='1']">
					<xsl:attribute name="BGCOLOR"><xsl:value-of select="/MSI/LAYOUT/ODDROW"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="BGCOLOR"><xsl:value-of select="/MSI/LAYOUT/EVANROW"/></xsl:attribute>
				</xsl:otherwise>
				</xsl:choose>			
				
				<TD>
				   <INPUT TYPE="CheckBox">
					<xsl:attribute name="NAME"><xsl:value-of select="AREAID"/></xsl:attribute>
		   	  
					<xsl:choose>
					<xsl:when test="ASSIGNED[.!='']">
					<xsl:attribute name="CHECKED">true</xsl:attribute>
					</xsl:when>
					</xsl:choose>
				   </INPUT>
			   </TD>
				<TD><xsl:value-of select="AREANAME"/></TD>
			</TR>
		</xsl:for-each>
	 
		<input type="hidden" name="AREATOTAL" value="259">
		<xsl:attribute name="VALUE"><xsl:value-of select="MSI/AREAINFO/FOOTER/TOTALCOUNT"/></xsl:attribute>
		</input>
	 </TABLE>
	 </TD>
</TR>
</xsl:when>
</xsl:choose>


</TABLE>

  <INPUT TYPE="submit" NAME="submit" VALUE="Add Customer" TABINDEX="125"></INPUT>
</FORM>
</BODY>
</HTML>
</xsl:template>
</xsl:stylesheet>
