/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;

public class DefaultErrorPage
extends HttpServlet {
    public String exceptionString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<b>Internal Servlet Error:</b><br>");
        pw.println("<pre>");
        if (e != null) {
            e.printStackTrace(pw);
        }
        pw.println("</pre>");
        if (e instanceof ServletException) {
            this.printRootCause((ServletException)e, pw);
        }
        return sw.toString();
    }

    private String makeAbsolute(Request request, String location) {
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            String requrl = HttpUtils.getRequestURL((HttpServletRequest)request.getFacade()).toString();
            try {
                url = new URL(new URL(requrl), location);
            }
            catch (MalformedURLException malformedURLException2) {
                return location;
            }
        }
        return url.toString();
    }

    void printRootCause(ServletException e, PrintWriter out) {
        Throwable cause = e.getRootCause();
        if (cause != null) {
            out.println("<b>Root cause:</b>");
            out.println("<pre>");
            cause.printStackTrace(out);
            out.println("</pre>");
            if (cause instanceof ServletException) {
                this.printRootCause((ServletException)cause, out);
            }
        }
    }

    public void redirect(Request request, Response response, String location) throws IOException {
        location = this.makeAbsolute(request, location);
        response.setContentType("text/html");
        response.setHeader("Location", location);
        StringBuffer buf = new StringBuffer();
        buf.append("<head><title>Document moved</title></head>\r\n");
        buf.append("<body><h1>Document moved</h1>\r\n");
        buf.append("This document has moved <a href=\"");
        buf.append(location);
        buf.append("\">here</a>.<p>\r\n");
        buf.append("</body>\r\n");
        String body = buf.toString();
        response.setContentLength(body.length());
        if (response.isUsingStream()) {
            ServletOutputStream out = response.getOutputStream();
            out.print(body);
        } else {
            PrintWriter out = response.getWriter();
            out.print(body);
        }
    }

    private void sendPrivateError(Request request, Response response, int sc, String msg) throws IOException {
        response.setContentType("text/html");
        response.setStatus(sc);
        StringBuffer buf = new StringBuffer();
        if (response.isIncluded()) {
            buf.append("<h1>Included servlet error: ");
        } else {
            buf.append("<h1>Error: ");
        }
        buf.append(String.valueOf(sc) + "</h1>\r\n");
        buf.append("<h2>Location: " + request.getRequestURI() + "</h2>");
        if (msg != null) {
            buf.append(String.valueOf(msg) + "\r\n");
        }
        if (response.isUsingStream()) {
            ServletOutputStream out = response.getOutputStream();
            out.print(buf.toString());
        } else {
            PrintWriter out = response.getWriter();
            out.print(buf.toString());
        }
    }

    public void service(HttpServletRequest requestH, HttpServletResponse responseH) throws ServletException, IOException {
        Request request = ((HttpServletRequestFacade)requestH).getRealRequest();
        Response response = request.getResponse();
        int status = response.getStatus();
        String msg = (String)request.getAttribute("javax.servlet.error.message");
        Throwable e = (Throwable)request.getAttribute("tomcat.servlet.error.throwable");
        if (e != null) {
            request.getContext().log(this.exceptionString(e));
            this.sendPrivateError(request, response, 500, this.exceptionString(e));
            return;
        }
        if (status == 302) {
            this.redirect(request, response, msg);
        } else {
            this.sendPrivateError(request, response, status, msg);
        }
    }
}

