/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.File;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.ContextInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestDispatcherImpl;
import org.apache.tomcat.core.RequestInterceptor;
import org.apache.tomcat.core.RequestSecurityProvider;
import org.apache.tomcat.core.ServletContextFacade;
import org.apache.tomcat.core.ServletLoader;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.core.SessionManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.logging.Logger;
import org.apache.tomcat.util.FileUtil;
import org.apache.tomcat.util.MimeMap;
import org.apache.tomcat.util.StringManager;

public class Context {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private String path = "";
    private String docBase;
    private ContextManager contextM;
    private ServletContextFacade contextFacade;
    private SessionManager sessionManager;
    private ServletLoader servletL;
    boolean reloadable = true;
    private Hashtable attributes = new Hashtable();
    private File workDir;
    private RequestSecurityProvider rsProvider;
    private Vector contextInterceptors = new Vector();
    private Vector requestInterceptors = new Vector();
    private Hashtable servlets = new Hashtable();
    private Hashtable initializationParameters = new Hashtable();
    private boolean expectUserWelcomeFiles = false;
    private Vector welcomeFiles = new Vector();
    private Hashtable errorPages = new Hashtable();
    private String description = null;
    private boolean isDistributable = false;
    private MimeMap mimeTypes = new MimeMap();
    private int sessionTimeOut = -1;
    Hashtable tagLibs = new Hashtable();
    Hashtable envEntryTypes = new Hashtable();
    Hashtable envEntryValues = new Hashtable();
    private Hashtable mappings = new Hashtable();
    Hashtable constraints = new Hashtable();
    Hashtable containers = new Hashtable();
    private ServletWrapper defaultServlet = null;
    String authMethod;
    String realmName;
    String formLoginPage;
    String formErrorPage;
    int debug = 0;
    boolean firstLog = true;
    Logger csLog = null;
    private boolean isWorkDirPersistent = false;
    private String engineHeader = null;
    private URL documentBase;
    private URL servletBase = null;
    private boolean isInvokerEnabled = false;
    private File warDir = null;
    private boolean isWARExpanded = false;
    private boolean isWARValidated = false;
    ContextInterceptor[] cInterceptors;
    RequestInterceptor[] rInterceptors;

    public void addContentType(String ext, String type) {
        this.mimeTypes.addContentType(ext, type);
    }

    public void addContextInterceptor(ContextInterceptor ci) {
        this.contextInterceptors.addElement(ci);
    }

    public void addEnvEntry(String name, String type, String value, String description) {
        System.out.println("Add env-entry " + name + "  " + type + " " + value + " " + description);
        if (name == null || type == null) {
            throw new IllegalArgumentException();
        }
        this.envEntryTypes.put(name, type);
        if (value != null) {
            this.envEntryValues.put(name, value);
        }
    }

    public void addErrorPage(String errorType, String value) {
        this.errorPages.put(errorType, value);
    }

    public void addInitParameter(String name, String value) {
        this.initializationParameters.put(name, value);
    }

    public void addRequestInterceptor(RequestInterceptor ci) {
        this.requestInterceptors.addElement(ci);
    }

    public void addSecurityConstraint(String[] path, String[] methods, String[] roles, String transport) throws TomcatException {
        int i = 0;
        while (i < path.length) {
            Container ct = new Container();
            ct.setContext(this);
            ct.setTransport(transport);
            ct.setRoles(roles);
            ct.setPath(path[i]);
            this.constraints.put(path[i], ct);
            this.contextM.addContainer(ct);
            ++i;
        }
    }

    public void addServlet(ServletWrapper wrapper) throws TomcatException {
        String name = wrapper.getServletName();
        if (this.servlets.get(name) != null) {
            this.log("Removing duplicate servlet " + name + " " + wrapper);
            this.removeServletByName(name);
        }
        this.servlets.put(name, wrapper);
    }

    public void addServletMapping(String path, String servletName) throws TomcatException {
        ServletWrapper sw;
        if (this.mappings.get(path) != null) {
            this.log("Removing duplicate " + path + " -> " + this.mappings.get(path));
            this.mappings.remove(path);
            Container ct = (Container)this.containers.get(path);
            this.removeContainer(ct);
        }
        if ((sw = (ServletWrapper)this.servlets.get(servletName)) == null) {
            sw = new ServletWrapper(this);
            sw.setServletName(servletName);
            if (servletName.startsWith("/")) {
                sw.setPath(servletName);
            } else {
                sw.setServletClass(servletName);
            }
            this.addServlet(sw);
        }
        if ("/".equals(path)) {
            this.defaultServlet = sw;
        }
        this.mappings.put(path, sw);
        Container map = new Container();
        map.setContext(this);
        map.setHandler(sw);
        map.setPath(path);
        this.contextM.addContainer(map);
        this.containers.put(path, map);
    }

    public void addTaglib(String uri, String location) {
        this.tagLibs.put(uri, location);
    }

    public void addWelcomeFile(String s) {
        if (this.expectUserWelcomeFiles) {
            this.removeWelcomeFiles();
            this.expectUserWelcomeFiles = false;
        }
        this.welcomeFiles.addElement(s);
    }

    public void expectUserWelcomeFiles() {
        this.expectUserWelcomeFiles = true;
    }

    public Object getAttribute(String name) {
        if (name.equals("org.apache.tomcat.jsp_classpath")) {
            String cp = this.getServletLoader().getClassPath();
            return cp;
        }
        if (name.equals("org.apache.tomcat.classloader")) {
            return this.getServletLoader();
        }
        Object o = this.attributes.get(name);
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public Container getContainer(String path) {
        return (Container)this.containers.get(path);
    }

    public Enumeration getContainerLocations() {
        return this.containers.keys();
    }

    public Enumeration getContainers() {
        return this.containers.elements();
    }

    Context getContext(String path) {
        if (!path.startsWith("/")) {
            return null;
        }
        Request lr = this.contextM.createRequest(path);
        this.getContextManager().processRequest(lr);
        return lr.getContext();
    }

    public ContextInterceptor[] getContextInterceptors() {
        if (this.contextInterceptors.size() == 0) {
            return this.contextM.getContextInterceptors();
        }
        if (this.cInterceptors == null || this.cInterceptors.length != this.contextInterceptors.size()) {
            this.cInterceptors = new ContextInterceptor[this.contextInterceptors.size()];
            int i = 0;
            while (i < this.cInterceptors.length) {
                this.cInterceptors[i] = (ContextInterceptor)this.contextInterceptors.elementAt(i);
                ++i;
            }
        }
        return this.cInterceptors;
    }

    public ContextManager getContextManager() {
        return this.contextM;
    }

    public int getDebug() {
        return this.debug;
    }

    public ServletWrapper getDefaultServlet() {
        if (this.defaultServlet == null) {
            this.defaultServlet = this.getServletByName("default");
        }
        return this.defaultServlet;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDocBase() {
        return this.docBase;
    }

    public URL getDocumentBase() {
        block5: {
            if (this.documentBase != null) break block5;
            if (this.docBase == null) {
                return null;
            }
            try {
                String absPath = this.docBase;
                absPath = FileUtil.isAbsolute(this.docBase) ? this.docBase : String.valueOf(this.contextM.getHome()) + File.separator + this.docBase;
                try {
                    absPath = new File(absPath).getCanonicalPath();
                }
                catch (IOException iOException) {}
                this.documentBase = new URL("file", "", absPath);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return this.documentBase;
    }

    public String getEngineHeader() {
        return this.engineHeader;
    }

    public Enumeration getEnvEntries() {
        return this.envEntryTypes.keys();
    }

    public String getEnvEntryType(String name) {
        return (String)this.envEntryTypes.get(name);
    }

    public String getEnvEntryValue(String name) {
        return (String)this.envEntryValues.get(name);
    }

    public String getErrorPage(int errorCode) {
        return this.getErrorPage(String.valueOf(errorCode));
    }

    public String getErrorPage(String errorCode) {
        return (String)this.errorPages.get(errorCode);
    }

    ServletContextFacade getFacade() {
        if (this.contextFacade == null) {
            this.contextFacade = new ServletContextFacade(this.contextM, this);
        }
        return this.contextFacade;
    }

    public String getFormErrorPage() {
        return this.formErrorPage;
    }

    public String getFormLoginPage() {
        return this.formLoginPage;
    }

    public String getInitParameter(String name) {
        return (String)this.initializationParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.initializationParameters.keys();
    }

    public FileNameMap getMimeMap() {
        return this.mimeTypes;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        ServletWrapper wrapper = this.getServletByName(name);
        if (wrapper == null) {
            return null;
        }
        RequestDispatcherImpl rD = new RequestDispatcherImpl(this);
        rD.setName(name);
        return rD;
    }

    public String getPath() {
        return this.path;
    }

    String getRealPath(String path) {
        Context targetContext;
        String realPath;
        Context base = this;
        String normP = FileUtil.normPath(path);
        Request req = this.contextM.createRequest(base, normP);
        this.contextM.processRequest(req);
        String mappedPath = req.getMappedPath();
        if (mappedPath == null) {
            mappedPath = req.getPathInfo();
        }
        if (mappedPath == null) {
            mappedPath = req.getLookupPath();
        }
        if (!FileUtil.isAbsolute(realPath = String.valueOf((targetContext = req.getContext()).getDocBase()) + mappedPath)) {
            realPath = String.valueOf(this.contextM.getHome()) + "/" + realPath;
        }
        realPath = FileUtil.patch(realPath);
        if (this.debug > 5) {
            this.log("Get real path " + path + " " + realPath + " " + normP);
        }
        return realPath;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null || !path.startsWith("/")) {
            return null;
        }
        RequestDispatcherImpl rD = new RequestDispatcherImpl(this);
        rD.setPath(path);
        return rD;
    }

    public RequestInterceptor[] getRequestInterceptors() {
        if (this.requestInterceptors.size() == 0) {
            return this.contextM.getRequestInterceptors();
        }
        if (this.rInterceptors == null || this.rInterceptors.length != this.requestInterceptors.size()) {
            this.rInterceptors = new RequestInterceptor[this.requestInterceptors.size()];
            int i = 0;
            while (i < this.rInterceptors.length) {
                this.rInterceptors[i] = (RequestInterceptor)this.requestInterceptors.elementAt(i);
                ++i;
            }
        }
        return this.rInterceptors;
    }

    public RequestSecurityProvider getRequestSecurityProvider() {
        return this.rsProvider;
    }

    public URL getResource(String rpath) throws MalformedURLException {
        URL url = null;
        String absPath = this.getDocBase();
        absPath = FileUtil.isAbsolute(this.docBase) ? this.docBase : String.valueOf(this.contextM.getHome()) + File.separator + this.docBase;
        try {
            absPath = new File(absPath).getCanonicalPath();
        }
        catch (IOException iOException) {}
        if ("".equals(rpath)) {
            return new URL("file", null, 0, absPath);
        }
        if (rpath == null) {
            return null;
        }
        if (!rpath.startsWith("/")) {
            rpath = "/" + rpath;
        }
        Request lr = this.contextM.createRequest(this, rpath);
        this.getContextManager().processRequest(lr);
        String mappedPath = lr.getMappedPath();
        if (mappedPath == null) {
            mappedPath = lr.getPathInfo();
        }
        if (mappedPath == null) {
            mappedPath = lr.getLookupPath();
        }
        try {
            String contextHome = new File(this.docBase).getCanonicalPath();
            String realPath = String.valueOf(contextHome) + mappedPath;
            if (!new File(realPath).getCanonicalPath().startsWith(contextHome)) {
                return null;
            }
            url = new URL("file", null, 0, String.valueOf(absPath) + mappedPath);
            if (this.debug > 9) {
                this.log("getResourceURL=" + url + " request=" + lr);
            }
            return url;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ServletWrapper getServletByName(String servletName) {
        return (ServletWrapper)this.servlets.get(servletName);
    }

    public ServletLoader getServletLoader() {
        return this.servletL;
    }

    public Enumeration getServletNames() {
        return this.servlets.keys();
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public int getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public String getTaglibLocation(String uri) {
        return (String)this.tagLibs.get(uri);
    }

    public Enumeration getTaglibs() {
        return this.tagLibs.keys();
    }

    public File getWARDir() {
        return this.warDir;
    }

    public Enumeration getWelcomeFiles() {
        return this.welcomeFiles.elements();
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public boolean isDistributable() {
        return this.isDistributable;
    }

    public boolean isInvokerEnabled() {
        return this.isInvokerEnabled;
    }

    public boolean isWARExpanded() {
        return this.isWARExpanded;
    }

    public boolean isWARValidated() {
        return this.isWARValidated;
    }

    public boolean isWorkDirPersistent() {
        return this.isWorkDirPersistent;
    }

    public final void log(String msg) {
        this.log(msg, null);
    }

    public void log(String msg, Throwable t) {
        if (this.contextM == null) {
            System.out.println(msg);
            if (t != null) {
                t.printStackTrace(System.out);
            }
            return;
        }
        if (msg.startsWith("<l:")) {
            this.contextM.doLog(msg, t);
        } else {
            this.contextM.doLog("Context log: path=\"" + this.path + "\" " + msg, t);
        }
    }

    public void logServlet(String msg, Throwable t) {
        if (this.firstLog) {
            this.csLog = Logger.getLogger("servlet_log");
            if (this.csLog != null) {
                this.csLog.setCustomOutput("true");
                this.csLog.setVerbosityLevel(3);
                this.firstLog = false;
            }
        }
        if (this.csLog != null) {
            this.csLog.log("Context log path=\"" + this.path + "\" :" + msg + "\n");
        } else {
            System.out.println("Context log path=\"" + this.path + "\"" + msg);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void removeContainer(Container ct) {
        this.containers.remove(ct.getPath());
    }

    public void removeServletByName(String servletName) throws TomcatException {
        this.servlets.remove(servletName);
    }

    public void removeWelcomeFiles() {
        if (!this.welcomeFiles.isEmpty()) {
            this.welcomeFiles.removeAllElements();
        }
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
    }

    public void setDebug(int level) {
        if (level > 0) {
            this.log("Set debug to " + level);
        }
        this.debug = level;
    }

    public void setDebug(String level) {
        try {
            this.setDebug(Integer.parseInt(level));
        }
        catch (Exception e) {
            this.log("Set debug to '" + level + "':", e);
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDistributable(boolean isDistributable) {
        this.isDistributable = isDistributable;
    }

    public void setDocBase(String docB) {
        this.docBase = docB;
    }

    public void setDocumentBase(URL s) {
        this.documentBase = s;
    }

    public void setEngineHeader(String s) {
        this.engineHeader = s;
    }

    public void setIcon(String icon) {
    }

    public void setInitParameter(String name, String value) {
        this.initializationParameters.put(name, value);
    }

    public void setInvokerEnabled(boolean isInvokerEnabled) {
        this.isInvokerEnabled = isInvokerEnabled;
    }

    public void setIsWARExpanded(boolean isWARExpanded) {
        this.isWARExpanded = isWARExpanded;
    }

    public void setIsWARValidated(boolean isWARValidated) {
        this.isWARValidated = isWARValidated;
    }

    public void setLoginConfig(String authMethod, String realmName, String formLoginPage, String formErrorPage) {
        this.authMethod = authMethod;
        this.realmName = realmName;
        this.formLoginPage = formLoginPage;
        this.formErrorPage = formErrorPage;
    }

    public void setPath(String path) {
        if ("/".equals(path)) {
            path = "";
        }
        this.path = path;
    }

    public void setReloadable(String s) {
        this.reloadable = new Boolean(s);
    }

    public void setReloadable(boolean b) {
        this.reloadable = b;
    }

    public void setRequestSecurityProvider(RequestSecurityProvider rsProvider) {
        this.rsProvider = rsProvider;
    }

    public void setServletLoader(ServletLoader loader) {
        this.servletL = loader;
    }

    public void setSessionManager(SessionManager manager) {
        this.sessionManager = manager;
        if (this.sessionManager != null) {
            this.sessionManager.setSessionTimeOut(this.sessionTimeOut);
        }
    }

    public void setSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
        if (this.sessionManager != null) {
            this.sessionManager.setSessionTimeOut(sessionTimeOut);
        }
    }

    public void setWARDir(File f) {
        this.warDir = f;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setWorkDirPath(String workDir) {
        this.workDir = new File(workDir);
    }

    public void setWorkDirPersistent(boolean b) {
        this.isWorkDirPersistent = b;
    }

    public String toString() {
        return "Ctx(" + this.path + "," + this.getDocBase() + ")";
    }
}

