//==============================================================================
//
//		CLIENT.CPP --  1999 Adam King
//
//						: Client Window Routines
//
//==============================================================================
#define STRICT
#include <windows.h>
#pragma hdrstop

#include "client.h"
#include "dibdll.h"

void Client_OnCommand(HWND hWnd, int id, HWND hwndCtl, UINT codeNotify);

	extern HWND 			hWndFrame;
	extern WNDPROC			OldClientProc;

	BOOL						BrowserOn = FALSE;


//------------------------------------------------------------------------------
//
#pragma argsused
LRESULT CALLBACK NewClientProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
	case WM_HSCROLL:
	case WM_VSCROLL:
		if(wParam == SB_BOTTOM ||
			wParam == SB_TOP ||
			wParam == SB_LINEDOWN ||
			wParam == SB_LINEUP ||
			wParam == SB_PAGEDOWN ||
			wParam == SB_PAGEUP)
		{
			SendMessage(hwnd, WM_SETREDRAW, FALSE, 0L);
			CallWindowProc(OldClientProc, hwnd, msg, wParam, lParam);
			SendMessage(hwnd, WM_SETREDRAW, TRUE, 0L);
		}
		break;

	case WM_PAINT:
		{
			DIBVIEW *	ClientDib = (DIBVIEW *)GetWindowLong(hWndFrame, 0);
			if(ClientDib)
			{
				PAINTSTRUCT		ps;
				HDC				hdc;
				hdc = BeginPaint(hwnd, &ps);
				ClientDib->PaintDIB(hwnd, hdc);
				EndPaint(hwnd, &ps);
			}
		}
		return 0;

	case WM_COMMAND:
		Client_OnCommand(hwnd, wParam, (HWND)LOWORD(lParam), HIWORD(lParam));
		return 0;
	}

	// Message not processed, so pass on to the old procedure...
	return CallWindowProc(OldClientProc, hwnd, msg, wParam, lParam);
}

#pragma argsused
void Client_OnCommand(HWND hWnd, int id, HWND hwndCtl, UINT codeNotify)
{
	switch(id)
	{
	default:
		PostMessage(hWndFrame, WM_COMMAND, id, MAKELPARAM(hwndCtl, codeNotify));
		break;
	}
}


