char msg_c[]="$Header: d:/wilhelm/winrsh/RCS/msg.c%v 1.6 1994/11/07 04:40:07 wcheung Exp wcheung $";
/*************************************************************************
 *
 * msg - Message Bar Module
 *
 * Copyright(C) 1994 William K. W. Cheung
 * All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * WinRSH/WinRSH32 - Remote Shell for Windows
 * Author: William K. W. Cheung (wcheung@ee.ubc.ca)
 * Date:   November 4, 1994
 *
 ************************************************************************/
#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <ctl3d.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "msg.h"
#include "err.h"

#define _MSG_BUFSIZ	128

LRESULT CALLBACK _export SSNewProc(HWND hWnd, UINT iMessage,
													WPARAM wParam, LPARAM lParam);

/*
 * Local variables
 */
static HWND hMsgBdrWnd;
static HWND hMsgWnd;
static HBRUSH	hMsgBrush = NULL;
static WNDPROC lpfnSSOldProc;
static FARPROC lpfnSSNewProc;

/*
 * Local Functions
 */
static HFONT SetMsgFont(LPSTR lpszFntName, int nPt);

void DoInitMsg(HWND hWnd, HINSTANCE hInst)
{
	hMsgBdrWnd = CreateWindow("static", NULL,
							WS_CHILD|WS_VISIBLE|SS_BLACKRECT,
							0, 0, 0, 0,
							hWnd, (HMENU)-1, hInst, NULL);

	hMsgWnd = CreateWindow("static", NULL,
							WS_CHILD|WS_VISIBLE|SS_LEFTNOWORDWRAP,
							0, 0, 0, 0,
							hWnd, (HMENU)MB_ID, hInst, NULL);
	Ctl3dSubclassCtl(hMsgBdrWnd);

	lpfnSSOldProc = (WNDPROC)GetWindowLong(hMsgWnd, GWL_WNDPROC);
	lpfnSSNewProc = MakeProcInstance((FARPROC)SSNewProc, hInst);
	SetWindowLong(hMsgWnd, GWL_WNDPROC, (LONG)lpfnSSNewProc);
	hMsgBrush = CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
	SendMessage(hMsgWnd, WM_SETFONT, (WPARAM)SetMsgFont("Helv", 8), (LPARAM)TRUE);
}

void MsgPrintf(char *szFormat, ...)
{
	va_list     vaArgs;
	char        szBuf[_MSG_BUFSIZ];

	va_start(vaArgs, szFormat);
	if (vsprintf(szBuf, szFormat, vaArgs) != EOF)
		SendMessage(hMsgWnd, WM_SETTEXT, 0, (LPARAM)szBuf);
	va_end(vaArgs);
}

int DoMsgSize(LPARAM lParam, UINT nOffset)
{
	int	iyClient, ixClient;

	if (lParam)
	{
		iyClient = HIWORD (lParam);
		ixClient = LOWORD (lParam);
		MoveWindow(hMsgBdrWnd, 7, iyClient-nOffset+3, ixClient-14, nOffset-5, TRUE);
		MoveWindow(hMsgWnd, 10, iyClient-nOffset+4, ixClient-20, nOffset-8, TRUE);
		return TRUE;
	}
	return FALSE;
}

HFONT SetMsgFont(LPSTR lpszFntName, int nPt)
{
	HDC         hDc;
	LOGFONT     lfont;
	HFONT			hMsgFnt;

	hDc = GetDC(hMsgWnd);
	memset(&lfont, 0, sizeof(lfont));

	lfont.lfHeight = -MulDiv(nPt, GetDeviceCaps(hDc, LOGPIXELSY), 72);
	lfont.lfWeight         = FW_NORMAL;
	strcpy((char *)lfont.lfFaceName, lpszFntName);
	hMsgFnt = CreateFontIndirect((LPLOGFONT) &lfont);

	ReleaseDC(hMsgWnd, hDc);
	return(hMsgFnt);
}

LRESULT CALLBACK _export SSNewProc(HWND hWnd, UINT iMessage,
													WPARAM wParam, LPARAM lParam)
{
	static char	szBuf[_MSG_BUFSIZ] = "";
	static HFONT 	hMsgFnt = NULL;
	HDC	hDc;
	RECT	rect;
	PAINTSTRUCT	ps;

	switch(iMessage)
	{
		case WM_SETFONT:
			hMsgFnt = (HFONT)wParam;
			break;

		case WM_SETTEXT:
			GetClientRect(hWnd, &rect);
			lstrcpy((LPSTR)szBuf, (LPSTR)lParam);
			InvalidateRect(hWnd, NULL, TRUE);
			return 0;

		case WM_PAINT:
			hDc = BeginPaint(hWnd, &ps);
			GetClientRect(hWnd, &rect);
			if (szBuf[0] == '\0')
				FillRect(hDc, &rect, hMsgBrush);
			else
			{
				SelectObject(hDc, hMsgFnt);
				SetBkColor(hDc, GetSysColor(COLOR_BTNFACE));
				SetTextColor(hDc, GetSysColor(COLOR_BTNTEXT));
				ExtTextOut(hDc, rect.left, rect.top, ETO_CLIPPED|ETO_OPAQUE,
							  &rect, szBuf, strlen(szBuf), NULL);
			}
			EndPaint(hWnd, &ps);
			return 0;

		case WM_CLOSE:
			if (hMsgBrush)
				DeleteObject(hMsgBrush);
			if (hMsgFnt)
				DeleteObject(hMsgFnt);
			hMsgBrush = NULL;
			hMsgFnt = NULL;
			break;
	}
	return CallWindowProc(lpfnSSOldProc, hWnd, iMessage, wParam, lParam);
}

