#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
------------------------------------------------------------------------
---------DEFINIRE A SECONDA SISTEMA OPERATIVO!!!!!!!!!!!!!!!!!!!
------------------------------------------------------------------------
*/
#define UNIXALPHA       /* macchina unix */
#undef MSDOS          /* prova su macchina DOS */
#undef DEBUG          /* definire per msg di debug */
#undef DEBUGPASS


#ifdef UNIXALPHA
  #include "md5.h"
  #include "des.h"
#endif

/*
------------------------------------------------------------------------
IPERupload.cgi

(C)1996 Aldo Ghigliano, s63998@athena.polito.it

This is freeware.


SCOPO:
------
 Questo programma cgi puo' ricevere comandi da un client, che comunica
con il server http tramite POST /../iperupload.cgi ...
 Per i parametri ed il funzionamento si veda il file di help
dell' IPERtool, SELFHELP.AEH

 Delle funzioni realizzate in realta' alla fine servono solo:
   AUTHINI
   PUT
   GETMYRIGHTS
   DEL

ISTRUZIONI DI COMPILAZIONE
--------------------------
- Definire opportunamente cio' che e' segnato con *************
- Mettere sulla vostra macchina la libreria "crypto", che ho preso da SSLeay,
  disponibile presso:
    http://www.polito.it/iper/ss...
  Credo convenga mettere tutta SSLeay.
- MyMemo: compilare con
    gcc iperup.c -o iperup.cgi -lcrypto -I/data/httpd/iper/
------------------------------------------------------------------------
*/

/*
------------------------------------------------------------------------
---------DEFINIRE!!!!!!!!!!!!!!!!!!!
------------------------------------------------------------------------
*/
#ifdef UNIXALPHA
  char c_base[]="/data/httpd/iper/";
  char c_pwddir[]="pwds/";
  char c_pwdfile[]="user.pwd";
  char c_userdirsfile[]="user.dir";
#endif

#ifdef MSDOS
  char c_base[]="\\C\\";
  char c_pwddir[]="";
  char c_pwdfile[]="user.pwd";
  char c_userdirsfile[]="user.dir";
#endif
















#define boolean char

#define TRUE 1
#define FALSE 0


typedef	char* string;
char 	c_init[]="Content-Type: text/plain\n";

char 	codice[3],
	m_stringa[256],
	m_user[80],        /*letti dal main da stdin, cioe' dal POST*/
        mm_user[81],
	m_pass[80],
	m_actn[80],
	m_base[256],
	passd[100],    /* pass supponendo che la pass fosse cod. con DES */
	pass[100];     /* pass vera */
        


/*
------------------------------------------------------------------
------------------------------------------------------------------
*/
void antispappola(string src, string dest, int len)
{
  int l;
  l=0;
  while (l<len)
  {
    dest[l]= ((src[l*2]-'A') & 0x0f)+
            (((src[l*2+1]-'A') << 4) & 0xf0);
    l++;
  }
  dest[len]=0;
}


/*
------------------------------------------------------------------
------------------------------------------------------------------
*/
void levazeri(string src, int len)
{
  int l;
  l=0;
  while (l<len)
  {
    if (src[l]==0) src[l]=1;
    l++;
  }
  src[len]=0;
}


/*
------------------------------------------------------------------
decodifica


in ingresso:
   key=parola ascii 16bytes 
   ascii=stringa 32bytes ascii multicodificata 
        (codificata da 16 bytes derivati da des di una
         stringa con  deskey=tronc8(md5(key)) 
   outdes=stringa decodificata
------------------------------------------------------------------
*/
void decodifica(string key, string ascii, string outdes)
{
  char indes[20],md5ofpass[20];
  string ss;
  int  l;
  #ifdef UNIXALPHA
    MD5_CTX c;
    des_key_schedule d;
    des_cblock dsk;
  #endif
          
  
  /*===
    calcolo l'md5 di key, e lo tronco a 8 bytes, dopo aver
    trasformato tutti gli '0' in '1'
    (per comodita')
  */  
  /*
    md5input=key
    md5output=md5ofpass
    hash
  */
  #ifdef UNIXALPHA 
    MD5_Init(&c);  
    MD5_Update(&c,key,strlen(key));
    MD5_Final(md5ofpass,&c);
  #endif
  levazeri(md5ofpass,16);
  md5ofpass[8]=0;

  /*===
    ottengo la stringa di 16 byte codificata con DES convertendo da
    una stringa di 32 bytes ASCII
  */
  /*
    desKey=md5ofPass
  */
  strncpy(dsk,md5ofpass,8);
  des_set_key(&dsk,&d);  
  antispappola(ascii,indes,16);

  
  outdes[16]=0;
  /*===
    decifro la stringa di 16 bytes con DES, usando come chiave
    quella ottenuta con Md5
  */
  /*
    desInput=indes
    desOutput=outdes
    des=ECB
    decipher
  */
  des_ecb_encrypt(indes,outdes,&d,DES_DECRYPT);
  des_ecb_encrypt(indes+8,outdes+8,&d,DES_DECRYPT);

  /*===
     elimino il padding a 13 che riempiva i 16 bytes della stringa
     codificata, se essa in origine era minore di 16 bytes 
  */
  ss=strchr(outdes,13);
  if (ss!=NULL) 
  {
    ss[0]=0;
  } else
  { 
    outdes[16]=0;
  }
}


















/*
---------------------------------------------------------------------------
   converte una stringa di 16 bytes BIN in 32 bytes ASCII,
   dove A=0
---------------------------------------------------------------------------
*/
void spappola(string wsrc, string wdest)
{
  int i=0;

  while (i<16)
  {
    wdest[i*2]='A'+(wsrc[i] & 0xf);
    wdest[i*2+1]='A'+((wsrc[i] &0xf0)>>4);
    i++;
  }
  wdest[i*2]=0;
}





/*
---------------------------------------------------------------------------
Codifico la password (max 16 caratteri, paddata con 13) con una chiave
DES arbitraria.
Questa codifica e' usata per mascherare la pass nel file  user.pwd.
Nel file  user.pwd  la pass volendo puo' anche essere inserita in chiaro. 
--------------------------------------------------------------------------
*/
void codif(string inpass, string outpass)
{
  char outdes[20];
  int  l;

  #ifdef UNIXALPHA
    des_key_schedule d;
    des_cblock dsk;
  #endif

  inpass[16]=0;
  l=strlen(inpass);
  while (l<16)
  { 
    inpass[l]=13;
    l++;
  }          
  inpass[16]=0;
  
  strncpy(dsk,"\x23\x4a\x5fpippo",8);
  des_set_key(&dsk,&d);  

  des_ecb_encrypt(inpass,outdes,&d,DES_ENCRYPT);
  des_ecb_encrypt(inpass+8,outdes+8,&d,DES_ENCRYPT);
  
  spappola(outdes,outpass);
}


/*
---------------------------------------------------------------------------
Decodifico la password (max 16 caratteri, paddata con 13) con una chiave
DES arbitraria.
--------------------------------------------------------------------------
*/
void decodif(string inpass, string outpass)
{
  char   indes[20];
  string ss;
  int    l;

  #ifdef UNIXALPHA
    des_key_schedule d;
    des_cblock dsk;
  #endif

  antispappola(inpass,indes,16);  
  
  strncpy(dsk,"\x23\x4a\x5fpippo",8);
  des_set_key(&dsk,&d);  

  outpass[16]=0;
  des_ecb_encrypt(indes,outpass,&d,DES_DECRYPT);
  des_ecb_encrypt(indes+8,outpass+8,&d,DES_DECRYPT);

  /*===
     elimino il padding a 13 che riempiva i 16 bytes della stringa
     codificata, se essa in origine era minore di 16 bytes 
  */
  ss=strchr(outpass,13);
  if (ss!=NULL) 
  {
    ss[0]=0;
  } else
  { 
    outpass[16]=0;
  }
}






/*
---------------------------------------------------------------------------
--------------------------------------------------------------------------
*/
void error(string str)
{
  fprintf(stderr,"[...some years later");
  #ifdef MSDOS
    ;
  #endif
  fprintf(stderr,"] IPERUP.CGI:[Monitor] reason:%s\n",str);
}



/*
---------------------------------------------------------------------------
   Cancello 13 e 10 eventualmente intrappati perche'
   Il content type e' binario
--------------------------------------------------------------------------
*/
void gets2(char *stringa)
{
  int l=0;

  gets(stringa);
  while (l<strlen(stringa))
  {
    if ( (stringa[l]==13) || (stringa[l]==10) )
    {
      strcpy(stringa+l,stringa+l+1);
    }
    l++;
  }
}





/*
---------------------------------------------------------------------------
   Salva la stringa casuale cod. dal server, in un file temporaneo
   specifico per ogni utente.
   Questa stringa vale 1 volta sola, e' cancellata dopo il primo tentativo
   di immissione pass.
--------------------------------------------------------------------------
*/
void salva_strcasuale(string wtruepass)
{
  char    st[100],str2[255];
  FILE    *fil;

  /* salvo */
  strcpy(st,c_base);
  strcat(st,c_pwddir);
  strcat(st,m_user);
  strcat(st,".pp");
  fil=fopen(st,"wb");
  if (fil!=NULL)
  {
    fputs(wtruepass,fil);
    fputs("\0\n",fil);
    fclose(fil);

    /* QUI CI VA UN CHMOD PERCHE' la stringa casuale appena generata
       DEVE ESSERE VISIBILE
       SOLO AL SERVER, altrimenti tanti saluti alla sicurezza.
    */
    strcpy(str2,"chmod og-rw u+rw ");
    strcat(str2,st);

    system(str2);
  } else
  {
    puts("Problemi a scrivere il file temporaneo di pass...");
  }
}




/*
---------------------------------------------------------------------------
   Carica la stringa casuale, la pass dell'utente, le accoda,
   codifico con MD5, spappola (cioe' converte i 16 byte MD5 in 32 ascii
   e restituisce il risultato
   (hash password utente spappolata in ASCII)
--------------------------------------------------------------------------
*/
void get_strcasuale(string wtruepass)
{
  #ifdef UNIXALPHA
    MD5_CTX c;
  #endif
  char    str_src[100],str_dest[100],st[100],
	  str_cas[100],pass2[100];
  char    linea[500],sss[100];
  boolean flag;
  string  lineai,lineaf;
  FILE    *fil;

  /* leggo la stringa casuale */
  /* salvo */
  strcpy(st,c_base);
  strcat(st,c_pwddir);
  strcat(st,m_user);
  strcat(st,".pp");
  fil=fopen(st,"rt");
  if (fil!=NULL)
  {
    fgets(str_cas,34,fil);
    str_cas[32]=0;
    fclose(fil);
  } else {
    puts("Temp random string KO");
    #ifdef DEBUG
      error("File temporaneo di stringa casuale KO.");
    #endif
  };
  remove(st); /* cancello str. casuale */


  /* leggo la pass */
  strcpy(st,c_base);
  strcat(st,c_pwdfile);
  fil=fopen(st,"rt");
  #ifdef DEBUG
    error("Apertura file pwd.");
  #endif

  flag=TRUE;
  if (fil==NULL) {
    puts("Non riesco ad accedere al file");
    puts(st);
  }
  while ((fgets(linea,500,fil)!=NULL) && (flag))
  {
    lineai=strstr(linea," ");
    if (strncmp(linea,mm_user,lineai-linea+1)==0) {

      lineai++;
      lineaf=lineai;
      while ( ((*lineaf)!=13) &&
	      ((*lineaf)!=10) &&
	      ((*lineaf)!=' ') ) lineaf++;
      if ((lineai!=NULL))
      {
          
	  strncpy(pass,lineai,lineaf-lineai);
	  pass[lineaf-lineai]=0;
	  flag=FALSE;
	/* se la pass esiste la ricopio nella var pass
	*/
      }
    }
  }
  fclose(fil);


  /* !!!!!!!!!!!!!!!!!! */
  if (strlen(pass)<30) 
  {  
    /* la pass nel file di pass e' in chiaro */

    /* accodo */
    strcat(str_cas,pass);
    #ifdef DEBUGPASS
      puts(str_cas);
    #endif


    #ifdef UNIXALPHA
      MD5_Init(&c);
      MD5_Update(&c,str_cas,strlen(str_cas));
      MD5_Final(str_dest,&c);
    #else
      strcpy(str_dest,"\x11\x11\x22\x22\x11\x11\x22\x22\x11\x11\x22\x22\x11\x11\x22\x22");
      /* pass provvisoria pari a BBBBCCCCBBBBCCCCBBBBCCCCBBBBCCCC */
    #endif


    /* ora in dest ho la stringa md5: la spappolo in 32 caratteri ascii */
    spappola(str_dest,wtruepass);
    wtruepass[32]=0;

  } else {    
  
    /* !!!!!!!!!!!!!!!!!!!!! 
      la pass e' codificata!
      parte che fa l'hash con la decodifica DES della PASS 
    */
    
    
    /* accodo */
    decodif(pass,pass2); /* src dest (sorry but I think in Pascal) */
    strcpy(pass,pass2);  /* dest src (grrr! this is C) */
    /* memorizzo nella variabile globale pass la pass effettiva */
    strcat(str_cas,pass);
    #ifdef DEBUGPASS
      puts(str_cas);
    #endif


    #ifdef UNIXALPHA
      MD5_Init(&c);
      MD5_Update(&c,str_cas,strlen(str_cas));
      MD5_Final(str_dest,&c);
    #else
      strcpy(str_dest,"\x11\x11\x22\x22\x11\x11\x22\x22\x11\x11\x22\x22\x11\x11\x22\x22");
      /* pass provvisoria pari a BBBBCCCCBBBBCCCCBBBBCCCCBBBBCCCC */
    #endif


    /* ora in dest ho la stringa md5: la spappolo in 32 caratteri ascii */
    spappola(str_dest,wtruepass);
    wtruepass[32]=0;
  }
}




/*
----------------------------------------------------------------------
  chiamata da CHPASS
  sostituisce alla vecchia pass la decodifica
  della nuova fatta con la vecchia
----------------------------------------------------------------------
*/
int dodes()
{
  FILE *fils;
  FILE *fild;
  char outdes[30],outpass[50];
  char st[300],ss[300];
  char    linea[500];
  string  lineai,lineaf;
  
  
  
	    /* LA PASS mi e' inviata nel parametro contenuto in
	      m_stringa, codificata con DES, usando come
	      chiave 8 byte md5 della vecchia PASS */
	      
	    /* leggo vecchia pass gia' per l'aut, e' in pass  
	        decodifico con DES */
  decodifica(pass,m_stringa,outdes);
  
  	  
	    
	    /* salvo la nuova pass nel file user.pwd*/
  strcpy(st,c_base);
  strcat(st,c_pwdfile);
  strcpy(ss,st);
  strcat(ss,".old");
  /*
    rinomino .old il vecchio file di pass, lo apro, e lo
    scorro per creare il nuovo file di pass.
  */
  
  
  if (rename(st,ss)==0) 
  {
    fils=fopen(ss,"rt");
    fild=fopen(st,"wt");
  
    if ((fils!=NULL) && (fild!=NULL)) 
    {
      while ((fgets(linea,500,fils)!=NULL))
      {
        lineai=strstr(linea," ");
        if (strncmp(linea,mm_user,lineai-linea+1)==0) 
        {
          lineai++;
          lineaf=lineai;
          while ( ((*lineaf)!=13) &&
	      ((*lineaf)!=10) &&
	      ((*lineaf)!=' ') ) lineaf++;
          if ((lineai!=NULL))
          {
	    /* 
	      scrivo file
	    */
	    fputs(m_user,fild);
	    fputs(" ",fild);
	    /*
	      codifico la nuova pass con DES
	    */
	    codif(outdes,outpass);
	    
	    /*
	      scrivo pass
	    */
	    fputs(outpass,fild);
	    fputs("\x0A",fild);
          }  
        } else fputs(linea,fild);
      }
      fclose(fils);
      fclose(fild);
      strcpy(ss,"chmod 700 ");
      strcat(ss,st);
      system(ss);

    
      puts("Yes, pass change done");
      return 1;
    } else puts("Problemi sul server leggendo/creando file di pass.");
  } else puts("Problemi sul server rinominando il file di pass.");

  /*
            puts("Questa funzione verra' automaticamente attivata"
                 " non appena disponibile. Riferirsi intanto al 7072.");
  */
}





/*
---------------------------------------------------------------------------
  Restituisce true se la stringa in ingresso non contiene simboli che
  permettono azioni truffaldine
--------------------------------------------------------------------------
*/
boolean is_string_ok(string stringa)
{
  return ((strstr(stringa,"..") != NULL)
     ||(strchr(stringa,' ') != NULL)
     ||(strchr(stringa,';') != NULL)
     ||(strchr(stringa,'|') != NULL)
     ||(strchr(stringa,'<') != NULL)
     ||(strchr(stringa,'>') != NULL)
     );
}






/*
------------------------------------------------------------------
   autentico pass e dir dove l'utente puo' scrivere

   legge:
    - user.dir  per vedere se l'utente user
      formato:
		!max 255 caratteri per linea 255K totale
		!NB. il nome utente non puo' contenere '_'
		!
		!utente  dirwrite  dirread  corso/argomento
		!
		aldo /users/s63998/public_html/usr/puffo/ /~s63998/usr/puffo/ Puffologia applicata
		aldo /users/s63998/public_html/usr/fondapuff/ /~s63998/usr/fondapuff/ Fondamenti di puffologia
		fabio /users/s63998/public_html/usr/web/ /~s63998/usr/web/ Fondamenti di webmasterologia

      e' autorizzato ad accedere alla dir base.
      ad es. per aldo e' corretto
	base=/users/s63998/public_html/usr/puffo/

    - controlla che stringa non contenga ".."
------------------------------------------------------------------
*/
int checkautorization()
{
  FILE    *fil;
  char    linea[500],st[255],linea2[100];
  string  lineai,lineaf;
  boolean flag;


  /* verifico pass */
  {
    get_strcasuale(linea);
    /* linea
         e' l'hash spappolato della pass mem. sul server,
    */
    if (strcmp(linea,m_pass)!=0) {
        puts("Pass KO.");
        #ifdef DEBUGPASS
          puts(m_pass);
          puts(linea);
        #endif
        return 0;
    }
    #ifdef DEBUG
      error("Pass OK.");
    #endif
  }



  /* verifico dir, se l'azione non e' CHPASS */
  if (strncmp(m_actn,"CHPASS",6)!=0)
  {
    strcpy(st,c_base);
    strcat(st,c_userdirsfile);
    fil=fopen(st,"rt");
    if (fil==NULL)
    {
      puts("No user.dir!!");
      return 0;
    }
    flag=TRUE;
    while ((fgets(linea,500,fil)!=NULL) && (flag))
    {
      lineai=strstr(linea," ");
      if (strncmp(linea,mm_user,lineai-linea+1)==0) {

	lineai++;
	lineaf=strstr(lineai," ");
	if ((lineai!=NULL) && (strncmp(lineai,m_base,lineaf-lineai)==0))
	  flag=FALSE;
	/* se la base dir corrisponde setto un flag, altrimenti
	 proseguo, perche' un utente puo' avere piu' basedir
	 a cui e' autorizzato ad accedere */
      }
    }
    fclose(fil);

    if (flag)
    {
      puts("Base dir KO.");
      return 0;
    }
    #ifdef DEBUG
      error("Base dir OK.");
    #endif
  }


  /* impedisco cd.. redirezioni, pipe, azioni truffaldine */
  if (
       (is_string_ok(m_base))
	       &&
       (is_string_ok(m_stringa))
     )
  {
    puts("Invalid chars!\n");
    return 0;
  }

  return 1;
  /* */
}



















/*
---------------------------------------------------------------------------------

stringa casuale
la genero, la spedisco, la memorizzo

---------------------------------------------------------------------------------
*/
void put_strcasuale()
{
  char str[100],str_casuale[40];

  strcpy(str_casuale,"stringa casuale");

  #ifdef UNIXALPHA
    RAND_seed(str_casuale,10);
    RAND_bytes(str,16);
  #else
    strcpy(str,"ABCDABCDABCDABCD");
  #endif

  spappola(str,str_casuale);

  salva_strcasuale(str_casuale);

  puts(str_casuale);
  #ifdef DEBUG
    error("Fine put stringa casuale.");
  #endif
}





/*
---------------------------------------------------------------------------------
  estraggo dal file user.dir le linne che iniziano con il nome dell'utente:
  l'utente riceve cosi' le info sulle dir cui puo' sccedere e una
  descrizione del loro contenuto, secondo il formato concordato per user.dir
---------------------------------------------------------------------------------
*/
void put_rights()
{
    FILE    *fil;
    char    linea[500],st[255];
    boolean flag;
    string  lineai;

    strcpy(st,c_base);
    strcat(st,c_userdirsfile);
    fil=fopen(st,"rt");
    if (fil==NULL)
    {
      puts("No user.dir!!");
    }
    flag=TRUE;
    while ((fgets(linea,500,fil)!=NULL) && (flag))
    {
      lineai=strstr(linea," ");
      if (strncmp(linea,mm_user,lineai-linea+1)==0) {
	printf(linea);
      }
    }
    fclose(fil);
}
























/*
------------------------------------------------------------------
    MAIN
------------------------------------------------------------------
*/
int main()
{
  char buf[BUFSIZ],tmp[256],stringa1[256];
  long lung;
  int i;
  FILE *fil;



  /* mando init */
  puts(c_init);


  gets2(tmp);

  if (strncmp(tmp,"user=",5)==0) {
    strcpy(m_user,tmp+5);
    strcpy(mm_user,m_user);
    strcat(mm_user," ");

    gets2(tmp);
    if (strncmp(tmp,"pass=",5)==0) {
      strcpy(m_pass,tmp+5);

      gets2(tmp);
      if (strncmp(tmp,"base=",5)==0) {
	strcpy(m_base,tmp+5);

	gets2(tmp);
	if (strncmp(tmp,"actn=",5)==0) {
	  strcpy(m_actn,tmp+5);


	  /* get del 5^ parametro, che c'e' sempre */
	  gets2(m_stringa);



	  #ifdef DEBUG
	    error("User,base,azione,stringa");
	    error(m_user);
	    /* fputs(pass,stderr); */
	    error(m_base);
	    error(m_actn);
	    error(m_stringa);
	  #endif


	  /* per chiedere AUTHINI, GETMYRIGHTS, SEIVIVO, non serve
	     autorizzazione */
	  if
	    ((strncmp(m_actn,"AUTHINI",7)!=0)
			&&
	    (strncmp(m_actn,"SEIVIVO",7)!=0)
			&&
	    (strncmp(m_actn,"GETMYRIGHTS",11)!=0)
			&&
	      (checkautorization()==0))
	  {
	    #ifdef DEBUG
	      error("Autentication failure.");
	    #endif
	    puts("Autentication failure.\n");
	    return 0;
	  }


	  /*-------------------------------------------------------------
	   FORNISCO LA STR. CASUALE */
	  if (strncmp(m_actn,"AUTHINI",7)==0) {
	    put_strcasuale();
	    return 0;
	  } else


	  /*-------------------------------------------------------------
	   FORNISCO UN ESTRATTO DEL FILE user.dir, RELATIVO ALL'UTENTE
	   CHIAMANTE; sostituisce il GET dell'intero file USER.DIR
	   da parte dell'utente */
	  if (strncmp(m_actn,"GETMYRIGHTS",11)==0) {
	    put_rights();
	    return 0;
	  } else


	  /*-------------------------------------------------------------
	     SALVO il file binario che mi manda l'utente
	     nella dir base o in una sottodir */
	  if (strncmp(m_actn,"PUT",3)==0) {
	    strcpy(tmp,m_base);
	    strcat(tmp,m_stringa);
	    fil=fopen(tmp,"wb");
	    fputs("\n",stderr);
	    fputs(tmp,stderr);
	    fputs("\n",stderr);

	    if (fil!=NULL) {
	      gets2(m_stringa);
	      lung=atoi(m_stringa);
	      /* mangio 13,10 */
	      /* fread(buf,2,1,stdin);*/

	      /* leggo lunghezza del file binario che mi hanno mandato*/

	      /* binario??? */

		while (lung>BUFSIZ) {
		  fread(buf,BUFSIZ,1,stdin);
		  fwrite(buf,BUFSIZ,1,fil);
		  lung=lung-BUFSIZ;
		}
		if (lung>0) {
		  fread(buf,lung,1,stdin);
		  fwrite(buf,lung,1,fil);
		}

		/* fclose(filin); */
		fclose(fil);

	      /* else
		puts("Not put");
		return 0;
	      */

		strcpy(m_stringa,"chmod og-w a+r u+w ");
		strcat(m_stringa,tmp);
		system(m_stringa);

	    } else
	    {
		puts("Not put");
		return 0;
	    }
	    puts("Yes, put done");
	    return 0;
	  } else


	  /*-------------------------------------------------------------
	     CANCELLO UN FILE nella dir base o in una sottodir */
	  if (strncmp(m_actn,"DEL",3)==0) {
	    
	    strcpy(tmp,m_base);
	    strcat(tmp,m_stringa);

	    if (remove(tmp)==0) {
	      puts("Yes, del done");
	    } else {
	      puts("Not done del");
	    };
	    return 0;
	  } else


	  /*-------------------------------------------------------------
	     CONSENTO ALL' UTENTE di cambiare la pass
	  */
	  if (strncmp(m_actn,"CHPASS",6)==0) {
	    dodes();

	    return 0;
	  } else


	  /*-------------------------------------------------------------
	    TEST */
	  if (strncmp(m_actn,"SEIVIVO",7)==0) {
	    puts("Son vivo!");
	    return 0;
	  } else


	  /*-------------------------------------------------------------
	    LEGGO LA DIR della subdir specificata da base */
	  if (strncmp(m_actn,"LS",2)==0) {
	    strcpy(tmp,"cd ");
	    strcat(tmp,m_base);
	    system(tmp);
	    system("ls -la |& cat");
	    return 0;
	  } else







	  /* ==========
			FOLLOWING FUNCTIONS MAY BE OBSOLETE...
			NON USATA DAL SISTEMA IPERUPLOAD, SI PUO' TOGLIERE
	  */


	  /* CREO UNA DIRECTORY  nella dir base o in una sottodir  */
	  if (strncmp(m_actn,"MD",2)==0) {
	    /*
	    strcpy(tmp,"mkdir -m+rx ");
	    strcat(tmp,m_base);
	    strcat(tmp,m_stringa);

	    if (system(tmp)==0) {
	      puts("Yes, dir maked");
	    } else {
	      puts("Not maked dir");
	    };
	    */
	    return 0;
	  } else


	  /* CANCELLO UNA DIR dentro la dir. base */
	  if (strncmp(m_actn,"RD",2)==0) {
	    /*
	    if (strlen(m_base) > 10) {
	      strcpy(tmp,"rm -r ");
	      strcat(tmp,m_base);
	      strcat(tmp,m_stringa);

	      if (system(tmp)==0) {
		puts("Yes, dir removed");
	      } else {
		puts("Not removed dir");
	      };
	    }
	    */
	    return 0;
	  } else




	  if (strncmp(m_actn,"DIR",3)==0) {
	    
	    return 0;
	  } else
	  {
	    puts("IPERupload: funzione non disponibile o errore nel programma"
	    	      "chiamante.");
	    return 0;
	  }


	}
      }
    }
  }

  /* comunico al client che qualcosa e' ko*/
  puts("Error");
  return 0;





}