#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
_________________________________________________________________________________________

IPERSERVER 0.5  (C)1996 Aldo Ghigliano  All Rights Reserved
This software is not freeware nor shareware.
This software is free of charge only for university students and no-profit
organizations.

For business purpose please contact the autor: s63998@athena.polito.it

[Ver 1.00 - 11/3/1996]
Now Ver 2.07  8/96


SCOPO:
Legge un file AEH e butta su stdOut, a seconda dei parametri in ingresso,
una pagina HTML, un'immagine, un file, ecc.
Le pagine HTML generate contengono nei link e nelle immagini dei riferimenti
a IPERSERVER stesso.

Per il corretto funzionamento del programma e' indispensabile settare
il file di configurazione IPER.INI.
Le indicazioni su come settarlo e sul funzionamento del programma sono
disponibili nella guida dell'IPERtool, che e' disponibile on-line
all'indirizzo
  http://www.polito.it/iper.

La guida e' visualizzata da IPERserver stesso, pertanto costituisce
contemporaneamente una dimostrazione del funzionamento del programma.
La guida puo' essere consultata anche non in rete, su un comune PC.
E' sufficiente scaricarla dall'indirizzo:
  http://www.polito.it/iper/selfhelp.aeh

Per visionare la guida su PC e' necessario leggere il file AEH con il
programma IPERedit: il disco di intallazione di IPERedit e' scaricabile
all'indirizzo:
  http://www.polito.it/iper/install/ins.zip

Le istruzioni per l'installazione di IPERedit sono presenti nella
guida on-line all'indirizzo suindicato. IPERedit serve per leggere e creare
files AEH.

Il programma IPERserver e' molto semplice.
IPERedit e' circa 100-200 volte piu' esteso.
_________________________________________________________________________________________

Per testare il programma in DOS, con stdin e stdout:
settare
	set PATH_INFO=/0/0/Z/path/selfhelp.aeh/

dopo aver messo selfhelp.aeh nella dir corrente.
A questo punto chiamando iper esso dovrebbe mostrare la pagina 0.
_________________________________________________________________________________________
*/



/*
=============================================================================

ISTRUZIONI PER L'UTILIZZO

- vedere il manuale a www.polito.it/iper, CHE FA SEMPRE BENE...
- creare il file iper.ini
- compilare iper.c  in  iper.cgi, guardando prima che i seguenti define siano
  quelli desiderati per il vostro sistema

=============================================================================
*/

/* 1) ==========
   DOS o UNIX ? se dos, define MSDOS, altrimenti define UNIXALPHA
   Il programma e' stato compilato con successo anche su SUN.
   Vedi www.uniud.it [devo mett ind compl...................]
*/
#define  UNIXALPHA
#undef MSDOS



/* 2) ==========
   BLACKbox : se volete usare l'interfaccia database che interopera
   con il programma balckbox, definite la seguente linea
*/
#define YESBLACKBOX


 
/* 3) ==========
   Debug
*/
#ifdef MSDOS
  #define DEBUG
#endif

#define UTIL
























#ifdef UNIXALPHA
#ifdef YESBLACKBOX
#include <sys/msg.h>
#include <sys/ipc.h>
#endif
#endif

/* #define MAXUTENTI 100 */

#ifdef MSDOS
  char barra[]="\\";
  char barrach='\\';
  typedef long int4;
  #define config_file "iperdos.ini"
  #define BUFLEN 10000
  #define MAXARRAY 2000
#endif


#ifdef UNIXALPHA
  char barra[]="/";
  char barrach='/';
  typedef int int4;
  #define BUFLEN 33000
  #define MAXARRAY 64000
#define config_file "iper.ini"
#endif

/* FILE DI CONFIGURAZIONE */

/* NUMERO DI MACCHINA COMPOSTO DI 4 BYTE (INT, LONG,... A SECONDA DELLA MACCHINA,
	CHE ORRRORE IL C!) */

/* NELLA DIRECTORY DI IPER DEVONO ESSERE PRESENTI ANCHE I FILE:
	 - P_SOMM.GIF
	 - P_CERCA
	 - P_GUIDA
	 - P_PRECED
	 - P_COPER
*/



/*
====================================================================
====================================================================
*/
#define MAXKEYS 1000
#define boolean char
#define TRUE 1
#define FALSE 0
#define TFINERIGA 22
#define TCASELLANORMALE 33
#define NIL NULL

/*
====================================================================
	TIPI E RECORD MUTUATI DAL PROGRAMMA DELPHI
====================================================================
*/
enum {tttop,ttself,ttparent,ttblank } ttargettipo; 
enum {tacancellato,tavecchia,tanormale}
	  ttabellatipo;
enum {iscancellato,isedit,ispass,isfile,ismemo,
		ishidden,isradio,ischeck,islist,iscombo,
		iscommento,ishtml,isprogramma,
		isspace0,isspace1,isspace2,isspace3,
		isspace4,isfloatingframe                                        
		}
	  tinputstattipo;
enum {idcancellato,idedit,idmemo,
		idhidden,idradiosingle,idchecksingle,idlist,idcombo,
		idtable,idradio,idcheck,iddinlist,idhtml}
	  tinputdintipo;
enum {btcancellato,btsubmit,btimage,btreset}
	  tbottonecgitipo;
enum {ifcancellato,ifget,ifpost,ifautopass}
	  tinizioformtipo;
enum {imgif,imjpg,imtrgif,imcancellato,imngf,imnjpg}
	  timmaginetipo;
enum {lkwav,lkmidi,lkavi,lkmov,lkquals,lkcancellato}
	  tlinktipo;
enum {thtesto,thpopup,thframe,thcancellato}
	  ttestohtmltipo;
enum {prdummy,prcancellato,prnormale}
	  tprogrammatipo;
enum {mfdummy,mfcancellato,mfnormale}
	  tmappaframetipo;

enum {mmcancellato,mmwav,mmmidi,mmavi,
                        mmmov};
                        
enum {testohtml,internetlink,ziplink,genlink,
	keyword,
	immagine,mappaclic,
	programma,
	tabellahtml,mappaframe,
	spazio0,
	spazio1,
	spazio2,
	spazio3,
	spazio4,
	spazio5,
	spazio6,
	spazio7,
	spazio8,
	spazio9,
	inputstat,
	inputdin,
	bottonecgi,
	inizioform,
	multimedia,
	boh,
	tohUltimo,
	testoHtmlRtf}
	  toggettihel;

enum {dgfile,dgblackbox}
	  tdingettipo;
enum {friga,fcol,ftopriga,fbotriga,fsxcol,fdxcol,fprimo}
	  tframetipo;
enum {hsx,hdx,hcentro,hgiustificato,hnojuschange}
	  thjusty;
enum {vtop,vmiddle,vbottom}
	  tvjusty;
enum {asx,adx,acentro,atop,amiddle,abottom}
	  tallinea;
enum {ffpre,fftt}
	  tfontfisso;
enum {atpulsanti,atloop,atmouse,atfileopen};
  


typedef char riferimenti[4];
typedef char intc4[4];
typedef char intc2[2];
typedef char* string;
typedef char tarrayint[32000];
typedef char foffset[4];
typedef char offset[4];
typedef char str75[76];
typedef char str79[80];
typedef char str255[256];
typedef char str127[128];
typedef char tcolor[4];
typedef char tpmultiimage[4];



/*
==============================================================

		  oggetti primari di HEL

==============================================================
  !!!!!!!!!!!!!!!!!
						 - i primi 3 campi di testohtml..genlink
							devono ess.=
						 - per 32bit  bene tutti i record siano
							lunghi un multiplo di 4bytes.
*/

/*=== TESTOHTML
	****************
	   una pagina Html, oppure  una pagina Html che verr
	  realizzata in una simulazione di finestra popup,
	  oppure un frame.

	  Pu contenere alcuni classici comandi HTML i riferimenti a
	  links e immagini sono fatti in modo diverso dall'HTML usuale
	  (vedi dopo).
*/

  typedef struct
  {
	 foffset        fileoffs;
	 char           tipo;
	 str75          caption;
	 riferimenti    framedata;   /*se <>$ffffffff punta ad un oggetto
											frame, di cui  il frame principale,
											o master*/
	 riferimenti    sfondo;      /*se $fffffffe -2  popup,
											se $ffffffff -1 no sfondo,
											altrimenti  il riferimento dell'
											immagine che fa da sfondo*/
	 tcolor         testocol,
			linkcol,
			follcol,
			sfondocol;
	 riferimenti    keyword[20];
	 intc4		len;
	 char           br,brr;
	 offset         offs;        /*puntatore a oggetto
				       secondario che contiene il
				       testo vero e proprio*/
	 char           bubble[200];
  } ttestohtml;
  typedef ttestohtml* ptestohtml;


/* INTERNETLINK
	*************
	  consente di inserire links a pagine Internet qualsiasi,
	  a mail (mailto:)
	  ad altri files AEH (iper:)
*/
  typedef struct
  {
	 foffset        fileoffs;    /*dummy*/
	 char           tipo;
	 str127         caption;     /*+ spazio x internet */
  } tinternetlink;
  typedef tinternetlink* pinternetlink;


/*=== genlink
	*************
	  consente di incorporare files qualsiasi dentro un file AEH
*/
  typedef struct
  {
	 foffset        fileoffs;    /*offset nel file dell' ogg.
											secondario, che coincide con il file
											incorporato*/
	 char           tipo;
	 str79          caption;     /*nome file*/
	 intc4		len;         /*lunghezza file, pu essere file >64K*/
  } tgenlink;
  typedef tgenlink* pgenlink;


/*=== ZIPLINK
	*************
	  consente di incorporare files qualsiasi dentro un file AEH
  */
  typedef tgenlink tziplink;
  typedef tziplink* pziplink;


/*=== KEYWORD
	****************
	  consente di associare ad ogni pagina TESTOHTML una o pi
	  parole chiavi globali.
	  Questo consente in windows tramite IPERedit, o in
	  Internet tramite IPERserver, di fare ricerche per keyword,
	  similmente a quanto avviene negli help di windows.
	  Un rif. a kwd non pu essere inserito all'interno del testo.
	  Va messo nell'array  keyword dell'oggetto TESTOHTML.
	  E' longint, sono valide le kw >0

*/

  typedef struct
  {
	 str79          caption;     /* */
  } tkeyword;
  typedef tkeyword* pkeyword;


/*=== PROGRAMMA
	****************
	  consente di inserire parti di testo sottolineate o immagini
	  che se cliccate lanciano un programma windows associato.
	  Puo' essere utile per inserire animazioni o altro
*/
  typedef struct
  {
	 foffset        fileoffs;    /*dummy*/
	 char           tipo;
	 str75          caption;     /*nome file*/
	 str127         winpath;
	 str255		webrif;
  } tprogramma;
  typedef tprogramma* pprogramma;




/*!!!!!!!!!!!!!!!!!
				 - i primi 3 campi di
			immagine,mappaclic,tabellahtml,equazione
			devono essere uguali
*/
/*=== IMMAGINE
	****************
	  consente di inserire nel testo immagini, anche trasparenti
*/
  typedef struct
  {
	 foffset        fileoffs;    /*dummy*/
	 char           tipo;
	 str75          caption;     /*nome file*/
	 riferimenti    defaultlink; /*default link per mappa clic*/
	 intc2          w,h;
	 char           allin;
	 tpmultiimage   bmp;
	 str75		filename;
	 tcolor         traspcol;
	 intc4 		len;
  } timmagine;
  typedef timmagine* pimmagine;


/*=== mappaclic
	***************
	  consente di inserire nel testo mappe cliccabili, anche trasparenti
*/
	 typedef struct
	 {
		  riferimenti link;
		  intc4       dummy;
		  intc2       le,t,w,h;
	 } clicklink;
  typedef struct
  {
	 timmagine    img;     /*immagine*/
	 intc4        tipo;
	 clicklink    links[30/*maxzoneclic*/];
										  /*rettangoli in cui si clicca e links
											a cui rimandano*/
										  /*il primo  SOPRA a tutti*/
  } tmappaclic;
  typedef tmappaclic* pmappaclic;


/*=== EQUAZIONE
	****************
	  future exp.
*/
  typedef timmagine   tequazione;
  typedef tequazione* pequazione;


/*=== TABELLAHTML
	****************
	  consente di inserire tabelle che possono utilizzare
	  quasi tutte le opzioni dell'Html.
	  I dati relativi ad una tabella sono memorizzati tramite
	  l'oggetto primario e secondario: nell'AHTML, oltre
	  al tag di inizio tabella <$08xxyyxx> sono contemplati
	  solo i tag <TF> (fine casella) e <TE> (fine tabella).
	  L'editor funziona bene senza altri orpelli.
*/
  typedef intc4* plongint;

  typedef struct
  {
	 foffset        fileoffs;    /*offset nel file dell' ogg.
											secondario, che coincide con
											le info sullo sfondo esteso della
											tabella.*/
	 char           tipo;
	 str75          caption;     /*nome file*/
	 intc4          offs;        /*puntatore a oggetto
											secondario che contiene altri dati
											interni della tabella
										  */
	 intc2 		len;
	 boolean        editata;
	 char           h_perc,w_perc,cellpadding,cellspacing,
						 bordo,righe,colonne;
	 char           hjus;
	 char	        vjus;
	 char           wcolonne[100];

	 /* nuovi campi */
	 foffset        fileoffs2;   /* non usati per ora*/
	 intc4          offs2;
	 intc2          len2;
	 riferimenti    sfondo;      /* se primo byte 0  colore,
											else  rif. a immagine
											else se $ffffffff no colore */
	 tcolor         bcolorlight,bcolordark;
	 char           bubble[200];
  } ttabellahtml;
  typedef ttabellahtml* ptabellahtml;


/*=== mappaframe
	****************
	  consente di creare pagine multiframe, in cui ogni frame
	   disegnato usando un corrispondente oggetto TestoHtml
*/
  typedef struct
  {
	 foffset        fileoffs;    /*offset nel file dell' ogg.
											secondario*/
	 char           tipo;
	 str79          caption;     /*nome file*/
	 intc4          len;         /*lunghezza della strutt. dati
											al momento del salvataggio*/
	 intc4          lenRecords;  /* lunghezza del record rel. ad ogni
											frame sizeof(TFrameSave) */
	 intc4          root;         /* bject */
	 intc4          len3;        /* lunghezza della strutt. terziaria,
											cio il testo per il server, che
											preparo in Delphi per pigrizia */
	 foffset        fileoffs3;
	 intc4          dummy;
	 char           dummy2[3];
  } tmappaframe;
  typedef tmappaframe* pmappaframe;


  /*!!!!!!!!!!!!!!!!! OGGETTI VISUAL
						 - i primi 5-7 campi
							devono essere uguali
  */
  /*=== INPUTSTAT
	***************
	  consente di inserire un elemento passivo di un form
  */
  typedef struct
  {
	 foffset        fileoffs;  /* puntatore a contenuto */
	 char           tipo;
	 intc4          obj;
	 offset         offs;
	 intc4          len;

	 str79          name,
						 value;
	 char           cols,rows,
						 size;
	 boolean        putvalue,checked,multiple;
	 char           dummy;
  } tinputstat;
  typedef tinputstat* pinputstat;

  /*=== INPUTSTAT2
	***************
	  
  */
  typedef struct
  {
	 foffset        fileoffs;  /* puntatore a contenuto */
	 char           tipo;
	 intc4          obj;
	 offset         offs;
	 intc4          len;

         str79          name;
         boolean        _scroll;
         char           _margh,_margw;
         intc4          bordercolor;
         intc4 	        _caller;
         intc4          _link;  /* link iniz. della fin.*/
         intc4          worklink;       /* future exp */
         boolean        useframeset;
         char           dumm[79-1-4-4-4-4-2-1 +1];
         char           target;
         boolean        percent,dum;      /* 3 */
         intc2          hhh,www;          /*   4 */
  } tinputstat2;
  typedef tinputstat2* pinputstat2;



                                                                                          


  /*=== INPUTDIN
	***************
	  consente di inserire un elemento attivo di un form, che runtime
	  si carica attingendo ad un file sul server o usando un programma
	  di interfaccia con un database (IPERblackbox)
  */
  typedef struct
  {
	 foffset        fileoffs;  /* puntatore a contenuto, cioe'
				  query */
	 char           tipo;
	 intc4          obj;
	 offset         offs;
	 intc4          len;

	 str79          name,
			value;
	 char           cols,rows,
			size;
	 boolean        putvalue,checked,multiple;
	 /* char           dummy; */
	 char           dintipo;

	 offset         offsQR;  /*non piu' usati in iperedit*/
	 intc4          lenQR;

	 str127         dborhtfilename,
			serverorfilename;
	 char           spaces,numremarks,
			dummy2[2];
  } tinputdin;
  typedef tinputdin* pinputdin;


  /*=== BOTTONECGI
	***************
	  consente di inserire un pulsante di immissione CGI
	  che puo' scatenare un semplice SUBMIT oppure puo' far
	  andare ad un'altra pagina, specificata all'inizio del form
  */
  typedef struct
  {
	 foffset        fileoffs;  /* puntatore a contenuto, cioe'
				  query */
	 char           tipo;
	 intc4          obj;
	 offset         offs;
	 intc4          len;

	 str79          name,
						 value;
	 riferimenti    rifimage;
	 riferimenti    link;
	 char           allin;
	 intc4          dummy;
	 char           dummy1[2];
  } tbottonecgi;
  typedef tbottonecgi* pbottonecgi;


  /*=== INIZIOFORM mark di inizio form
	************
  */
  typedef struct
  {
	 foffset         fileoffs;  /* puntatore a contenuto, cioe'
				   query */
	 char            tipo;
	 intc4           obj;
	 offset          offs;
	 intc4           len;
         char            azione[256]; 
	 boolean         putenctype;
	 intc2           dummy;
	 str79           enctype;
  } tinizioform;
  typedef tinizioform* pinizioform;


  /*=== MULTIMEDIA
  */
  
  typedef struct
  {         
	 foffset         fileoffs;  /* puntatore a contenuto, cioe'
				   query */
	 char            tipo;
	 intc4           obj;
	 offset          offs;
	 intc4           len;
         riferimenti 	 riffile;    /* file multimedia da genlink */
         riferimenti     rifimage;   /* file multimedia da genlink */
         char            azione;     /* atPulsanti,atLoop,atMouse */
         boolean 	 controls;                                                                                  
         intc2           loop;   
         intc2           loopdelay;    
         intc2           loopcount;    
         intc2           xx,yy;
  } tmultimedia;
  typedef tmultimedia* pmultimedia;
                                                                                                


  /*===============================================================

		  oggetti primari di HEL: come sono riferiti nell'AHTML

	===============================================================

	  testohtml,genlink,ziplink,internetlink,programma:
	  -------------------------------------------------
				  Puo' essere riferito inserendo
						<$xx112233>
						  xx      ziplink  (1byte, TOggettiHel)
						  112233  rifer    (3byte)
				  nel testo prima della parte cliccabile e inserendo
						<%>
				  dopo.

     immagine,mappaclic,inputstat,.. ...tutti gli altri
	  -------------------------------------------------
				  Puo' essere riferito usando
		<$xx223344>
						 xx       immagine (1byte, TOggettiHel)
						 223344   rifer    (3byte)
	      inserendolo una sola volta nel testo.
  */




















/*
==============================================================

		  altre strutture

==============================================================
*/


/*===== lista keyword, necessaria per ricerca argomenti */
typedef struct
{
  char  caption[80];     /* keyword */
  int4  code;            /* numero d'ordine della keyword nel file AEH */
  void* pnt;             /* puntatore alla keyword che segue in ordine
				 alfabetico */
} tkeywordlist;

typedef tkeywordlist* pkeywordlist;


/*===== header file AEH */
typedef struct
{
  char 	        id[4];
  char 	        caption[80];
  char 	        e1[256],e2[256],e3[256],e4[256],e5[256],e6[256];
  char 	        numtab;
  intc2	        aehcreatorversion;
  char 	        readonly;
  riferimenti   sommario,copertina;
  intc4	        ver;
  char          pulssommario,pulscerca,pulsguida,notpulscopertina,
                pulsindietro,
		nonvispulsanti;
  char 	        fontfisso[40],fontprop[40];
  char          reserved[256];
}  theaderaeh;


/*===== tabella0, elemento */
typedef struct
{
  intc4 offsetintab1;
  intc4 lunghezzarecord;
  intc4 numerorecord;
} telementotab0;


/*===== file di configurazione */
typedef struct
{
  char 	     selfhelp_path[180];
  char 	     cgi_path[180];
  char 	     basehref[180];
  char 	     blackbox[180];
} tserverconfig;



/*
	obsoleto...
	la cronologia  composta per ogni utente dal nome dell'help file che stava
	leggendo e dalla pagina. Il primo int della cronologia  l'indice*/
typedef struct
{
  char 	     helpfile[120];
  int4	     pagina;
} tcronologia;

typedef struct
{
  int         index;
  tcronologia c[30];
} tdatiutente;




/*===== blackbox */
typedef struct
{
  long mtype;
  char mtext[30000];
} messaggio;














/*
==============================================================
	COSTANTI
==============================================================
*/
/* char ahref_i[]="<A TARGET=_top HREF=\""; */   /* iper.cgi/"; */
/* char iniziolink_f[]="\">" */;

char content[]="Content-Type: text/html\n";
char inizio_pagina_i[]="<HTML>\n<HEAD>\n<TITLE>";
char inizio_pagina_f[]="</TITLE>\n</HEAD>\n<!--ver2.09-->\n";
char fine_pagina[]="</BODY></HTML>\n";

char iniziolink_i[]="<A TARGET=_top HREF=\"";
char finelink[]="</A>";
char pulsante_copertina_f[]="\"><IMG SRC=\"p_coper.gif\" BORDER=0 ALT=[COPERTINA]></A>";
char pulsante_sommario_f[]="\"><IMG SRC=\"p_somm.gif\" BORDER=0 ALT=[SOMMARIO]></A>";
char pulsante_cerca_f[]="\"><IMG SRC=\"p_cerca.gif\" BORDER=0 ALT=[CERCA]></A>";
char pulsante_precedente_f[]="\"><IMG SRC=\"p_prec.gif\" BORDER=0 ALT=[PRECEDENTE]></A>";
char pulsante_guida_f[]="\"><IMG SRC=\"p_guida.gif\" BORDER=0 ALT=[GUIDA]> </A>";

char autore[]="autore";
char titolo[]="titolo";
char tit[]="titolo=\x0";
const string m_er[]={ "leggendo","scrivendo","rinominando","rimuovendo" };


char form_i0[]="\n<FORM TARGET=_top METHOD=\"POST\" ACTION=\"";
char form_i00[]="?C+C\">\n<INPUT TYPE=\"hidden\" NAME=\"uten\" VALUE=\"";
char form_i1[]="\">\n<INPUT TYPE=\"hidden\" NAME=\"help\" VALUE=\"";
char form_f[]="\n</FORM><HR>Per ritornare alla pagina precedente usa "
			"il tasto &lt- del visualizzatore<P>"
			"<FONT SIZE=2><i>IPERtool-IPERserver</i> Ver 2.09-tmff beta<br>"
			"(C)1996 Aldo Ghigliano</CENTER>";















/*
=======================================================================================

	VARIABILI GLOBALI

=======================================================================================
*/
/* variabili temporanee usate qua e la' */
FILE           *fp1,*fp2;
tserverconfig   config;
theaderaeh      header;
tdatiutente     datiutente;
telementotab0   tabella0[256];
int4            lunghezzatabellaprimaria,
		offsettabellaprimaria,offsettabellasecondaria;


/* usata all'interno di molte procedure che si occupano di costruire la
   pagina */
ttestohtml      tmptestohtml;
tkeywordlist    firstkey;
pkeywordlist    pkeys[MAXKEYS];
int4            stackY[MAXARRAY];
int             spY;
char            buf[BUFLEN];


/* parametri del main, ricevuti da path info */
char            m_oggetto;         /* oggetto corrente */
int4            m_paginamadre,m_tab,
		m_index,           /* n^ elemento corrente, se l'ogg. corrente
				e' TESTOHTML questo e' n^.pagina
				corrente */
		m_pagina;          /* n^ pagina che prossimamente sara'
				la pag. madre */

char            m_comando;
char            m_nomehelpfile[120];
boolean         m_frame=FALSE;
string		m_iniz;

/* lista dei parametri in ingresso:
				strings   nomi parametri
				objects   contenuto parametri

   sono puntatori a stringhe di lunghezza variabile
				*/
string*		listaparamq_objects;
string*		listaparamq_strings;
int		listaparamq_count;
boolean		flagpre;

















/*
=======================================================================================

	DUMMY per DOS

=======================================================================================
*/
#ifdef MSDOS
  #define IPC_RMID 123

  int msgrcv(int msq_id, messaggio* message, int len, long tipo,
	     short flags)
  {
    return -1;
  };

  int msgget(int chiave,short flags)
  {
    return 5678;
  };

  int msgctl(int msq_id, int operazione, void* buf)
  {
  };

#endif






















/*
=======================================================================================

	MESSAGGI ERRORE

=======================================================================================
*/
/*
---------------------------------------------------------------------------------------
	messaggi di errore
---------------------------------------------------------------------------------------
*/
void err(char b,string s1)
{
  fprintf(stderr,"[");
  #ifdef MSDOS
    ;
  #endif
  fprintf(stderr,"] IPER.CGI reason:");
  fprintf(stderr,"Errore %s il file \"%s\"\n",m_er[b],s1);
  exit(EXIT_FAILURE);
}

void errr(char b,string s1)
{
  printf("EEE: Errore %s il file \"%s\"\n",m_er[b],s1);
}
/*
---------------------------------------------------------------------------
--------------------------------------------------------------------------
*/
void error(string str)
{
  fprintf(stderr,"[");
  #ifdef MSDOS
    ;
  #endif
  fprintf(stderr,"] IPER.CGI:[Monitor] reason:%s\n",str);
}





















/*
---------------------------------------------------------------------------------------
	funzioni utili per costruire le tabelle a partire dai
	dati memorizzati nel file AEH
---------------------------------------------------------------------------------------
*/
/*
function TFEditt.pushY(y:integer):boolean;
begin
  result:=true;
  if spY<sizeof(TArrayInt) then begin
	  stackY^[spY]:=y;
	  inc(spY);
  end else result:=false;
end;

function TFEditt.popY(var y:integer):boolean;
begin
  result:=true;
  dec(spY);
  if spY>-1 then begin
	  y:=stackY^[spY];
  end else begin
	  inc(spY);
	  result:=false;
  end;
end;
*/
boolean pusht(int4 y)
{
  if (spY<MAXARRAY)
  {
	  stackY[spY]=y;
	  spY++;
	  return TRUE;
  } else return FALSE;
}

int4 popt()
{
  spY--;
  if (spY>-1)
  {
	  return stackY[spY];
  } else {
	  spY++;
	  return 0xFF;
  }
}




















/*
=======================================================================================

ROUTINES DI CONVERSIONE

=======================================================================================
*/
/*
---------------------------------------------------------------------------------------
	legge un longint in formato basso-alto e lo converte
	in int della macchina, risolvendo l'annoso problema del sesso dei byte
---------------------------------------------------------------------------------------
*/
int4 inttoint(intc4 i)
{
  return ((int4)i[0] & 0xff)+(((int4)i[1]<<8) & 0xff00)
	 +(((int4)i[2]<<16) & 0xff0000)+(((int4)i[3]<<24) & 0xff000000);
}

int4 int2toint(intc2 i)
{
  /* solo valori positivi */
  return ((int4)i[0] & 0xff)+(((int4)i[1]<<8) & 0xff00);
}


/*
---------------------------------------------------------------------------------------
	upcase di un carattere
---------------------------------------------------------------------------------------
*/
char upcase(char c)
{
  if ((c>='a') && (c<='z'))
  {
	 c=c-('a'-'A');
  }
  return c;
}



/*
---------------------------------------------------------------------------------------
	converte un intero in stringa
---------------------------------------------------------------------------------------
*/
void inttostr(int4 i, string st)
{
  int4 l;
  int j;
  char tmp[80];

  j=0;

  if (i==0)
  {
    st[0]='0';
    st[1]='\0';
  } else
  {
    st[0]='\0';
    while (i>0)
    {
      l=i%10;
      i=i/10;
      tmp[0]=l+'0';
      tmp[1]=0;
      strcat(tmp,st);
      strcpy(st,tmp);
      /* che brutto*/
      j++;
    }
  }
}

/*
---------------------------------------------------------------------------------------
   traduco un ascii 0..9, A..F in intero
---------------------------------------------------------------------------------------
*/
int tabs(char c)
{
  int l;

  if ((c>='0') && (c<='9'))
  {
	 l=c-'0';
  } else
  if ((c>='A') && (c<='F'))
  {
    l=c-'A'+10;
  };
  return l;
}
/*
---------------------------------------------------------------------------------------
   traduco un intero in un ascii 0..9, A..F
---------------------------------------------------------------------------------------
*/
char stab(int c)
{
  char l;

  if ((c>=0) && (c<=9))
  {
    l=c+'0';
  } else
  if ((c>=10) && (c<=15))
  {
    l=c+'A'-10;
  };
  return l;
}
/*
---------------------------------------------------------------------------------------
   traduco un ascii come x es. "2f" in intero
---------------------------------------------------------------------------------------
*/
int4 fromhex(string s)
{
  char tmp[256];
  int4 l;

  l=( tabs(upcase(s[0])) << 4 )+tabs(upcase(s[1]));
  return l;
}
/*
---------------------------------------------------------------------------------------
   traduco un byte in una stringa ascii come x es. "2f"
---------------------------------------------------------------------------------------
*/
string tohex(char c)
{
  static char tmp[3];

  tmp[0]=stab( (c & 0xf0) >> 4 );
  tmp[1]=stab( (c & 0x0f) );
  tmp[2]=0;
  return tmp;
}
/*
---------------------------------------------------------------------------------------
   traduco un byte in una stringa ascii come x es. "2f"
---------------------------------------------------------------------------------------
*/
void tohex2(char c,char* tmp)
{
  tmp[0]=stab( (c & 0xf0) >> 4 );
  tmp[1]=stab( (c & 0x0f) );
  tmp[2]=0;
}
/*
---------------------------------------------------------------------------------------
   traduco un int4 in una stringa ascii di 6byte x es. "2f002f"
   Questa funzione lavora bene solo con i TColor, dove il
   colore e' memorizzato come 00bbggrr
---------------------------------------------------------------------------------------
*/
void tohexstr(string tmp, int4 i)
{
  tmp[4]=stab((int) ((i & 0xf00000) >> 20) );
  tmp[5]=stab((int) ((i & 0x0f0000) >> 16) );
  tmp[2]=stab((int) ((i & 0x00f000) >> 12) );
  tmp[3]=stab((int) ((i & 0x000f00) >> 8 ) );
  tmp[0]=stab((int) ((i & 0x0000f0) >> 4 ) );
  tmp[1]=stab((int) (i & 0x00000f)       );
  tmp[6]=0;
}
void tohexstrBis(string tmp, int4 i)
{
  tmp[0]=stab((int) ((i & 0xf00000) >> 20) );
  tmp[1]=stab((int) ((i & 0x0f0000) >> 16) );
  tmp[2]=stab((int) ((i & 0x00f000) >> 12) );
  tmp[3]=stab((int) ((i & 0x000f00) >> 8 ) );
  tmp[4]=stab((int) ((i & 0x0000f0) >> 4 ) );
  tmp[5]=stab((int) (i & 0x00000f)       );
  tmp[6]=0;
}
/*
---------------------------------------------------------------------------------------
	traduco una stringa da pseudo PERL a normale
---------------------------------------------------------------------------------------
*/
void invtrad(string s)
{
  char tmp[256];
  int l;

  l=0;
  while (s[0]!=0)
  {
    if (s[0]!='%')
    {
      tmp[l]=s[0];
      s++;
    } else
    {
		tmp[l]=fromhex(s+1);
      s=s+3;
	 }
    l++;
  }
  tmp[l]=0;
  strcpy(s,tmp);
}
/*
---------------------------------------------------------------------------------------
	traduco l'allineamento
---------------------------------------------------------------------------------------
*/
void tradalign(int l, string tm)
{
  if (l==amiddle) strcpy(tm,"MIDDLE");
  else if (l==adx) strcpy(tm,"RIGHT");
  else if (l==acentro) strcpy(tm,"CENTER");
  else if (l==atop) strcpy(tm,"TOP");
  else if (l==asx) strcpy(tm,"LEFT");
  else if (l==abottom) strcpy(tm,"BOTTOM");
}
/*
---------------------------------------------------------------------------------------
   traduco l'allineamento
---------------------------------------------------------------------------------------
*/
void tradhalign(int l, string tm)
{
		 if (l==hdx) strcpy(tm,"RIGHT");
  else if (l==hcentro) strcpy(tm,"CENTER");
  else if (l==hsx) strcpy(tm,"LEFT");
}
/*
---------------------------------------------------------------------------------------
	traduco l'allineamento
---------------------------------------------------------------------------------------
*/
void tradvalign(int l, string tm)
{
  if (l==vmiddle) strcpy(tm,"MIDDLE");
  else if (l==vtop) strcpy(tm,"TOP");
  else if (l==vbottom) strcpy(tm,"BOTTOM");
}

/*
---------------------------------------------------------------------------------------
	estraggo tipo oggetto e numero elemento da un tag del tipo

	12345678        (ascii)

   dove ogg=12        (char)
	elem=345678   (int4)
---------------------------------------------------------------------------------------
*/
void extract_tag(string s, int4* ogg, int4* elem)
{
  /* int4 i; */
  (*ogg)=fromhex(s);
  /* i=fromhex(s+6); */
  (*elem)=(fromhex(s+2)<<16) + (fromhex(s+4)<<8) + (fromhex(s+6));
}
/*
--------------------------------------------------------------------------------------
  converte una stringa Pascal in una C
--------------------------------------------------------------------------------------
*/
void pastoc(string s)
{
  char tmp[257];

  strncpy(tmp,s,256);
  tmp[tmp[0]+1]=0;
  strcpy(s,tmp+1);
}
























/*
=======================================================================================

	ROUTINES DEL PROGRAMMA VERO E PROPRIO

=======================================================================================
*/
/*
---------------------------------------------------------------------------------------
	apre il file di help, legge l'header del file di help e scrive
	Il nome e' contenuto in

     nomefilehelp

   Le tabelle sono caricate nelle variabili globali

     tabella0

   E' aggiornato:

     lunghezzatabellaprimaria
     offsettabellaprimaria
     offsettabellasecondaria

   Il file globale fp1  aperto.

---------------------------------------------------------------------------------------
*/
boolean apri_leggi_header()
{
  int4   i;
  intc4  j;

  fp1=fopen(m_nomehelpfile,"rb");
  if (fp1!=NULL)
  {
	 fread(&header,sizeof(header),1,fp1);
    if (strncmp(header.id,"ALDO",4)==0)
    {
      i=sizeof(telementotab0) * (header.numtab+1); /* +1 ?*/

      if (fread(&tabella0,i,1,fp1)!=0)
      {
	if (fread(&j,sizeof(intc4),1,fp1)!=0)
	{
	  lunghezzatabellaprimaria=inttoint(j);

	  offsettabellaprimaria=sizeof(header)+sizeof(intc4)+i;
	  offsettabellasecondaria=offsettabellaprimaria+lunghezzatabellaprimaria;

	  /* faccio in modo che per quanto riguarda i vecchi ipertesti sia
	     imposta la visualizzazione pulsanti */
	  if (header.numtab<inputstat)
	  {
	    header.nonvispulsanti=FALSE;
	  }
	  return TRUE;
	}
      }
    }
  }
  return FALSE;
}


























/*
--------------------------------------------------------------------------------------
  legge informazioni sull' oggetto
  (ad es. leggi_info_ogg(TESTOHTML,0,&tmptestohtml)
--------------------------------------------------------------------------------------
*/
void leggi_info_ogg(char ogg, int4 elem, void* bufff)
{
  int4         i,j;
  timmagine*   ptmp;
  tkeyword*    pktmp;


  i=inttoint(tabella0[ogg].lunghezzarecord);
  j=inttoint(tabella0[ogg].offsetintab1);

  /* cerco il record che contiene le info dell'elemento */
  fseek(fp1,offsettabellaprimaria + j + elem * i, SEEK_SET);

  /* lo leggo */
  fread(bufff,i,1,fp1);
  ptmp=bufff;
  pktmp=bufff;

  /* converto la caption dal Pascal al C, estraggo i nomi file senza path
	  quando e' il caso
  */

  if ( (ogg==testohtml)||(ogg==internetlink)
		 ||(ogg==tabellahtml)||(ogg==programma)   )
  {
	 pastoc( ptmp->caption );
	 /* in Delphi non avrei dovuto creare la variabile temporanea
		 ptmp, avrei potuto fare un bel cast tipo
			ttestoHtml(buffer).caption
		 o si puo' far anche qui?
	 */
  } else
  if ( ogg==keyword )
  {
	 pastoc( pktmp->caption );
  } else
  if ( (ogg==genlink)||(ogg==ziplink) )
  {
	  /* occorre estrarre il nome file dalla caption,
		 togliere c:\aeh\sada\.. */
  } else
  if ( (ogg==immagine)||(ogg==mappaclic) )
  {
	  /* occorre estrarre il nome file dal campo filename di  timmagine */
	 pastoc( ptmp->caption );
  };

}
























/*
--------------------------------------------------------------------------------------
  utility che stampa un riferimento dinamico di iper, del tipo
	 ="http://.../iper.cgi/0/0/Z/path/nomefile.aeh"
--------------------------------------------------------------------------------------
*/
void st_dinrif(int4 tag)
{
  /* riferimento dinamico*/
  printf("=\"%s/0",config.cgi_path);
  printf("/%li/N", tag );
  if (m_nomehelpfile[0]!='/') printf("/");
  printf("%s/\"",m_nomehelpfile);
}
/*
--------------------------------------------------------------------------------------
  utility che stampa IMAGE=.. o BGCOLOR=...
  partendo da un supersfondo (elemento memorizzato in un array che
  caratterizza lo sfondo di una casella di una tabella)
--------------------------------------------------------------------------------------
*/
void st_sfondo(int4 tag)
{
  int4 tip;
  char s[20];

  tip=tag>>24;
  tag=tag & 0xffffff;
  if (tip==0)
  {
    tohexstr(s,tag) ;
    printf("BGCOLOR=#%s",s);
  }
  else if (tip==3)
  {
    tag=tag | (0x1000000*immagine);
    printf("BACKGROUND");
    st_dinrif(tag);
  }
}
/*
--------------------------------------------------------------------------------------
	"stampa" il link dinamico ad un oggetto
	E' richiamato durante la stampa di una pagina
	 -di testo
	 -di testo popup
	 -di testo frame
	se ci sono dei link dinamici.
--------------------------------------------------------------------------------------
*/
void st_oggetto(char ogg, int4 elem)
{
  int4 		i,tag;
  char 		t[250],s[250];
  tmappaclic	tmpmappaclic;


  tag=ogg;
  tag=(tag<<24)+elem;

  if ((ogg==mappaclic))
  {
	 /* e' un oggetto mappaclic: metto A HREF
		 che richiama  iper.cgi  con il riferimento proprio
	 */
	 printf("<A ");
	 if (m_frame==TRUE) printf("TARGET=_top ");
	 printf("HREF");
	 printf("=\"%s/%li",config.cgi_path,m_pagina);
	 printf("/%li/M",tag);
	   if (m_nomehelpfile[0]!='/') printf("/");
	 printf("%s/\">",m_nomehelpfile);
  }

  if ((ogg==immagine)||(ogg==mappaclic))
  {
	 /* era un oggetto IMMAGINE o mappaclic: metto un IMG SRC
		 che richiama  iper.cgi  con il riferimento proprio
		 del link */
	 leggi_info_ogg(ogg,elem,&tmpmappaclic);

	 tradalign(tmpmappaclic.img.allin,t);
	 printf("<IMG BORDER=0 ALIGN=%s ALT=\"[%s]\" ",
		 t,tmpmappaclic.img.caption);
	 /* se mappaclic c'e' ISMAP */
	 if ((ogg==mappaclic)) printf("ISMAP ");
	 printf("SRC");
  } else
  {
	 /* era un oggetto testoHtml, ZIP o GEN: metto A HREF
		 che richiama  iper.cgi  con il riferimento proprio
	 */
	 printf("<A ");
	 if (m_frame==TRUE) printf("TARGET=_top ");
	 printf("HREF");
  }
  /* riferimento dinamico*/
  st_dinrif(tag);
  
  if (flagpre)      { printf("> "); }
               else { puts(">"); }


  if ((ogg==mappaclic))
  {
	 printf("</A>");
  }

}




/*
--------------------------------------------------------------------------------------
  cerca fine link % e intanto stampa link ad
  eventuali immagini che fossero li' dentro
--------------------------------------------------------------------------------------
*/
string cerca_fine_efai(string buf)
{
  int4    ogg,elem;
  boolean flag;
  string  pnt;


  flag=TRUE;
  pnt=buf;
  while ((*pnt!=0) && (flag==TRUE))
  {
	  while (
		  (
			 (*(pnt-1)!='<') ||
		    ((*pnt!='%') && (*pnt!='$') && (*pnt!=0))
		  ) &&
		  (*pnt!=0)
		) pnt++;

	  if (*pnt=='$') /* fine prematura */
	  {
	      /* stampo il testo residuo
		 contenuto nel link */
	      *(pnt-1)=0;
	      printf("%s",buf);
			  /* %> */
	      buf=pnt+10;

	      /* potrebbe essere un'immagine, perche' e' dentro
		 il link. se  altro per ora skippo */
	      extract_tag(pnt+1,&ogg,&elem);
			pnt=buf;
			if ((ogg==immagine) || (ogg==mappaclic))
		st_oggetto(ogg,elem);
	  }
	  else
	  if (*pnt=='%')
	  {
			/* stampo il testo residuo
		 contenuto nel link e poi il </A> di fine link*/
	      *(pnt-1)=0;
	      printf("%s",buf);
			pnt=pnt+2; /* %> */
	      buf=pnt;
	      printf("%s",finelink);
	      flag=FALSE;
			/* ho finito di occuparmi del link*/
	  }
  }
  if (*pnt==0) return pnt;
			 else return buf;
}





















































/*
---------------------------------------------------------------------
 usata per convertire 2 linee successive di testo in:
  - 1 stringa di testo
  - informazione checked o no
---------------------------------------------------------------------
*/
boolean extractlin2(char* pnt, char* testo)
{
  char*  	pnt1;
  int    	len;

  pnt1=strchr(pnt,10);
  if (pnt1!=NIL)
  {
	  len=pnt1-pnt;
	  if ((len>0) && (*(pnt1-1)==13)) len--;
	  strncpy(testo,pnt,len);
	  testo[len]=0;
	  pnt=pnt1+1;

	  /*selezionato o no?*/
	  pnt1=strchr(pnt,10);
	  if (pnt1!=NIL)
	  {
	      return (
		(pnt[0]=='X')
		||(pnt[0]=='Y')
		||(pnt[0]=='x')
		||(pnt[0]=='y'));
	  }
  }
}



/*
---------------------------------------------------------------------
 usata per convertire 3 linee successive di testo in:
  - 2 stringhe
    di testo (typ. testo e option value)
  - informazione checked o no
---------------------------------------------------------------------
*/
char* extractlin(char* pnt, char* testo, char* value,
		 boolean* check)
{
  char* 	pnt1;
  int  		len;


  pnt1=strchr(pnt,10);
  if (pnt1!=NIL) {
    len=pnt1-pnt;
    if ((len>0) && (*(pnt1-1)==13)) len--;
    strncpy(testo,pnt,len);
    testo[len]=0;
    pnt=pnt1+1;
    /* option value */
    pnt1=strchr(pnt,10);

    if (pnt1!=NIL)
    {
      len=pnt1-pnt;
      if ((len>0) && (*(pnt1-1)==13)) len--;
      strncpy(value,pnt,len);
      value[len]=0;
      pnt=pnt1+1;
      /* selezionato o no? */
      pnt1=strchr(pnt,10);
      if (pnt1!=NIL)
      {
	*check=            (
	  (pnt[0]=='X')
	  || (pnt[0]=='Y')
	  || (pnt[0]=='x')
	  || (pnt[0]=='y'))
	;
	pnt=pnt1+1;
      }
    }
  }
  if (pnt1==NULL)
  {
	  return NULL;
  } else {
	  return pnt;
  }
}

/*
--------------------------------------------------------------------------------------
  legge un file nel buffer woffsqr
--------------------------------------------------------------------------------------
*/
int4 dofileread(char* filename,char** pwoffsqr)
{
  FILE* 	fp2;
  int4 		length;
  char*         woffsqr;

  #ifdef UTIL
	      puts("\n<!-- file file:");
	      printf(filename);
	      puts("-->");
  #endif
  fp2=fopen(filename,"r");
  if (fp2!=NULL)
  {
    fseek(fp2, 0L, SEEK_END);
    length = ftell(fp2);
    fseek(fp2, 0L, SEEK_SET);
    /* alloco buffer */
  #ifdef UTIL
	      puts("\n<!-- lungh file:");
	      printf("%i \n",length);
	      puts("-->");
  #endif
    
    
    
    woffsqr=(char*) malloc(length);
    /*vedi nota altrove su bachi borland3, credo*/
    fread(woffsqr,length,1,fp2);
    fclose(fp2);
  } else {
    woffsqr=(char*) malloc(400);
    strcpy(woffsqr,"Errore durante file rd\x0D\x0AId1\x0D\x0Ax\x0D\x0A"
	       "Dati di test 2\x0D\x0AId2\x0D\x0An\x0D\x0A"
	       "Dati di test 3\x0D\x0AId3\x0D\x0An\x0D\x0A");
    strcat(woffsqr,filename);
    strcat(woffsqr,"\x0D\x0AQuesto file non e' accessibile\x0D\x0A!!!!\x0D\x0A");
  }
  *pwoffsqr=woffsqr;
}


/*
---------------------------------------------------------------------
  Sostituisce i parametri tra virgolette presenti in una query
  con i parametri che ci sono nella lista
    ListaParamQ

    query     deve essere gia' allocata e piena.
 in complete  viene restituito il puntatore al risultato
---------------------------------------------------------------------
*/
void querytoquery(char* query, char** pcomplete)
{
  char* 	stri;
  char*		strf;
  char*         buf;
  char*         bufiniz;
  char*         str2;
  int 		l,i;
  int4		len;
  char		s[256];


  buf=(char*) malloc(sizeof(MAXARRAY));

  bufiniz=buf;
  stri=query;

  strf=strchr(stri,'"');

  while (strf!=NIL)
  {
	if ((buf+(strf-stri))-bufiniz<MAXARRAY)
	{
	  strncpy(buf,stri,strf-stri);
	  buf=buf+(strf-stri);
	  buf[0]=0;

	  str2=strchr(strf+1,'"');
	  if (str2!=NIL)
	  {
	    /*cerco se tra i parametri ce n'e' uno che ha nome
	     uguale a quello che ho trovato tra virgolette.
	     I nomi dei parametri sono memorizzati in minuscolo,
	     sempre.*/
	    stri=str2+1;  /* punto al testo dopo le virgolette */

	    /* estraggo dalle virgolette il parametro da sostituire */
	    strncpy(s,strf+1,stri-strf-2);
	    s[stri-strf-2]=0;
	    if (strlen(s)==0)
	    {
		/*era un "" che rappresenta una virgoletta*/
		strcpy(buf,"\"");
		buf++;
	    } else {
		/* s:=lowercase(s); */
		l=0;
		while ((l<listaparamq_count) &&
		      (strcmp(listaparamq_strings[l],s)!=0)) l++;

		if (l<listaparamq_count)
		{
		  /* Ho trovato il parametro. Ricopio il suo
		     valore dentro la query, se ci sta...*/

		  len=strlen(listaparamq_objects[l]);
		  if ((buf+len)-bufiniz<MAXARRAY)
		  {
		    strcpy(buf,listaparamq_objects[l]);
		    buf=buf+len;
		  } else strf=NIL;
		}

	    }
	  }
	  strf=strchr(stri,'"');
	} else strf=NIL;
  };

  if (strf==NIL)
  {
	strcpy(buf,stri);
	buf+=strlen(stri);
  }

  /* stri=(char*) malloc(buf-bufiniz);
  strncpy(stri,bufiniz,buf-bufiniz); */

  bufiniz[buf-bufiniz]=0;
  *pcomplete=bufiniz;

  /* free(bufiniz); */
}


/*
----------------------------------------------------------------------
 === UrlEncode
 Converte una array<=32k in una array urlencodata<=32k.
 Iniz serve per non superare il limite di 32k,  l'inizio
 iniziale allocato per l'array src (pu essere <> da src,
 src pu contenere un indirizzo intermedio per accodare)
----------------------------------------------------------------------
*/
int urlencode(char* src,char* dest,char* iniz)
{
  char 		c;
  char*		destiniz;

  destiniz=dest;
  while (src[0]!=0)
  {
    c=src[0];
    if (c==1)
	strcat(dest,"=");
    else if (c==10)
	strcat(dest,"&");
    else if (c==13) {
	strcat(dest,"&");
	if (src[1]==10) src++;
    }
    else if (c==' ')
	strcat(dest,"+");
    else if               (
      (c=='.') || (c=='_') || (c=='-') || (c=='*') ||
      ((c>='0') && (c<='9'))
      || ((c>='A') && (c<='Z'))
      || ((c>='a') && (c<='z'))
			  )
    {
	dest[strlen(dest)+1]=0;
	dest[strlen(dest)]=c;
    } else {
	strcat(dest,"%");
	tohex2(c,dest+strlen(dest));
	/*hex*/
    }
    src++;
  }

  return strlen(dest);
}



/*
----------------------------------------------------------------------
  DoQuery

     Fa una query tramite il programma
  blackbox.

     Quello che riceve e'
  messo in una variabile dinamica allocata qui e puntata da
  Risposta. Restituisce  Risposta
  (max dimensione array, Risposta=NIL se ci sono problemi)

     Prima di chiamare questa funzione occorre:
  - comporre la query definitiva, non urlencodata.
    LA QUERY DEFINITIVA si ha passando la query di partenza a
    QueryToQuery, che sostituisce i parametri usando ListaParamQ.


    usa ik buffer dinamicam allocato dal main m?iniz
----------------------------------------------------------------------
*/
int doquery(char* db,
	    char* server,
	    char* query,
	    char** risposta)
{
  char* 	iniz;
  char*         rrr;
  char          idcoda[80];
  int           id,i;
  messaggio*    message;
  char* 	buf;



  iniz=m_iniz;
  strcpy(idcoda,"[Blackbox disabled]");


  /* creo gli altri parametri da passare*/
  strcpy(iniz,config.blackbox);
  strcat(iniz," ");

  #ifdef UTIL
	      puts("\n<!-- bb:");
	      puts(iniz);
	      puts("-->");
  #endif


  #ifdef YESBLACKBOX
    /* creo una coda di sistema */
    id=msgget(IPC_PRIVATE,0666|IPC_EXCL|IPC_CREAT);
    printf("\n<!-- id coda: %i-->\n",id);

    inttostr(id,idcoda);
    strcat(iniz,idcoda);
    strcat(iniz," ");
  #endif



  strcat(iniz,db);
  strcat(iniz," ");
  strcat(iniz,server);
  strcat(iniz," ");

  /* accodo la query, urlencodata...*/
  urlencode(query,iniz+strlen(iniz),iniz);


  #ifdef UTIL
	      puts("\n<!-- query e tutto a posto per blackbox:");
	      puts(iniz);
	      puts("-->");
  #endif



  #ifdef YESBLACKBOX
    /* chiamo blackbox */
   if (id>-1) { 
    message=(messaggio *) malloc(sizeof(messaggio));
    rrr=(*message).mtext;

    rrr[0]=0;
    system(iniz);
    /* aspetto risposta dalla coda di sistema */
    i=msgrcv(id,message,sizeof(messaggio),0,0);
    /* cancello la coda */
    msgctl(id,IPC_RMID,buf);
    } else {
      i=-1;
      rrr=(char*) malloc(MAXARRAY); /* prova */
      }
  #else
    i=-1;
    rrr=(char*) malloc(MAXARRAY); /* prova */
  #endif


  if (i<0)
  {
      strcpy(rrr,"Blackbox disabilitato o Errore in ricezione query\x0D\x0AId1\x0D\x0Ax\x0D\x0A"
		 );
      strcat(rrr,idcoda);
      strcat(rrr,"\x0D\x0AId coda\x0D\x0An\x0D\x0A");
      strcat(rrr,db);
      strcat(rrr,"\x0D\x0AQuesto e' il database\x0D\x0An\x0D\x0A");
      strcat(rrr,server);
      strcat(rrr,"\x0D\x0AServer\x0D\x0An\x0D\x0A");
  };

  *risposta=rrr;
  return strlen(rrr);
}

/*
--------------------------------------------------------------------------------------
  utilizzando i dati in woffsqr crea una tabella html
  formata da col colonne
--------------------------------------------------------------------------------------
*/
void exttab(char* woffsqr, int col)
{
  char* 	pnt1;
  int  		len,c;
  char          testo[500];

  pnt1=strchr(woffsqr,10);


  puts("<TABLE BORDER=1>");
  while (pnt1!=NIL)
  {
    puts("<TR>");
    c=0;
    while ((pnt1!=NIL) && (c<col))
    {
      len=pnt1-woffsqr;
      if ((len>0) && (*(pnt1-1)==13)) len--;
      strncpy(testo,woffsqr,len);
      testo[len]=0;
      woffsqr=pnt1+1;
      printf("<TD>%s</TD>\n",testo);

      pnt1=strchr(woffsqr,10);
      c++;
    }
    puts("</TR>");
  }
  puts("</TABLE>");
}

/*
--------------------------------------------------------------------------------------
  utilizzando i dati in woffsqr crea una lista di link html
  formata secondo i parametri
--------------------------------------------------------------------------------------
*/
void extdinlist(char* woffsqr, int numremarks, int spaces)
{
  char* 	pnt1;
  int  		len,c;
  char          testo[500],link[500];

  pnt1=strchr(woffsqr,10);

  while (pnt1!=NIL)
  {
    len=pnt1-woffsqr;
    if ((len>0) && (*(pnt1-1)==13)) len--;
    strncpy(testo,woffsqr,len);
    testo[len]=0;

    woffsqr=pnt1+1;
    pnt1=strchr(woffsqr,10);

    if (pnt1!=NIL)
    {
      len=pnt1-woffsqr;
      if ((len>0) && (*(pnt1-1)==13)) len--;
      strncpy(link,woffsqr,len);
      link[len]=0;
      woffsqr=pnt1+1;

      printf("<LI>%s%s\">%s</A>\n",iniziolink_i,link,testo);

      pnt1=strchr(woffsqr,10);
      c=0;
      while ((pnt1!=NIL) && (c<numremarks))
      {
	len=pnt1-woffsqr;
	if ((len>0) && (*(pnt1-1)==13)) len--;
	strncpy(link,woffsqr,len);
	link[len]=0;
	woffsqr=pnt1+1;

	puts("<BR>");
	puts(link);

	pnt1=strchr(woffsqr,10);
	c++;
      }
    }

    c=0;
    while (c<spaces)
    {
      puts("<BR>");
      c++;
    }
  }
  /* puts("<BR>"); */
}


/*
--------------------------------------------------------------------------------------
  visualizza una pagina
--------------------------------------------------------------------------------------
*/
void viewpage(int4 pagina, string buf)
{
  int4          ogg,elem,len,tag,tagmm,tagmi;
  int4          perc,ri,cl,wlenqr;
  int		i,looop;
  string        buf2;
  boolean       flag,errore,netscape;
  boolean       check;
  char          temp[26],tip,
		il_nomehelpfile[256],tmp[256],
		testo[256],value[256];
  intc4*        bufsfondo;
  char*		bufchar;
  char*         woffsqr;
  string	pnt,ss;
  string	completequery;
  ttabellahtml	tmptabella;
  tinputdin     tmpinput;
  tinputstat2   tmpinput2;
  tbottonecgi   tmpbottonecgi;
  tinizioform   tmpinizioform;
  tinternetlink tmpinternetlink;
  tmultimedia   tmpmultimedia;



  /* leggo info sulla pagina da visualizzare dentro  tmptestoHtml  */
  leggi_info_ogg(testohtml,pagina,&tmptestohtml);
  /* leggo la pagina da visualizzare dentro il buffer */
  fseek(fp1, offsettabellasecondaria + inttoint(tmptestohtml.fileoffs), SEEK_SET);
  fread(buf,int2toint(tmptestohtml.len),1,fp1);

  len=int2toint(tmptestohtml.len);
  buf[len-1]=0;  /* sicurezza */



  /*============================
    traduco da AHTML a HTML, creo cioe' link e oggetti dinamici */
  errore=FALSE;
  flagpre=FALSE;
  buf2=buf;
  while ( ((pnt=strchr(buf2,'<')) != NULL )
		 && (errore==FALSE) )
  {
    pnt++;
    if ( (*(pnt)=='$') )
		/*==============
			 inizio di un link o un comando
			 vediamo che comando e': e' necessario farlo perche' ci
			 sono dei comandi che significano l'introduzione di link
			 HTML, e comandi che significano l'introduzione di oggetti.
		*/
    {
	extract_tag(pnt+1,&ogg,&elem);
	*(pnt-1)=0;

	/* stampo tutto il buon testo html che c'era prima del
	  comando */
	printf("%s",buf);
	/* passo a dopo l'inizio comando */
	buf=pnt+10;  /* $00xx00xx>
			^         ^
			 pnt       pnt+10
		     */
	buf2=buf;



	if (ogg==testohtml)                          /* TESTO */
	{
	  st_oggetto(ogg,elem);
		/* dentro il link ci potrebbe essere una o piu'immagini */
		/* ora cerco il marcatore <%> di fine link testo dinamico */
		/* CHIUDO IL LINK*/
	  buf=cerca_fine_efai(buf);
	  buf2=buf;
	}
	else if (ogg==internetlink)                  /* LINK INTERNET */
	{
	  leggi_info_ogg(internetlink,elem,&tmpinternetlink);

	  /* Il link internet puo' anche essere un riferimento, relativo
	     o meno, ad un altro ipertesto
	     Il testo e' del tipo

		iper:/abspath/.../testo.aeh 123

	      oppure

		iper:testo.aeh 123           (significa relativo, nella stessa
						dir del chiamante)

	      prendendo dal file di configurazione iper fa in modo
	      di autorichiamarsi per caricare il file opportuno, alla
	      pagina 123
	  */
	  if (strncmp(tmpinternetlink.caption,"iper:",5)==0)
	  {
	    /*=============== iper: */

	    /* estraggo il nome dell'help file */
	    i=0;
	    while
	      ((tmpinternetlink.caption[i]!=0)
	      && (tmpinternetlink.caption[i]!=' ')) i++;
	    strncpy(il_nomehelpfile,tmpinternetlink.caption+5,i-5);
	    il_nomehelpfile[i-5]=0;

	    /* il numero pag */
	    if (tmpinternetlink.caption[i]!=0)
	    {
	      tag=atoi(tmpinternetlink.caption+i+1);
	    } else tag=0;



	    printf(iniziolink_i);
	    printf("%s/%li",config.cgi_path,m_pagina); /* cgi e pag precedente */
	    printf("/%li/N", tag );
	    /* se il primo carattere intodotto dall'utente non e'
	      una sbarra, il nome del file e' relativo: estraggo dal nome
	      help file corrente il path e lo piazzo in testa a
	      il_nomehelpfile*/
	    if ((il_nomehelpfile[0]!='\\')
	       && (il_nomehelpfile[0]!='/'))
	    {
	      /* m_nomehelpfile e' ad esempio:
		     /users/s63998/public_html/pippo.aeh

		mal che vada e'
		     /pippo.aeh
		     */
	      i=strlen(m_nomehelpfile);
	      while
		((m_nomehelpfile[i]!='\\')
		&& (m_nomehelpfile[i]!='/') && (i>0)) i--;
	      strcpy(tmp,il_nomehelpfile);
	      strncpy(il_nomehelpfile,m_nomehelpfile,i+1);
	      il_nomehelpfile[i+1]=0;
	      strcat(il_nomehelpfile,tmp);
	    }
	    printf("%s/\">",il_nomehelpfile);

	  } else {
	    /*=============== normale link internet */

	    printf("%s%s\">",iniziolink_i,
			  tmpinternetlink.caption);
	  }

	  /* CHIUDO IL LINK*/
	  buf=cerca_fine_efai(buf);
	  buf2=buf;
	}
	else if  ((ogg==ziplink)||(ogg==genlink))  /* FILE INCORPORATO */
	{
	  st_oggetto(ogg,elem);
	  /* CHIUDO IL LINK*/
	  buf=cerca_fine_efai(buf);
	  buf2=buf;
	}
	else if ((ogg==immagine)||(ogg==mappaclic)) /* immagine */
	{
	  st_oggetto(ogg,elem);
	}
	else if (ogg==programma)
	{
	  /* punta al comando W: "questa funz e' disp. solo
	     in MsWin" */
	  printf("%s%s/%i/0/W",iniziolink_i,config.cgi_path,m_pagina);
	    if (m_nomehelpfile[0]!='/') printf("/");
	  printf("%s/\">",m_nomehelpfile);
	  buf=cerca_fine_efai(buf);
	  buf2=buf;
	}
	else if (ogg==tabellahtml)
	{
	  /* caratteristiche fondamentali */
	  leggi_info_ogg(tabellahtml,elem,&tmptabella);
	  printf("\12<FONT SIZE=3><TABLE WIDTH=\"%i%%\" ",tmptabella.w_perc);

	  printf("BORDER=%i ",tmptabella.bordo);
	  printf("CELLPADDING=%i CELLSPACING=%i ",
	    tmptabella.cellpadding,
	    tmptabella.cellspacing);


	  /* se non e' una tabella vecchio stile stampo
	  l'eventuale sfondo, immagine o colorato */
	  ri=inttoint(tmptabella.sfondo);
	  if (tmptabella.tipo==tanormale)
	  st_sfondo(ri);
	  puts(" >");
	  ri=tmptabella.righe-1;


	  /*============ se esistono delle informazioni di sfondo le copio
	    nell'array di longint   bufsfondo */
	  bufsfondo=NIL;
	  tag=inttoint(tmptabella.offs);
	  if (tag!=0)
	  {
	    if (tmptabella.tipo==tanormale)
	    { /* alloco un buffer per le tabelle */
	      bufsfondo=(intc4*) malloc(MAXARRAY);
	      /* leggo la tabella dentro il buffer */
	      fseek(fp1, offsettabellasecondaria +
			  inttoint(tmptabella.fileoffs), SEEK_SET);
	      fread(bufsfondo,int2toint(tmptabella.len),1,fp1);
	    } else tag=0;
	  }


	  /* pusho per ogni casella le info:
		-la casella precedente e' un fine riga o no
		-la dimensione della casella corrente.
		-l'eventuale sfondo
	  */
	  while (ri>=0)
	  {
	    cl=tmptabella.colonne-2;
	    pusht(TFINERIGA);
	    if (tag==0) { pusht(0xffffffff); }
	    else {
	      perc=inttoint(bufsfondo[ri*tmptabella.colonne+cl+1]);
	      pusht(perc);
	    }
	    pusht(tmptabella.vjus);
	    pusht(tmptabella.hjus);
	    pusht(tmptabella.wcolonne[cl+1]);

	    while (cl>=0)
	    {
	      pusht(TCASELLANORMALE);
	      if (tag==0) { pusht(0xffffffff); }
	      else {
		perc=inttoint(bufsfondo[ri*tmptabella.colonne+cl]);
		pusht(perc);
	      }
	      pusht(tmptabella.vjus);
	      pusht(tmptabella.hjus);
	      pusht(tmptabella.wcolonne[cl]);
	      cl--;
	    }
	    ri--;
	  }


	  /*libero il buffer*/
	  if (bufsfondo!=NIL) free(bufsfondo);

	  /* inizio la prima casella della tabella*/
	  perc=popt();
	  printf("<TR><TD WIDTH=\"%i%%\" ",perc);
	  perc=popt();                  /* hjus */
	  tradhalign(perc,temp);
	  printf("ALIGN=%s ",temp);     /* vjus */
	  perc=popt();
	  tradvalign(perc,temp);
	  printf("VALIGN=%s ",temp);
	  perc=popt();
	  st_sfondo(perc);
	  puts(" >\n");
	}
	else if (ogg==inputstat)
	{
	  /* converto le informazioni nel file AEH nell' appropriato
	   input, assegnando eventuale contenuto iniziale ecc.
	   ecc.ecc. a seconda del tipo di input */
	  leggi_info_ogg(inputstat,elem,&tmpinput);
	  leggi_info_ogg(inputstat,elem,&tmpinput2);

	  bufchar=NIL;
	  tag=inttoint(tmpinput.offs);
	  if (tag!=0)  /* 0 e' il NIL pascal, indica array non
			  allocata */
	  {
	    /* alloco un buffer per il contenuto iniziale
	       o per la query, e lo carico da disco */
	    bufchar=(char*) malloc(MAXARRAY);
	    fseek(fp1, offsettabellasecondaria +
			  inttoint(tmpinput.fileoffs), SEEK_SET);
	    fread(bufchar,int2toint(tmpinput.len),1,fp1);
	  }


	  pastoc(tmpinput.name);
	  pastoc(tmpinput.value);
	  if
	  ((tmpinput.tipo==isedit)
	  || (tmpinput.tipo==ispass)
	  || (tmpinput.tipo==isfile)
	  )
	  {
	    printf("<INPUT ");
	    if ((tmpinput.tipo==ispass)) { printf("TYPE=password "); }
	    else if ((tmpinput.tipo==isfile)) printf("TYPE=file ");

	    printf("NAME=\"%s\" ",tmpinput.name);
	    if (tmpinput.putvalue)
	      printf("VALUE=\"%s\" ",tmpinput.value);
	    printf("SIZE=%i ",tmpinput.size);
	    printf(">\n");
	  }
	  else if
	  (tmpinput.tipo==ismemo)
	  {
	    printf("<TEXTAREA NAME=\"%s\" ",tmpinput.name);
	    printf("ROWS=%i COLS=%i >\n",tmpinput.rows,
	       tmpinput.cols);
	    if (tmpinput.putvalue)
	      printf("%s",bufchar);
	    printf("\n</TEXTAREA>");
	  }
	  else if
	  ((tmpinput.tipo==ischeck)
	  || (tmpinput.tipo==isradio)
	  || (tmpinput.tipo==ishidden)
	  )
	  {
	    printf("<INPUT ");
	    if ((tmpinput.tipo==ischeck))  { printf("TYPE=checkbox "); }
	    else if (tmpinput.tipo==isradio) { printf("TYPE=radio "); }
	    else if (tmpinput.tipo==ishidden) printf("TYPE=hidden ");
	    printf("NAME=\"%s\" ",tmpinput.name);
	    printf("VALUE=\"%s\" ",tmpinput.value);
	    if ( (tmpinput.checked) &&
		 (tmpinput.tipo!=ishidden) )
	      printf("CHECKED ");
	    printf(">\n");
	  }
	  else if
	  (tmpinput.tipo==iscommento)
	  {
	    printf("<!--%s-->",bufchar);
	  }
	  else if
	  (tmpinput.tipo==ishtml)
	  {
	    printf("%s",bufchar);
	  }
	  else if
	  (tmpinput.tipo==isprogramma)
	  {
	    printf("<!--system com found -->");
	    system(bufchar);
	  }
	  else if
	  (tmpinput.tipo==isfloatingframe)
	  {
	    
	    /* floating frame di IE3.0*/
	    printf("<IFRAME ");
	    if ( 
	         ( ( tmpinput2._margh)!=0 ) ||
	         ( ( tmpinput2._margw)!=0 )
	       )  
            {
              printf(" MARGINHEIGHT=%i", tmpinput2._margh );
              printf(" MARGINWIDTH=%i", tmpinput2._margw );  
            } else printf(" FRAMEBORDER=\"no\" ");
	    
	    if ( tmpinput2.percent==FALSE ) 
	    {
	      printf(" HEIGHT=%i WIDTH=%i ",int2toint( tmpinput2.hhh),
	                                   int2toint( tmpinput2.www) );
	    } else
	    {
	      printf(" HEIGHT=%i%% WIDTH=%i%% ",int2toint( tmpinput2.hhh),
	                                       int2toint( tmpinput2.www) );
	    }
	    
	    tagmi=inttoint( tmpinput2._link) & 0xffffff;
	    
	    printf(" NAME=%li",tagmi);
            printf(" SRC=\"%s/0",config.cgi_path);
            if ( tmpinput2.useframeset==FALSE) {
	      printf("/%li/F",tagmi);
	    } else {
	      printf("/%li/N",tagmi);
	    }
	    if (m_nomehelpfile[0]!='/') printf("/");
	    printf("%s/\" ",m_nomehelpfile);
	    
            printf(" TARGET="); 	       
	    tip=tmpinput2.tipo & 0xff;
            if (tip==tttop) { 
              printf("_top "); 	       
            } else if (tip==ttself) {
              printf("_self "); 	       
            } else if (tip==ttparent) {
              printf("_parent "); 	       
            } else if (tip==ttblank) {
              printf("_blank "); 	       
            } else {
              printf("_top "); 	       
            }
            
	    printf(" SCROLLING=");
            if (tmpinput2._scroll==FALSE) {
	      printf("no ");
	    } else {
	      printf("yes ");
	    }

            tohexstr(value,inttoint(tmpinput2.bordercolor) ) ;
            printf("BORDERCOLOR=#%s ",value );            

	    printf(">\n</IFRAME>");
	    printf("<!--%s-->",tmpinput2.dumm);
	  }
	  else if (
	  (tmpinput.tipo==islist)
	  || (tmpinput.tipo==iscombo) )
	  {
	    printf("<SELECT NAME=\"%s\"",tmpinput.name);
	    if (tmpinput.tipo==islist)
	      printf(" SIZE=%i ",tmpinput.size);

	    puts(" >");
	    pnt=bufchar;
	    while (pnt!=NIL)
	    {
	      pnt=extractlin(pnt,testo,value,&check);
	      if (pnt!=NIL)
	      {
		printf("<OPTION VALUE=\"%s\"",value);
		if (check) printf(" SELECTED");
		printf(" >%s\n",testo);
	      }
	    }
	    printf("</SELECT>");
	  }

	  /*libero il buffer*/
	  if (bufchar!=NIL) free(bufchar);

	}
	else if (ogg==inputdin)
	{
	  /* converto le informazioni nel file AEH nell' appropriato
	   input, assegnando eventuale contenuto iniziale ecc.
	   ecc.ecc. a seconda del tipo di input.
	   Prima faccio la query sostituendo i parametri, o
	   leggo il file */



	  leggi_info_ogg(inputdin,elem,&tmpinput);
	  bufchar=NIL;
	  tag=inttoint(tmpinput.offs);



	  if (tag!=0)  /* 0 e' il NIL pascal, indica array non
			  allocata */
	  {
	    /* alloco un buffer per per la query, e lo carico da disco */
	    bufchar=(char*) malloc(MAXARRAY);
	    fseek(fp1, offsettabellasecondaria +
			  inttoint(tmpinput.fileoffs), SEEK_SET);
	    fread(bufchar,int2toint(tmpinput.len),1,fp1);
	  }




	  /*====== il buffer   woffsqr  e' allocato dalla routine che
		   fa la query, oppure da quella che legge il file */
	  woffsqr=NIL;
	  /* faccio la query o leggo il file */

	  if (tmpinput.dintipo==dgfile)
	  {
	    pastoc(tmpinput.serverorfilename);
	    wlenqr=dofileread(tmpinput.serverorfilename,&woffsqr);
		   /*=== a questo punto se woffsQR<>NIL punta il contenuto del
		    file letto*/
	  } else
	  if (tmpinput.dintipo==dgblackbox)
	  {
		   /*traduco la query in una query vera: la procedura
		    QueryToQuery usa i dati degli inputs della pagina
		    precedente per tradurre la query con "param"
		    nella query vera, dove ai parametri sono sostituiti
		    i corrispondenti value. */
	    completequery=NIL;
	    #ifdef DEBUG
	      puts("\n<!--query iniziale:");
	      puts(bufchar);
	      puts("-->");
	    #endif
	    querytoquery(bufchar,&completequery);
	    #ifdef DEBUG
	      puts("\n<!--query tradotta coi parametri:");
	      puts(completequery);
	      puts("-->");
	    #endif

	    if (completequery!=NIL)
	    {
	      pastoc(tmpinput.dborhtfilename);
	      pastoc(tmpinput.serverorfilename);
	      wlenqr=doquery(
			   tmpinput.dborhtfilename,tmpinput.serverorfilename,
			   completequery,
			   &woffsqr);
	      free(completequery);

	      /*=== a questo punto se offsQR<>NIL punta il risultato della
	       query */
	    }
	  }

	  /* creo gli oggetti usando il file o il risultato della
	    query, qualunque cosa sia e' in woffsqr*/
	  pastoc(tmpinput.name);
	  pastoc(tmpinput.value);
	  if
	  (tmpinput.tipo==idedit)
	  {
	    printf("<INPUT ");
	    printf("NAME=\"%s\" ",tmpinput.name);
	    printf("VALUE=\"%s\" ",woffsqr);
	    printf("SIZE=%i ",tmpinput.size);
	    printf(">\n");
	  }
	  else if
	  (tmpinput.tipo==idmemo)
	  {
	    printf("<TEXTAREA NAME=\"%s\" ",tmpinput.name);
	    printf("ROWS=%i COLS=%i >\n",tmpinput.rows,
	       tmpinput.cols);
	    printf("%s",woffsqr);
	    printf("\n</TEXTAREA>");
	  }
	  else if
	  ((tmpinput.tipo==idchecksingle)
	  || (tmpinput.tipo==idradiosingle)
	  )
	  {
	    printf("<INPUT ");
	    if (tmpinput.tipo==idchecksingle) { printf("TYPE=checkbox "); }
	    else if (tmpinput.tipo==idradiosingle) printf("TYPE=radio ");
	    printf("NAME=\"%s\" ",tmpinput.name);
	    pnt=woffsqr;
	    check=extractlin2(pnt,testo);
	    printf("VALUE=\"%s\" ",tmpinput.value);
	    if (check) printf("CHECKED ");
	    printf(">%s",testo);
	  }
	  else if
	  (tmpinput.tipo==idhidden)
	  {
	    printf("<INPUT TYPE=hidden NAME=\"%s\" ",tmpinput.name);
	    printf("VALUE=\"%s\" ",woffsqr);
	    printf(">\n");
	  }
	  else if
	  (tmpinput.tipo==idhtml)
	  {
	    printf("%s",woffsqr);
	  }
	  else if (
	  (tmpinput.tipo==idlist)
	  || (tmpinput.tipo==idcombo)  )
	  {
	    printf("<SELECT NAME=\"%s\"",tmpinput.name);
	    if (tmpinput.tipo==idlist)
	      printf(" SIZE=\"%i\"",tmpinput.size);
	    if (tmpinput.multiple)
	      printf(" MULTIPLE");
	    puts(">");

	    pnt=woffsqr;
	    while (pnt!=NIL)
	    {
	      pnt=extractlin(pnt,testo,value,&check);
	      if (pnt!=NIL)
	      {
		printf("<OPTION VALUE=\"%s\" ",value);
		if (check) printf("SELECTED");
		printf(">%s\n",testo);
	      }
	    }
	    printf("</SELECT>");
	  }
	  else if  (
	  (tmpinput.tipo==idradio)
	  || (tmpinput.tipo==idcheck))
	  {
	    pnt=woffsqr;
	    while (pnt!=NIL)
	    {
	      pnt=extractlin(pnt,testo,value,&check);
	      if (pnt!=NIL)
	      {
		if (tmpinput.tipo==idradio)
		{
		  printf("<INPUT TYPE=\"radio\" NAME=\"%s\" ",tmpinput.name);
		  printf("VALUE=%s",value);
		} else {
		  printf("<INPUT TYPE=\"checkbox\" NAME=\"%s\" VALUE=on ",value);
		}
		if (check) printf(" CHECKED");
		printf(">%s<BR>",testo);
	      }
	    }
	  }
	  else if
	  (tmpinput.tipo==iddinlist)
	  {
	    extdinlist(woffsqr,tmpinput.numremarks,tmpinput.spaces);
	  }
	  else if
	  (tmpinput.tipo==idtable)
	  {
	    exttab(woffsqr,tmpinput.cols);
	  }



	  /*libero il buffer*/
	  if (bufchar!=NIL) free(bufchar);
	  /*========= libero woffsqr, allocato da
		 dofileread  opp.  doquery */
	  if (woffsqr!=NIL) free(woffsqr);



	}
	else if (ogg==bottonecgi)
	{
	  /* converto le informazioni nel file AEH nell' appropriato
	   input, assegnando eventuale contenuto iniziale ecc.
	   ecc.ecc. a seconda del tipo di input */
	  leggi_info_ogg(bottonecgi,elem,&tmpbottonecgi);

	  printf("<INPUT TYPE=");
	  if (tmpbottonecgi.tipo==btsubmit)
	  { printf("submit");
	  } else
	  if (tmpbottonecgi.tipo==btimage)
	  { printf("image");
	  } else printf("reset");

	  if (tmpbottonecgi.name[0]>0)
	  {
	    pastoc(tmpbottonecgi.name);
	    printf(" NAME=\"%s\"",tmpbottonecgi.name);
	  }

	  if (tmpbottonecgi.tipo==btimage)
	  {
	    printf(" SRC");
	    tag=inttoint(tmpbottonecgi.rifimage) | (0x1000000*immagine);
	    st_dinrif(tag);
	  }

	  /* se il browser non puo' vis. l'immagine fa veder il testo */
	  pastoc(tmpbottonecgi.value);
	  printf(" VALUE=\"%s\"",tmpbottonecgi.value);

	  puts(">");

	}
	else if (ogg==inizioform)
	{
	  /* converto le informazioni nel file AEH nell' appropriato
	   input, assegnando eventuale contenuto iniziale ecc.
	   ecc.ecc. a seconda del tipo di input */
	  leggi_info_ogg(inizioform,elem,&tmpinizioform);

	  printf("</FORM><FORM TARGET=_top METHOD=");
	  /*  */
	  if (tmpinizioform.tipo==ifautopass)
	  {
	    printf("POST ACTION=\"%s/%li",config.cgi_path,m_pagina);
	    printf("/0/E" /*tmpinizioform.link*/ );
	    /* il numero della pagina da raggiungere e' nell' id
	       del bottone premuto, che e' obbligatoriamente
	       pagid1234

	       dove 1234 e' la pagina.
	    */
	    printf("%s/\"",m_nomehelpfile);
	  } else
	  if ((tmpinizioform.tipo==ifget)
	    || (tmpinizioform.tipo==ifpost))
	  {
	    if (tmpinizioform.tipo==ifget)
	    { printf("GET"); } else printf("POST");

	    pastoc(tmpinizioform.azione);
	    printf(" ACTION=\"%s\"",tmpinizioform.azione);
	  }
	  pastoc(tmpinizioform.enctype);
	  if (tmpinizioform.putenctype)
	    printf(" ENCTYPE=\"%s\"",tmpinizioform.enctype);
	  puts(">");
	} 
	else if  ((ogg==multimedia))  /* MULTIMEDIA */
	{
	  puts("<!--multimedia found-->");
	  /* converto le informazioni nel file AEH nell' appropriato
	   tag multimedia, assegnando eventuale contenuto iniziale ecc.
	   ecc.ecc. a seconda del tipo di input */
	  leggi_info_ogg(multimedia,elem,&tmpmultimedia);

	  /*  */
          /*tag=ogg;
          tag=(tag<<24)+elem;*/
          tagmm=genlink;
          tagmm=(tagmm<<24)+(inttoint(tmpmultimedia.riffile) & 0xffffff);
          tagmi=immagine;
          tagmi=(tagmi<<24)+(inttoint(tmpmultimedia.rifimage) & 0xffffff);
          looop=int2toint(tmpmultimedia.loop);
          if (looop==65535) looop=-1; 

          /* il browser e' netscape o explorer? */
          ss=getenv("HTTP_USER_AGENT");
          netscape=(strstr(ss,"MSIE")==NULL);

  	  if ((tmpmultimedia.tipo==mmwav) ||
  	      (tmpmultimedia.tipo==mmmidi))  	  
	  {	    
	    if (netscape)
	    {/* NS */
	      printf("<EMBED SRC");
  	      printf("=\"%s/0",config.cgi_path);
	      printf("/%li/N",tagmm);
	      if (m_nomehelpfile[0]!='/') printf("/");
	      printf("%s/",m_nomehelpfile);
    	      if (tmpmultimedia.tipo==mmwav) 
    	      {
	        printf("?d+d+d+d+%i.wav\" ",tagmm);
	      } else
	        printf("?d+d+d+d+%i.mid\" ",tagmm);
	      
	      if (tmpmultimedia.azione==atloop)
	      {
	        printf("AUTOSTART=true HIDDEN=true ");
 	        printf("LOOP=%i >\n",looop);
	      } else
	      {
	        printf("CONTROLS=console >\n");
	      }  
	      /* IE */
	    }
	    else
	    {
	      if (tmpmultimedia.azione==atloop) 
	      {
	        printf("<BGSOUND SRC");
  	        printf("=\"%s/0",config.cgi_path);
	        printf("/%li/N",tagmm);
	        if (m_nomehelpfile[0]!='/') printf("/");
 	        
 	        printf("%s/",m_nomehelpfile);
    	        if (tmpmultimedia.tipo==mmwav) 
    	        {
	          printf("?d+d+d+d+%i.wav\" ",tagmm);
	        } else
	          printf("?d+d+d+d+%i.mid\" ",tagmm);

	        printf("LOOP=%i >\n",looop);
	      }
	    }

	  }
	  else  
  	  if ((tmpmultimedia.tipo==mmavi) ||
  	      (tmpmultimedia.tipo==mmmov))  	  
	  {
	    if (netscape)
	    {	    
  	      /* NS */  
	      printf("<EMBED SRC");
  	      printf("=\"%s/0",config.cgi_path);
	      printf("/%li/N",tagmm);
	      if (m_nomehelpfile[0]!='/') printf("/");
 	        
 	      printf("%s/",m_nomehelpfile);
    	      if (tmpmultimedia.tipo==mmmov) 
    	      {
	          printf("?d+d+d+d+%i.mov\" ",tagmm);
	      } else
	          printf("?d+d+d+d+%i.avi\" ",tagmm);
	    	    
	      printf("HEIGHT=%i WIDTH=%i ",int2toint(tmpmultimedia.xx),
	                                 int2toint(tmpmultimedia.yy));
	      
	      if (tmpmultimedia.azione==atloop)
	      {
	        printf("AUTOSTART=true ");
 	        if (looop==-1)
 	        {
 	          puts("LOOP=true >\n");
 	        } else puts("LOOP=false >\n"); 
	      } else
	      {
	        printf("AUTOSTART=false CONTROLLER=true >\n");
	      }  
	    }
	    else
	    { 
	      /* IE */
	      printf("<IMG DYNSRC");
  	      printf("=\"%s/0",config.cgi_path);
	      printf("/%li/N",tagmm);
	      if (m_nomehelpfile[0]!='/') printf("/");
    
 	      printf("%s/",m_nomehelpfile);
    	      if (tmpmultimedia.tipo==mmmov) 
    	      {
	          printf("?d+d+d+d+%i.mov\" ",tagmm);
	      } else
	          printf("?d+d+d+d+%i.avi\" ",tagmm);
	    
	      printf("HEIGHT=%i WIDTH=%i ",int2toint(tmpmultimedia.xx),
	                                 int2toint(tmpmultimedia.yy));
	      
	      /*
	      printf("BORDER=0 ALT=\"[animazione]\" ");
  	      printf("SRC=\"%s/0",config.cgi_path);
	      printf("/%li/N",tagmi);
	      if (m_nomehelpfile[0]!='/') printf("/");
	      printf("%s/\" ",m_nomehelpfile);
	      */	
		 
	      if (tmpmultimedia.azione==atloop) 
	      {
	        printf("START=fileopen LOOP=%i >",looop);
	      } else
	      {
	        printf("CONTROLS LOOP=0 >\n");
	      }
	    }
	  }
	}
      } else
      /*==============
			 inizio di un comando di delimitazione tabella
			 e' necessario tradurre l'AHTML in HTML usando gli
			 oggetti mem. internamente, o meglio lo stack che e'
			 stato creato con questi oggetti
      */
      if (*(pnt)=='T')
      {
			/*=== fine casella*/
	if ((*(pnt+1)=='F') || (*(pnt+1)=='Z'))
	{
	  *(pnt-1)=0;
				/* stampo tutto il buon testo html che c'era prima del link */
				printf("%s",buf);
				buf=pnt+3;          /*.......*/
				buf2=buf;

				printf("\12</TD>\12");
				if (popt()==TFINERIGA)   /* fine riga e inizio nuova riga */
				{  printf("\12</TR>\12<TR>\12"); }

				perc=popt();                    /* perc */
				if (perc>0)
				{  printf("\12<TD WIDTH=\"%i%%\" ",perc); }
				else printf("\12<TD ");

				perc=popt();                  /* hjus */
				tradhalign(perc,temp);
				printf("ALIGN=%s ",temp);     /* vjus */

				perc=popt();
				tradvalign(perc,temp);
				printf("VALIGN=%s ",temp);

				perc=popt();
				st_sfondo(perc);
				puts(" >\n");
			}
			else
			/* fine tabella */
			if (*(pnt+1)=='E')
			{

				popt();                  /* pop di un f.r. */
				*(pnt-1)=0;
				/* stampo tutto il buon testo html che c'era prima del link */
				printf("%s",buf);
				buf=pnt+3;          /*.........*/
				buf2=buf;

				printf("\12</TD>\12</TR>\12</TABLE>\12");
			}
			else
			{
				buf2=pnt;
			}
		} else
		/*==============
			 inizio di un comando paragrafo preformattato
		*/
		if ( (*(pnt)=='P') && (*(pnt+1)=='R') )
		{
		  flagpre=TRUE;   /* PRE sono in un paragrafo preform. */
		  buf2=pnt;
		} else
		/*==============
			 fine di un comando paragrafo preformattato
		*/
		if ( (*(pnt)=='/') && (*(pnt+1)=='P') )
		{
		  flagpre=FALSE;  /* /PRE non sono + */
		  buf2=pnt;
		} else
		/*==============
			 comando di a capo BR
		*/
		if ( (*(pnt)=='B') && (*(pnt+1)=='R') )
		{
			if (flagpre)    /* elimino diff. IPER-Netscape: tolgo
				i BR dentro i paragrafi PRE
				IPER li vuole, Netscape NO */
			{
			  *(pnt-1)=0;
			  /* elimino il BR e stampo tutto il buon testo html che c'era prima */
			  printf("%s",buf);
			  buf=pnt+3;          /*.........*/
			  buf2=buf;
			} else buf2=pnt;
		} else
		{
			buf2=pnt;
		}
  }
  printf("%s",buf);
  /* alla fine di ogni testo c'e' un bello zero! */

}


/*
--------------------------------------------------------------------------------------
  visualizza un insieme di frame
--------------------------------------------------------------------------------------
*/
void stampa_frame(int4 framenum, string buf)
{
  int4    	ogg,elem,len;
  string  	pnt;
  string        buf2;
  boolean 	errore;
  tmappaframe	tmpmappaframe;


  /* leggo le info sulla mappaframe da stampare */
  leggi_info_ogg(mappaframe,framenum,&tmpmappaframe);
  /* leggo la mappaframe in AHTML */
  fseek(fp1, offsettabellasecondaria + inttoint(tmpmappaframe.fileoffs3), SEEK_SET);
  len=inttoint(tmpmappaframe.len3);
  fread(buf,len,1,fp1);

  buf[len-1]=0;  /* sicurezza */

    /* traduco da AHTML a HTML */
  buf2=buf;
  errore=FALSE;
  while (      ((pnt=strchr(buf2,'$')) != NULL )
	    && (errore==FALSE) )
  {
      {
	/* ho trovato l'inizio di un link da tradurre dinamicamente
	*/
	extract_tag(pnt+1,&ogg,&elem);
	*(pnt)=0;
	/* stampo tutto il buon testo html che c'era prima del link */
	printf("%s",buf);
	/* passo a dopo il link */
	buf=pnt+9;  /* $00xx00xx"
		       ^        ^
		      pnt       pnt+8
		     */
	buf2=buf;
	if (ogg==testohtml)                          /* TESTO */
	{
	  /* nei frame AHTML salvati   SRC=" c'e' gia' */
	  printf("%s/%li/%li/F",config.cgi_path,m_pagina,elem);
	  printf("%s/",m_nomehelpfile);
	  /* puts("/"); */
	}
	else
	{
	  errore=TRUE;
	  fputs("errore in un frame, non riesco a decifrare l'oggetto contenuto",stderr);
	  /*  errore  */
	}
      }
  }

  printf("%s",buf); /* alla fine di ogni testo c'e' un bello zero!
		       (spero!) */
}






















/*
--------------------------------------------------------------------------------------
  background, colori , titolo per inizio pagina
--------------------------------------------------------------------------------------
*/
void inizio_pagina(string titolo)
{
  int4 i,j;
  char s[30];

  puts(inizio_pagina_i);
  puts(titolo);
  puts(inizio_pagina_f);
  puts(config.basehref);

  printf("<BODY ");
  i=inttoint(tmptestohtml.sfondo);

  if (i>-1)
  {
    j=immagine;
    i=i+(j<<24);
    /* creo il link dinamico per l'immagine di background */

    
    printf("BACKGROUND=\"%s/0/%i/N",config.cgi_path,i);
    printf("%s/\" ",m_nomehelpfile);
    
    
    /* se non cambiamo dopo, la popup prende lo sfondo del
       chiamante */
  }

  tohexstr(s,inttoint(tmptestohtml.testocol)) ;
  printf("TEXT=#%s ",s );
  tohexstr(s,inttoint(tmptestohtml.linkcol)) ;
  printf("LINK=#%s ",s );
  tohexstr(s,inttoint(tmptestohtml.follcol)) ;
  printf("VLINK=#%s ",s );
  tohexstr(s,inttoint(tmptestohtml.sfondocol)) ;
  printf("BGCOLOR=#%s >\n",s );
}


/*
--------------------------------------------------------------------------------------
  background, colori , titolo per inizio pagina
--------------------------------------------------------------------------------------
*/
void inizio_pagina_err(string titolo)
{
  int4 i;
  char s[30];

  puts(inizio_pagina_i);
  puts(titolo);
  puts(inizio_pagina_f);
  puts(config.basehref);
  printf("<BODY BACKGROUND=\"sfondo.jpg\" >");

}





















/*
--------------------------------------------------------------------------------------
  visualizza pulsanti "SOmmario", "..
--------------------------------------------------------------------------------------
*/
void visualizza_pulsanti()
{
  /* pulsanti */

   if (header.pulssommario)
   {
	printf("%s%s/%i/0/S",iniziolink_i,config.cgi_path,m_pagina);
	printf("%s/",m_nomehelpfile);
	puts(pulsante_sommario_f);
   }
   if (!header.notpulscopertina)
   {
	printf("%s%s/%i/0/Z",iniziolink_i,config.cgi_path,m_pagina);
	printf("%s/",m_nomehelpfile);
	puts(pulsante_copertina_f);
   }
   if (header.pulscerca)
   {
	printf("%s%s/%i/0/C",iniziolink_i,config.cgi_path,m_pagina);
	printf("%s/",m_nomehelpfile);
	puts(pulsante_cerca_f);
   }
   if (header.pulsguida)
   {
	 /* apro il file di guida per l'utente */
	printf("%s%s/%i/0/N",iniziolink_i,config.cgi_path,m_pagina);
	printf("%s/",config.selfhelp_path);
	puts(pulsante_guida_f);
   }
}


/*
--------------------------------------------------------------------------------------
  visualizza una pagina
--------------------------------------------------------------------------------------
*/
void visualizza_html(int paginaleader, int tipo, int paginavera)
{
  int4      num;
  timmagine tmpimmagine;



  if ((m_comando!='n') && (m_comando!='z')) puts(content);


  if (tmptestohtml.tipo==thframe)
  {
    puts(inizio_pagina_i);
    puts(titolo);
    puts(inizio_pagina_f);
    puts(config.basehref);

    if (!header.nonvispulsanti)
    {
      /* se richiesta la visualizzazione bottoni, inizio con un frame
	 principale:
	 il frame in alto  punta  al richiamo cgi che visualizza
	 i bottoni */
      puts("<FRAMESET ROWS=\"55,*\" >\n");
      printf("<FRAME SRC=\"%s/0/0/B%s/\" SCROLLING=\"no\">",
		  config.cgi_path,m_nomehelpfile);

      /* leggo i dati dei frames della pagina da visualizzare
	 e stampo il frame convertendo i link in
	 chiamate a iper.cgi con comando  F  */
    }
    num=inttoint(tmptestohtml.framedata);
    stampa_frame(num,buf);

    if (!header.nonvispulsanti)
    {
      /* chiudo il frame principale */
      puts("</FRAMESET>");
    }
    puts("<NOFRAME>");
  }

    /* quello che segue nel caso di un frame e' visualizzato
		 solo da un browser "Non Frame Capable" */


    /* inizio pagina */
    inizio_pagina(tmptestohtml.caption);
    if (!header.nonvispulsanti)
    {
      visualizza_pulsanti();
      puts("<HR><BR>");
    }

    /* se la finestra era una popup la visualizza prima di tutto il resto in
       un riquadro */
	 if (tipo==thpopup)
    {
      puts("<TABLE CELLPADDING=20 BORDER=2><TR><TD ALIGN=LEFT></B></I></PRE></TT>");
      viewpage(paginavera,buf);
      puts("</TD></TR></TABLE><P>");
    }
    viewpage(paginaleader,buf);
    puts(fine_pagina);


  if (tmptestohtml.tipo==thframe)
  {
    puts("</NOFRAME>");
    puts(fine_pagina);
  }

}
/*
--------------------------------------------------------------------------------------
  visualizza una pagina html singleframe
--------------------------------------------------------------------------------------
*/
void visualizza_htmlsingleframe(int paginaleader)
{
  string    pnt;
  int4      len;
  timmagine tmpimmagine;


  /* inizio pagina */
  
  m_frame=TRUE;
  
  puts(content);
  inizio_pagina(tmptestohtml.caption);
  /* NO pulsanti */
  len=int2toint(tmptestohtml.len);
  buf[len-1]=0;  /* sicurezza */
  viewpage(paginaleader,buf);
  puts(fine_pagina);
}






















/*
--------------------------------------------------------------------------------------
  visualizza una pagina, principale
--------------------------------------------------------------------------------------
*/
void visualizza_pagina(int pagina)
{
  leggi_info_ogg(testohtml,pagina,&tmptestohtml);
  
  /*
  fputs("<br> leggi info ogg",stderr);
  */

  if ((tmptestohtml.tipo==thtesto) || (tmptestohtml.tipo==thframe))
  {
    /*TESTO NORMALE O FRAME */
    m_pagina=m_index;        /* la futura pagina madre sara' la pagina
				attuale */
	 visualizza_html(pagina,thtesto,pagina);
  }
  else
  {
    /*
    fputs("Ho individuato popup",stderr);
    */
    /*POPUP*/
    m_pagina=m_paginamadre;  /* la futura pagina madre sara' la pagina
				madre attuale */
	 visualizza_html(m_paginamadre,thpopup,pagina);
	 /* visualizzo la pagina precedente con in piu' la POPUP "finta",
       In questo modo una POPUP non puo' essere visualizzata come prima
       pagina */
  }
}
/*
--------------------------------------------------------------------------------------
  visualizza una pagina, interna ad un <frameset...
  in pratica visualizza uno dei frame
--------------------------------------------------------------------------------------
*/
void visualizza_singleframe(int pagina)
{
  leggi_info_ogg(testohtml,pagina,&tmptestohtml);
  /*
  fputs("<br> leggi info ogg",stderr);
  */
  
    /* TESTO NORMALE O POPUP NON CI INTERESSA, QUI VISUALIZZ.
		 SEMPRE UGUALE */
  m_pagina=m_index;           /* la futura pagina madre sara' la pagina
				 attuale */
  visualizza_htmlsingleframe(pagina);
}



































void fgets1(string s)
{
  int i;

  fgets(s,80,fp2);


  while ( ((i=strlen(s)) >0 ) && (s[i-1]<' ') )
   {
     s[i-1]=0;
   }
}

/*
---------------------------------------------------------------------------------------
   leggo il file di configurazione
---------------------------------------------------------------------------------------
*/
int leggi_config()
{
  fp2=fopen(config_file,"rt");
  if (fp2==NULL) 
  {
    /*
    puts(content);
    puts("Ahime' non riesco a leggere il file di configurazione iper.ini");
    puts("Senza il file di configurazione sono perso!!!!!");
    return FALSE;
    */
    
    /* ................................................................. 

       PROVVISORIO PER ORA AL POLI NON RIESCE A LEGGERE IPER.INI:
       GLI DO' IO I DATI!

    */

    strcpy(config.selfhelp_path,"/data/htppd/iper/selfhelp.aeh");
    strcpy(config.cgi_path,"http://www.polito.it/cgi-bin/cgi-iper/iper.cgi");
    strcpy(config.basehref,"<BASE HREF=\"http://www.polito.it/iper/\">");
    strcpy(config.blackbox,"/data/httpd/iper/blackbox");
  
  
  } else {
    fgets1(config.selfhelp_path);
    fgets1(config.cgi_path);
    fgets1(config.basehref);
    fgets1(config.blackbox);
    fclose(fp2);
  }
  
  if (
      (strlen(config.selfhelp_path)==0)
     ) return FALSE;

  return TRUE;
}


























/*
--------------------------------------------------------------------------------------
  Da' su  stdout  un oggetto richiesto.
  L'oggetto deve essere compatibile con il tipo tmappaclic,
  cioe' avere gli stessi primi campi del record, ed un record
  uguale o piu' corto (per non fare errori di protezione!)
--------------------------------------------------------------------------------------
*/
void estrai_file(char ogg, int4 elem)
{
  string 	imagebuf,ss;
  FILE*  	fp2;
  int4 		offset,len;
  tgenlink	tmpgenlink;
  tmappaclic    tmpmappaclic;
  boolean       netscape;


  /* Dico l'opportuno content-type */
  if ((ogg==immagine) || (ogg==mappaclic))
  {
	 leggi_info_ogg(ogg,elem,&tmpmappaclic);
    offset=inttoint(tmpmappaclic.img.fileoffs);
    len=inttoint(tmpmappaclic.img.len);
	 if (tmpmappaclic.img.tipo==imgif)
	 { printf("Content-Type: image/gif\n");
	 } else
	 if (tmpmappaclic.img.tipo==imjpg)
    { printf("Content-Type: image/jpg\n");
	 }
  } else
  /*................ qui posso aggiungere altri tipi di contenuti, cioe'
    dire a Netscape come deve trattare altri tipi di file, es. file
    audio..............
  */
  if (ogg==ziplink)
  {
	 leggi_info_ogg(ogg,elem,&tmpgenlink);
    offset=inttoint(tmpgenlink.fileoffs);
	 len=inttoint(tmpgenlink.len);
    printf("Content-type:application/x-zip\n");
  }
  else if (ogg==genlink)
  {
    /*
     
    */
    leggi_info_ogg(ogg,elem,&tmpgenlink);
    offset=inttoint(tmpgenlink.fileoffs);
    len=inttoint(tmpgenlink.len);
    
              /* il browser e' netscape o explorer? */
    ss=getenv("HTTP_USER_AGENT");
    netscape=(strstr(ss,"MSIE")==NULL);
    if (netscape) 
    {
      if (tmpgenlink.tipo==lkwav)
      { printf("Content-type: audio/x-wav\n");
      } else
      if (tmpgenlink.tipo==lkmidi)
      { printf("Content-type: audio/midi\n");
      } else
      if (tmpgenlink.tipo==lkavi)
      { printf("Content-type: video/x-msvideo\n");
      } else
      if (tmpgenlink.tipo==lkmov)
      { printf("Content-type: video/quicktime\n");
      }
    }
    else
    {
      if (tmpgenlink.tipo==lkwav)
      { printf("Content-type: audio/wav\n");
      } else
      if (tmpgenlink.tipo==lkmidi)
      { printf("Content-type: audio/midi\n");
      } else
      if (tmpgenlink.tipo==lkavi)
      { printf("Content-type: video/x-msvideo\n");
      } else
      if (tmpgenlink.tipo==lkmov)
      { printf("Content-type: video/quicktime\n");
      }
    } 
  }
  printf("Content-length: %i\n\n",len);


  /* cerco l'immagine o il file nel file sorgente */
  fseek( fp1,offsettabellasecondaria + offset,SEEK_SET );

  /* la carico in memoria quindi la butto in stdout */
  if (len>0)
  {
	 imagebuf=(string)malloc(len);
    if (imagebuf==NULL)
    {
      puts("Memoria insufficiente<BR>");
    } else
	 {
		fread(imagebuf,len,1,fp1);
      fwrite(imagebuf,len,1,stdout);
    }
    free(imagebuf);
  } else
  {
    puts("L' oggetto richiesto e' vuoto oppure non definito!<BR>");
  }
}

























/*
---------------------------------------------------------------------------
  Visualizza la pagina linkata
  alla coordinata scelta nella mappa cliccabile
---------------------------------------------------------------------------
*/
void mappa_clic(string coord)
{
  string      ptr;
  int4        l,ll,elem,x,y;
  char        ogg;
  tmappaclic  tmpmappaclic;

  ptr=strchr(coord,',');
  if (ptr!=NULL)
  {
    ptr[0]=0;
    x=atoi(coord);
    y=atoi(ptr+1);


    leggi_info_ogg(mappaclic,m_index,&tmpmappaclic);
    l=0;
    
    /*
    fprintf(stderr,"\nCoord x: %i \n",x);
    fprintf(stderr,"\nCoord y: %i \n",y);
    */
    
    while (l<30)
    {
		if (tmpmappaclic.links[l].link>=0)
		if ( (int2toint(tmpmappaclic.links[l].le)<=x) &&
		(int2toint(tmpmappaclic.links[l].le)+
		  int2toint(tmpmappaclic.links[l].w)>=x) &&
		(int2toint(tmpmappaclic.links[l].t)<=y) &&
		(int2toint(tmpmappaclic.links[l].t)+
		  int2toint(tmpmappaclic.links[l].h)>=y) )
      {
	/*
	fprintf(stderr,"limiti: %i",
		int2toint(tmpmappaclic.links[l].le));
	fprintf(stderr,"limiti: %i",
	   int2toint(tmpmappaclic.links[l].t));
	fprintf(stderr,"limiti: %i",
	   int2toint(tmpmappaclic.links[l].w));
	fprintf(stderr,"limiti: %i",
	   int2toint(tmpmappaclic.links[l].h));
        */

	ll=inttoint(tmpmappaclic.links[l].link);
	elem=ll & 0xffffff;
	ogg=(ll & 0xff000000) >> 24;
	if (ogg==testohtml)
	{
	  /*
	  fprintf(stderr,"\nIndividuato link: %i\n",l);
	  */
	  visualizza_pagina(elem);
	}
	l=30;
      }
      l++;
    }

    if (l==30)
    {
      /* non e' stato trovato alcun link in corrisp delle coordinate
	 cliccate */
       /*
       fputs("\nNon trovata pagina specifica: visualizzo pagina di default.\n",stderr);
       */
		 visualizza_pagina(m_paginamadre);
    }
  } else fputs("\nNon specificate coordinate per mappaclic",stderr);
}



































/*
---------------------------------------------------------------------------
  Routine sfruttata per immagazzinare nella "doppia lista"
  puntata da pkeys[], di massimo 1000 elementi,
  le keywords o i titoli degli argomentio puntati da una keyword,
  in ordine alfabetico.
  Usa variabili globali:
	 pkeys[..]
	 firstkey
---------------------------------------------------------------------------
*/
void inser_in_ord(int4 i, pkeywordlist pnewkey)
{
  boolean      found;
  int4         l;
  pkeywordlist j,k;


  if ((i<MAXKEYS) && (pnewkey!=NULL))
  {
    if (i==0) firstkey.pnt=pnewkey;
    pkeys[i]=pnewkey;

    l=0;
    k=&firstkey;
	 j=k->pnt;
     found=FALSE;

    while ((l<i) && (found==FALSE))
    {
      if (strcmp(pnewkey->caption,j->caption)<0)
      {
	/* se la nostra stringa e' minore e' lei la prima */
	pnewkey->pnt=j;
	/* puntera' a quella attuale come successiva */

	k->pnt=pnewkey;
	/* la precedente puntera' a lei */
	found=TRUE;
      } else
      {
	k=j;
	j=k->pnt;
	/* passiamo alla prossima stringa */
	l++;
      }
    }
    if (found==FALSE)
    {
    /* la nostra stringa e' l'ultima, la penultima puntera' a lei*/
      k->pnt=pnewkey;
    }
  }

}


/*
---------------------------------------------------------------------------
  Legge dal file AEH le keyword e le mette in una struttura che e' sia
  un' array nella quale le keyword sono immagazzinate con lo stesso
  ordine che hanno nel file AEH, sia una lista in cui,
  partendo da  firstkey.pnt,
  si puo' accedere alla lista keyword in ordine alfabetico.

  Questo e' un metodo veloce per mostrare all'utente una cosa alfabetic.
  ordinata, ma mantenere all'interno ancora il vecchio ordine
  che serve per la ricerca delle keyword per numero d'ordine.
---------------------------------------------------------------------------
*/
void inserisci_ordinata(int4 i)
{
  pkeywordlist pnewkey;

  /* alloco spazio per una nuova keyword reale */
  pnewkey=(pkeywordlist)malloc(sizeof(tkeywordlist));
  pnewkey->code=i;

  /* leggo la keyword */
  leggi_info_ogg(keyword,i,pnewkey);
  /* immagazzino in pkeys^[i], mantenendo l'ordine */
  inser_in_ord(i,pnewkey);

}






/*
---------------------------------------------------------------------------
  Visualizza la finestra che contiene tutte le keyword disponibili
  per la ricerca
---------------------------------------------------------------------------
*/
void cerca()
{
  int4         i,j;
  pkeywordlist k;
  char         tmp[255];

  i=0;
  j=inttoint(tabella0[keyword].numerorecord);
  while (i<j)
  {
    inserisci_ordinata(i);
    i++;
  }

  leggi_info_ogg(testohtml,0,&tmptestohtml);
  puts(content);
  inizio_pagina("Cerca argomento tramite parola chiave...");

  printf("<CENTER><H1>Scegli una parola chiave</H1>");
  printf("%s%s%s%i",form_i0,config.cgi_path,form_i00,0);
  printf("%s%s",form_i1,m_nomehelpfile);
  puts("\">\n<SELECT NAME=\"keyw\" SIZE=14>\n");

  i=0;
  k=&firstkey;
  j=inttoint(tabella0[keyword].numerorecord);

  while (i<j)
  {
    k=k->pnt;
    printf("<OPTION VALUE=\"%i\">",k->code);
    puts(k->caption);
    i++;
  }
  puts("\n</SELECT>\n<P><INPUT TYPE=\"submit\" VALUE=\"Trova argomenti\">");
  puts(form_f);


}





























/*----------------------------------------------------------------

	routine di conver

-------------------------------------------------------------------*/
char stringa[3000];

void stoi(char stringa[],int *intptr)
{
	  int segno=1;
	  int indice=0;

	  if(stringa[indice]=='-'||stringa[indice]=='+')
	     segno=(stringa[indice++]=='-')?-1:1;
	  *intptr=0;
	  while(stringa[indice]>='0'&& stringa[indice]<='F')
	  {
		*intptr=16*(*intptr)+stringa[indice]-'0';
		if (stringa[indice++]>'9')
		*intptr-=7;
	  }
	  if(stringa[indice]=='\0')
	  {
		*intptr=segno*(*intptr);
		return;
	  }
	  else return;
}



/*
---------------------------------------------------------------------------
  Visualizza la finestra che contiene i titoli degli argomenti relativi
  alla keyword precedentemente scelta dall'utente,

  oppure se un argomento e' stato scelto, salta alla pagina relativa
  all'argomento.
---------------------------------------------------------------------------
*/
void trova_argomenti()
{
  int4         ii,i,j,jj,k,keyword_scelta,argomento=-1;
  char         arg[3][300];
  ttestohtml   tmpt;
  tkeyword     tmpk;
  boolean      flag;
  pkeywordlist pk,pnewkey;

  int    codint,n;
  char   *secstr;
  char   codice[3];
  string ini;
  char   tmphlp[3000];


  arg[0][0]=0;
  arg[1][0]=0;
  arg[2][0]=0;

  /* leggo i parametri che il POST mi ha mandato sul mio stdin.
     si tratta di qualcosa come
	   user=123&help=%2fdsfsdf%2fsdf&keyw=14&

     In pratica ' '     ->  '+'
		CR LF       '&'
		&,
		$,
		%,
		...         %xx  dove xx e' la codifica ASCII hex
				 (di default latin1, anche le lettere
				 accentate sono quindi lecite, come del resto
				 in tutto l'HTML, anche se pochi lo sanno)
  */
  gets(stringa);
  strncpy(tmphlp,stringa,3000);
  tmphlp[3000]=0;

  /* assumo che ogni parametro occupi una sola linea (e'sbagliato per
    i memo, ma qui non ce n'e', e smisto le 3 linee che mi
    interessano in  arg[0..2] */
  /* il codice seguente e' adattato da conver, avuta da alberto capella */
  n=0;
  ini=stringa;
  k=0;
  for(n=0;stringa[n]!='\0';n++)
  {
	  if(stringa[n]=='%')
	    {
		codice[0]=stringa[n+1];
		codice[1]=stringa[n+2];
		codice[2]='\0';
		stoi(codice,&codint);
		secstr=stringa+n+3;
		if(codint==';')
			codint--;
		stringa[n]=codint;
		stringa[n+1]='\0';
		strcat(stringa,secstr);
	    }
	  else if(stringa[n]=='&')
	       {
		 stringa[n]='\0';
		 strcpy(arg[k],ini);
		 ini=stringa+n+1;
		 k++;
		 stringa[n]='&';
	       }
	  else if(stringa[n]=='+')
		stringa[n]=' ';
	  else if (stringa[n]==13)
		 stringa[n]='\0';
	}

  /* ultimo argomento */
  strcpy(arg[k],ini);



  /* estraggo le informazioni che mi sono necessarie
     dalle stringhe ricavate */
  if (arg[0][0]=='u')
  {
    /*  estraggo numero utente                utente
	 utente=atoi(arg[0]+5);                           */
    /* piu' non serve */

    /*  estraggo file help utente             nomehelpfile*/
    strcpy(m_nomehelpfile,arg[1]+5);

    /*         - estraggo numero keyword      keyword_scelta */
    /*  oppure - estraggo argomento           argomento */
    if (arg[2][0]=='k')
	 {
      /* keyword */
      keyword_scelta=atoi(arg[2]+5);
    } else
    {
      /* argomento */
      argomento=atoi(arg[2]+5);
    }



	 if (apri_leggi_header())
    {
      /* crea_tmp_immagini(); */

		if (argomento==-1)
      {
	/* la chiamata a questa routine proveniva dalla pagina delle
	 keyword: devo allora cercare tutte le pagine di testo che
	 contengono la keyword selezionata */

	leggi_info_ogg(testohtml,0,&tmptestohtml);
	puts(content);
	inizio_pagina("Argomenti trovati...");

	leggi_info_ogg(keyword,keyword_scelta,&tmpk);

	puts("<CENTER><H1>Scegli un argomento</H1>");
	printf("Parola chiave: %s<P>",tmpk.caption);

	printf("%s%s%s%i",form_i0,config.cgi_path,form_i00,0);
	printf("%s%s",form_i1,m_nomehelpfile);


	puts("\"><br>\n<SELECT NAME=\"argo\" SIZE=14>\n");

	i=0;
	ii=0;
	j=inttoint(tabella0[testohtml].numerorecord);

	while (i<j)
	{
	  leggi_info_ogg(testohtml,i,&tmpt);

	  jj=0;
	  flag=FALSE;
	  while ( (jj<20)  && ( (k=inttoint(tmpt.keyword[jj])) > -1 )
		&& (flag==FALSE) )
	  {
		 if (k==keyword_scelta) flag=TRUE;
	    jj++;
	  }
	  if (flag)
	  {
	   /* sfrutto la routine che avevo fatto per le
	     keyword */
	    pnewkey=(pkeywordlist)malloc(sizeof(tkeywordlist));

	    if (pnewkey==NULL)
	    {
	      
	      fputs("Memoria insufficiente: COMPRATE RAM!",stderr);
	    
	    } else
	    { if (strlen(tmpt.caption)==0) strcpy(pnewkey->caption,"n.n.");
	      else
		strcpy(pnewkey->caption,tmpt.caption);

			pnewkey->code=i;
	      inser_in_ord(ii,pnewkey);
	      ii++;
	    }
	  }
	  i++;
	}

	i=0;
	pk=&firstkey;
	if (pk->pnt!=NULL) while (i<ii)
	{
		pk=pk->pnt;
		printf("<OPTION VALUE=\"%i\">",pk->code);
		puts(pk->caption);
		i++;
	}


	puts("\n</SELECT>\n<P><INPUT TYPE=\"submit\" VALUE=\"Vedi pagina\">");
	puts(form_f);

      }
      else
      {
      /* la chiamata a questa routine proveniva dalla pagina degli
	 argomenti: devo allora visualizzare la pagina di testo
	 selezionata, argomento */

      /* il numero utente e' gia' a posto */
	visualizza_pagina(argomento);
      }
    }
    else
    {
      /* l' apertura lettura header non  andata a buon fine */
	inizio_pagina_err("Problemi...");
	puts("Non riesco ad elaborare il file che mi hai indicato<br>Debug:<br>");
	puts(tmphlp);
	puts("<br>\nArgomenti decodificati:");
	puts(arg[0]);
	puts("<br>\n");
	puts(m_nomehelpfile);
	puts("<br>\n");
	puts(arg[2]);
	puts("<br>\n");
    }
	 close(fp1);

  }
  else
  {
    inizio_pagina_err("Problemi...");

    puts("Il contenuto del POST non e' stato decodificato correttamente!");
    puts(fine_pagina);
  }
}





















/*
=======================================================================================
   MAIN
=======================================================================================
*/
int main(int argc, char *argv[])
{
  int    c;
  char   s[255],t[255],tm[200],path_info[255],car[3],prv[200],tml[300];
  string parambuf;
  int    lastbr,i,l,ll;
  string ptr,ptr2,pppp;
  int4   tag;



  /*
  fputs("\n------------------------------------------------------\n",stderr);
  */

  if (leggi_config()==FALSE)
  {
	puts("Non riesco a leggere il file di configurazione:");
	puts(config_file);
	puts("");
  } else
  {
    ptr=getenv("PATH_INFO");
    if (ptr!=NULL)
    {
      /* puts(content);
      puts("path info non ricevuta!");
      exit(2);
      */
      
      /*
      strcpy(path_info,ptr);
      */
      
      /* strcpy(prv,"nn"); */
      /* mi occupo di eliminare le estensioni fantasma 
      ========prova
      */
      
      
      /*
      pppp=prv;
      */
      
      pppp=ptr;
      strcpy(path_info,ptr);
      
      
      ll=strlen(path_info);
      if (path_info[ll-2]!='h') {
        ll=ll-3;
        while ((ll>0) && (path_info[ll]!='/')) ll--;
        path_info[ll+1]=0;
      };
      
      
      ptr=strchr(path_info,'/');
    }


    if ((argc>2) && (argc<5))
    {
	/* se ci sono + di 2 argomenti ma no path_info siamo in modo
	ricerca, occorre leggere il POST da stdin e processare
	i comandi di ricerca argomento */
	if (argc>3) {
	/* 
	  non c'e' path-info ma ci sono argomenti: allora il primo
	  argomento e' la pagina, il secondo e'il file di help
 	*/
          m_pagina=atoi(argv[1]);
          m_paginamadre=m_pagina;
          strcpy(m_nomehelpfile,argv[2]);
          m_oggetto=0;
          m_index=m_pagina;
          m_comando='n';
          goto produci;
          
	} else
	trova_argomenti();
    } else
    if (ptr!=NULL)
    {
      /* se c'e' un extra-path, o qualche 
         parametro dummy siamo in modo normale */
      {
	ptr2=ptr+1;
	ptr=strchr(ptr2,'/');
	if (ptr==NULL) exit(3);
	ptr[0]=0;
	m_paginamadre=atoi(ptr2);
	m_pagina=m_paginamadre;
	/* m_paginamadre: puo' essere la pagina a cui si deve ritornare
	 nel caso che la pagina attuale sia una popup, o nel caso
	 che la zona scelta nella mappa cliccabile non abbia un target
	 definito
	*/


	ptr2=ptr+1;
	ptr=strchr(ptr2,'/');
	if (ptr==NULL) exit(3);
	ptr[0]=0;
	tag=atol(ptr2);
	m_oggetto=(tag & 0xff000000) >> 24;
	m_index=(tag & 0xffffff);
	/* oggetto: l'oggetto che dobbiamo mandare ora su stdout, cioe':
		  -pagina di testo  Content-type: text/html
		  -immagine                     : image/gif image/jpg
		  -ZIP                          : application/x zip
	*/


	ptr2=ptr+1;
	ptr=strchr(ptr2,'/');
	if (ptr==NULL) exit(3);
	ptr[0]=0;
	m_comando=ptr2[0];
	/* comando: 	N normale, visualizza l'oggetto richiesto normalmente
			F l'oggetto richiesto e' una pagina di testo richiesta
		    da un riquadro di un frame: non devi visualizzare quindi
		    i bottoni "Sommario","Copertina", ecc., che non va bene
		    compaiano in piu' frame
			C cerca
			Z copertina
			S sommario
	*/



	ptr[0]='/';
	strncpy(m_nomehelpfile,ptr,strlen(ptr)-1);   /* elimino ultimo / */
	m_nomehelpfile[strlen(ptr)-1]=0;
	/* nomehelpfile: /users/s63998/public_html/usr/puffo/aldo_c.aeh
	*/


	/*stackY=(int4*) malloc(sizeof(MAXARRAY));*/
produci:

	spY=0;

	listaparamq_strings=(string*) malloc(MAXARRAY);
	listaparamq_objects=(string*) malloc(MAXARRAY);
	listaparamq_count=0;


	m_iniz=(char*) malloc(MAXARRAY);




	/* apro il file AEH, se e' a posto leggo l'header...*/
	if (apri_leggi_header()) {

	  /* processo la richiesta */
	  if ( (m_comando=='N') || (m_comando=='n')) {
	    /*============= OGGETTO
	      se il comando e' M occorre visualizz. la pagina senza
	      content-type.
	    */
	    /*
	    fputs("\n comando N: visualizza oggetto",stderr);
	    */
	    if (m_oggetto==testohtml) {
			visualizza_pagina(m_index);
		 } else
		 estrai_file(m_oggetto,m_index);

	  } else
	  if (m_comando=='E') {
	    /*============= PAGINA, RICHIESTA DI USO ESTESO:
		 MEMORIZZO I PARAMETRI IN INPUT PER USARLI
		 NELLA QUERY */


	    if (m_oggetto==testohtml) {
	      /**/
	      parambuf=malloc(MAXARRAY);

	      listaparamq_count=0;
	      i=0;
	      lastbr=0;

	      while (( (c=getchar())!=EOF) && (c!=10) && (c!=13))
	      {
		if (i>MAXARRAY-3) i=MAXARRAY-3;

		if (c=='&') {
		  parambuf[i]=13;
		  parambuf[i+1]=10;
		  i=i+2;
		  lastbr=i;
		} else
		if (c=='%') {
		  car[0]=getchar();
		  car[1]=getchar();
		  car[2]=0;
		  stoi(car,&l);
		  parambuf[i]=l;
		  i++;
		} else
		if (c=='+') {
		  parambuf[i]=' ';
		  i++;
		} else
		if (c=='=') {
		  l=i-lastbr+1;
		  parambuf[i]=0;
		  listaparamq_strings[listaparamq_count]=
		    malloc(l);
		  strncpy(listaparamq_strings[listaparamq_count],
		    parambuf+lastbr,l);
		  /* listaparamq_strings[listaparamq_count][l]=0; */

		  if (strncmp(parambuf+lastbr,"pagid",5)==0)
		  {
		   /* abbiamo trovato l'id del bottone chiamante,
		    memorizziamo in m_index la pagina da raggiungere */
		    m_index=atoi(parambuf+lastbr+5);
		    #ifdef DEBUG
		      printf("<!--button found: id=%li->\n",m_index);
		    #endif
		  }

		  if (listaparamq_count>0) {
		    parambuf[lastbr-2]=0;
		    l=lastbr-1;
		    listaparamq_objects[listaparamq_count-1]=
		      malloc(l);
		    strncpy(listaparamq_objects[listaparamq_count-1],
		      parambuf,l);
		    /* listaparamq_objects[listaparamq_count-1][l]=0; */

		    #ifdef DEBUG
		      printf("<!--cont=");
		      puts(listaparamq_objects[listaparamq_count-1]);
		      puts("-->");
		    #endif

		  }

		  #ifdef DEBUG
		    printf("<!--par=");
		    puts(listaparamq_strings[listaparamq_count]);
		    puts("-->");
		  #endif

		  lastbr=0;
		  listaparamq_count++;
		  i=0;
		} else
		{
		  parambuf[i]=c;
		  i++;
		}
	      }

	      /* dopo l'ultimo parametro non ci sono return,
		 ma devo leggerlo ugualmente tutto */
	      lastbr=i+1;

	      if (listaparamq_count>0)
	      {
		    lastbr=i+2;
		    parambuf[lastbr-2]=0;
		    l=lastbr-1;
		    listaparamq_objects[listaparamq_count]=
		      malloc(l);
		    strncpy(listaparamq_objects[listaparamq_count],
		      parambuf,l);
		    /* listaparamq_objects[listaparamq_count][l]=0; */

		    #ifdef DEBUG
		      printf("<!--lastcont=");
		      puts(listaparamq_objects[listaparamq_count]);
		      puts("-->");
		    #endif
	      }
	      free(parambuf);

	      visualizza_pagina(m_index);


	    } else
	    {
	      inizio_pagina_err("Errore.");
	      puts("Errore nei parametri!");
	    }
	  } else
	  if (m_comando=='F') {
	    /*
	    fputs("\n comando F: pezzo di frame:non visual. pulsanti",stderr);
	    */
		 if (m_oggetto==testohtml) {
			visualizza_singleframe(m_index);
	    };
	  } else
	  if (m_comando=='C') {
	    /*
	    fputs("\n comando C: cerca",stderr);
	    */
		 cerca();
	  } else
	  if ((m_comando=='Z') || (m_comando=='z')) {
	    /*
	    fputs("\n comando Z: copertina",stderr);
	    */
		 visualizza_pagina(inttoint(header.copertina));
	  } else
	  if (m_comando=='S') {
	    /*
	    fputs("\n comando S: sommario",stderr);
	    */
		 visualizza_pagina(inttoint(header.sommario));
	  } else
	  if (m_comando=='W') {
	    /*
	    fputs("\n comando W: wins",stderr);
	    */
	    inizio_pagina_err("Informazione.");
	    puts("Questa funzione  disponibile solo in MSWindows.");
	  } else
	  if (m_comando=='B') {
	    /*
	    fputs("\n comando B: buttons",stderr);
	    */
	    puts(content);
	    inizio_pagina("barra pulsanti");
	    visualizza_pulsanti();

	  } else
	  if ((argc>1) && (m_comando=='M'))
	  {
	    /*
	    fputs("\n comando M: mappa cliccabile",stderr);
	    */
	    /* mappa cliccabile */
	    mappa_clic(argv[1]);

	  }
	} else
	{
	  /* l' apertura lettura header non  andata a buon fine */
	  puts(content);
	  inizio_pagina_err("Problemi...");
	  puts("Non riesco ad elaborare il file che mi hai indicato. Path info");
	  puts(pppp);
	  puts("<BR>");
	  puts("Richiesta:");
	  puts(prv);
	  puts("<BR>");
	  puts("Path info:");
	  puts(tml);
	  puts("<BR>");
	  puts("Path info char -2:");
	  printf("%c",tml[strlen(tml)-2]);
	  puts("<BR>");
	  puts("Comando:");
	  putchar(m_comando);
	  puts("<BR>");
	  puts(m_nomehelpfile);
	  puts("<BR>");
	  printf("%i",m_pagina);
	}

	/* free(stackY);*/
	close(fp1);
      }
    } else
    {
	/* 
	  non c'e' path-info ma ci sono argomenti: allora il primo
	  argomento e' la pagina, il secondo e'il file di help
             err	
	*/
	puts(content);
	inizio_pagina_err("Problemi...");
	puts("Parametri errati, non c'e' path info ma ci sono argomenti.");
	puts(pppp);
	puts("<BR>");
	putchar(m_comando);
	puts("<BR>");
	puts(m_nomehelpfile);
	puts("<BR>");
	printf("%i",m_pagina);

    }
  }
  return 0;
}






/*char          nomehelpfile_trad[360],nometmpdir[300];*/


/*
---------------------------------------------------------------------------------------
   traduco una stringa da normale a pseudo PERL
---------------------------------------------------------------------------------------
*/
/*
void trad(string s, string tmp)
{
  int l;

  l=0;
  while (s[0]!=0)
  {
    if ( (s[0]!='%') && (s[0]!='&') && (s[0]!='$') &&
		 (s[0]!='/') && (s[0]!='\\')
     )
    {
      tmp[l]=s[0];
      l++;
    } else
    {
      tmp[l]='%';
      tmp[l+1]=0;
      strcat(tmp,tohex(s[0]));
      l=l+3;
	 }
	 s++;
  }
  tmp[l]=0;
}
  */
