/* ------------------------------------------------------------------------ */
/* CLIPSHOP.C (C) CopyLeft Bill Buckels 1999                                */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* If you don't agree, remove this source code from your computer now.      */
/*                                                                          */
/* Written by   : Bill Buckels                                              */
/*                589 Oxford Street                                         */
/*                Winnipeg, Manitoba, Canada R3M 3J2                        */
/*                                                                          */
/* Email: bbuckels@escape.ca                                                */
/* WebSite: http://www.escape.ca/~bbuckels                                  */
/*                                                                          */
/* Date Written : June 1999                                                 */
/* Purpose      : View and Copy "Old Printshop" ClipArt in Windows          */
/* Revision     : 1.1 First Release                                         */
/* Notes        : I banged CLIPSHOP together from several of my old         */
/*                programs. I wrote most of this code between 1990 and 1993,*/
/*                and CLIPSHOP is a mixture of Windows 3.1 and DOS routines.*/
/*                I haven't made any attempt to bulletproof this program    */
/*                nor to do anything beyond tidying things up a little,     */
/*                but it is relatively safe to use and all that of course.  */
/*                It's hard to say exactly how useful CLIPSHOP will be      */
/*                to most folks anyway. Since I wrote it mainly for         */
/*                myself, and for visitors to my WebSite, I pretty much     */
/*                consider it a "done-deal" for the time being.             */
/* ------------------------------------------------------------------------ */
/* Written in Large Model Microsoft C Version 6.00a                         */
/* ------------------------------------------------------------------------ */

// windows headers
#include <windows.h>
#include <commdlg.h>

// microsoft runtime headers
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>

// our own header
#include "clipshop.h"

// ------------------------------------------------------------------------
// Local Constants
// ------------------------------------------------------------------------
enum {  CLIPTYPE_DAT = 0,
        CLIPTYPE_POG,
        CLIPTYPE_SHP,
        CLIPTYPE_GPH,
        NUM_CLIPTYPES};

// ------------------------------------------------------------------------
// Structure Declarations
// ------------------------------------------------------------------------
typedef struct {
       char mycaption[16];
    }MYLIST;

/* a bit field structure for the CGA pixel */
struct cgabit{
       unsigned int x4: 2;
       unsigned int x3: 2;
       unsigned int x2: 2;
       unsigned int x1: 2;
    };

/* we use a union to unmask the CGA pixel bit fields */
union cgapixel{
      struct cgabit pixel;
      unsigned char byt;
    };

/* a bit field structure for the Monochrome pixel */
struct monobit{
       unsigned int x8: 1;
       unsigned int x7: 1;
       unsigned int x6: 1;
       unsigned int x5: 1;
       unsigned int x4: 1;
       unsigned int x3: 1;
       unsigned int x2: 1;
       unsigned int x1: 1;
    };

/* we use a union to unmask the Monochrome pixel bit fields */
union monopixel{
      struct monobit pixel;
      unsigned char byt;
    };

/* print partner specific */

typedef struct {
  unsigned char namlen;
  unsigned char nambuf[20];
  unsigned char datatype;
  unsigned char height;
  unsigned char width;
}PRINT_PARTNER_DATA_HDR;

#define DATA_HDR_LEN sizeof(PRINT_PARTNER_DATA_HDR)
#define END_OF_HDR 26   /* header ends, data begins */
#define RAW_DATA   1

// ------------------------------------------------------------------------
// Function prototypes
// ------------------------------------------------------------------------

long far PASCAL WndProc (HWND, WORD, WORD, LONG) ;
BOOL FAR PASCAL EntryDlgProc(HWND, unsigned, WORD, LONG);

long far PASCAL MyAbout(HWND);
long far PASCAL MyLoad(HWND);
long far PASCAL MySave(HWND);
long far PASCAL MyExport(HWND);
long far PASCAL MyEntry(HWND);
long far PASCAL MyDelete(HWND);
long far PASCAL MyCopy(HWND, WORD);
long far PASCAL MyHelp(HWND);

int openbitmaps(char *);
int closebitmaps();
BOOL ppReadFileHeader(FILE *);
BOOL ppReader();

int InitDialog(HWND,WORD);
int ClearScreen(HWND,HDC,COLORREF);
int LoadPic();
BOOL FAR PASCAL IsBilingual(LPSTR);
BOOL FAR PASCAL FileExists(LPSTR, LPSTR);
int BaseName(char *, char *);
void MakeCaptionLines(char *, char *, int *, unsigned);

// ------------------------------------------------------------------------
// Variables
// ------------------------------------------------------------------------
char *lpszAppName = "CLIPSHOP";
char *lpszTitle   = "CLIPSHOP(C) CopyLeft Bill Buckels 1999. All Rights Reversed.";
char *lpszTitleFile  = "Now Clipping %s";

// some error messages (we didn't make all things singing and all things
// dancing for this version, so we had better make sure folks know
// why we can't handle certain operations...)

char *lpSorrySave = "Sorry... before saving or exporting "
                    "you must load a library that "
                    "uses the small picture format "
                    "(88 x 52 \"Old PrintShop\", "
                    "\"New PrintShop\" or \"Old PrintMaster\" "
                    "graphics).\n\n"
                    "Additional picture libraries and "
                    "The METOO(C) Children's Program and "
                    "other Teacher's Choice Programs that use "
                    "the \"Old PrintShop\" graphics format are available "
                    "from the Teacher's Choice Website at\n\n"
                    "http://www.escape.ca/~bbuckels/kidstuff\n";

char *lpSorryEntry = "Sorry... You cannot enter text until "
                    "you load a library that uses the small picture format "
                    "(88 x 52 \"Old PrintShop\", "
                    "\"New PrintShop\" or \"Old PrintMaster\" "
                    "graphics).\n\n"
                    "This feature was included in ClipShop mainly "
                    "to allow you "
                    "to create custom ENGLISH vocabulary lesson plans "
                    "for use in the METOO(C) Children's Program and "
                    "other Teacher's Choice Programs that use "
                    "the \"Old PrintShop\" graphics format.\n\n"
                    "METOO(C) and other Children's Programs are available "
                    "from the Teacher's Choice Website at\n\n"
                    "http://www.escape.ca/~bbuckels/kidstuff\n";

char *lpSorryDelete = "Sorry... Deleting a picture can only be done "
                    "after loading an \"Old Printshop\" format .DAT "
                    "graphics library.\n\n"
                    "This feature was included in ClipShop mainly "
                    "to allow you to remove unwanted images from "
                    "custom ENGLISH vocabulary lesson plans "
                    "for use in the METOO(C) Children's Program and "
                    "other Teacher's Choice Programs that use "
                    "the \"Old PrintShop\" graphics format.\n\n"
                    "METOO(C) and other Children's Programs are available "
                    "from the Teacher's Choice Website at\n\n"
                    "http://www.escape.ca/~bbuckels/kidstuff\n";

char *lpSorryBilingual = "Sorry... the .DAT or .NAM file that you wish to "
                    "modify may be linked to a BILINGUAL support "
                    "library from Teacher's Choice Productions. "
                    "Try working on a copy if you absolutely "
                    "must modify this file.\n\n"
                    "This feature was included in ClipShop mainly "
                    "to provide support for "
                    "custom ENGLISH vocabulary lesson plans "
                    "for use in the METOO(C) Children's Program and "
                    "other Teacher's Choice Programs that use "
                    "the \"Old PrintShop\" graphics format.\n\n"
                    "METOO(C) and other Children's Programs are available "
                    "from the Teacher's Choice Website at\n\n"
                    "http://www.escape.ca/~bbuckels/kidstuff\n";

BOOL STARTED=FALSE;
BOOL HELPACTIVE=FALSE;
int xborder=0,yborder=0;

MYLIST *mylist = (MYLIST *)NULL;
unsigned mytotal=0;

int namehandle=-1,dathandle=-1,mycurrent=0,oldcurrent=0;
FILE *fpPartner = NULL;

PRINT_PARTNER_DATA_HDR ppHdr;

HDC hdcParent;
HWND hwndParent;
HANDLE hInst;
HANDLE hAccTable;                        // handle to accelerator table

// BITMAP data to copy to the clipboard
HANDLE hData = NULL;
LPSTR  lpData;
LONG   dwDataSize;

BITMAPFILEHEADER BitMapFileHeader;
LPBITMAPINFOHEADER lpbi, lpbmp;
char *lpinfo, *fbuf, *bmpbuf;

/* global image width and image height */
/* these values are set when each image is read from the file */
unsigned uiBmpWidth = (XSHOP*2),
         uiBmpHeight = (YSHOP*2);

int iClipType = CLIPTYPE_DAT;

char *lpszExtension[NUM_CLIPTYPES][2] = {
    ".DAT", ".NAM",
    ".POG", ".PNM",
    ".SHP", ".SDR",
    ".GPH", ".GPH"};
    // printpartner stores pictures and names in the same file

// directory list globals
char szCustFilterSpec[MAXCUSTFILTER];     // custom filter buffer
OPENFILENAME ofn;                         // struct. passed to GetOpenFileName

static char PathName[128] = "\0";         // ofn global
static char FileName[128] = "\0";         // ofn global

// filter string for dir. listings
char far *szFilterSpec;

// filter string variables for different types of filename dialogs

static char szAnySpec[256]
          = "Any Old Files(*.*)\0*.*\0"
            "Old PrintShop Graphics(*.DAT)\0*.DAT\0"
            "New PrintShop Graphics(*.POG)\0*.POG\0"
            "Old PrintMaster Graphics(*.SHP)\0*.SHP\0"
            "Old PrintPartner Graphics(*.GPH)\0*.GPH\0";

static char szBmpSpec[128]
          = "BMP Files(*.BMP)\0*.BMP\0";

static char szPrintShopSpec[128]
          = "DAT Files(*.DAT)\0*.DAT\0";

char szDialogBuf[(INPUTSIZE*3)];// user's input buffer
char szNam[128], szDat[128];    // global file names for convenience

// the 8 x 16 OEM character set bitmaps
typedef struct{
    unsigned char b[256][16];
}RAMFONT;

RAMFONT far *lpRamFont;                  // bitmap conversion font resource
HRSRC   hMyFontloc;
HGLOBAL hMyFontRes;

#define MB_SUCCESS  (MB_OK|MB_ICONINFORMATION)
#define MB_FAILURE  (MB_OK|MB_ICONSTOP)

char *FileSuccess = "File %s Successfully saved.";
char *FileFailure = "Unable to save file %s.";


// ------------------------------------------------------------------------
// Windows Entry Point (main module)
// ------------------------------------------------------------------------
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
     {
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;
     int x1=0,y1=0,yfactor;
     int xwidth,ywidth;

     hInst = hInstance; // save instance handle
     if (!hPrevInstance)
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon(hInstance, "MyIcon");
          wndclass.hCursor       = NULL;//LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = lpszAppName ;

          RegisterClass (&wndclass) ;
	  }

    // put the window onto centre-stage
    xwidth=GetSystemMetrics(SM_CXSCREEN);
    ywidth=GetSystemMetrics(SM_CYSCREEN);

    if(xwidth>XMAX)
    {
      xborder=GetSystemMetrics(SM_CXBORDER)*2;
      x1=(xwidth-XMAX)/2 -xborder;
      xwidth=XMAX+xborder+xborder;
      xborder/=2;
    }
    if(ywidth>YMAX)
    {
      yborder = GetSystemMetrics(SM_CYBORDER)*2;
      yfactor = GetSystemMetrics(SM_CYCAPTION);
      y1 = (ywidth-YMAX)/2 -yborder-yfactor;
      ywidth= YMAX+yborder+yfactor+yfactor;
      yborder/=2;
    }

    if(hMyFontloc=FindResource(hInstance,"MYFONT",RT_RCDATA))
     {
        if(hMyFontRes=LoadResource(hInstance,hMyFontloc))
        {
            lpRamFont=(RAMFONT far *)LockResource(hMyFontRes);
        }
     }

     hAccTable = LoadAccelerators(hInstance, "ClipShopAcc");

     hwndParent = hwnd = CreateWindow (lpszAppName,lpszTitle,
                          WS_MAXIMIZE|WS_MINIMIZEBOX|
                          WS_CAPTION|WS_POPUP|WS_SYSMENU,
                          x1,y1,xwidth,ywidth,
                          NULL, NULL, hInstance, NULL) ;


     hdcParent=GetDC(hwnd);

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     initpic();

     while (GetMessage (&msg, NULL, 0, 0))
     {
        if (!TranslateAccelerator(hwnd, hAccTable, &msg))
        {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
        }
     }

     hwndParent = NULL;
     closebitmaps();
     freepic();
     ReleaseDC(hwnd,hdcParent);
     UnlockResource(hMyFontRes);
     FreeResource(hMyFontRes);

     return msg.wParam ;
}


// ------------------------------------------------------------------------
// Main Message Loop
// ------------------------------------------------------------------------
long far PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    HMENU hMenu,
          hMenuPopup;
    HDC hMemoryDC;
    HBITMAP hBitmap, hOldBitmap;
    HDC hdc;
    BITMAP bitmap;

    PAINTSTRUCT ps;
    static char far buffer[128];

    switch (message)
	  {
        case WM_CREATE:
          hMenu= CreateMenu();

          hMenuPopup= CreateMenu();
          AppendMenu (hMenuPopup, MF_ENABLED| MF_STRING,
                     IDM_LOAD,    "[F7]\tLoad Library");
          AppendMenu (hMenuPopup, MF_ENABLED| MF_SEPARATOR,0,"");
          AppendMenu (hMenuPopup, MF_ENABLED| MF_STRING,
                     IDM_CHANGE,  "[F8]\tChange Text");
          AppendMenu (hMenuPopup, MF_ENABLED| MF_STRING,
                     IDM_SAVE,    "[F9]\tSave to Library");
          AppendMenu (hMenuPopup, MF_ENABLED| MF_STRING,
                     IDM_DELETE,  "[DEL]\tDelete Current Clip");
          AppendMenu (hMenuPopup, MF_ENABLED| MF_STRING,
                     IDM_EXPORT,  "[F10]\tExport Library to BMP");
          AppendMenu (hMenuPopup, MF_ENABLED| MF_SEPARATOR,0,"");
          AppendMenu (hMenuPopup, MF_ENABLED| MF_STRING,
                     IDM_QUIT,    "[ESC]\tExit ClipShop");


          AppendMenu (hMenu, MF_ENABLED| MF_POPUP,
                     (UINT)hMenuPopup,  "&File");
          AppendMenu (hMenu, MF_ENABLED| MF_STRING,
                     IDM_MORE,          "[F2] ne&Xt");
          AppendMenu (hMenu, MF_ENABLED| MF_STRING,
                     IDM_COPY,          "[F3] &Copy");
          AppendMenu (hMenu, MF_ENABLED| MF_STRING,
                     IDM_THINCOPY,      "[F4] &ThinCopy");
          AppendMenu (hMenu, MF_ENABLED| MF_STRING,
                     IDM_SMALLCOPY,     "[F5] &SmallCopy");

          hMenuPopup= CreateMenu();
          AppendMenu (hMenuPopup, MF_ENABLED| MF_STRING,
                     IDM_HELP,         "[F1]\tHelp");
          AppendMenu (hMenuPopup, MF_ENABLED| MF_STRING,
                     IDM_ABOUT,        "[F6]\tABout");
          AppendMenu (hMenu, MF_ENABLED| MF_POPUP,
                     (UINT)hMenuPopup, "&Help");

          SetMenu (hwnd,hMenu);
          return 0L;

        case WM_COMMAND:

          // command message handler switch
          switch(wParam)
          {

                case IDM_MORE:
                  if(STARTED==TRUE) {
                    SetCursor(LoadCursor(NULL,IDC_WAIT));
                    LoadPic();
                    SetCursor(LoadCursor(NULL,IDC_ARROW));
                    return 0L;
                  }
                  break;
                case IDM_LOAD:
                  return MyLoad(hwnd);
                case IDM_CHANGE:
                  return MyEntry(hwnd);
                case IDM_SAVE:
                  return MySave(hwnd);
                case IDM_DELETE:
                  return MyDelete(hwnd);
                case IDM_EXPORT:
                  return MyExport(hwnd);
                case IDM_QUIT:
                  DestroyWindow(hwnd);return 0L;
                case IDM_COPY:
                case IDM_THINCOPY:
                case IDM_SMALLCOPY:
                  if (STARTED == TRUE) {
                    MyCopy(hwnd, wParam);
                    return 0L;
                  }
                  break;
                case IDM_ABOUT:
                  MyAbout(hwnd);
                  return 0L;
                case IDM_HELP   : return MyHelp(hwnd);
           }
           break;

      case WM_PAINT:

           hdc=BeginPaint(hwnd,&ps);
           if(STARTED==TRUE)
             ShowPic(oldcurrent, uiBmpWidth, uiBmpHeight);
           else
           {

              if((hBitmap=LoadBitmap(hInst,"MyBmp"))!=NULL)
              {
                if((hMemoryDC=CreateCompatibleDC(hdc))!=NULL)
                {
                  hOldBitmap=SelectObject(hMemoryDC,hBitmap);
                  if(hOldBitmap)
                  {
                    GetObject(hBitmap,sizeof(BITMAP),(LPSTR)&bitmap);
                    BitBlt(hdc,xborder,yborder,
                               400,400,
                               hMemoryDC,
                               0,0,
                               SRCCOPY);
                    SelectObject(hMemoryDC,hOldBitmap);
                  }
                  DeleteDC(hMemoryDC);
                }
                DeleteObject(hBitmap);
              }
           }
           EndPaint(hwnd,&ps);
           return 0L;

      case WM_DESTROY:   
           if(HELPACTIVE!=FALSE)WinHelp(hwnd,"CLIPSHOP.HLP",HELP_QUIT,0L);
           HELPACTIVE = FALSE;
           PostQuitMessage(0);
           return 0L;
          }

     return DefWindowProc (hwnd, message, wParam, lParam) ;
}

// ------------------------------------------------------------------------
// Allocate memory and initialize image buffers
// ------------------------------------------------------------------------
int initpic()
{
    unsigned mysize;
    unsigned long *templong;
    char *cbuf;

    fbuf  =malloc(FILEMAX);  // printshop = 572
    bmpbuf=malloc(FILEMAX);

    mysize=sizeof(BITMAPINFOHEADER);
    lpbi=malloc(mysize+8);
    lpbmp=malloc(mysize+8);   // export buffer...

    memset(lpbi,0,mysize+8);

    lpinfo=malloc(BUFFERMAX);  // printshop = 624 * 4

    lpbi[0].biSize=sizeof(BITMAPINFOHEADER);
    lpbi[0].biWidth=2L*XSHOP;     // nominal size - printshop * 2
    lpbi[0].biHeight=2L*YSHOP;    // nominal size - printshop * 2
    lpbi[0].biPlanes=1;
    lpbi[0].biBitCount=1;
    lpbi[0].biCompression=BI_RGB;
    lpbi[0].biSizeImage=(DWORD)624*4;  // nominal size - printshop * 2
    lpbi[0].biXPelsPerMeter=0L;
    lpbi[0].biYPelsPerMeter=0L;
    lpbi[0].biClrUsed=2L;
    lpbi[0].biClrImportant=0L;

    cbuf=(char *)(&lpbi[0].biSize);
    templong=(unsigned long *)&cbuf[mysize];
    templong[0]=(unsigned long)255<<16|255<<8|255;

    memcpy(lpbmp, lpbi, mysize+8); // copy the lpbi to the export bmp
                                   // we will setup the variants later...

}

// ------------------------------------------------------------------------
// free the memory used by this program
// ------------------------------------------------------------------------
int freepic()
{
    free(lpinfo);
    free(lpbi);
    free(lpbmp);
    free(fbuf);
    free(bmpbuf);
}

/* --------------------------------------------------------------------- */
/* Read a PrintPartner file past the file header and position the record */
/* pointer to the start of the first record. Bail if any problems.       */
/* --------------------------------------------------------------------- */
BOOL ppReadFileHeader(FILE *fp)
{

  int c;
  char buf[128];
  int len = strlen(PRINT_PARTNER);

  rewind(fp);
  fread(buf, len, 1, fp);
  buf[len] = ASCIIZ;
  if (strcmpi(PRINT_PARTNER, buf)) {
    return FALSE;
  }
  while ((c = fgetc(fp))!=END_OF_HDR) {
    if (c == EOF) {
      return FALSE;
    }
  }
  return TRUE;
}

/* --------------------------------------------------------------------- */
/* Read an image from a PrintPartner file.                               */
/* --------------------------------------------------------------------- */
BOOL ppReader()
{
    unsigned packet,
             bytesperline,
             jdx,
             idx;
    int x, y;

    // try to read the image data header from a printmaster file...
    // if we are at the end of the file
    // we seek back to the beginning...
    // if still an error we give-up.

    if (0 == fread(&ppHdr, DATA_HDR_LEN, 1, fpPartner)) {
      ppReadFileHeader(fpPartner);
      if (0 == fread(&ppHdr, DATA_HDR_LEN, 1, fpPartner)) {
        // "unexpected error ... no records"
        return FALSE;
      }
    }

    // if this file has been saved by the user, it will be raw.
    // otherwise it will be run length encoded and we can't
    // deal with it... so give-up.

    if (RAW_DATA != ppHdr.datatype) {
      // "Unsupported File Format. Type 1 Uncompressed Records Only."
      return FALSE;
    }

    packet = ppHdr.width * ppHdr.height;
    if (packet != fread(fbuf, sizeof(char), packet, fpPartner)) {
      // "unexpected error ... no data"
      return FALSE;
    }

    uiBmpHeight = 2 * ppHdr.height;
    uiBmpWidth = 8 * ppHdr.width;

    lpbi[0].biHeight= (long)uiBmpHeight;
    lpbi[0].biWidth = (long)uiBmpWidth;

    bytesperline = ppHdr.width;
    while (bytesperline%4)bytesperline++;
    lpbi[0].biSizeImage=(DWORD)bytesperline*uiBmpHeight;

    // convert the data to a windows bitmap format
    idx = 0;
    for (y = (ppHdr.height-1); y> -1; y--) {
      jdx = (y * 2) * bytesperline;
      for (x = 0; x < ppHdr.width; x++) {
        // write pairs of scanlines
        lpinfo[jdx] = lpinfo[jdx+bytesperline] = fbuf[idx];
        idx++;
        jdx++;
      }
    }
    ppHdr.nambuf[ppHdr.namlen] = ASCIIZ;
    return TRUE;
}

// ------------------------------------------------------------------------
//  Loader function after user selects a file from the ofn Dialog
// ------------------------------------------------------------------------
int openbitmaps(char *pszLibname)
{
    unsigned long target;
    unsigned int targetint;
    char szBuf[256],
         *ptr = ".DAT";
    int i,j;

    closebitmaps();

    /* build the filename based on known files that we handle */
    strcpy(szNam, pszLibname);
    for (i=0; szNam[i] != 0; i++) {
      if (szNam[i] == '.') {
        ptr = (char *)&pszLibname[i];
        szNam[i] = 0;
        break;
      }
    }

    for (i = 0; i < NUM_CLIPTYPES; i++) {
      if (strcmpi(ptr, (char *)&lpszExtension[i][0][0]) == 0 ||
          strcmpi(ptr, (char *)&lpszExtension[i][1][0]) == 0) {
        iClipType = i;
        break;
      }
    }

    strcpy(szDat, szNam);
    strcat(szDat, (char *)&lpszExtension[iClipType][0][0]);
    strcat(szNam, (char *)&lpszExtension[iClipType][1][0]);

    sprintf(szBuf, "Error! Unable to open %s.", szDat);

    // we handle printpartner seperately...
    if (iClipType == CLIPTYPE_GPH) {
      fpPartner = fopen(szDat, "rb");
      if (NULL == fpPartner) {
        MessageBox(NULL,szBuf,lpszTitle,MB_ICONHAND);
        return -1;
      }
      if (ppReadFileHeader(fpPartner) == FALSE) {
        fclose(fpPartner);
        fpPartner = NULL;
        sprintf(szBuf, "Error! %s has an invalid header.", szDat);
        MessageBox(NULL,szBuf,lpszTitle,MB_ICONHAND);
        return -1;
      }
      return SUCCESS;
    }

    if((dathandle = open(szDat,O_RDONLY|O_BINARY)) == -1)
    {
      MessageBox(NULL,szBuf,lpszTitle,MB_ICONHAND);
      return -1;
    }

    // if it's a pog file we blow away the header
    if (iClipType == CLIPTYPE_POG)
      read(dathandle,szBuf,10);


    if((namehandle = open(szNam,O_RDONLY|O_BINARY)) == -1)
    {
      close(dathandle);
      dathandle = -1;
      sprintf(szBuf, "Error! Unable to open %s.", szNam);
      MessageBox(NULL,szBuf,lpszTitle,MB_ICONHAND);
      return -1;
    }

    target=filelength(namehandle);
    targetint=(unsigned )target;
    mytotal=targetint/CAPTIONLENGTH; /* how many images are in the library */

    if((mylist=malloc(targetint))==NULL)
    {
      close(dathandle);
      close(namehandle);
      dathandle = namehandle = -1;
      MessageBox(NULL,"Memory Allocation Error!",
                      lpszTitle,MB_ICONHAND | MB_SYSTEMMODAL);
      return -1;
    }

    read(namehandle,mylist[0].mycaption,targetint);
    close(namehandle);
    namehandle = -1;

    // trim the whitespace from the NAM file entries
    for(i=0;i<mytotal;i++)
    {
      j=CAPTIONLENGTH;
      while(j!=0)
      {
        j--;
        if(mylist[i].mycaption[j]>32)j=0;
        else mylist[i].mycaption[j]=0;
      }
    }
    return 0;

}

// ------------------------------------------------------------------------
// General Cleanup and reset initial values before loading new clipart.
// ------------------------------------------------------------------------
int closebitmaps()
{
    if (NULL != hwndParent)
      SetWindowText(hwndParent,lpszTitle);  // reset the title
    STARTED = FALSE;
    mytotal = mycurrent = oldcurrent = 0;

    if (NULL != fpPartner) {
      fclose(fpPartner);       // print partner is handled differently
      fpPartner = NULL;
    }

    if (dathandle != -1)
      close(dathandle);
    if (namehandle != -1)
      close(namehandle);
    dathandle = namehandle = -1;
    if ((MYLIST *)NULL != mylist)
      free(mylist);
    mylist = (MYLIST *)NULL;

    iClipType = CLIPTYPE_DAT;          // default is printshop
    lpbi[0].biWidth=2L*XSHOP;          // nominal size - printshop * 2
    uiBmpWidth = (XSHOP*2);
    lpbi[0].biHeight=2l*YSHOP;         // nominal size - printshop * 2
    uiBmpHeight = (YSHOP*2);
    lpbi[0].biSizeImage=(DWORD)624*4;  // nominal size - printshop * 2

    return 0;
}

// ------------------------------------------------------------------------
// Load and Display the next image
// ------------------------------------------------------------------------
int LoadPic()
{
    int y,x,nibble,i;
    char *abuf,*bbuf,*cbuf;
    char szBuf[128];

    int packet, x1, y1; // work variables

    if (iClipType == CLIPTYPE_GPH) {
      if (ppReader() == FALSE) {
        closebitmaps();
        InvalidateRect(hwndParent, NULL, TRUE);   // repaint everything
        UpdateWindow(hwndParent);                 // force WM_PAINT message
        MessageBox(NULL,"Error! Unsupported format.",lpszTitle,MB_ICONHAND);
        return 0;
      }
    }
    else {
      if(mycurrent<mytotal)
       {
           oldcurrent=mycurrent;
           mycurrent++;
         }
       else
       {
         lseek(dathandle, 0L, SEEK_SET);
         // if pog, blow-away the header
         if (iClipType == CLIPTYPE_POG)
           read(dathandle,szBuf,10);
         oldcurrent=mycurrent=0;
         mycurrent++;
        }

      if (iClipType == CLIPTYPE_SHP) {
        read(dathandle,szBuf,4);
        packet=szBuf[0]; // width in bytes
        y1=szBuf[1];     // height in rasters
        x1=szBuf[2];     // width in pixels
        // if printmaster, first and last image bytes are NULL PADDING
      }

      read(dathandle,fbuf,572);

      // if printmaster, first and last image bytes are NULL PADDING
      if (iClipType == CLIPTYPE_SHP)
        read(dathandle,szBuf,1);

      // magnify the image 2 x 2

      memset(lpinfo,0,624*4);
      i=0;
      for(y=51;y>-1;y--)
      {

      x=0;
      cbuf = (char *)&fbuf[i];i+=11;   /* file buffer */


      abuf = (char *)&lpinfo[y*48];   /* scanline 1 */
      bbuf = (char *)&abuf[24];       /* scanline 2 */

      while(x<11)
        {

          //=======================================
          // the low nibble goes into the first byte of the scanline
          // the high nibble goes into the second byte....

          nibble=0;
          while(nibble<8)
          {
            if (*cbuf & 0x80>>nibble)
            {
                  *abuf |=3;     /* 2 pixels wide - scanline 1 */
                  *bbuf |=3;     /* 2 pixels wide - scanline 2 */
            }
            nibble++;
            if(nibble != 4 && nibble !=8 )
            {
                  *abuf<<=2;
                  *bbuf<<=2;
            }
            else
            {
                  *abuf++;
                  *bbuf++;
            }
          }
          //=======================================

          *cbuf++;
          x++;
        }
      }
    }
    ClearScreen(hwndParent,hdcParent,RGB(255,255,255));
    ShowPic(oldcurrent, uiBmpWidth, uiBmpHeight);

return 0;
}

// ------------------------------------------------------------------------
// Display the current image
// ------------------------------------------------------------------------
int ShowPic(int idx, int width, int height)
{
    DWORD dwcolor;
    static char far mybuf[128];
    int X, Y;

    X = xborder+(XMAX/2)-(width/2);
    Y = yborder+(YMAX/2)-(height/2);

    // display the captions
    dwcolor=GetTextColor(hdcParent);
    if (iClipType != CLIPTYPE_GPH) {
      sprintf(mybuf,"Picture #%d",idx);
      SetTextColor(hdcParent,RGB(0,0,255));
      TextOut(hdcParent,X,Y-40,mybuf,strlen(mybuf));
      SetTextColor(hdcParent,RGB(255,0,0));
      TextOut(hdcParent,X,Y+height+8,mylist[idx].mycaption,
              strlen(mylist[idx].mycaption));
    }
    else {
      SetTextColor(hdcParent,RGB(255,0,0));
      TextOut(hdcParent,xborder,yborder,ppHdr.nambuf,strlen(ppHdr.nambuf));
    }
    SetTextColor(hdcParent,dwcolor);

    // display the buffer

   SetDIBitsToDevice(hdcParent,X,Y,
                      width,height,
                      0, 0, 0, height,
                      (LPSTR)lpinfo,
                      (PBITMAPINFO)lpbi,
                      DIB_RGB_COLORS);
}


// ------------------------------------------------------------------------
// Copy the Current Image to the ClipBoard
// ------------------------------------------------------------------------
long far PASCAL MyCopy(HWND hWnd, WORD wParam)
{
    // copy a DIB to the clipboard

    unsigned int BytesPerLine;
    unsigned idx,
             x,
             x1,
             x2,
             len, // header size + colormap
             xadjust,
             yadjust,
             zadjust,
             badjust;

    unsigned char far *src;
    union cgapixel   Pic;
    union monopixel  Clip;

    SetCursor(LoadCursor(NULL,IDC_WAIT));

    xadjust = yadjust = 1;             // copy 2:2
    switch(wParam) {
      case IDM_SMALLCOPY:              // copy 1:1
         yadjust = 2;
      case IDM_THINCOPY:               // copy 1:2
         if (iClipType != CLIPTYPE_GPH)
           xadjust = 2;
    }
    zadjust = xadjust * yadjust;
    badjust = xadjust * 8;

    BytesPerLine = uiBmpWidth/badjust;
    while((BytesPerLine%4)!=0)BytesPerLine++;
    x1 = uiBmpWidth/8;
    while((x1%4)!=0)x1++;

    len = (unsigned)BMPHEADERSIZE + (sizeof(long) * 2);

    dwDataSize =  0L;                      // Size =
    dwDataSize += BytesPerLine;            // 8 pixels per byte DW boundary
    dwDataSize *= (uiBmpHeight/yadjust);   // X number of rasters
    dwDataSize += len;                     // + Header + colormap

    hData = GlobalAlloc(GMEM_MOVEABLE, dwDataSize);
    if(hData == NULL)
    {
      MessageBox(hWnd,"Out Of Memory!",NULL,MB_ICONHAND | MB_SYSTEMMODAL);
      SetCursor(LoadCursor(NULL,IDC_ARROW));
      return -1L;
    }

    lpData = GlobalLock(hData);

    if(lpData == NULL)
    {
       MessageBox(hWnd,"Out Of Memory!",NULL,MB_ICONHAND | MB_SYSTEMMODAL);
       SetCursor(LoadCursor(NULL,IDC_ARROW));
       return -1L;
     }

    // copy the header into the memory block to pass to the clipboard

    // temporarily adjust
    lpbi[0].biWidth=lpbi[0].biWidth/xadjust;
    lpbi[0].biHeight=lpbi[0].biHeight/yadjust;
    lpbi[0].biSizeImage=lpbi[0].biSizeImage/zadjust;

    src=(unsigned char far *)&lpbi[0].biSize;      // copy
    for(idx=0;idx<len;idx++)lpData[idx]=src[idx];

    // put back to normal
    lpbi[0].biWidth=lpbi[0].biWidth*xadjust;
    lpbi[0].biHeight=lpbi[0].biHeight*yadjust;
    lpbi[0].biSizeImage=lpbi[0].biSizeImage*zadjust;

    // now copy the bitmap to the memory block

    x  = 0;
    x2 = 0;
    for(idx=len;idx<dwDataSize;idx++) {

      if ((wParam == IDM_THINCOPY || wParam == IDM_SMALLCOPY) &&
          (iClipType != CLIPTYPE_GPH)) {
        Pic.byt  = lpinfo[x];
        Clip.byt = 0;
        if (Pic.pixel.x1)Clip.pixel.x1 =1;
        if (Pic.pixel.x2)Clip.pixel.x2 =1;   // if scaling
        if (Pic.pixel.x3)Clip.pixel.x3 =1;   // use every second bit
        if (Pic.pixel.x4)Clip.pixel.x4 =1;
        x++;
        x2++;
        Pic.byt  = lpinfo[x];
        if (Pic.pixel.x1)Clip.pixel.x5 =1;
        if (Pic.pixel.x2)Clip.pixel.x6 =1;
        if (Pic.pixel.x3)Clip.pixel.x7 =1;
        if (Pic.pixel.x4)Clip.pixel.x8 =1;
        lpData[idx] = Clip.byt;
        x++;
        x2++;
      }
      else {
        lpData[idx]=lpinfo[x];
        x++;
        x2++;
      }
      // only save every second scanline if doing a small copy
      if (wParam == IDM_SMALLCOPY && (x2==x1)) {
        x+=x1;
        x2=0;
      }
    }

   // release the bitmap to the clip board...
   GlobalUnlock(hData);
   if (OpenClipboard(hWnd))
   {
     EmptyClipboard();
     SetClipboardData(CF_DIB, hData);
     CloseClipboard();
   }
   hData = NULL;

   SetCursor(LoadCursor(NULL,IDC_ARROW));
   return 0L;
}

// ------------------------------------------------------------------------
// Initialize variant info for the ofn dialog
// ------------------------------------------------------------------------
int InitDialog(HWND hWnd,WORD DirType)
{
    // fill in fields of OPENFILENAME struct.
    // depending on what kind of file we are processing

    switch(DirType)
    {
        case DIR_BMP:
          PathName[0] = FileName[0] = ASCIIZ; /* wipeout previous contents */

          // use the library name to create a base name for the Windows BitMap
          if (TRUE == FileExists(szDat, FileName)) {
            BaseName(FileName, NULL);
            strcat(FileName, ".BMP");
          }
          szFilterSpec=(char far *)&szBmpSpec[0];
          break;
        case DIR_PRINTSHOP:
          PathName[0] = FileName[0] = ASCIIZ; /* wipeout previous contents */
          szFilterSpec=(char far *)&szPrintShopSpec[0];
          break;
        default:
          PathName[0] = FileName[0] = ASCIIZ; /* wipeout previous contents */
          szFilterSpec=(char far *)&szAnySpec[0];
          break;
    }
    ofn.lStructSize       = sizeof(OPENFILENAME);
    ofn.hwndOwner         = hWnd;
    ofn.lpstrFilter       = szFilterSpec;
    ofn.lpstrCustomFilter = szCustFilterSpec;
    ofn.nMaxCustFilter	  = MAXCUSTFILTER;
    ofn.nFilterIndex      = 1;
    ofn.lpstrFile         = FileName;
    ofn.nMaxFile          = MAXFILENAME;
    ofn.lpstrInitialDir   = PathName;
    ofn.Flags             = OFN_HIDEREADONLY;
    ofn.lpfnHook          = NULL;
    ofn.lpstrTitle        = (LPSTR)"Select/Enter Filename";
    return 0;
}

// ------------------------------------------------------------------------
// Display ofn dialog, select file, display file...
// ------------------------------------------------------------------------
long far PASCAL MyLoad(HWND hWnd)
{
    char szShortName[20];

    InitDialog(hWnd,DIR_ANY);
    if(GetOpenFileName ((LPOPENFILENAME)&ofn))
    {

      if (FileExists(ofn.lpstrFile, NULL)) {
        if(SUCCESS == openbitmaps(ofn.lpstrFile)) {
          SetCursor(LoadCursor(NULL,IDC_WAIT));
          LoadPic(TRUE);
          SetCursor(LoadCursor(NULL,IDC_ARROW));
          FileExists(szDat, szShortName);
          sprintf(szDialogBuf, lpszTitleFile, szShortName);
          SetWindowText(hWnd, szDialogBuf);
          STARTED = TRUE;
        }
        else {
          InvalidateRect(hwndParent, NULL, TRUE);   // repaint everything
          UpdateWindow(hwndParent);                 // force WM_PAINT message
        }
      }
    }
    return 0L;
}


// ------------------------------------------------------------------------
// Display ofn dialog, select file, save to new or append to existing...
// only supporting "Old Printshop" .DAT and .NAM files for now.
// This is sufficient to provided support for users of our programs like
// METOO so they can make custom ENGLISH vocabularies...
// ------------------------------------------------------------------------
long far PASCAL MySave(HWND hWnd)
{
    char szSaveNam[MAXFILENAME],
         szSaveDat[MAXFILENAME];
    FILE *fp, *fp2;
    int iResult = IDNO, idx;
    int iStyle = MB_SUCCESS;
    char *mptr = (char *)&FileSuccess[0];

    if((iClipType != CLIPTYPE_SHP &&
        iClipType != CLIPTYPE_POG &&
        iClipType != CLIPTYPE_DAT) || (STARTED != TRUE)) {
                MessageBox(hWnd, lpSorrySave, lpszTitle, MB_FAILURE);
      return 0L;
    }

    InitDialog(hWnd,DIR_PRINTSHOP);
    if(GetOpenFileName ((LPOPENFILENAME)&ofn))
    {
      strcpy(szSaveNam, ofn.lpstrFile);

      // bypass files that need to be synchronized with
      // bilingual support files...
      if (TRUE == IsBilingual(szSaveNam)) {
        MessageBox(hWnd, lpSorryBilingual, lpszTitle, MB_FAILURE);
        return 0L;
      }

      for (idx = 0; szSaveNam[idx]!= ASCIIZ;)
        if (szSaveNam[idx] == '.')
          szSaveNam[idx] = ASCIIZ;
        else
          idx++;

      strcpy(szSaveDat, szSaveNam);
      strcat(szSaveDat, ".DAT");
      strcat(szSaveNam, ".NAM");

      // don't append to the current file...
      // no point in doing so anyway... since duplicates in file then

      if (strcmpi(szSaveNam, szNam)) {
         iResult = IDYES;
         if (FileExists(szSaveNam, NULL)) {
           iResult = MessageBox(hwndParent, "File Already Exists.\nAppend?",lpszTitle,
                             MB_ICONQUESTION|MB_YESNO);
         }
      }
      else
        MessageBox(hwndParent, "Cannot append to current file.",lpszTitle,
                                MB_OK|MB_ICONSTOP);
      if (iResult == IDYES) {
         // avoid the most common errors...
         // we need to write these files as a pair so we
         // must open both successfully before writing...

         // opening for appendmode assures that we create
         // the file if it does not exist and we add to it if it does...
         // I didn't want to support a full range of variations
         // on saving and deleting for this version... just keeping it simple.

         iResult = IDNO;
         fp  = fopen(szSaveDat, "ab");
         if (NULL != fp) {
           fp2 = fopen(szSaveNam, "ab");
           if (NULL != fp2) {
             // if we successfully opened both files
             // write the graphic first then the name...

             // to do - add a test for adequate disk space here
             if (572 == fwrite(fbuf,1, 572, fp))
               if (CAPTIONLENGTH ==
                   fwrite((char*)&mylist[oldcurrent].mycaption[0],1,
                          CAPTIONLENGTH, fp2))
                 iResult = IDYES;   // success
             fclose(fp2);
           }
           fclose(fp);
         }
         if (iResult != IDYES) {
           mptr = (char *)&FileFailure[0];
           iStyle = MB_FAILURE;
         }
         sprintf(szDialogBuf, mptr, szSaveDat);
         MessageBox(hwndParent, szDialogBuf,lpszTitle, iStyle);
      }
    }
    return 0L;
}


// ------------------------------------------------------------------------
// Creates a 16 x 8 font-mapped bitmap-chunk in memory on-the-fly
// from a string of text...
// makes the headers and the text captions for the .BMP export...
// ------------------------------------------------------------------------
void MakeCaptionLines(char *src, char *dest, int *i, unsigned bytesperline)
{
  int x, x1, j, k, c;

  x = i[0];
  x-= bytesperline; // leave a 2 raster buffer
  x-= bytesperline;
  j = strlen(src);
  for(k=0;k<16;k++)
  {
    for(x1=0;x1<j;x1++)
    {
      c=src[x1];
      if(c==13||c==10||c==0||c=='\x1a')break;
      dest[x1 + x] = lpRamFont[0].b[c][k];
    }
    x-= bytesperline;
  }
  i[0] = x;
}


// ------------------------------------------------------------------------
// Display ofn dialog, select bmp file or type new name, then export
// entire library...
// ------------------------------------------------------------------------
long far PASCAL MyExport(HWND hWnd)
{

    FILE *fp, *fp2, *fp3;
    char *lpFileBuf, *ptr;
    char szSaveNam[MAXFILENAME];
    int iResult, idx, j, k, x, x1, c;
    unsigned height, width, bytesperline, uiTotalBlocks;
    long pos;
    size_t BlockSize, BlockValue;
    int iStyle = MB_SUCCESS;
    char *mptr = (char *)&FileSuccess[0];


    if((iClipType != CLIPTYPE_SHP &&
        iClipType != CLIPTYPE_POG &&
        iClipType != CLIPTYPE_DAT) || (STARTED != TRUE)) {
                MessageBox(hWnd, lpSorrySave, lpszTitle,
                    MB_OK|MB_ICONSTOP);
      return 0L;
    }

    InitDialog(hWnd,DIR_BMP);
    if(GetOpenFileName ((LPOPENFILENAME)&ofn))
    {
      strcpy(szSaveNam, ofn.lpstrFile);
      for (idx = 0; szSaveNam[idx]!= ASCIIZ;)
        if (szSaveNam[idx] == '.')
          szSaveNam[idx] = ASCIIZ;
        else
          idx++;
      strcat(szSaveNam, ".BMP");
      iResult = IDYES;
      if (FileExists(szSaveNam, NULL)) {
        iResult = MessageBox(hwndParent, "File Already Exists.\nOverWrite?",lpszTitle,
                             MB_ICONQUESTION|MB_YESNO);
      }
      if (iResult == IDYES) {
        iResult = IDNO;
        lpFileBuf = malloc(EXPORTBLOCK);
        if (lpFileBuf != NULL) {
          memset(lpFileBuf, 255, EXPORTBLOCK);
          fp = fopen(szNam,"rb");
          if (NULL != fp) {
            fp2 = fopen(szDat, "rb");
            if (NULL != fp2) {
              fp3 = fopen(szSaveNam, "wb");
              if (NULL != fp3) {

                // 8 images across...
                // just like the appendices in
                // "The Official Printshop Handbook"

                uiTotalBlocks =  mytotal;
                while (uiTotalBlocks%EXPORTIMAGES)uiTotalBlocks++;
                uiTotalBlocks =  (uiTotalBlocks/EXPORTIMAGES);

                height = ((uiTotalBlocks + 1) * EXPORTHEIGHT);
                width  = EXRASTERWIDTH;
                bytesperline = EXRASTERBYTES;

                // 1. Set the values for the file header.
                ptr=(char *)&BitMapFileHeader.bfType;
                ptr[0] = 'B';                            // signature = BM
                ptr[1] = 'M';
                BitMapFileHeader.bfSize =  0L;           // File Size =
                BitMapFileHeader.bfSize += bytesperline; // 8 pixels per byte DW boundary
                BitMapFileHeader.bfSize *= height;       // X number of rasters
                BitMapFileHeader.bfSize +=  62L;         // + Header
                BitMapFileHeader.bfReserved1 = 0;        // set next 2 to 0
                BitMapFileHeader.bfReserved2 = 0;        // (typical default)
                BitMapFileHeader.bfOffBits=62L;          // standard monochrome header
                                                         // offset to bitmap data
                // 2. Set the values for the Info Header
                // most of these were set when this was allocated at
                // the start of the program...

                lpbmp[0].biWidth         = 0L;
                lpbmp[0].biHeight        = 0L;
                lpbmp[0].biWidth        += width;   // pixels
                lpbmp[0].biHeight       += height;  // rasters
                lpbmp[0].biSizeImage     = BitMapFileHeader.bfSize - 62;

                iResult = IDYES;

                // 3. Write the header
                // to do - check for adequate disk space.

                BlockSize = sizeof(BITMAPFILEHEADER);
                BlockValue=
                  fwrite((char *)&BitMapFileHeader.bfType,1,BlockSize,fp3);
                if (BlockValue != BlockSize) {
                  iResult = IDNO;
                }
                else  {
                  BlockSize  = (sizeof(BITMAPINFOHEADER)+8);
                  BlockValue =
                    fwrite(lpbmp, 1, BlockSize,fp3);
                }

                // 4. Create a blank file
                // we will fill this up later...
                if (BlockValue != BlockSize) {
                  iResult = IDNO;
                }
                else {
                  for (idx = 0; idx < (uiTotalBlocks+1); idx++) {
                    BlockValue = fwrite(lpFileBuf, 1, EXPORTBLOCK, fp3);
                    if (BlockValue != EXPORTBLOCK) {
                      iResult = IDNO;
                      break;
                    }
                  }
                }

                // for now assume that if we have created a blank file
                // then we are likely to be able to update the file

                if (iResult == IDYES) {
                  pos = 0L;
                  pos += uiTotalBlocks;
                  pos *= EXPORTBLOCK;
                  pos += 8L;
                  pos += sizeof(BITMAPFILEHEADER);
                  pos += sizeof(BITMAPINFOHEADER);

                  // write the Header Caption for the BMP file
                  fseek(fp3, pos, SEEK_SET);
                  memset(lpFileBuf, 0, EXPORTBLOCK);

                  // position x to the top of the block
                  x = EXPORTBLOCK - bytesperline;
                  x += EXPADDINGBYTES;

                  strcpy(szDialogBuf,
                        "Created by Ye Olde ClipShoppe(C) CopyLeft Bill Buckels"
                        " 1999. All Rights Reversed.");

                  MakeCaptionLines(szDialogBuf, lpFileBuf, &x, bytesperline);

                  // draw a line
                  x-= bytesperline; // leave a 2 raster buffer
                  x-= bytesperline;
                  j  = EXRASTERBYTES - (EXPADDINGBYTES * 2);

                  memset(&lpFileBuf[x], 0xff, j);
                  x-= bytesperline;
                  memset(&lpFileBuf[x], 0xff, j);

                  sprintf(szDialogBuf, "Created from Files %s", szDat);
                  MakeCaptionLines(szDialogBuf, lpFileBuf, &x, bytesperline);
                  sprintf(szDialogBuf, "               and %s", szNam);
                  MakeCaptionLines(szDialogBuf, lpFileBuf, &x, bytesperline);

                  // draw a line
                  memset(&lpFileBuf[x], 0xff, j);
                  x-= bytesperline;
                  memset(&lpFileBuf[x], 0xff, j);
                  x-= bytesperline;
                  memset(&lpFileBuf[x], 0xff, j);
                  x-= bytesperline;
                  memset(&lpFileBuf[x], 0xff, j);

                  fwrite(lpFileBuf, 1, EXPORTBLOCK, fp3); // write the header

                  // if it's a pog file we blow away the header
                  if (iClipType == CLIPTYPE_POG)
                    fread(szDialogBuf, 1, 10, fp2);

                  for (idx = 0; idx < uiTotalBlocks; idx++) {
                    pos-= EXPORTBLOCK;
                    fseek(fp3, pos, SEEK_SET);
                    memset(lpFileBuf, 0, EXPORTBLOCK);
                    for (j = 0; j < EXPORTIMAGES; j++) {

                      if (iClipType == CLIPTYPE_SHP) {
                        if (fread(szDialogBuf, 1, 4, fp2) < 4)
                          break;
                      }

                      if (fread(bmpbuf, 1, 572, fp2) < 572)
                        break;

                      if (iClipType == CLIPTYPE_SHP) {
                        if (fread(szDialogBuf, 1, 1, fp2) < 1)
                          break;
                      }

                      x = EXPORTBLOCK - bytesperline;
                      x += ((EXPORTWIDTH/8) * j);
                      x += EXPADDINGBYTES;
                      x-= bytesperline; // leave a 2 raster buffer
                      x-= bytesperline;

                      for (k = 0; k < 52; k++) {
                         memcpy(&lpFileBuf[x], &bmpbuf[k*11], 11);
                         x-= bytesperline;
                      }

                      szDialogBuf[0] = ASCIIZ;
                      fread(szDialogBuf, 1, CAPTIONLENGTH, fp);
                      szDialogBuf[CAPTIONLENGTH] = ASCIIZ;
                      MakeCaptionLines(szDialogBuf, lpFileBuf, &x, bytesperline);

                    }
                    fwrite(lpFileBuf, 1, EXPORTBLOCK, fp3);
                  }
                }
                fclose(fp3);
                if (iResult == IDNO)  // just remove the file if an error...
                  remove(szSaveNam);
              }
              fclose(fp2);
            }
            fclose(fp);
          }
          free(lpFileBuf);
        }
        if (iResult != IDYES) {
           mptr = (char *)&FileFailure[0];
           iStyle = MB_FAILURE;
        }
        sprintf(szDialogBuf, mptr, szSaveNam);
        MessageBox(hwndParent, szDialogBuf,lpszTitle, iStyle);
      }
    }
    return 0L;
}


// ------------------------------------------------------------------------
// Only allow image delete from Old Printshop DAT Files.
// Just resetting to beginning of file after delete... keep it simple.
// ------------------------------------------------------------------------
long far PASCAL MyDelete(HWND hWnd)
{
    FILE *fp, *fp2, *fp3, *fp4;
    int iResult, idx;
    char szSaveNam[MAXFILENAME],
         szSaveDat[MAXFILENAME],
         szShortName[20];
    long pos;

    if((iClipType != CLIPTYPE_DAT) || (STARTED != TRUE)) {
                MessageBox(hWnd, lpSorryDelete, lpszTitle,
                    MB_OK|MB_ICONSTOP);
      return 0L;
    }
    // bypass files that need to be synchronized with
    // bilingual support files...
    if (TRUE == IsBilingual(szDat)) {
                MessageBox(hWnd, lpSorryBilingual, lpszTitle,
                    MB_OK|MB_ICONSTOP);
            return 0L;
    }


    iResult = MessageBox(hwndParent, "The current picture will be "
                                     "permanently erased.\n"
                                     "Are you sure you want to delete it?",
                                     lpszTitle,MB_ICONQUESTION|MB_YESNO);

    if (IDYES == iResult) {
      if (mytotal == 1) {   // if we only have 1 image left
        closebitmaps();     // just remove the library...
        remove(szNam);
        remove(szDat);
        InvalidateRect(hwndParent, NULL, TRUE); // repaint everything
        UpdateWindow(hwndParent);              // force WM_PAINT message
      }
      else {

        strcpy(szSaveNam,szNam);
        strcpy(szSaveDat,szDat);
        idx = strlen(szNam) - 1;
        szSaveNam[idx] = szSaveDat[idx] = '$';  // temporary file names
        iResult = IDNO;

        close(dathandle);
        dathandle = -1;

        rename(szDat, szSaveDat);
        fp = fopen(szSaveDat, "rb");

        if (NULL != fp) {
          rename(szNam, szSaveNam);  // rename originals
          fp2 = fopen(szSaveNam, "rb");

          if (NULL != fp2) {
            fp3 =  fopen(szDat, "wb");
            if (NULL != fp3) {
              fp4 =  fopen(szNam, "wb");
              if (NULL != fp4) {

                // to do... check for disk space...

                iResult = IDYES;  // assume success if we got this far...

                // check for write errors.
                // assume that everything went ok if none...

                for (idx = 0; idx < mytotal; idx++) {
                   fread(fbuf,1, 572, fp);
                   fread(szDialogBuf, 1, CAPTIONLENGTH, fp2);
                   if (idx == oldcurrent)    // just skip the deleted record
                     continue;
                   if (572 != fwrite(fbuf,1, 572, fp3)) {
                     iResult = IDNO;
                     break;
                   }
                   if (CAPTIONLENGTH
                       != fwrite(szDialogBuf, 1, CAPTIONLENGTH, fp4)) {
                     iResult = IDNO;
                     break;
                   }
                }

                // close all files and remove the temporary work files...
                // unless there was an error (i.e. no diskspace).
                fclose(fp4);
                fclose(fp3);
                fclose(fp2);
                fclose(fp);
                if (iResult == IDNO) {
                  remove(szNam);
                  remove(szDat);
                  rename(szSaveNam, szNam);
                  rename(szSaveDat, szDat);
                }
                else {
                  remove(szSaveNam);
                  remove(szSaveDat);
                }
                closebitmaps();
                strcpy(szSaveDat, szDat);
                if(SUCCESS == openbitmaps(szSaveDat)) {
                   SetCursor(LoadCursor(NULL,IDC_WAIT));
                   LoadPic(TRUE);
                   SetCursor(LoadCursor(NULL,IDC_ARROW));
                   STARTED = TRUE;
                   FileExists(szDat, szShortName);
                   sprintf(szDialogBuf, lpszTitleFile, szShortName);
                   SetWindowText(hWnd, szDialogBuf);
                 }
                 else {
                   iResult = IDNO;
                   InvalidateRect(hwndParent, NULL, TRUE); // repaint everything
                   UpdateWindow(hwndParent);               // force WM_PAINT message
                 }
              }
              else {
                // if we couldn't open the output nam file
                // remove the new 0 length dat file
                // rename the original files back
                fclose(fp3);
                fclose(fp2);
                fclose(fp);
                remove(szDat);
                rename(szSaveNam, szNam);
                rename(szSaveDat, szDat);
              }
            }
            else {
              // if we couldn't open the output dat file
              // rename the original files back...
              fclose(fp2);
              rename(szSaveNam, szNam);
              fclose(fp);
              rename(szSaveDat, szDat);
            }
          }
          else {
            // if we couldn't open the nam file, put the dat file back
            fclose(fp);
            rename(szSaveDat, szDat);
          }
        }


        // if an error occurred, then try to pick-up where we left off!
        if (iResult != IDYES && STARTED == TRUE) {
          if ((dathandle = open(szDat,O_RDONLY|O_BINARY)) == -1) {
            closebitmaps();
          }
          else {
            pos = 572L * oldcurrent;
            lseek(dathandle, pos, SEEK_SET);
          }
          InvalidateRect(hwndParent, NULL, TRUE); // repaint everything
          UpdateWindow(hwndParent);               // force WM_PAINT message
        }
      }
      // if successful say so...
      if (iResult == IDYES) {
        MessageBox(hwndParent, "Picture Deleted",lpszTitle,
                               MB_OK|MB_ICONINFORMATION);
      }
      else {
        MessageBox(hwndParent, "Unable to delete picture.\n"
                               "An error has occurred!",lpszTitle,
                               MB_OK|MB_ICONSTOP);
      }
    }
    return 0L;
}



// ------------------------------------------------------------------------
// Generic Text Entry Dialog - A Simple InputBox that uses a global buffer
// the global buffer is called szDialogBuf...
// ------------------------------------------------------------------------
long far PASCAL MyEntry(HWND hWnd)
{
     FARPROC lpProc;                     // far pointer to callback
     long pos;                           // position in file
     FILE *fp;
     int idx;

     // I only change text if the clip names are in a seperate file...
     // I want to avoid unecessary complexity, and I added this
     // feature to provide basic support for changing the captions to use
     // as vocabulary in my programs that use the old printshop format.

     if((iClipType != CLIPTYPE_SHP &&
         iClipType != CLIPTYPE_POG &&
         iClipType != CLIPTYPE_DAT) || (STARTED != TRUE)) {
                MessageBox(hWnd, lpSorryEntry, lpszTitle,
                    MB_OK|MB_ICONSTOP);

            return 0L;
     }

     // bypass files that need to be synchronized with
     // bilingual support files...
     if (TRUE == IsBilingual(szDat)) {
                MessageBox(hWnd, lpSorryBilingual, lpszTitle,
                    MB_OK|MB_ICONSTOP);
            return 0L;
     }

     lpProc = MakeProcInstance(EntryDlgProc, hInst);
     if (TRUE == DialogBox(hInst, "TextEntryBox", hWnd, lpProc) &&
         szDialogBuf[0]!=ASCIIZ) {
        // clean memory
        szDialogBuf[CAPTIONLENGTH-1] = ASCIIZ;
        for (idx = 0; idx < CAPTIONLENGTH; idx++) {
          if (szDialogBuf[idx] != ASCIIZ)
            continue;
          while (idx < CAPTIONLENGTH) {
            szDialogBuf[idx] = ASCIIZ;
            idx++;
          }
          break;
        }
        memcpy((char*)&mylist[oldcurrent].mycaption[0],szDialogBuf,CAPTIONLENGTH);
        if (NULL != (fp = fopen(szNam, "rb+w"))) {
          pos = (long)(oldcurrent * CAPTIONLENGTH);
          fseek(fp, pos, SEEK_SET);
          fwrite(szDialogBuf, 1, CAPTIONLENGTH, fp);
          fclose(fp);
        }
     }
     InvalidateRect(hWnd, NULL, TRUE);   // repaint everything
     UpdateWindow(hWnd);                 // force WM_PAINT message
     FreeProcInstance(lpProc);
     return 0L;

}


// ------------------------------------------------------------------------
// EntryDlgProc - callback function for "Text Entry..." dialog
// ------------------------------------------------------------------------
BOOL FAR PASCAL EntryDlgProc(HWND hDlg, WORD wMsg, WORD wParam, LONG lParam)
{
    unsigned char c;
    int i, mx, my;

    switch (wMsg) 
    {
        case WM_INITDIALOG:                 // dialog box initialization
            return (TRUE);                  // signal message processed

        case WM_COMMAND:                    // command received
            if(wParam == IDOK)              // OK button clicked?
            {                               // yes, retrieve text
              szDialogBuf[0]=0x00;
              GetDlgItemText(hDlg, IDD_EDITTEXT, szDialogBuf, INPUTSIZE-1);
              EndDialog(hDlg, TRUE);        // signal text accepted
            }
            else if(wParam == IDD_CANCEL)   // Cancel button clicked?
            {
                                            // Input was cancelled
              EndDialog(hDlg, FALSE);       // signal text not accepted
            }
    }
    return(FALSE);                          // signal message not processed
}


// ------------------------------------------------------------------------
// Display info about this program
// ------------------------------------------------------------------------
long far PASCAL MyAbout(HWND hWnd)
{

  MessageBox(hWnd,
    "CLIPSHOP(C) is a simple \"Old PrintShop\" Graphics Utility Program "
    "that allows you to view \"Old PrintShop\" Clip Art (.DAT and .NAM Files) "
    "in Windows, and to Copy the current Clip to the Windows "
    "ClipBoard. You can then Paste the Clip into your favorite "
    "Windows Paint Program or Word Processor.\n\n"
    "CLIPSHOP(C) also reads \"New PrintShop\" Clip Art (.POG and .PNM Files), "
    "\"Old PrintMaster\" Clip Art (.SHP and .SDR Files), and "
    "\"Old PrintPartner\" Clip Art (Uncompressed .GPH Files).\n"
    "Read the CLIPSHOP(C) Help File for additional features.\n\n"
    "CLIPSHOP(C) is distributed as FreeWare with Open Source.\n"
    "You have a royalty-free right to use, modify, reproduce and "
    "distribute this program and its source code in any way you find useful, "
    "provided that you agree that Bill Buckels has no warranty obligations "
    "or liability resulting from said distribution in any way whatsoever.\n\n"
    "\t\tBill Buckels\n"
    "\t\t589 Oxford Street\n"
    "\t\tWinnipeg, Manitoba, Canada R3M 3J2\n\n"
    "Email: bbuckels@escape.ca\n"
    "WebSite: http://www.escape.ca/~bbuckels\n"
    "Home of Teacher's Choice Productions and \"The ClipShop Connection\".\n" ,
    lpszTitle,
    MB_OK|MB_ICONINFORMATION);

  return 0L;

}

// ------------------------------------------------------------------------
// FUNCTION ClearScreen
//
// clear the client area of the window to the clearcolor.
// ------------------------------------------------------------------------
int ClearScreen(HWND hWnd, HDC hdcTemp, COLORREF dwClearColor)
{
    HBRUSH hPrevBrush, hClearBrush;// brush to clear client area
    RECT rcClientArea;   // data structure of xy coordinates for rectangle
    HPEN hPrevPen, hClearPen;      // pen to clear area

    if(hdcTemp==NULL)return FAILURE;
    hClearBrush = CreateSolidBrush((COLORREF)dwClearColor);     // create brush
    hClearPen   = CreatePen(PS_SOLID,1,(COLORREF)dwClearColor); // create pen
    hPrevBrush = SelectObject(hdcTemp,hClearBrush); // select brush
    hPrevPen   = SelectObject(hdcTemp,hClearPen);   // select pen
    GetClientRect(hWnd,&rcClientArea);         // fetch bounding coordinates
    FillRect(hdcTemp,&rcClientArea,hClearBrush);    // filled rectangle
    SelectObject(hdcTemp,hPrevPen);                 // deselect pen
    SelectObject(hdcTemp,hPrevBrush);               // deselect brush
    DeleteObject(hClearBrush);                      // delete brush
    DeleteObject(hClearPen);                        // delete pen

return SUCCESS;                                // return to caller
}

// --------------------------------------------------------------------
// IsBilingual - if the file is bilingual, return true.
//
// For our programs, we do not allow a bilingual .DAT and .NAM file
// to be modified since this will wreak havoc when the user wants
// to use these in our programs like METOO and PANDAPIC...
// Perhaps in later revisions of clipshop we may provide bilingual
// editing support...
// but for this version, keep it simple and just bypass these.
// --------------------------------------------------------------------
BOOL FAR PASCAL IsBilingual(LPSTR lpszBaseName)
{
   int idx;

   if(lpszBaseName[0]==ASCIIZ)return FALSE;
   strcpy(szDialogBuf, lpszBaseName);
   strupr(szDialogBuf);

   // bypass the ones we know about today...
   if (NULL!= strstr(szDialogBuf, "PICLIST.") ||
       NULL!= strstr(szDialogBuf, "CHINESE."))
     return TRUE;

   // and bypass others that may exist in the future...
   // Note: this check will only work if the user
   // edits the .DAT and .NAM files in the same directory as
   // the bilingual support files... but hey.. we can't prevent
   // all disasters...

   for (idx = 0; szDialogBuf[idx] != ASCIIZ;) {
     if (szDialogBuf[idx] == '.')
       szDialogBuf[idx] = ASCIIZ;
     else
       idx++;
   }

   strcat(szDialogBuf, ".BIN");              // chinese
   if (FileExists(szDialogBuf, NULL))return TRUE;

   szDialogBuf[idx] = ASCIIZ;                // french articles
   strcat(szDialogBuf, ".ARF");
   if (FileExists(szDialogBuf, NULL))return TRUE;
   szDialogBuf[idx] = ASCIIZ;                // french nouns
   strcat(szDialogBuf, ".NOM");
   if (FileExists(szDialogBuf, NULL))return TRUE;
   szDialogBuf[idx] = ASCIIZ;                // french sentences
   strcat(szDialogBuf, ".TXF");
   if (FileExists(szDialogBuf, NULL))return TRUE;

   szDialogBuf[idx] = ASCIIZ;                // english sentences
   strcat(szDialogBuf, ".TXE");
   if (FileExists(szDialogBuf, NULL))return TRUE;

   return FALSE;
}

// ------------------------------------------------------------------------
// FUNCTION FileExists
//
// returns TRUE if the pathname is valid
// returns FALSE if not
// ------------------------------------------------------------------------
BOOL FAR PASCAL FileExists(LPSTR lpszFileName, LPSTR lpszShortName)
{
   struct find_t wild_card;

   if(lpszFileName[0]==ASCIIZ)return FALSE;
   if(_dos_findfirst(lpszFileName,_A_NORMAL,&wild_card)!=0)return FALSE;
   if (NULL != lpszShortName) {
     strcpy(lpszShortName, wild_card.name);
   }

return TRUE;
}


// ------------------------------------------------------------------------
// Displays the help file...
// ------------------------------------------------------------------------
long far PASCAL MyHelp(HWND hWnd)
{
    SetCursor(LoadCursor(NULL,IDC_WAIT));
    HELPACTIVE = WinHelp(hWnd,"CLIPSHOP.HLP",HELP_CONTENTS,0L);
    SetCursor(LoadCursor(NULL,IDC_ARROW));
    return 0L;
}


// strip extension from filename
int BaseName(char *ptr, char *szShortName)
{
  int idx, jdx = 0, kdx = 0;

  for (idx = 0; ptr[idx]!= ASCIIZ; idx++) {
        kdx++;
        if (ptr[idx] == '.')    // track the last known dot
          jdx = idx;
        // avoid directories with .EXTensions
        if (ptr[idx] == 92 || ptr[idx] == ':') {
          jdx = 0;
          kdx = idx + 1;
        }
  }

  if (jdx)
    ptr[jdx] = ASCIIZ;

  if (NULL != szShortName)
    strcpy(szShortName, (char *)&ptr[kdx]);

  return (kdx); // return offset of short file name in longname string
}
