/*===========================================================================
SOLAR v0.95.2 slrnews :: Module ..\slrnews\slrnews.c
Original Author: Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This software module has been placed in the public domain.
===========================================================================*/

/* Include Files */
#include <stdio.h>
#include <dir.h>
#include <string.h>
#include <values.h>
#include "..\common\version.h"
#include "codedate.h"
#include "..\common\yesno.h"
#include "slrnews.h"

int main(int argc, char *argv[])
{
	FILE              *newsrc = NULL;

	extern    char    *optarg;
	unsigned  char    x;
  const     char    *optionS = "u:U:vVnNFf";

	char              orig_path[MAXPATH];
	char              username[10];
	int               exit_code     = x_success;
	long              message_count = 0L;
	long              summary_count = 0L;
	long              temp_count    = 0L;
	int               do_update_newsrc = NO;

	/* Store original directory */

	getcwd(orig_path, MAXPATH);

	/* Set default values for globals */

	strcpy(temp_path,      "NONE");
	strcpy(user_path,      "NONE");
	strcpy(config_path,    "NONE");
	strcpy(log_path,       "NONE");
	strcpy(newsgroups_path,"NONE");
	strcpy(username,       "NONE");

	news_area_bytes     = MAXLONG;
	news_area_messages  = MAXLONG;
	news_total_bytes    = MAXLONG;
	news_total_messages = MAXLONG;

  news_type           = u;        /* Default to USENET format  */
  news_index          = c;        /* Default to full C News    */
  use_fossil          = NO;       /* Default to no FOSSIL      */
  kill_summary        = YES;      /* Default to kill summaries */
  verbose             = NO;       /* Default to no verbose     */
  port                = 99;       /* Default for no port       */

	/* Parse command line */

	while ((x = getopt(argc, argv, optionS)) != '\xFF')
	{
		switch (toupper(x)) {
			case '?'  : exit_code = x_usage;
									goto ExitMain;
			case 'U'  : if ((strcmp(username,"NONE")) == 0)
									{
										strcpy(username,optarg);
										break;
									}
									else
									{
										exit_code = x_usage;
										goto ExitMain;
									}
			case 'V'  : verbose = YES;
									break;
			case 'N'  : do_update_newsrc = YES;
									break;
			case 'F'  : use_fossil = YES;
									break;
    }
  }

  /* Check to see if username was set. If
     not, try to set from PCBDOOR.SYS or
     DOORS.SYS file. */

  if (strcmp(username,"NONE") == 0)
  {
    if (read_doors() != 0)
    {
      exit_code = x_usage;
			goto ExitMain;
    }
  }

  if (verbose == YES)
  {
    RPrintf("\nSOLAR v%s <> slrnews (%s)\n\n",VERSION,CODE_DATE);
    RPrintf("Processing news for user: %s\n",username);
  }

  /* Load configuration files. */

  if ((load_static(username) != 0)    || \
      (load_config() != 0)            || \
      (user_defaults() != 0)          || \
      (set_directory(temp_path) != 0))
  {
    exit_code = x_fatal;
    goto ExitMain;
  }

  if (verbose == YES)
    RPrintf("Default directory set to %s\n",temp_path);

  /* Zero total byte counter */

  totbyte_count = 0L;

  /* Remove any temporary newsrc files */

  kill_newsrc(NEWSRC_TMP);

  /* Open newsrc file for reading. If not found,
     that's generally OK, but don't do anything else. */

  if ((newsrc = open_newsrc(NEWSRC,"rt")) == NULL)
  {
    sprintf(_slrerr,"main(): No %s file found for user %s",NEWSRC,username);
    exit_code = x_fatal;
    goto ExitMain;
  }

  /* Load forum file paths */

  if (verbose == YES)
    RPrintf("Loading paths to forum files...\n");
  if (load_forums() != 0)
  {
    exit_code = x_fatal;
    goto ExitMain;
  }

  /* Process each record in newsrc until
     end of file is reached */

  while (read_newsrc(newsrc) == 0)
  {
    /* Check to see if group should be processed */

    if (keyword != 'n')
    {

      /* Try to set default directory to group's newsspool path. */

      switch(set_default_path()) {

        /* An unexpected error occurred setting path. Bad Thing(tm) */

        case -2 : exit_code = x_fatal;
                  goto ExitMain;

        /* Group not in forum file(s). Do not rewrite to newsrc file. */

        case -1 : RPrintf("Newsgroup: %s - Group not found... removing.\n",area_name);
                  break;

        /* Group path set OK. Process the group. */

        case 0  : RPrintf("Newsgroup: %s",area_name);

                  /* Pack the messages into SOUP files. */

                  if ((temp_count = pack_group()) < 0L)
                  {
                    exit_code = x_fatal;
                    goto ExitMain;
                  }

                  /* Summarize what we just did. */

                  switch (keyword) {
                    case 'a'  : message_count += temp_count; break;
                    case 's'  : summary_count += temp_count; break;
                  }

                  /* Update the newsrc file. */

                  if (write_newsrc(NEWSRC_TMP,"at") != 0)
                  {
                    exit_code = x_fatal;
                    goto ExitMain;
                  }
                  break;

        /* Group's directory not found. Report group not active and skip. */

        case 1  : RPrintf("Newsgroup: %s - Group not active... skipping.\n",area_name);

                  /* Rewrite the newsrc file. */

                  if (write_newsrc(NEWSRC_TMP,"at") != 0)
                  {
                    exit_code = x_fatal;
                    goto ExitMain;
                  }
                  break;

        /* Access denied to group for some reason. Report the error
           and do not rewrite to newsrc file. */

        case 2  : RPrintf("Newsgroup: %s - %s.\n",area_name,_slrerr);
                  break;
      }
    }
    else
    {
      if (write_newsrc(NEWSRC_TMP,"at") != 0)
      {
        exit_code = x_fatal;
        goto ExitMain;
      }
    }

    /* Check message count against global message limit */

    if (message_count > news_total_messages)
    {
      RPrintf("Exceeded maximum of %lu messages\n",news_total_messages);
      while ((read_newsrc(newsrc)) != 1)
        write_newsrc(NEWSRC_TMP,"at");
      break;
    }

    /* Check byte count against global byte limit */

    if (totbyte_count > news_total_bytes)
    {
      RPrintf("Exceeded maximum of %lu bytes\n",news_total_bytes);
      while (read_newsrc(newsrc) != 1)
        write_newsrc(NEWSRC_TMP,"at");
      break;
    }
  }

  /* Close newsrc file */

  fclose(newsrc);

ExitMain:
  if (forum) remove_list();
  set_directory(orig_path);
  switch (exit_code) {
    case x_success  : RPrintf("\nBatched %lu messages\n",message_count);
                      RPrintf("Summarized %lu messages\n",summary_count);
                      sprintf(logbuf,"%s %lu batched %lu summarized %lu bytes",username,message_count,summary_count,totbyte_count);
                      logit("slrnews");
                      if ((message_count > 0L) || (summary_count > 0L))
                      {
                        if (do_update_newsrc == YES) update_newsrc();
                      }
                      break;
    case x_usage    : usage();
                      break;
    case x_fatal    : if (newsrc) fclose(newsrc);
                      fprintf(stderr,"\n%s\n",_slrerr);
                      sprintf(logbuf,"%s",_slrerr);
                      logit("slrnews");
                      break;
  }
  return exit_code;
}

/*
 * Function: void usage()
 * Purpose : Display command line usage
 * Return  : N/A
*/

void usage()
{
  RPrintf("\nSOLAR v%s <> slrnews (%s)\n",VERSION,CODE_DATE);
  RPrintf("\nUsage: slrnews -u username [-v] [-n] [-f]\n");
  return;
}
