/*===========================================================================
SOLAR v0.95.1 :: Common module viewfile.c
Original Author : Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This source code has been placed into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
         KJH  Created.
01/02/95 KJS  Changed fprintf() to RPrintf() for FOSSIL support.
              Changed getc() to Fossil_Getc()
30/10/95 KJS  Added check for carrier drop after call to Rgetc().
===========================================================================*/

#include <stdio.h>
#include <dir.h>
#include "..\common\yesno.h"
#include "..\common\fossil.h"

extern int port;
extern int verbose;
/*
Function: int view_file(char filepath[MAXPATH])
Purpose : Display a text file.
Return  : 0 on success, non-zero on error.
*/

int view_file(char filepath[MAXPATH])
{
  FILE *viewfile = NULL;
  char buffer[80];
  int  lines = 0;

  if (verbose == YES)
     RPrintf("Viewing file: %s\n",filepath);
  if ((viewfile = fopen(filepath,"rt")) == NULL)
	{
    goto ErrorExit;
	}
	while ((fgets(buffer,80,viewfile)) != NULL)
	{
    RPrintf("%s",buffer);
		lines++;
		if (lines > 23)
		{
      RPrintf("[Any key for more, Q to quit]");
      lines = Rgetc(port);
      if (lines == -1) {
         fclose(viewfile);
         goto ErrorExit;
      }
      RPrintf("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");
      RPrintf("                             ");
      RPrintf("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");
			if ((lines == 81) || (lines == 113)) break;
      lines = 0;
		}
	}
  fclose(viewfile);
GoodExit:
  return 0;
ErrorExit:
  return 1;
}
