/*===========================================================================
SOLAR :: ..\common\diskfree.c

Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>
This software module has been placed into the public domain.
===========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <dos.h>

extern char _slrerr[80];
extern long disk_minimum;

extern int set_directory(char *path);

int diskfree(char *chkpath)
{
  struct dfree free;
  long avail;
  int drive;
  char orig_path[MAXPATH];

  getcwd(orig_path, MAXPATH);
  if (set_directory(chkpath) != 0) goto ErrorExit;

  drive = getdisk();
  getdfree(drive+1, &free);
  if (free.df_sclus == 0xFFFF)
  {
    sprintf(_slrerr,"diskfree(): Error in getdfree() call.");
    exit(1);
  }

  avail =  (long) free.df_avail *
           (long) free.df_bsec *
           (long) free.df_sclus;
  if (avail < disk_minimum)
  {
    sprintf(_slrerr,"diskfree(): Insufficient disk space = %ld, need at least %ld bytes.", avail, disk_minimum);
    goto ErrorExit;
  }

GoodExit:
  if (set_directory(orig_path) != 0) goto ErrorExit;
  return 0;
ErrorExit:
  return 1;
}
