# Sample Aliasfile for UUPtoccM v1.1 (UUPlus to ccMail)
#
# The aliasfile (UUPTOCCM.ALS) is the file where internet addresses are
# assigned to cc:Mail addresses. It also contains the full name for users and
# the setting that determines how much of the internet message header of
# incoming messages is displayed in cc:Mail to the recipient.
#
# Lines starting with # or ; and empty lines are ignored
#
# The alias entries have the following syntax (one line per entry,
# here split up for simplicity):
#
#       internetHandle
#       :*:
#       ccMailHandle
#       :**:
#       Full Name
#       :***:
#       HeaderFlag
#
# The HeaderFlag can be
#
#   F   for Full Header. The whole header from incoming internet e-mail
#       messages is displayed to the cc:Mail user.
#
#   B   for Basic Header. Only the following fields (if existant) are being
#       displayed to the cc:Mail user:
#
#         From:
#         To:
#         cc:
#         Subject:
#
#   N   for No Header. No header info will be displayed to the cc:Mail user.
#
# Messages that are routed to the System Administrator because of some errors
# are always imported with full header information.
#
# The following line in the Aliasfile would mean:
#
#       HBrwon:*:Henry:**:Henry Brown:***:N
#
#       the user has an internet address of           HBrown@your.domain
#       the user has a ccMail address of              Henry
#       the users name is                             Henry Brown
#       the user will see no internet headers in cc:Mail
#
#
# The ccMailHandle can also be a public Mailing List or a a public Bulletin
# Board. In this case the ccMailHandle would start with a #, just like
# bulletin boards or mailing lists do start.
#
# In case any name (either ccMailHandle or internetHandle) is referenced more
# than once the following rules apply:
#
#  - for outgoing mail, the internetHandle of the first matching ccMailHandle
#    will be used
#
#  - for incoming mail, the ccMailHandle of the first matching internetHandle
#    will be used
#
#  For example:
#
#  Ron:*:Ronald.Foo:**:Ronald Foo:***:N
#  Ron:*:Ron.Foo:**:Ronald Foo:***:N
#  Admin:*:Ronald.Foo:**:Ronald Foo:***:N
#
#  ccMail to Internet from Ronald.Foo would be addressed as
#       From: Ron@your.domain
#  (first line)
#
#  ccMail to Internet from Ron.Foo would also be addressed as
#       From: Ron@your.domain
#  (second line)
#
#  internet mail to Ron@your.domain would be put in the ccMail account
#       Ronald.Foo
#  (first line)
#
#  internet mail to Admin@your.domain would also be put in the ccMail account
#       Ronald.Foo
#  (third line)

# users at MAINBLDG

HBrwon:*:Henry:**:Henry Brown:***:N
DWhite:*:Daniel:**:Daniel White:***:N
Ron:*:Ronald.Foo:**:Ronald Foo:***:F

# Mailing Lists

Sales:*:#Sales:**::***:B
Tech:*:#Support:**::***:B
Support:*:#Support:**::***:B

# Bulletin Boards

TechSupp:*:#Tech BB:**::***:B

# users at remote postoffices

GAnders:*:Gloria at FINANCE:**:Gloria Anderson:***:N
PWhite:*:Petra at NY:**:Petra White:***:N

# default accounts (expected to exist on internet)

admin:*:Ronald.Foo:**:Postmaster:***:F
postmaster:*:Ronald.Foo:**:Postmaster:***:F
root:*:Ronald.Foo:**:Root:***:F
postmistress:*:Ronald.Foo:**:Postmaster:***:F
postmonster:*:Ronald.Foo:**:Postmaster:***:F

# mail manager

Ron:*:Mailmanager:**:Ronald Foo:***:F
