@if "%debug%"=="" echo off
rem -------------------------------------------------------------
rem  %sndrive%\usr\lib\snuupm\adduser.bat user-id Name of Person
rem
rem  Adds a new user to the SNUUPM system.
rem  Author: Mike Lawrie (mlawrie@apies.frd.ac.za)
rem  Uses ASKENV.EXE from Timo Salmi's tsbat40.zip (ts@uwasa.fi)
rem -------------------------------------------------------------

set snuupmuser=%1
if not "%SNUUPMUSER%"=="" goto getname
goto usage

:getname
set snuupmname=%2
if not "%3"=="" set snuupmname=%snuupmname% %3
if not "%4"=="" set snuupmname=%snuupmname% %4
if not "%5"=="" set snuupmname=%snuupmname% %5
if not "%6"=="" set snuupmname=%snuupmname% %6
if not "%7"=="" set snuupmname=%snuupmname% %7
if not "%8"=="" set snuupmname=%snuupmname% %8
if not "%9"=="" set snuupmname=%snuupmname% %9
if not "%SNUUPMNAME%"=="" goto tolower
goto usage

:tolower
echo %SNUUPMUSER%|askenv /b /l
set snuupmuser=%askenv%
set askenv=

:checkdir
if not exist %sndrive%\usr\%SNUUPMUSER%\nul goto confirm
echo The user-id "%SNUUPMUSER%" appears to be in use already.
echo.
echo You will have to de-register that user, or use another user-id
echo for the user that you are trying to register.
goto ends

:confirm
echo ----------------------------------------------------
echo You are about to create USER-ID "%SNUUPMUSER%"
echo              for someone called "%SNUUPMNAME%"
echo ----------------------------------------------------
%sndrive%\usr\lib\snuupm\askenv Is this correct? (y/n) /l
if "%ASKENV%"=="y" goto makedirs
if "%ASKENV%"=="n" goto ends
goto confirm

:makedirs
echo ----------------------------------------------------
if not exist %sndrive%\usr\%SNUUPMUSER%\nul md %sndrive%\usr\%SNUUPMUSER%
if not exist %sndrive%\usr\%SNUUPMUSER%\mail\nul md %sndrive%\usr\%SNUUPMUSER%\mail
if not exist %sndrive%\usr\%SNUUPMUSER%\mbox\nul md %sndrive%\usr\%SNUUPMUSER%\mbox

:passwd
copy %sndrive%\etc\uupc\passwd %sndrive%\etc\uupc\passwd.bak
echo %SNUUPMUSER%:*:::%SNUUPMNAME%:%sndrive%\usr\%SNUUPMUSER%>>%sndrive%\etc\uupc\passwd

:aliases
echo nickname username@host.domain > %SNUUPMFILE% %sndrive%\usr\%SNUUPMUSER%\aliases.txt

:userrc
set snuupmfile=%sndrive%\usr\%SNUUPMUSER%\%SNUUPMUSER%.rc
echo Name=%SNUUPMNAME%>  %SNUUPMFILE%
echo Mailbox=%SNUUPMUSER%>> %SNUUPMFILE%
echo Home=%sndrive%\usr\%SNUUPMUSER%>> %SNUUPMFILE%
echo Aliases=%sndrive%\usr\%SNUUPMUSER%\aliases.txt>> %SNUUPMFILE%
echo Editor=%editor% %%s>> %SNUUPMFILE%
echo Signature=%sndrive%\usr\%SNUUPMUSER%\mbox\inetsig.pms>> %SNUUPMFILE%

:snewsrc
set snuupmfile=%sndrive%\usr\%SNUUPMUSER%\snews.rc
echo Name=%SNUUPMNAME%>  %SNUUPMFILE%
echo Mailbox=%SNUUPMUSER%>> %SNUUPMFILE%
echo Home=%sndrive%\usr\%SNUUPMUSER%\>> %SNUUPMFILE%
echo Aliases=%sndrive%\usr\%SNUUPMUSER%\aliases.txt>> %SNUUPMFILE%
echo Editor=%editor% %%s>> %SNUUPMFILE%
echo Signature=mbox\inetsig.pms>> %SNUUPMFILE%
echo colorhelpf whi+>> %SNUUPMFILE%
echo colortextf whi+>> %SNUUPMFILE%
echo colorheadb blu>> %SNUUPMFILE%
echo colorheadf whi>> %SNUUPMFILE%
echo colormsgb blu>> %SNUUPMFILE%
echo colormsgf whi>> %SNUUPMFILE%
echo Extract=~\extract.nws>> %SNUUPMFILE%

:signatures
set snuupmfile= %sndrive%\usr\%SNUUPMUSER%\mbox\inetsig.pms
copy %sndrive%\usr\lib\snuupm\utl\blanklin  %SNUUPMFILE%
echo -->> %SNUUPMFILE%
echo %SNUUPMNAME%>> %SNUUPMFILE%
copy %SNUUPMFILE% %sndrive%\usr\%SNUUPMUSER%\mbox\localsig.pms
goto ends

:usage
echo.
echo Usage: adduser user-id Proper Name of the User
echo.
echo This program is designed to run from the SNUUPM Main Menu.

:ends
set snuupmuser=
set snuupmname=
set snuupmfile=
set askenv=
pause
rem -------------------------------------------------------------
rem  $Id: adduser.bat 1.1 1995/04/30 19:26:23 mlawrie Exp $
rem
rem  $Log: adduser.bat $
rem  Revision 1.1  1995/04/30 19:26:23  mlawrie
rem  Initial revision
rem
rem ----ends-----------------------------------------------------
