UNIQ(1)                  USER COMMANDS                    UNIQ(1)

NAME
  uniq - remove or report adjacent duplicate lines

AUTHOR
  Jason Mathews
  NASA/Goddard Space Flight Center
  Code 633.2
  Greenbelt, Maryland  20771
  <mathews@nssdca.gsfc.nasa.gov>

COPYRIGHT
  Copyright (C) 1992-95 by Jason Mathews.  Permission is granted to any
  individual or institution to use, copy or modify this software so
  long as it is not sold for profit, provided this copyright notice
  is retained.

SYNOPSIS
  uniq  [-c | -d | -u] [ +|-n ] [ inputfile [ outputfile ] ]

DESCRIPTION
  The uniq command reads standard input by default, or input_file, compares
  adjacent lines, removes the second and succeeding occurrences of a line,
  and writes to standard output or the specified file output_file.
  Repeated lines must be on consecutive lines to be found.  You can arrange
  them with the sort command before processing.

OPTIONS
  -c   Supersede -u and -d and generate an output report in
       default style but with each line preceded by a count of
       the number of times it occurred.

  The normal output of uniq is the union of the  -u  and  -d
  options.

  -d   Write one copy of just the repeated lines.

  -u   Copy only those lines which are not repeated in the
       original file.

  The n arguments specify skipping an initial portion of each
  line in the comparison:

  -n      The first n fields together with any blanks before
	  each are ignored.  A field is defined as a string of
          non-SPACE, non-TAB characters separated by SPACE and
          TAB characters from its neighbors.

  +n      The first n characters are ignored.  Fields are
	  skipped before characters.

EXAMPLES

  To delete repeated lines in the following file called fruit and save it to
  a file named newfruit, enter:

	uniq fruit newfruit

	     or

	uniq < fruit > newfruit

  The file fruit contains the following lines:

       apples
       apples
       bananas
       cherries
       cherries
       peaches
       pears

  The file newfruit created will contain the following lines:

       apples
       bananas
       cherries
       peaches
       pears

  To show repeated lines in an unsorted file called `input.txt', enter:

	sort input.txt | uniq -d


MS-DOS Release 1.2   Last change: 14 Jan 1995
