/* Special More */

#ifndef __COMPACT__
#error Use COMPACT memory model
#endif

#include <stdio.h>
#include <io.h>
#include <stdlib.h>
#include <alloc.h>
#include <assert.h>
#include <conio.h>
#include <string.h>
#include <process.h>
#include <dir.h>

#define MAXLINES    32000
#define MAXLEN      2048

#define CASE_SEN    1
#define NORMAL      2
#define REPEAT      3
#define REVERSE     4

#define GET		0
#define SET		1

#define WRITE_FILE	0
#define WRITE_BLOCK	1

#define highlight() { textcolor(col[2]);textbackground(col[5]); }
#define inverse()   { textcolor(col[1]);textbackground(col[4]); }
#define normal()    { textcolor(col[0]);textbackground(col[3]); }
#define flashing()  { textcolor(col[2] + BLINK);textbackground(col[5]); }

#define rest_keys() gotoxy(1,25);inverse();cprintf(keys);clreol();normal()
#define rest_message() gotoxy(1,1);inverse();cprintf(message);clreol();normal()

#define open_con_w() freopen("con","wt",stdout); setbuf(stdout, NULL)

#define ESC         27
#define UPARROW     72+256
#define DOWNARROW   80+256
#define LEFTARROW   75+256
#define RIGHTARROW  77+256
#define HOME        71+256
#define END         79+256
#define PGUP        73+256
#define PGDN        81+256
#define CTRLPGUP    132+256
#define CTRLPGDN    118+256
#define CTRLRIGHT	115+256
#define F1          59+256
#define F7          65+256
#define F8          66+256
#define F9          67+256
#define F10         68+256

void read_file(void);
void display(void);
void putseg(int loc, int line, int start);
void disp_page(int column, int line);
void open_kbd(void);
void open_file(void);
int  open_prn(void);
int  getscan(void);
char *_cgets(char *s);
char getline(char *s);
void strseg(char *dest, char *src, int start, int len);
int  find(int type, int line);
void help(int line, int column);
void print(int line, int column);
void print_all(void);

void colors(int column, int line);
void printer(int column, int line);
void editor(int column, int line);
void read_setup(void);
void write_setup(void);

int  bookmark(int cmd, int line);
int  goto_line(int line);

void read_name(void);

void write_file(int func);
void edit(void);

int  tot_lines;
char filename[129];
char prg_path[129];
char message_str[66];
char file_r;
int  block_begin = -32767;
int  block_end = -32767;

struct str_struct *ptrs[(MAXLINES/32)+1];

int col[6] = { LIGHTGRAY, BLACK, WHITE, BLACK, LIGHTGRAY, BLACK };

#define NOSTOR "%s: insufficent memory for file"
#define FNDERR "%s: structure managament error"

int cr = 0;

#define chkptr(x) if( x == NULL ) { clrscr(); printf(NOSTOR,name); exit(2); }
#define chkfail() if( find_fail ) { clrscr(); printf(FNDERR,name); exit(2); }
#define str_size sizeof(struct str_struct)

struct str_struct {
	int rec_num;
	long pos;
	char *str[32];
};

char *ptr(int line);
void setptr(int line, char *s);

int bookmarks[10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 };

char port[68] = "prn";
char edit_cmd[68] = "edit @";

char prg_name[128];
char name[9];

char *keys = "Keys: cursor, Find Case Next Back, Print All, block: +-*, Get Set, Line F1=Help";
char *message = "Enhanced More by Daniel Sachs. Copyright 1990 by Daniel Sachs.";
char *date = __DATE__;

void main(int argc, char *argv[])
{
     argc--;

	open_con_w();

	strcpy(prg_name,argv[0]);
	read_name();

     if (argv[0] == NULL)
     {
		printf("%s: DOS 3.0 or greater required",name);
          exit(2);
     }

     if (argc > 1)
     {
		printf("%s: too many arguments. syntax: %s <filename>\n\r",name,name);
		printf("%s: if no file is specified, reads standard input",name);
          exit(2);
     }

     if (argc == 1)
     {
          file_r = 1;
          strcpy(filename,argv[1]);
          open_file();
               if (strlen(filename) < 65)
               {
                    strcpy(message_str,filename);
                    message = strupr(message_str);
			}
			else
			{
				int i,j;

				strcpy(message_str,"\x11\xc4\xc4");

				j = strlen(filename)-56;

				for(i=0;i<60;i++)
					message_str[i+3]=*(filename+j+i);

				message_str[i] = 0;

				message = strupr(message_str);
			}
     }
     else
		file_r = 0;

     directvideo = 1;

     read_setup();

     normal();
     clrscr();

     highlight();
     gotoxy(1,24);

     if (!file_r)
          cputs("Reading standard input, please wait...");
     else
          cputs("Reading file, please wait...");

     gotoxy(23,5);
	cputs("E N H A N C E D   M O R E   v1.3\n\n\n\r");
     normal();
     cputs("written 6/90 by Daniel Sachs, copyright 1990 by Daniel Sachs\n\r");
     cputs("written in Turbo C. Portions copyright 1988 by Borland, Inc.");
     cprintf("\r\n\nCompiled on %s.",date);
     read_file();
     display();
     window(1,1,80,25);
     gotoxy(1,25);
     clreol();
     exit(0);
}

void read_name(void)
{
	char fdrive[3];
	char fdir[65];
	char fext[5];

	fnsplit(prg_name,fdrive,fdir,name,fext);
	strlwr(name);
}

void read_file(void)
{
	char s[MAXLEN],eof,*tmp;
	int i,j;

     gotoxy(1,20);

     for (i=0;;i++)
     {
          if (i == MAXLINES)
          {
               clrscr();
			printf("%s: file is too long",name);
               exit(2);
          }
		eof = getline(s);

		tmp = malloc(strlen(s)+1);

		if (tmp == NULL)
          {
               clrscr();
			printf("%s: insufficient memory for file",name);
               exit(2);
		}

		strcpy(tmp,s);

		setptr(i,tmp);

          if ((i % 40) == 0)
          {
               gotoxy(50,24);
			cprintf("Line %5i. %3iK Free.",i,(int)(coreleft()/1024));
               gotoxy(1,20);
          }

		if (eof)
		{
			for(j=0;j<strlen(s);j++)
				if(s[j] != 32)
				{
					i++;
					break;
				}
			break;
		}
     }

     tot_lines = i-1;

     for (;i < tot_lines+24;i++)
		setptr(i,"");
}

void read_setup(void)
{
     FILE *setup;

     char fdrive[3];
     char fdir[65];
     char fnam[9];
     char fext[5];

     char name[127];

     fnsplit(prg_name, fdrive, fdir, fnam, fext);
     strcpy(fext,".CFG");
     fnmerge(name, fdrive, fdir, fnam, fext);

     setup = fopen(name,"rt");

     if (setup != NULL)
     {
          fread(edit_cmd, 1, 68, setup);
          fread(port, 1, 68, setup);
          fread(col, 2, 6, setup);
          fclose(setup);
     }
}

void write_setup(void)
{
     FILE *setup;

     char fdrive[3];
     char fdir[66];
     char fnam[10];
     char fext[5];

     char path[127];

     fnsplit(prg_name, fdrive, fdir, fnam, fext);
     strcpy(fext,".CFG");
     fnmerge(path, fdrive, fdir, fnam, fext);

     setup = fopen(path,"wb");

     if (setup != NULL)
     {
          fwrite(edit_cmd, 1, 68, setup);
          fwrite(port, 1, 68, setup);
          fwrite(col, 2, 6, setup);
          fclose(setup);
     }
     else
          putchar(7);
}

void open_kbd(void)
{
     freopen("con","rt",stdin);
     assert(stdin != NULL);
}

void open_file(void)
{
     FILE *filetest;

     filetest=freopen(filename,"rt",stdin);
     if (filetest == NULL)
     {
		printf("%s: unable to open file",name);
          exit(4);
     }
}

int open_prn(void)
{
     FILE *filetest;

     filetest=freopen(port,"wt",stdprn);

     return(filetest != NULL);
}

char getline(char *s)
{
     int i,j,x,eof,col;
     char t[MAXLEN];
     static char message = 0;

     for(i=0;;i++)
     {
          x = getchar();
          eof = x == EOF;
          if (((x != EOF) && (x != '\n')) && (i < MAXLEN-1))
               t[i]=(char)x;
          else
               break;
     }
     t[i]=0;

     if ((i>=MAXLEN-1) && !message)
     {
          gotoxy(1,23);
		cprintf("%s: lines too long, split...",name);
          message=1;
          gotoxy(1,20);
     }

     x = 0;
     col = 1;

     for (i=0;i<strlen(t);i++)
     {
          if (t[i]!='\t')
          {
               s[x++]=t[i];
               col++;
          }
          else
               for(j=0;j<((col%8)+8*((col%8)==0));j++)
               {
                    s[x++]=32;
                    col++;
               }
          if (MAXLEN-x < 8)
               {
                    strcpy(s,t);
                    x=MAXLEN-1;
                    break;
               }
          }

     s[x]=0;

     return (eof);
}

void strseg(char *dest, char *src, int start, int len)
{
     int i,j;

     j=0;

     for (i=start;i<len+start;i++)
     {
          dest[j++]=src[i];
          if (src[i]==0)
               break;
     }

     dest[j]=0;
}

void putseg(int loc, int line, int start)
{
     char x[MAXLEN];

     if (((loc >= block_begin) && (loc <= block_end))
     && ((block_begin >= 0) && (block_end >= 0)))
          highlight();

	if (start >= strlen(ptr(loc)))
     {
          gotoxy(1,line);
          clreol();
     }
     else
     {
		strseg(x,ptr(loc),start,80);
          gotoxy(1,line);
          cputs(x);
          if (wherey() == line)
               clreol();
     }
     normal();
}

void disp_page(int column, int line)
{
     int i,y;

     i=line;

     for (y=2; y<25; y++)
          putseg(i++,y,column);
}

int getscan(void)
{
     int a;

     a = getch();
     if (a == 0)
          a = getch() + 256;

     return (a);
}

void display(void)
{
     int line, column, key, old_line, old_col;
     char exit;

     line = column = 0;

     open_kbd();

     rest_message();

     rest_keys();

     exit = 1;

     disp_page(column,line);

     do
     {
          gotoxy(65,1);
          inverse();
		cprintf("%5i, %4i",line+1,column+1);
          normal();
          gotoxy(80,25);

          key = getscan();

          old_line = line;
		old_col  = column;

          switch (key)
          {
               case ESC: exit = 0; break;

               case UPARROW:       line = line >= 1 ? line - 1 : 0; break;
               case DOWNARROW:     line = line < tot_lines ? line + 1 : line; break;
               case LEFTARROW:     column = (column >= 19) ? column - 20 : column; break;
			case RIGHTARROW:    column = (column+20 < MAXLEN) ? column + 20 : column; break;

			case CTRLRIGHT:	column = 0; break;

               case CTRLPGUP:      line = line >= 12 ? line - 12 : 0; break;
               case CTRLPGDN:      line = line < tot_lines-12 ? line + 12 : tot_lines; break;

               case HOME:line = 0; break;
			case END: line = tot_lines; break;

               case PGUP:line = line >= 22 ? line - 22 : 0; break;
               case PGDN:line = line < tot_lines-22 ? line + 22 : tot_lines; break;

               case F1:  help(column,line); break;
               case F7:  colors(column,line); break;
               case F8:  printer(column,line); break;
               case F9:  editor(column,line); break;
               case F10: write_setup();

               case '+': block_begin = line; disp_page(column,line); break;
               case '-': block_end = line; disp_page(column,line); break;
               case '*': block_begin = -32767; block_end = -32767; disp_page(column, line); break;

			case 'l':
			case 'L': line = goto_line(line); break;

			case 'g':
			case 'G': line = bookmark(GET,line); break;

			case 's':
			case 'S': bookmark(SET,line); break;

               case 'E':
               case 'e': edit(); break;

               case 'W':
			case 'w': write_file(WRITE_FILE); break;

			case 'D':
			case 'd': write_file(WRITE_BLOCK); break;

               case 'P':
               case 'p': print(line,column); break;

               case 'A':
               case 'a': print_all(); break;

               case 'F':
               case 'f': line = find(NORMAL,line); break;

               case 'N':
               case 'n': line = find(REPEAT,line); break;

               case 'C':
               case 'c': line = find(CASE_SEN,line); break;

               case 'B':
               case 'b': line = find(REVERSE,line); break;
          }

	if (line == -1)
		line = 0;

     if (old_col != column)
          disp_page(column,line);

     if (old_line != line)
          if (abs(old_line-line)>1)
               disp_page(column,line);
          else
          if (old_line - line == -1)
          {
               movetext(1,3,80,24,1,2);
               putseg(line+22,24,column);
          }
          else
          {
               movetext(1,2,80,23,1,3);
               putseg(line,2,column);
          }

     }
     while (exit);
}

int find(int type,int line)
{
     static char search_string[75] = "";
     static int  search_type = 1;
     static int  len = 0;

     int i,j,flag,escape;

     if ((type == NORMAL) || (type == CASE_SEN))
     {
          search_type = type;

          search_string[0] = 65;

          highlight();

          gotoxy(1,25);
		cprintf("%sFind \x1a ",type == CASE_SEN ? "Case " : "");
          clreol();

          normal();

          if(_cgets(search_string) == NULL)
          {
               rest_keys();
               return(line);
          }

          len = search_string[1];

          for(i=0;i<len+1;i++)
               search_string[i]=search_string[i+2];

          type = REPEAT;
     }

     gotoxy(1,25);
     flashing();
     cprintf("Searching...");
     normal();
     clreol();

     flag = 0;
     escape = 0;

     for(i=line + 1-2*(type == REVERSE);(i <= tot_lines) && (i >= 0);
          i += 1-2*(type == REVERSE))
     {
		if (strlen(ptr(i)) < len)
               continue;
		for(j=0;j<strlen(ptr(i))-len+1;j++)
          {
               if(search_type == CASE_SEN)
				flag=!strncmp(ptr(i)+j,search_string,len);
               else
				flag=!strnicmp(ptr(i)+j,search_string,len);
               if (flag)
               {
                    flag = i;
                    break;
               }
          }
     if (flag)
          break;
     if (kbhit())
          if (getscan() == 27)
          {
               escape = 1;
               break;
          }
     }

     if (!flag && !escape)
          putchar(7);

     rest_keys();

     return (flag == 0 ? line : flag);
}

void help(int line, int column)
{
     window(1,2,80,24);
     clrscr();

     window(1,1,80,24);
     inverse();
     gotoxy(65,1);
     clreol();
     cputs("Help Page");
     normal();

     window(1,2,80,24);

	highlight();
	cputs(  "\r\nScrolling/Paging Functions");
	normal();

	cputs(  "\r\n     \x18 Scroll Up one line");
     cputs(  "\r\n     \x19 Scroll Down one line");
     cputs(  "\r\n     \x1b Scroll Left 20 columns");
	cputs(  "\r\n     \x1a Scroll Right 20 columns");
	cputs(  "\r\n     Ctrl-\x1b Go To Left Margin");
     cputs("\r\n\n     PgUp Scroll Up One Page");
     cputs(  "\r\n     PgDn Scroll Down One Page");
     cputs(  "\r\n     Ctrl-PgUp Scroll Up Half Page");
	cputs(  "\r\n     Ctrl-PgDn Scroll Down Half Page");

	highlight();
	cputs("\r\n\nSearch Functions");
	normal();

	cputs(  "\r\n     'F' Find Text");
	cputs(  "\r\n     'C' Case Sensitive Find");
	cputs(  "\r\n     'N' Find Next");
	cputs(  "\r\n     'B' Find Previous");

	highlight();
	cputs("\r\n\nWrite-To-Disk Functions");
	normal();
	cputs(  "\r\n     'W' Write File to Disk");
	cputs(  "\r\n     'D' Write Block to Disk");

	window(41,2,80,24);

	highlight();
	cputs( "\r\nPrint Functions");
	normal();

	cputs(  "\r\n     'P' Print Block");
     cputs(  "\r\n     'A' Print File");
     cputs(  "\r\n     '+' Mark beginning of Block");
     cputs(  "\r\n     '-' Mark end of Block");
     cputs(  "\r\n     '*' Clear Block");

	highlight();
	cputs("\r\n\nSetup Functions");
	normal();

	cputs(  "\r\n     F7  Change Screen Colors");
     cputs(  "\r\n     F8  Change Printer Port");
     cputs(  "\r\n     F9  Define Editor");
     cputs(  "\r\n     F10 Write Setup to Disk");

	highlight();
	cputs("\r\n\nMisc. Functions");
	normal();

	cputs(  "\r\n     'S' Set Bookmark");
	cputs(  "\r\n     'G' Go To Bookmark");
	cputs(  "\r\n     'L' Go To Line\n");

     if (file_r)
		cputs(  "\r\n     'E' Invoke Editor");
	cputs(  "\r\n     Esc Exit To DOS or Cancel");
     window(1,1,80,25);
     gotoxy(1,25);
     inverse();
     cprintf("Press any key to return to file viewer screen");
     clreol();

     getscan();

     rest_keys();

     disp_page(line,column);
}

void print(int line,int column)
{
     int i;

     if((block_begin < 0) || (block_end < 0))
          return;

     flashing();
     gotoxy(1,25);
     clreol();
     cprintf("Printing...");

     if (open_prn())
     {
          normal();

          for(i=block_begin;i<=block_end;i++)
          {
			fputs(ptr(i),stdprn);
               putc('\r',stdprn);
               putc('\n',stdprn);
               if (kbhit())
               {
                    if (getscan() == 27)
                         break;
               }
          }
     }
     else
          putchar(7);

     fclose(stdprn);

     rest_keys();

     disp_page(column,line);
}

void print_all(void)
{
     int i;

     flashing();
     gotoxy(1,25);
     clreol();
     cprintf("Printing...");
     normal();

     if(open_prn())
     {
          for(i=0;i<=tot_lines;i++)
          {
			fputs(ptr(i),stdprn);
               putc('\r',stdprn);
               putc('\n',stdprn);
               if (kbhit())
               {
                    if (getscan() == 27)
                         break;
                    }
          }
     }

     fclose(stdprn);

     rest_keys();
}

void edit(void)
{
     char dest[127],cmd[127];
     char *argv[15];
     char *prgm;

     int i,j,pos;

     if (!file_r)
          return;

     gotoxy(1,25);
     clreol();
     highlight();
     cprintf("Loading Editor...");
     normal();

     pos = 0;

     for(i = 0; i < strlen(edit_cmd); i++)
          if (*(edit_cmd + i) == '@')
               for(j=0; j < strlen(filename); j++)
                    dest[pos++] = *(filename + j);
          else
               dest[pos++] = *(edit_cmd + i);

     dest[pos] = 0;

     strcpy(cmd,dest);

     prgm = strtok(dest," ");
     j = 1;

     do
          argv[j] = strtok(NULL," ");
     while (argv[j++] != NULL);

     execvp(prgm,argv);

     putchar(7);
     rest_keys();

}

void write_file(int func)
{
	int i,j,len;
	int beg,end;
	char fail;
	char append;
	FILE *test;

	if( (func == WRITE_BLOCK) && ((block_begin == -32767) || (block_end == -32767)) )
	{
		putchar(7);
		return;
	}

     gotoxy(1,25);
     highlight();
	cprintf("%sFile \x1a ",func == WRITE_BLOCK ? "Block\x1a" : "Write ");
     normal();
     clreol();

     filename[0]=65;

     if(_cgets(filename) == NULL)
     {
          rest_keys();
          return;
     }

     len = filename[1];

     for(i=0;i<len+1;i++)
          filename[i]=filename[i+2];

     test = freopen(filename,"r",stdout);

	j = 0;
	append = 0;

     if (test != NULL)
     {
          open_con_w();
          putchar(7);
          gotoxy(1,25);
          highlight();
		cprintf("Rewrite \"%s\"? (y/n/a)",filename);
          normal();
          clreol();
          j = -1;
          do
          {
			i = getscan();
			if ((i == 'a') || (i == 'A'))
			{
				j = 2;
				append = 1;
			}
               if ((i == 'y') || (i == 'Y'))
                    j = 1;
			if (((i == 'n') || (i == 'N')) || (i == ESC))
                    j = 0;
          }
          while (j == -1);

          if (!j)
          {
               rest_keys();
               return;
          }
     }

     gotoxy(1,25);
     highlight();

     cprintf("Writing file...");
     clreol();

	if(append)
		test = freopen(filename,"at",stdout);
	else
		test = freopen(filename,"wt",stdout);

     if (test == NULL)
     {
          open_con_w();
          putchar(7);
          rest_keys();
          return;
	}

	beg = func == WRITE_BLOCK ? block_begin : 0;
	end = func == WRITE_BLOCK ? block_end   : tot_lines;

	for (i = beg, fail = 0;(i <= end) && (!fail); i++)
		fail = (puts(ptr(i)) == EOF) + 2*(kbhit() ? getscan() == 27 : 0);

     open_con_w();

     if (fail == 1)
          putchar(7);

     if (fail)
     {
		if(!append)
			unlink(filename);
          rest_keys();
          return;
	}

	if( ((!file_r) && (func == WRITE_FILE)) && (!append) )
	{
		file_r = 1;

		message = strupr(filename);
		rest_message();
	}

	rest_keys();
}

void colors(int column, int line)
{
     int i,old_i,exit,c,key;
     int old_fore = col[0],old_back = col[3];

     gotoxy(1,25);
     inverse();
     cprintf("Follow instructions in above area to change colors");
     clreol();
     normal();

     window(1,2,80,24);
     clrscr();

     cprintf("\n\n");

     for (i = 0; i <= WHITE; i++)
     {
          textcolor(i);
          textbackground(i == 0 ? 7 : 0);
          cprintf("%2i",i);
          textbackground(0);
          textcolor(7);
          cprintf(" ");
     }

     cprintf("         ");

     for (i = 0; i <= LIGHTGRAY; i++)
     {
          textbackground(i);
          textcolor(i == 7 ? 0 : 7);
          cprintf("%1i",i);
          textbackground(0);
          cprintf(" ");
     }

     clreol();
     normal();

     gotoxy(1,5);
     cprintf("Use \x18\x19 to move, \x1b\x1a to change colors (listed above). Esc exits to file.");

     cprintf("\r\n\n     Normal Foreground");
     cprintf(  "\r\n     Info. Line Foreground");
     cprintf(  "\r\n     Highlighted Foreground");
     cprintf("\r\n\n     Normal Background");
     cprintf(  "\r\n     Info. Line Background");
     cprintf(  "\r\n     Highlighted Background");

     for(i=1;i<7;i++)
     {
          gotoxy(30,6+i+(i>3));
          cprintf("%2i",col[i-1]);
     }

     i = 1;
     exit = 0;

     gotoxy(1,20);
     normal();
     cprintf("Normal Text Sample");
     inverse();
     cprintf("\n\rInfo. Line Text Sample");
     highlight();
     cprintf("\n\rHighlighted Text Sample");

     normal();

     gotoxy(3,7);
     cprintf("\xc4\x10");

     do
     {
          key = getscan();

          c = 0; old_i = i;

          switch (key)
          {
               case UPARROW:       i = i > 1 ? i-1 : 6; c = 7; break;
               case DOWNARROW:     i = i < 6 ? i+1 : 1; c = 7; break;
               case LEFTARROW:     c = -1; break;
               case RIGHTARROW:    c = +1; break;

               case ESC:           exit = 1; break;
          }

          if (c == 7)
          {
               gotoxy(3,6+old_i+(old_i>3));
               cprintf("   ");
               gotoxy(3,6+i+(i>3));
               cprintf("\xc4\x10");
          }
          else
               if (c != 0)
               {
                    col[i-1] += c;
                    if (col[i-1] < 0)
                         col[i-1] = i > 3 ? 7 : 15;
                    if (col[i-1] > (i > 3 ? 7 : 15))
                         col[i-1] = 0;
                    for(old_i=1;old_i<7;old_i++)
                    {
                         gotoxy(30,6+old_i+(old_i>3));
                         cprintf("%2i",col[old_i-1]);
                    }
                    gotoxy(1,20);
                    normal();
                    cprintf("Normal Text Sample");
                    inverse();
                    cprintf("\n\rInfo. Line Text Sample");
                    highlight();
                    cprintf("\n\rHighlighted Text Sample");

                    textcolor(old_fore);
                    textbackground(old_back);

                    gotoxy(5,6+i+(i>3));
               }
     }
     while (!exit);

     window(1,1,80,25);

     rest_keys();
     rest_message();
     disp_page(column,line);
}

void editor(column,line)
{
     int i;
     char tmp[67];

     gotoxy(1,25);
     inverse();
     cputs("Change editor command using instructions above");
     clreol();
     normal();

     window(1,2,80,24);
     clrscr();

     gotoxy(1,12);
     cputs("Enter the command that you would type at the DOS command line to run your\n\r");
     cputs("editor. Replace the filename with a '@' sign. However, if the editor is a batch\n\r");
     cputs("file you need to preface the command with 'RUN' in order for it to execute.\n\r");
     cputs("\n\rPress Esc (or Enter a blank line) to keep the same editor command.\n\r");

     gotoxy(1,5);
     cprintf("Change Editor Command Line:\n\n\r");
     highlight();
     cprintf("Current \x1a ");
     normal();
     cputs(edit_cmd);
     highlight();
     cprintf("\r\n\nNew \x1a ");
     normal();

     strcpy(tmp,edit_cmd);

     edit_cmd[0]=64;

     if (_cgets(edit_cmd) == NULL)
     {
          strcpy(edit_cmd,tmp);
          window(1,1,80,25);
          rest_keys();
          disp_page(column,line);
          return;
     }

     if (edit_cmd[1] == 0)
          strcpy(edit_cmd,tmp);
     else
          for(i=2;i<=strlen(edit_cmd);i++)
               edit_cmd[i-2] = edit_cmd[i];

     window(1,1,80,25);

     rest_keys();
     disp_page(column,line);
}

void printer(int column,int line)
{
     int i;
     char tmp[67];

     gotoxy(1,25);
     inverse();
     cputs("Change printer port using the instructions above");
     clreol();
     normal();

     window(1,2,80,24);
     clrscr();

     gotoxy(1,12);
     cputs("The printer port is the DOS logical device used for printer output. Usually,\r\n");
     cputs("this will be 'prn' (printer) but can be: \r\n\n");
     cputs("     PRN      Printer Port = LPT1. This should work for most printers.\n\r");
     cputs("     LPTx     Parellel Port #x\n\r");
     cputs("     COMx     Serial Port #x (must be set up using the MODE command)\n\r");
     cputs("\nYou can also type a filename; a print jobs will be sent to that file. However,\n\r");
     cputs("the file gets overwritten with every job you print.");
     cputs("\n\n\rTo leave without changing the port, hit Esc or Enter a blank line.\n\r");

     gotoxy(1,5);
     cprintf("Change Printer Port:\n\n\r");
     highlight();
     cprintf("Current \x1a ");
     normal();
     cputs(port);
     highlight();
     cprintf("\r\n\nNew \x1a ");
     normal();

     strcpy(tmp,port);

     port[0]=65;
     if(_cgets(port) == NULL)
     {
          window(1,1,80,25);
          strcpy(port,tmp);
          rest_keys();
          disp_page(column,line);
          return;
     }

     if (port[1] == 0)
          strcpy(port,tmp);
     else
          for(i=2;i<=strlen(port);i++)
               port[i-2] = port[i];

     window(1,1,80,25);

     rest_keys();
     disp_page(column,line);
}

char *_cgets(char *s)
{
     int i,loc,max,x,y;
     char *edit;

     loc = 0;
     edit = (s + 2);
     max = *s;

     for(;;)
     {
          i = getscan();

          if (i > 255)
               continue;

          if ((i > 31) && (loc < max))
          {
               *(edit+(loc++)) = i;
               cprintf("%c",(char)i);
          }

          if ((i == 8) && (loc > 0))
          {
               loc--;
               x = wherex();
               y = wherey();

               y = x == 1 ? y-1 : y;
               x = x == 1 ? 80 : x-1;

               gotoxy(x,y);
               cprintf(" ");
               gotoxy(x,y);
          }

          if (i == 27)
          {
               *(s + 1) = loc;
               *(s + loc) = 0;
               return(NULL);
          }

          if (i == 13)
          {
               *(s + 1) = loc;
               *(edit + loc) = 0;

               return(edit);
          }
     }
}

char *ptr(int line)
{
	return ptrs[line/32]->str[line%32];
}

void setptr(int line, char *s)
{
	if( ptrs[line/32] != NULL )
		ptrs[line/32]->str[line%32] = s;
	else
	{
		ptrs[line/32] = malloc(str_size);
		chkptr(ptrs[line/32]);
		ptrs[line/32]->str[line%32] = s;
	}
}

int goto_line(int line)
{
	char s[8];
	char *tmp;

	int x;

	gotoxy(1,25);
	highlight();
	cprintf("Line \x1a ");
	clreol();

	normal();

	s[0] = 5;
	tmp = _cgets(s);

	if( tmp == NULL )
	{
		inverse();
		gotoxy(1,25);
		cprintf(keys);
		clreol();
		normal();
		return(line);
	}

	tmp = s + 2;

	x = atoi(tmp);

	if( x == 0 )
	{
		putchar(7);
		x = line+1;
	}

	if( (x > tot_lines+1) || (x < 1) )
	{
		putchar(7);
		x = line+1;
	}

	inverse();
	gotoxy(1,25);
	cprintf(keys);
	clreol();
	normal();

	return(x-1);
}

int bookmark(int cmd, int line)
{
	char s[8];
	char *tmp;
	int x;
	int num;

	gotoxy(1,25);
	highlight();
	cprintf("Bookmark %s (0 - 9) \x1a ", cmd == GET ? "Find" : "Set");
	clreol();

	normal();

	s[0] = 1;
	tmp = _cgets(s);

	if( tmp == NULL )
	{
		inverse();
		gotoxy(1,25);
		cprintf(keys);
		clreol();
		normal();
		return(line);
	}

	num = s[2] - 48;

	if((s[2] < '0') || (s[2] > '9'))
	{
		putchar(7);
		x = line;
	}
	else
		if(cmd == GET)
		{
			x = bookmarks[num];
			if( x == -1 )
			{
				putchar(7);
				x = line;
			}
		}
		else
		{
			bookmarks[num] = line;
			x = line;
		}

	inverse();
	gotoxy(1,25);
	cprintf(keys);
	clreol();
	normal();

	return(x);
}