/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TStreamable
#define Uses_MsgBox
#define Uses_TInputLong
#include "tvtools.h"
__link( RInputLine )


#include <string.h>
#include <stdio.h>
#include <values.h>
#include <stdlib.h>
#include <strstream.h>


// TInputLong

const char * const TInputLong::name = "TInputLong";

void TInputLong::write( opstream& os )
{
  TInputLine::write( os );
  os << min;
  os << max;
}

void *TInputLong::read( ipstream& is )
{
  TInputLine::read( is );
  is >> min;
  is >> max;
  return this;
}

TStreamable *TInputLong::build()
{
  return new TInputLong( streamableInit );
}


TStreamableClass RInputLong( TInputLong::name,
                             TInputLong::build,
                             __DELTA(TInputLong)
                           );

TInputLong::TInputLong( const TRect& bounds,
			int aMaxLen,
			long aMin,
			long aMax
                      )
           :TInputRegExp( bounds, aMaxLen, "-0-9" )
{
  min = aMin;
  max = aMax;
}


TInputLong::TInputLong( int x, int y,
			int aMaxLen,
			long aMin,
			long aMax
                      )
           :TInputRegExp( x, y, aMaxLen, "-0-9" )
{
  min = aMin;
  max = aMax;
}


ushort TInputLong::dataSize()
{
  return sizeof( long );
}

void TInputLong::getData( void *rec )
{
  *(long *)rec = atol(data);
}

void TInputLong::setData( void *rec )
{
  ltoa(*(long *)rec, data, 10);
  selectAll(True);
}

Boolean TInputLong::valid( ushort command )
{
  switch( command )
        {
          case cmReleasedFocus: return True;

          case cmQuit :
          case cmClose:
          case cmOK   : long value = atol( data );
                        if ( (! *data) || (value < min) || (value > max) )
                           {
                             select();
                             messageBox( mfError | mfOKButton,
                                         "\03Number must be between %ld and %ld.",
                                         min, max
                                       );
                             selectAll( True );
                             return False;
                           }
                        break;
        }

  return TInputRegExp::valid( command );
}
