/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TComboBox
#include "tvtools.h"
#include <string.h>


#define cpComboBox "\x13"    // for normal TInputLine link
#define cpSComboBox "\x1A"   // for TStaticInputLine link


TComboBox::TComboBox( const TRect& bounds,
                      TInputLine *aLink,
                      TGenCollection *aList
                    ) :
	   TView( bounds )
{
 initBox( aLink, aList );
}


TComboBox::TComboBox( TInputLine *aLink,
                      TGenCollection *aList
                    ) :
	   TView( TRect(aLink->origin.x+aLink->size.x, aLink->origin.y, aLink->origin.x+aLink->size.x+1, aLink->origin.y+1) )
{
 initBox( aLink, aList );
}


void TComboBox::initBox( TInputLine *aLink, TGenCollection *aList )
{
 options |= ofPostProcess;
 eventMask |= evBroadcast;
 link = aLink;
 list = aList;
 icon = "\x19";
}


void TComboBox::shutDown()
{
 link = 0;
 TView::shutDown();
}


void TComboBox::draw()
{
 TDrawBuffer b;

 b.moveStr( 0, icon, getColor(0x01) );
 writeLine( 0, 0, size.x, size.y, b );
}


TPalette& TComboBox::getPalette() const
{
 static TPalette palette( cpComboBox, sizeof(cpComboBox)-1 );
 static TPalette spalette( cpSComboBox, sizeof(cpSComboBox)-1 );

 return spalette;
// if ( ! strcmp(link->name, "TStaticInputLine") ) return spalette;
//                                            else return palette;
}


void TComboBox::handleEvent( TEvent& event )
{
 TComboWindow *ComboWindow;
 TRect  r, p;

 TView::handleEvent( event );

 if ( (event.what == evMouseDown) ||
      (event.what == evKeyDown && ctrlToArrow(event.keyDown.keyCode) == kbDown
				&& (link->state & sfFocused)
      )
    )
    {
     if ( ! list || ! link ) return;

     if ( ! (link->state & sfDisabled) )    // Make InputLine the active view
        link->select();

     r = link->getBounds();                 // Get bounds of the InputLine

     r.b.x = r.a.x + max(list->getTextLength() + 1, link->size.x) + 1;
     int delta = owner->size.x - r.b.x - 1;
     if ( delta < 0 ) { r.a.x += delta;
                        r.b.x += delta;
                      }
     r.a.x = max( r.a.x, 1 );

     r.a.y += 1;
     r.b.y = r.a.y + list->getCount();
     delta = owner->size.y - r.b.y - 1;
     if ( delta < 0 )
        {
         r.a.y += delta;
         r.b.y += delta;
        }
     r.a.y = max( r.a.y, 1 );

     // Create a new TComboWindow
     ComboWindow = new TComboWindow( r, list );
     if ( ComboWindow )
        {
         ushort c = owner->execView( ComboWindow );    // Execute TComboWindow as modal view

         // If TComboWindow return cmOK and line is not disabled
         if ( (c == cmOK) && ! (link->state & sfDisabled) )
            {
	     char rslt[256];
	     ComboWindow->getSelection(rslt);     // Set the link data to the selection
	     strncpy(link->data, rslt, link->maxLen);
	     link->data[link->maxLen] = EOS;
	     link->selectAll(True);               // Select all in the linked view
	     link->drawView();                    // Redraw the linked view
	    }

	 destroy( ComboWindow );
        }

     clearEvent( event );
     return;
    }
}