
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0        *
; *     String Compare                                  *
; *                                                     *
; *     Copyright (C) 1990-1993 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   STRHCMP


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Publics

             PUBLIC  SCompare

;-------------------------------------------------------------------------------
; SCompare compares two strings and sets the zero and carry flag according to
; the result of the comparison. These flag are set as if two unsigned integers
; had been compared. The routine compares all the characters of the shorter
; string to the ones of the longer string, starting at index 1 in each string.
; The first mismatch determines the result of the comparison. If the characters
; compared are all equal, the string's length is compared: The longer string is
; bigger.
;
; On entry:  [SP+4]  Address of destination string
;            [SP+8]  Address of source string
;
; On exit:   ZF = 1  if Source = Destination
;            CF = 1  if Source < Destination
;-------------------------------------------------------------------------------

SCompare     PROC    FAR
             CLD                       ; auto increment for string instructions
             MOV     DX, DS            ; save callers data segment
             MOV     BX, SP            ; make new frame pointer
             LDS     SI, SS:[BX+8]     ; pointer to source
             LES     DI, SS:[BX+4]     ; pointer to destination
             LODSB                     ; source len, SI ptr to 1. char of source
             MOV     AH, ES:[DI]       ; length destination
             INC     DI                ; DI ptr to 1st char of destination
             MOV     CL, AL            ; duplicate length source
             SUB     CL, AH            ; length source - length destination
             SBB     CH, CH            ; CH = FF if length source < length dest.
             AND     CL, CH            ; CL = 0, if length source >= length dest
             ADD     CL, AH            ; CL = Min (length source, length dest)
             XOR     CH, CH            ; zero-extend to word, set ZF = 1
             REPE    CMPSB             ; comp. strings char by char until diff.
             JNE     $str_differ       ; strings differ
             CMP     AL, AH            ; strings equal, compare string length
$str_differ: MOV     DS, DX            ; restore caller's data segment
             RET     8                 ; pop parameters and return
SCompare     ENDP

             ALIGN   4

CODE         ENDS

             END
