program keytest;

(*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*)
(*                                                                         *)
(*  This is a short program to test and demonstrate some of the most       *)
(*  useful features of the Keyboard unit.  Individual sections are         *)
(*  explained in comments as we go.                                        *)
(*                                                                         *)
(*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*)

uses keyboard,dos;

const
 intmin=-1000;
 intmax=1000;
 wordmin=0;
 wordmax=1000;
 realmin=-1000.0;
 realmax=1000.0;
 decimals=5;
 stringmax=255;

var
 s:string[stringmax];
 regs:registers;
 x,y:byte;
 i:integer;
 w:word;
 r:real;
 numstate:boolean;

begin
 s:='Default string';
 chgcursor($20,0); { Shut off cursor }
 writeln('Displaying key states.  Press any key to continue.');
 repeat { Display the states of the various key flags }
  write('States: ');
  if leftshiftdown then write('LSHIFT ') else write('       ');
  if rightshiftdown then write('RSHIFT ') else write('       ');
  if controldown then write('CTRL ') else write('     ');
  if altdown then write('ALT ') else write('    ');
  if getcapslock then write('CAPS ') else write('     ');
  if getnumlock then write('NUM ') else write('    ');
  if getscrolllock then write('SCROLL ') else write('       ');
  if getinsert then write('INSERT ') else write('       ');
  write(^M); { Move to column 1 of current line }
 until keypressed;
 chgcursor(6,7); { Return thin cursor }
 writeln;
 writeln('Key pressed.');
 flushbuffer; { Get rid of the keypress that was created in the buffer }
 write('Enter an integer between ',intmin,' and ',intmax,': ');
 i:=0;
 readint(i,intmin,intmax);
 writeln; { Remember, there is no newline after the input is read }
 writeln('Number returned was ',i);
 write('Enter an unsigned integer between ',wordmin,' and ',wordmax,': ');
 w:=0;
 readno(w,wordmin,wordmax);
 writeln; { Same as above }
 writeln('Number returned was ',w);
 write('Enter a real number between ',realmin:1:decimals,' and ',
  realmax:1:decimals,': ');
 r:=0;
 readreal(r,realmin,realmax,decimals);
 writeln; { Ditto }
 writeln('Number returned was ',r:1:decimals);
 write('Enter a string: ');
 readstr(s,stringmax,[]);
 writeln; { Ditto }
 writeln('String returned was: "',s,'"');
 write('Edit the string: ');
 editstr(s,stringmax,[]);
 writeln; { Ditto }
 writeln('String returned was: "',s,'"');
 nonnumeric:=true;
 numstate:=getnumlock;
 write('Setting NUMLOCK to ON.  Press an arrow key or other keypad key.');
 setnumlock(on);
 repeat until keypressed;
 writeln;
 case getkey of
  home:          writeln('HOME key pressed.');
  uparrow:       writeln('UP ARROW key pressed.');
  pgup:          writeln('PAGE UP key pressed.');
  leftarrow:     writeln('LEFT ARROW key pressed.');
  rightarrow:    writeln('RIGHT ARROW key pressed.');
  end_:          writeln('END key pressed.');
  downarrow:     writeln('DOWN ARROW key pressed.');
  pgdn:          writeln('PAGE DOWN key pressed.');
  ins:           writeln('INSERT key pressed.');
  del:           writeln('DELETE key pressed.');
  cntlhome:      writeln('CONTROL-HOME key pressed.');
  cntlend:       writeln('CONTROL-END key pressed.');
  cntlpgup:      writeln('CONTROL-PAGE UP key pressed.');
  cntlpgdn:      writeln('CONTROL-PAGE DOWN key pressed.');
  cntlleftarrow: writeln('CONTROL-LEFT ARROW key pressed.');
  cntlrightarrow:writeln('CONTROL-RIGHT ARROW key pressed.');
  else           writeln('Key pressed was not a keypad key!');
 end;
 setnumlock(numstate);
 write('Key tests done.  Press RETURN.');
 readstr(s,0,[]);
end.