Unit Joystick;
Interface
 Uses Crt;

 { Joystick interface for Turbo Pascal V. 4.0 and above
   Public Domain, November 1989 by
   JonSoft Technologies Inc.
   (C) 1989 JonSoft Technologies Inc. }

CONST
 centX : Byte=80;
 centY : Byte=40;
 Joyst : BOOLEAN=TRUE;

PROCEDURE FastInitJS;
PROCEDURE BetterInitJS( range : Byte );
FUNCTION joy_X : Byte;
FUNCTION joy_Y : Byte;
FUNCTION button_1 : Byte;
FUNCTION button_2 : Byte;
FUNCTION Horiz : shortint;
FUNCTION Vert : shortint;


Implementation

CONST
 rangexm : Byte=25;
 rangeym : Byte=20;
 rangexp : Byte=25;
 rangeyp : Byte=25;

FUNCTION joy_X : Byte;
  VAR
    x : Word;
  BEGIN
    x := 0;
    Port[$201] := $ff;
    WHILE Port[$201] AND $1=1 DO Inc(x);
    joy_X := x;
  END;

FUNCTION joy_Y : Byte;
  VAR
    y : Word;
  BEGIN
    y := 0;
    Port[$201] := $0;
    WHILE Port[$201] AND $2=2 DO Inc(y);
    joy_Y := y;
  END;

PROCEDURE FastInitJs;
  BEGIN
    centX := joy_X;
    centY := joy_Y;
  END;

FUNCTION button_1 : Byte;
  BEGIN
    button_1 := ((Port[$201] AND $10) XOr $10) ShR 4;
  END;

FUNCTION button_2 : Byte;
  BEGIN
    button_2 := ((Port[$201] AND $20) XOr $20) ShR 5;
  END;

PROCEDURE BetterInitJs(range : Byte);
  VAR
(*    Ch : CHAR; *)
    uprjoyX, uprjoyY, centrjoyX, centrjoyY, lowrjoyX, lowrjoyY : Byte;

BEGIN
 WRITELN('Are you using a joystick? (Button = yes, RETURN = no)');
 REPEAT
  IF button_1+button_2 > 0 THEN Joyst := TRUE;
  IF KeyPressed THEN Joyst := FALSE;
 UNTIL (button_1+button_2 > 0) OR KeyPressed;
 IF Joyst = TRUE THEN BEGIN
  REPEAT UNTIL button_1+button_2 = 0;
  WRITELN('Move joystick to UPPER RIGHT corner and press a button.');
  REPEAT UNTIL button_1+button_2 > 0;
  uprjoyX := joy_X;
  uprjoyY := joy_Y;
  REPEAT UNTIL button_1+button_2 = 0;
  WRITELN('Move joystick to CENTER and press a button.');
  REPEAT UNTIL button_1+button_2 > 0;
  centrjoyX := joy_X;
  centrjoyY := joy_Y;
  centX := centrjoyX;
  centY := centrjoyY;
  REPEAT UNTIL button_1+button_2 = 0;
  WRITELN('Move joystick to LOWER LEFT CORNER and press a button.');
  REPEAT UNTIL button_1+button_2 > 0;
  lowrjoyX := joy_X;
  lowrjoyY := joy_Y;
  rangexm := (centrjoyX-uprjoyX) DIV range;
  rangexp := (lowrjoyX-centrjoyX) DIV range;
  rangeym := (centrjoyY-uprjoyY) DIV range;
  rangeyp := (lowrjoyY-centrjoyY) DIV range;
 END;
END;

FUNCTION Horiz : shortint;
  BEGIN
    IF joy_X<centX-rangexm THEN Horiz := -1
    ELSE IF joy_X > centX+rangexp THEN Horiz := 1
    ELSE Horiz := 0;
  END;

FUNCTION Vert : shortint;
  BEGIN
    IF joy_Y<centY-rangeym THEN Vert := -1
    ELSE IF joy_Y > centY+rangeyp THEN Vert := 1
    ELSE Vert := 0;
  END;

END.
