Unit MetaGr;

{ Unit MetaGr, Version 1.02.001, (c) 1994 Daniel Mahrenholz }

{ Modified by Matthias Koeppe for BGI or MetaGr selection
}

{$A+,B-,D+,F-,G+,O-,R-,S-,X+}

Interface

Uses Objects;

Type
	TBufferInfo = Record
			Count: Word;
			Free: Word;
		      End;

	TErrorProc = Procedure;

	PColors = ^TColors;
	TColors = Array[0..255,1..3] of Byte;

	PPalettes = ^TPalettes;
	TPalettes = Array[0..16] of Byte;

Var ErrorProc: TErrorProc;
    MetaError: Word;

Const
	me_NoError      = 0;
	me_Init         = 1;
	me_Buffer       = 2;
	me_Full         = 3;
	me_Stack        = 4;
	me_Memory       = 5;

	NormalPut       = 0;
	CopyPut         = 0;
	XORPut          = 1;
	ORPut           = 2;
	ANDPut          = 3;

	Black           =  0;
	Blue            =  1;
	Green           =  2;
	Cyan            =  3;
	Red             =  4;
	Magenta         =  5;
	Brown           =  6;
	LightGray       =  7;
	DarkGray        =  8;
	LightBlue       =  9;
	LightGreen      = 10;
	LightCyan       = 11;
	LightRed        = 12;
	LightMagenta    = 13;
	Yellow          = 14;
	White           = 15;
	Border          = 16;

	SolidLn         = 0;
	DottedLn        = 1;
	CenterLn        = 2;
	DashedLn        = 3;
	UserBitLn       = 4;

	EmptyFill       = 0;
	SolidFill       = 1;
	LineFill        = 2;
	LtSlashFill     = 3;
	SlashFill       = 4;
	BkSlashFill     = 5;
	LtBkSlashFill   = 6;
	HatchFill       = 7;
	XHatchFill      = 8;
	InterleaveFill  = 9;
	WideDotFill     = 10;
	CloseDotFill    = 11;
	UserFill        = 12;

	NormWidth       = 1;
	ThickWidth      = 3;

	qMetaExtSave    = 100;
	qMetaLine       = 100;
	qChMetaParams   = 100;

  Procedure PutPixel(x,y: Integer; Color:Byte);
  Function  GetPixel(x,y: Integer): Byte;
  Procedure HoriLine(x1,y1,x2: Integer);
  Procedure VertLine(x1,y1,y2: Integer);
  Procedure Bar (x1,y1,x2,y2: Integer);
  Procedure Rectangle (x1,y1,x2,y2: Integer);
  Procedure Circle (xm,ym,r: Integer);
  Procedure FillCircle (xm,ym,r: Integer);

  Procedure Line(x1,y1,x2,y2: Integer);
  Procedure MoveTo(x ,y: Integer);
  Procedure MoveRel(x,y: Integer);
  Procedure LineTo(x,y: Integer);
  Procedure LineRel(x,y: Integer);

  Procedure SetColor (Color: Byte);
  Procedure SetFillStyle (FillStyle, Color: Word);
  Procedure SetLineStyle (LineStyle, Pattern, Thickness:Word);
  Procedure SetWriteMode (Mode: Byte);
  Procedure ClearDevice;
  Procedure ClearPage;

  Procedure SetRGBColor(Color, R, G, B:Byte);
  Procedure GetRGBColor(Color:Byte; var R, G, B:Byte);
  Procedure SetRGBColorEntry(Color, R, G, B:Byte);
  Procedure GetRGBColorEntry(Color: Byte; var R, G, B:Byte);
  Procedure SetRGBColors(Colors: PColors; Start, Count:Byte);
  Procedure GetRGBColors(Colors: PColors; Start, Count:Byte);
  Procedure SetPalette(Palette, Color: Byte);
  Function  GetPalette(Palette: Byte): Byte;
  Procedure SetPaletteEntry(Palette, Color:Byte);
  Function  GetPaletteEntry(Palette: Byte): Byte;
  Procedure SetPalettes(Palettes: PPalettes);
  Procedure GetPalettes(Palettes: PPalettes);
  Procedure SetBorder(Color: Byte);
  Function  GetBorder: Byte;

  Procedure InitMetaGr;
  Procedure DoneMetaGr;
  Function  LastError: Byte;
  Function  GetBuffer (Size:Word):Pointer;
  Procedure SetBuffer (Buffer:Pointer);
  Procedure DrawBuffer (Buffer:Pointer);
  Procedure FreeBuffer (Buffer:Pointer);
  Procedure ClearBuffer(Buffer:Pointer);
  Procedure SetMetaState (State:Word);
  Procedure GetBufferInfo(Buffer:Pointer; var BufferInfo:TBufferInfo);
  Function  FullBuffer(Buffer:Pointer; Data:Word):Boolean;
  Function  MetaFunctions: Boolean;
  Procedure SaveExt;

  Function  ChMetaParams(Cmd: Word; var Buf): Word;
  Procedure SetMetaOrigin(x,y: Integer);
  Procedure SetMetaOriginP(P: TPoint);
  Procedure SetMetaClipRect(x1, y1, x2, y2: Integer);
  Procedure SetMetaClipRectR(R: TRect);

Implementation

{$ifdef metagr_bgi}
uses Memory, Gr, Graph, Bgi, GVisible, GvViews;
{$else}
Uses Crt, Memory, Gr;
{$endif}

Const
      LnPattern: Array[0..3] of Word=($0FFFF, $03333, $01E4F, $01F1F);
      FillPattern: Array[0..11] of Word=($00000, $0FFFF, $0AAAA, $0AAAA,
					 $0AAAA, $0AAAA, $0AAAA, $0AAAA,
					 $0AAAA, $0AAAA, $0AAAA, $0AAAA);
      ScanBackPtr: Word=0;
      ValidBuffer: Word=0;
      ValidStack : Word=0;

       R_l = 1;
       R_r = 2;
       R_u = 4;
       R_o = 8;

Type
     TDataRec=Record
		xl, yl          : Integer;
		xp, yp          : Integer;
		xa, ya          : Integer;
		xe, ye          : Integer;
		x,  y           : Integer;
		xm, ym          : Integer;
		Fa, FFa         : Word;
		DivConst        : Word;
		Clip            : Byte;
		Error           : Word;
		xm2, ym2        : Integer;
		LnStyle         : Word;
		Thickness       : Word;
		FillStyle       : Word;
		WriteMode       : Word;
		x1, y1          : Integer;
		x2, y2          : Integer;
		xd, yd          : Integer;
		LastY1          : Integer;
		LastY2          : Integer;
		mHi             : Integer;
		mLo             : Integer;
		msHi            : Integer;
		msLo            : Integer;
		DivXY           : Integer;
		DivXY2          : Integer;
		VZ              : Integer;
		xr, yr          : Integer;
		diff            : Integer;
		Bit             : Word;
		SaveBit         : Word;
		Row             : Byte;
		xEnd            : Byte;
		SaveSD          : Word;
		SaveCX          : Word;
		SaveDS          : Word;
		SaveBP          : Word;
		UserRegArea     : Array[0..6] of Byte;
	      End;


     TProgRec = Record
		  P_VL     : Word;
		  P_HL     : Word;
		  P_Bar    : Word;
		  P_Point  : Word;
		  P_GetP   : Word;
		  P_Line   : Word;
		  P_LineD  : Word;
		  P_HL_o   : Word;
		  P_Point_o: Word;
		End;

Var DrawPtr: Pointer;
    Data: TDataRec;
    Stack:Pointer;
    BackPtr: Word;
    EndPtr: Word;
    ExtPtr: Word;
    ProgRec: TProgRec;
    MPalettes: ^TPalettes;
    MColors: ^TColors;
    MetaOrigin: TPoint;

Procedure Save; forward;

procedure DefaultErrorProc; ASSEMBLER;
ASM
	MOV     Data.Error, AX
	MOV     MetaError, AX
	MOV     BX, WORD PTR ErrorProc
	OR      BX, WORD PTR ErrorProc+2
	JZ      @@1
	CALL    [ErrorProc]
@@1:
END;

function LastError;
Begin
  LastError:=Data.Error;
End;

{$ifdef metagr_bgi}

const
  WriteMode: Byte = NormalPut;

var
  FillColor,
  DrawColor: Byte;

Procedure PutPixel(x,y: Integer; Color:Byte);
begin Bgi.PutPixel(x, y, Color) end;

Function  GetPixel(x,y: Integer): Byte;
begin GetPixel := Bgi.GetPixel(x, y) end;

Procedure HoriLine(x1,y1,x2: Integer);
begin Bgi.Line(x1, y1, x2, y1) end;

Procedure VertLine(x1,y1,y2: Integer);
begin Bgi.Line(x1, y1, x1, y2) end;

Procedure Bar (x1,y1,x2,y2: Integer);
var
  y: Integer;
begin
  If WriteMode = NormalPut
  then Bgi.Bar(x1, y1, x2, y2)
  else begin
    Bgi.SetColor(FillColor);
    For y := y1 to y2 do Line(x1, y, x2, y);
    Bgi.SetColor(DrawColor)
  end
end;

Procedure Rectangle (x1,y1,x2,y2: Integer);
begin Bgi.Rectangle(x1, y1, x2, y2) end;

Procedure Circle (xm,ym,r: Integer);
begin Bgi.Circle(xm, ym, r) end;

Procedure FillCircle (xm,ym,r: Integer);
begin Bgi.FillEllipse(xm, ym, r, r) end;

Procedure Line(x1,y1,x2,y2: Integer);
begin Bgi.Line(x1, y1, x2, y2) end;

Procedure MoveTo(x ,y: Integer);
begin Bgi.MoveTo(x, y) end;

Procedure MoveRel(x,y: Integer);
begin Bgi.MoveRel(x, y) end;

Procedure LineTo(x,y: Integer);
begin Bgi.LineTo(x, y) end;

Procedure LineRel(x,y: Integer);
begin Bgi.LineRel(x, y) end;

Procedure SetColor (Color: Byte);
begin
  DrawColor := Color;
  Bgi.SetColor(Color)
end;

Procedure SetFillStyle (FillStyle, Color: Word);
begin
  FillColor := Color;
  Bgi.SetFillStyle(FillStyle, Color)
end;

Procedure SetLineStyle (LineStyle, Pattern, Thickness:Word);
begin Bgi.SetLineStyle(LineStyle, Pattern, Thickness) end;

Procedure SetWriteMode (Mode: Byte);
begin
  WriteMode := Mode;
  Bgi.SetWriteMode(Mode)
end;

Procedure ClearDevice;
begin Graph.ClearDevice end;

Procedure ClearPage;
begin Graph.ClearDevice end;

{$else}

procedure P_VL_Multi; ASSEMBLER;
ASM
@@M:
	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    5
	JMP     NEAR PTR Save
@@Dr:
	MOV     AX, MetaState
	AND     AX, ms_Draw
	JNZ     @@Dr2
	ADD     SP, 8
	RETN
@@Dr2:
	POP     AX
	MOV     DX, 03CEh
	XOR     AL, AL
	OUT     DX, AX
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, Data.WriteMode
	OUT     DX, AX
	MOV     AL, 08h
	OUT     DX, AL
	POP     DI
	POP     BX
	POP     DX
	ADD     DI, MetaOrigin.x
	ADD     BX, MetaOrigin.y
	ADD     DX, MetaOrigin.y
	CMP     DI, ClipRect.A.x
	JL      @@E
	CMP     DI, ClipRect.B.x
	JNL     @@E
	CMP     DX, ClipRect.B.y
	JL      @@M1
	MOV     DX, ClipRect.B.y
	DEC     DX
@@M1:
	CMP     DX, ClipRect.A.y
	JL      @@E
	CMP     BX, ClipRect.B.y
	JNL     @@E
	CMP     BX, ClipRect.A.y
	JNL     @@M2
	MOV     BX, ClipRect.A.y
@@M2:
	PUSH    DX
	PUSH    BX
	MOV     AX, BX
	MUL     BytesPerLine.word
	MOV     BX, DI
	SHR     DI, 3
	ADD     DI, AX
	AND     BX, 7
	MOV     CX, BX
	MOV     BX, 80h
	SHR     BX, CL
	MOV     DX, 03CEh
	MOV     AL, 8
	OUT     DX, AL
	INC     DX
	MOV     AL, BL
	OUT     DX, AL
	POP     BX
	POP     CX
	SUB     CX, BX
	INC     CX
	MOV     AX, ActivePSeg
	MOV     ES, AX
	ADD     DI, ActivePOfs
	MOV     BX, Data.LnStyle
@@A:
	ROR     BX, 1
	JNC     @@NP
	INC     Byte Ptr [ES:DI]
@@NP:
	ADD     DI, BytesPerLine.word
	LOOP    @@A
@@E:
	RETN
END;

procedure P_HL_N; assembler;
Asm
	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    8
	JMP     NEAR PTR Save
@@Dr:
	POP     Data.ya
	POP     Data.xe
	POP     Data.xa
	MOV     AX, MetaState
	AND     AX, ms_Draw
	JZ      @@L4
	MOV     AX, MetaOrigin.X
	MOV     BX, MetaOrigin.Y
	ADD     Data.xa, AX
	ADD     Data.xe, AX
	ADD     Data.ya, BX
	MOV     AX, ClipRect.A.x
	MOV     BX, ClipRect.A.y
	MOV     CX, ClipRect.B.x
	MOV     DX, ClipRect.B.y
	CMP     Data.ya, BX
	JL      @@L4
	CMP     Data.ya, DX
	JNL     @@L4
	CMP     Data.xa, CX
	JNL     @@L4
	CMP     Data.xa, AX
	JG      @@T1
	MOV     Data.xa, AX
@@T1:
	CMP     Data.xe, AX
	JL      @@L4
	CMP     Data.xe, CX
	JL      @@T2
	MOV     Data.xe, CX
	DEC     Data.xe
@@T2:
	MOV     DX, 03CEh
	POP     AX
	XOR     AL, AL
	OUT     DX, AX
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, Data.WriteMode
	OUT     DX, AX
	MOV     AL, 08h
	OUT     DX, AL
	INC     DX
	PUSH    DX
	MOV     AX, ActivePSeg
	MOV     ES, AX
	MOV     AX, Data.ya
	MUL     BytesPerLine.word
	MOV     BX, Data.xa
	SHR     BX, 3
	ADD     AX, BX
	MOV     DI, AX
	ADD     DI, ActivePOfs
	MOV     AX, Data.xa
	SHR     AX, 3
	MOV     CX, Data.xe
	SHR     CX, 3
	SUB     CX, AX
	OR      CX, CX
	JNZ     @@L1
	MOV     DX, $FFFF
	MOV     CX, Data.xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	AND     DH, DL
	MOV     AL, DH
	POP     DX
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	JMP     @@E
@@L1:
	MOV     DX, $FFFF
	MOV     CX, Data.xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	MOV     SI, DX
	POP     DX
	MOV     AX, SI
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	INC     DI
	MOV     AX, Data.xa
	SHR     AX, 3
	MOV     CX, Data.xe
	SHR     CX, 3
	SUB     CX, AX
	DEC     CX
	JZ      @@L2
	MOV     AX, Data.LnStyle
	OUT     DX, AL
	CLD
	PUSH    SI
	MOV     SI, DI
	REP     STOSB
	POP     SI
@@L2:
	MOV     AX, SI
	MOV     AL, AH
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	MOV     AL, $FF
	OUT     DX, AL
	DEC     DX
	MOV     AL, $01
	OUT     DX, AL
	INC     DX
	MOV     AL, $00
	OUT     DX, AL
	JMP     @@E
@@L4:
	POP     AX
@@E:
	POP     Data.ya
	POP     Data.xe
	POP     Data.xa
	RETN
End;

procedure P_HL_Multi; assembler;
Asm
	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    8
	JMP     NEAR PTR Save
@@Dr:
	POP     Data.ya
	POP     Data.xe
	POP     Data.xa
	MOV     AX, MetaState
	AND     AX, ms_Draw
	JZ      @@L4
	MOV     AX, MetaOrigin.X
	MOV     BX, MetaOrigin.Y
	ADD     Data.xa, AX
	ADD     Data.xe, AX
	ADD     Data.ya, BX
	MOV     AX, ClipRect.A.x
	MOV     BX, ClipRect.A.y
	MOV     CX, ClipRect.B.x
	MOV     DX, ClipRect.B.y
	CMP     Data.ya, BX
	JL      @@L4
	CMP     Data.ya, DX
	JNL     @@L4
	CMP     Data.xa, CX
	JNL     @@L4
	CMP     Data.xa, AX
	JG      @@T1
	MOV     Data.xa, AX
@@T1:
	CMP     Data.xe, AX
	JL      @@L4
	CMP     Data.xe, CX
	JL      @@T2
	MOV     Data.xe, CX
	DEC     Data.xe
@@T2:
	MOV     DX, 03CEh
	POP     AX
	XOR     AL, AL
	OUT     DX, AX
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, Data.WriteMode
	OUT     DX, AX
	MOV     AL, 08h
	OUT     DX, AL
	INC     DX
	PUSH    DX
	MOV     AX, ActivePSeg
	MOV     ES, AX
	MOV     AX, Data.ya
	MUL     BytesPerLine.word
	MOV     BX, Data.xa
	SHR     BX, 3
	ADD     AX, BX
	MOV     DI, AX
	ADD     DI, ActivePOfs
	MOV     AX, Data.xa
	SHR     AX, 3
	MOV     CX, Data.xe
	SHR     CX, 3
	SUB     CX, AX
	OR      CX, CX
	JNZ     @@L1
	MOV     DX, $FFFF
	MOV     CX, Data.xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	AND     DH, DL
	MOV     AL, DH
	POP     DX
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	JMP     @@E
@@L1:
	MOV     DX, $FFFF
	MOV     CX, Data.xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	MOV     SI, DX
	POP     DX
	MOV     AX, SI
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	INC     DI
	MOV     AX, Data.xa
	SHR     AX, 3
	MOV     CX, Data.xe
	SHR     CX, 3
	SUB     CX, AX
	DEC     CX
	JZ      @@L2
	MOV     AX, Data.LnStyle
	OUT     DX, AL
	CLD
	PUSH    SI
	MOV     SI, DI
	REP     SEGES MOVSB
	POP     SI
@@L2:
	MOV     AX, SI
	MOV     AL, AH
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	MOV     AL, $FF
	OUT     DX, AL
	DEC     DX
	MOV     AL, $01
	OUT     DX, AL
	INC     DX
	MOV     AL, $00
	OUT     DX, AL
	JMP     @@E
@@L4:
	POP     AX
@@E:
	POP     Data.ya
	POP     Data.xe
	POP     Data.xa
	RETN
End;

procedure P_Bar_N; assembler;
Asm

	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    10
	JMP     NEAR PTR Save
@@Dr:
	POP     Data.ye
	POP     Data.ya
	POP     Data.xe
	POP     Data.xa
	MOV     AX, MetaState
	AND     AX, ms_Draw
	JZ      @@L4
	MOV     AX, MetaOrigin.X
	MOV     BX, MetaOrigin.Y
	ADD     Data.xa, AX
	ADD     Data.xe, AX
	ADD     Data.ya, BX
	ADD     Data.ye, BX
	MOV     AX, ClipRect.A.x
	MOV     BX, ClipRect.A.y
	MOV     CX, ClipRect.B.x
	MOV     DX, ClipRect.B.y
	CMP     Data.ye, BX
	JL      @@L4
	CMP     Data.ya, DX
	JNL     @@L4
	CMP     Data.xa, CX
	JNL     @@L4
	CMP     Data.xa, AX
	JG      @@T1
	MOV     Data.xa, AX
@@T1:
	CMP     Data.xe, AX
	JL      @@L4
	CMP     Data.xe, CX
	JL      @@T2
	MOV     Data.xe, CX
	DEC     Data.xe
@@T2:
	CMP     Data.ya, BX
	JG      @@T3
	MOV     Data.ya, BX
@@T3:
	CMP     Data.ye, DX
	JL      @@T4
	MOV     Data.ye, DX
	DEC     Data.ye
@@T4:
	MOV     AX, Data.xe
	SUB     AX, Data.xa
	JS      @@L4
	MOV     AX, Data.ye
	SUB     AX, Data.ya
	JS      @@L4
	INC     AX
	MOV     Data.yd, AX
	MOV     DX, 03CEh
	POP     AX
	XOR     AL, AL
	OUT     DX, AX
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, Data.WriteMode
	OUT     DX, AX
	MOV     AL, 08h
	OUT     DX, AL
	INC     DX
	PUSH    DX
	MOV     AX, ActivePSeg
	MOV     ES, AX
	MOV     AX, Data.ya
	MUL     BytesPerLine.word
	MOV     BX, Data.xa
	SHR     BX, 3
	ADD     AX, BX
	MOV     DI, AX
	ADD     DI, ActivePOfs
	MOV     AX, Data.xa
	SHR     AX, 3
	MOV     CX, Data.xe
	SHR     CX, 3
	SUB     CX, AX
	OR      CX, CX
	JNZ     @@L1
	MOV     DX, $FFFF
	MOV     CX, Data.xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	AND     DH, DL
	MOV     AL, DH
	POP     DX
	AND     AX, Data.FillStyle
	OUT     DX, AL
	MOV     Data.SaveSD, DI
	MOV     CX, Data.yd
@@S1:
	INC     BYTE PTR [ES:DI]
	ADD     DI, BytesPerLine.word
	LOOP    @@S1
	JMP     @@E
@@L1:   MOV     DX, $FFFF
	MOV     CX, Data.xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	MOV     SI, DX
	POP     DX
	MOV     AX, SI
	AND     AX, Data.FillStyle
	OUT     DX, AL
	MOV     Data.SaveSD, DI
	MOV     CX, Data.yd
@@S2:
	INC     BYTE PTR [ES:DI]
	ADD     DI, BytesPerLine.word
	LOOP    @@S2
	MOV     DI, Data.SaveSD
	INC     DI
	MOV     AX, Data.xa
	SHR     AX, 3
	MOV     CX, Data.xe
	SHR     CX, 3
	SUB     CX, AX
	DEC     CX
	JZ      @@L2
	MOV     AX, Data.FillStyle
	OUT     DX, AL
	CLD
	PUSH    SI
	MOV     Data.SaveSD, DI
	MOV     Data.SaveCX, CX
	MOV     CX, Data.yd
@@S3:
	PUSH    CX
	MOV     CX, Data.SaveCX
	MOV     SI, DI
	REP     STOSB
	SUB     DI, Data.SaveCX
	ADD     DI, BytesPerLine.word
	POP     CX
	LOOP    @@S3
	MOV     DI, Data.SaveSD
	ADD     DI, Data.SaveCX
	POP     SI
@@L2:
	MOV     AX, SI
	MOV     AL, AH
	AND     AX, Data.FillStyle
	OUT     DX, AL
	MOV     CX, Data.yd
@@S4:
	INC     BYTE PTR [ES:DI]
	ADD     DI, BytesPerLine.word
	LOOP    @@S4
	MOV     AL, $FF
	OUT     DX, AL
	DEC     DX
	MOV     AL, $01
	OUT     DX, AL
	INC     DX
	MOV     AL, $00
	OUT     DX, AL
	JMP     @@E
@@L4:
	POP     AX
@@E:
	POP     Data.ya
	POP     Data.xe
	POP     Data.xa
	POP     Data.ye
	RETN
End;

procedure P_Bar_Multi; assembler;
Asm

	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    10
	JMP     NEAR PTR Save
@@Dr:
	POP     Data.ye
	POP     Data.ya
	POP     Data.xe
	POP     Data.xa
	MOV     AX, MetaState
	AND     AX, ms_Draw
	JZ      @@L4
	MOV     AX, MetaOrigin.X
	MOV     BX, MetaOrigin.Y
	ADD     Data.xa, AX
	ADD     Data.xe, AX
	ADD     Data.ya, BX
	ADD     Data.ye, BX
	MOV     AX, ClipRect.A.x
	MOV     BX, ClipRect.A.y
	MOV     CX, ClipRect.B.x
	MOV     DX, ClipRect.B.y
	CMP     Data.ye, BX
	JL      @@L4
	CMP     Data.ya, DX
	JNL     @@L4
	CMP     Data.xa, CX
	JNL     @@L4
	CMP     Data.xa, AX
	JG      @@T1
	MOV     Data.xa, AX
@@T1:
	CMP     Data.xe, AX
	JL      @@L4
	CMP     Data.xe, CX
	JL      @@T2
	MOV     Data.xe, CX
	DEC     Data.xe
@@T2:
	CMP     Data.ya, BX
	JG      @@T3
	MOV     Data.ya, BX
@@T3:
	CMP     Data.ye, DX
	JL      @@T4
	MOV     Data.ye, DX
	DEC     Data.ye
@@T4:
	MOV     AX, Data.xe
	SUB     AX, Data.xa
	JS      @@L4
	MOV     AX, Data.ye
	SUB     AX, Data.ya
	JS      @@L4
	INC     AX
	MOV     Data.yd, AX
	MOV     DX, 03CEh
	POP     AX
	XOR     AL, AL
	OUT     DX, AX
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, Data.WriteMode
	OUT     DX, AX
	MOV     AL, 08h
	OUT     DX, AL
	INC     DX
	PUSH    DX
	MOV     AX, ActivePSeg
	MOV     ES, AX
	MOV     AX, Data.ya
	MUL     BytesPerLine.word
	MOV     BX, Data.xa
	SHR     BX, 3
	ADD     AX, BX
	MOV     DI, AX
	ADD     DI, ActivePOfs
	MOV     AX, Data.xa
	SHR     AX, 3
	MOV     CX, Data.xe
	SHR     CX, 3
	SUB     CX, AX
	OR      CX, CX
	JNZ     @@L1
	MOV     DX, $FFFF
	MOV     CX, Data.xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	AND     DH, DL
	MOV     AL, DH
	POP     DX
	AND     AX, Data.FillStyle
	OUT     DX, AL
	MOV     Data.SaveSD, DI
	MOV     CX, Data.yd
@@S1:
	INC     BYTE PTR [ES:DI]
	ADD     DI, BytesPerLine.word
	LOOP    @@S1
	JMP     @@E
@@L1:   MOV     DX, $FFFF
	MOV     CX, Data.xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	MOV     SI, DX
	POP     DX
	MOV     AX, SI
	AND     AX, Data.FillStyle
	OUT     DX, AL
	MOV     Data.SaveSD, DI
	MOV     CX, Data.yd
@@S2:
	INC     BYTE PTR [ES:DI]
	ADD     DI, BytesPerLine.word
	LOOP    @@S2
	MOV     DI, Data.SaveSD
	INC     DI
	MOV     AX, Data.xa
	SHR     AX, 3
	MOV     CX, Data.xe
	SHR     CX, 3
	SUB     CX, AX
	DEC     CX
	JZ      @@L2
	MOV     AX, Data.FillStyle
	OUT     DX, AL
	CLD
	PUSH    SI
	MOV     Data.SaveSD, DI
	MOV     Data.SaveCX, CX
	MOV     CX, Data.yd
@@S3:
	PUSH    CX
	MOV     CX, Data.SaveCX
	MOV     SI, DI
	REP     SEGES MOVSB
	SUB     DI, Data.SaveCX
	ADD     DI, BytesPerLine.word
	POP     CX
	LOOP    @@S3
	MOV     DI, Data.SaveSD
	ADD     DI, Data.SaveCX
	POP     SI
@@L2:
	MOV     AX, SI
	MOV     AL, AH
	AND     AX, Data.FillStyle
	OUT     DX, AL
	MOV     CX, Data.yd
@@S4:
	INC     BYTE PTR [ES:DI]
	ADD     DI, BytesPerLine.word
	LOOP    @@S4
	MOV     AL, $FF
	OUT     DX, AL
	DEC     DX
	MOV     AL, $01
	OUT     DX, AL
	INC     DX
	MOV     AL, $00
	OUT     DX, AL
	JMP     @@E
@@L4:
	POP     AX
@@E:
	POP     Data.ya
	POP     Data.xe
	POP     Data.xa
	POP     Data.ye
	RETN
End;


procedure P_Point_Multi; ASSEMBLER;
ASM
	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    4
	JMP     NEAR PTR Save
@@Dr:
	POP     BX
	POP     AX
	POP     SI
	MOV     CX, MetaState
	AND     CX, ms_Draw
	JZ      @@E
	ADD     BX, MetaOrigin.X
	ADD     AX, MetaOrigin.Y
	CMP     BX, ClipRect.B.x
	JNL     @@E
	CMP     BX, ClipRect.A.x
	JL      @@E
	CMP     AX, ClipRect.B.y
	JNL     @@E
	CMP     AX, ClipRect.A.y
	JL      @@E
	MUL     BytesPerLine.word
	MOV     DI, BX
	SHR     DI, 3
	ADD     DI, AX
	AND     BX, 7
	MOV     CX, BX
	MOV     BX, 80h
	SHR     BX, CL
	MOV     DX, 03CEh
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, Data.WriteMode
	OUT     DX, AX
	MOV     AX, SI
	XOR     AL, AL
	OUT     DX, AX
	MOV     AH, BL
	MOV     AL, 8
	OUT     DX, AX
	MOV     AX, ActivePSeg
	MOV     ES, AX
	ADD     DI, ActivePOfs
	INC     BYTE PTR [ES:DI]
@@E:
	RETN
End;

procedure P_GetP_Multi; ASSEMBLER;
ASM
	POP     BX
	POP     AX
	CMP     BX, ClipRect.B.x
	JNL     @@E
	CMP     BX, ClipRect.A.x
	JL      @@E
	CMP     AX, ClipRect.B.y
	JNL     @@E
	CMP     AX, ClipRect.A.y
	JL      @@E
	MUL     BytesPerLine.word
	MOV     DI, BX
	SHR     DI, 3
	ADD     DI, AX
	AND     BX, 7
	MOV     CX, BX
	MOV     BX, 80h
	SHR     BX, CL
	ADD     DI, ActivePOfs
	MOV     SI, 0
	MOV     CX, 0
	MOV     DX, 03CEh
	MOV     AL, 4
	OUT     DX, AL
	INC     DX
	MOV     AL, 3
	OUT     DX, AL
	MOV     CL, BYTE PTR [ES:DI]
	AND     CL, BL
	JZ      @@1
	MOV     SI, 8
@@1:
	DEC     AL
	OUT     DX, AL
	MOV     CL, BYTE PTR [ES:DI]
	AND     CL, BL
	JZ      @@2
	ADD     SI, 4
@@2:
	DEC     AL
	OUT     DX, AL
	MOV     CL, BYTE PTR [ES:DI]
	AND     CL, BL
	JZ      @@3
	ADD     SI, 2
@@3:
	DEC     AL
	OUT     DX, AL
	MOV     CL, BYTE PTR [ES:DI]
	AND     CL, BL
	JZ      @@4
	INC     SI
@@4:
	MOV     AX, SI
	RETN
@@E:
	MOV     AX, 0
	RETN
END;

Procedure Check; ASSEMBLER;
ASM
	MOV     AX, 0
	MOV     BX, ClipRect.A.x
	MOV     CX, ClipRect.A.y
	MOV     DX, ClipRect.B.x
	MOV     BP, ClipRect.B.y
	CMP     SI, BX
	JNL     @@1
	MOV     AL, R_l
@@1:
	CMP     SI, DX
	JL      @@2
	MOV     AL, R_r
@@2:
	CMP     DI, CX
	JNL     @@3
	OR      AL, R_u
@@3:
	CMP     DI, BP
	JL      @@4
	OR      AL, R_o
@@4:
END;

Function Clip: Byte;
Var c1s, c2s, c1, c2, c: Byte;
    x,y : Integer;
Begin
ASM
	MOV     SI, Data.x1
	MOV     DI, Data.y1
	PUSH    BP
	CALL    Check
	POP     BP
	MOV     c1, AL
	MOV     c1s, AL
	MOV     SI, Data.x2
	MOV     DI, Data.y2
	PUSH    BP
	CALL    Check
	POP     BP
	MOV     c2, AL
	MOV     c2s, AL
END;
  if c1 or c2 = 0 then Begin Clip:=0; Exit; End;
  if c1 and c2 > 0 then Begin Clip:=1; Exit; End;
  while c1 or c2<>0 do Begin
    if c1 <>0 then c:=c1 else c:=c2;
    if c and R_l>0 then Begin
      x:=ClipRect.A.x;
      y:=Data.y1;
ASM
	MOV     BX, Data.x2
	SUB     BX, Data.x1
	JZ      @@1
	MOV     CX, ClipRect.A.x
	SUB     CX, Data.x1
	MOV     AX, Data.y2
	SUB     AX, Data.y1
	IMUL    CX
	IDIV    BX
	ADD     AX, y
	MOV     y, AX
@@1:
END;
    End
    ELSE Begin if c and R_r>0 then Begin
	x:=ClipRect.B.x-1;
	y:=Data.y1;
ASM
	MOV     BX, Data.x2
	SUB     BX, Data.x1
	JZ      @@1
	MOV     CX, ClipRect.B.x
	DEC     CX
	SUB     CX, Data.x1
	MOV     AX, Data.y2
	SUB     AX, Data.y1
	IMUL    CX
	IDIV    BX
	ADD     AX, y
	MOV     y, AX
@@1:
END;
       End
      ELSE Begin if c and R_u>0 then Begin
	  y:=ClipRect.A.y;
	  x:=Data.x1;
ASM
	MOV     BX, Data.y2
	SUB     BX, Data.y1
	JZ      @@1
	MOV     CX, ClipRect.A.y
	SUB     CX, Data.y1
	MOV     AX, Data.x2
	SUB     AX, Data.x1
	IMUL    CX
	IDIV    BX
	ADD     AX, x
	MOV     x, AX
@@1:
END;
	End
	ELSE Begin if c and R_o>0 then Begin
	    y:=ClipRect.B.y-1;
	    x:=Data.x1;
ASM
	MOV     BX, Data.y2
	SUB     BX, Data.y1
	JZ      @@1
	MOV     CX, ClipRect.B.y
	DEC     CX
	SUB     CX, Data.y1
	MOV     AX, Data.x2
	SUB     AX, Data.x1
	IMUL    CX
	IDIV    BX
	ADD     AX, x
	MOV     x, AX
@@1:
END;
	  End;
	End;
      End;
    End;
    if c=c1 then Begin
      Data.x1:=x; Data.y1:=y;
ASM
	MOV     SI, x
	MOV     DI, y
	PUSH    BP
	CALL    Check
	POP     BP
	MOV     c1, AL
END;
      if c1 and c1s >0 then Begin Clip:=1; Exit; End;
    End
    ELSE Begin
      Data.x2:=x; Data.y2:=y;
ASM
	MOV     SI, x
	MOV     DI, y
	PUSH    BP
	CALL    Check
	POP     BP
	MOV     c2, AL
END;
      if c2 and c2s >0 then Begin Clip:=1; Exit; End;
    End;
    if c1 or c2 =0 then Begin Clip:=0; Exit; End;
  End;
  Clip:=0;
End;

procedure P_Line_Multi; ASSEMBLER;
ASM
	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    6
	JMP     NEAR PTR Save
@@Dr:
	MOV     AX, MetaState
	AND     AX, ms_Draw
	JNZ     @@W
	ADD     SP, 10
	RETN
@@W:
	POP     Data.Bit
	POP     Data.y1
	POP     Data.y2
	POP     Data.x1
	POP     Data.x2
	MOV     AX, MetaOrigin.X
	ADD     Data.x1, AX
	ADD     Data.x2, AX
	MOV     AX, MetaOrigin.Y
	ADD     Data.y1, AX
	ADD     Data.y2, AX

	CALL    Clip
	OR      AL, AL
	JZ      @@CE
	RETN
@@CE:
	MOV     AX, Data.x2
	SUB     AX, Data.x1
	JNS     @@V1
	NEG     AX
	MOV     BX, Data.x1
	XCHG    BX, Data.x2
	MOV     Data.x1, BX
	MOV     BX, Data.y1
	XCHG    BX, Data.y2
	MOV     Data.y1, BX
@@V1:
	MOV     Data.xd, AX
	JNZ     @@VLW2
	MOV     AX, Data.y1
	MOV     BX, Data.y2
	CMP     AX, BX
	JL      @@VL2
	XCHG    AX, BX
@@VL2:
	PUSH    OFFSET @@VLB2
	PUSH    BX
	PUSH    AX
	PUSH    Data.x1
	PUSH    Data.Fa
	JMP     [ProgRec.P_VL]
@@VLB2:
	RETN
@@VLW2:
	MOV     AX, Data.y2
	SUB     AX, Data.y1
	MOV     Data.yd, AX
	OR      AX, AX
	JNZ     @@HLW2
	PUSH    OFFSET @@HLB2
	PUSH    Data.xa
	PUSH    Data.xe
	PUSH    Data.ya
	PUSH    Data.Fa
	PUSH    Data.x1
	PUSH    Data.x2
	PUSH    Data.y1
	JMP     [ProgRec.P_HL]
@@HLB2:
	RETN
@@HLW2:

	SHR     AX, 15
	MOV     Data.VZ, AX
	MOV     AX, BytesPerLine.word
	TEST    Data.VZ, 1
	JZ      @@M1
	NEG     AX
	NEG     Data.yd
@@M1:
	MOV     Data.diff, AX
	MOV     DX, 03CEh
	MOV     AX, Data.Bit
	MOV     AL, 0
	OUT     DX, AX
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, Data.WriteMode
	OUT     DX, AX
	MOV     AL, 08h
	OUT     DX, AL
	INC     DX
	PUSH    DX
	MOV     AX, ActivePSeg
	MOV     ES, AX
@@AG1:
@@AG3:
	MOV     AX, Data.yd
	MOV     BX, Data.xd
	MOV     DX, 0
	DIV     BX
	MOV     Data.mHi, AX
	MOV     Data.MLo, DX
	MOV     DX, Data.xd
	MOV     Data.DivXY, DX
	SHR     DX, 1
	MOV     Data.DivXY2, DX
@@AG2:
	MOV     AX, Data.y1
	MUL     BytesPerLine.word
	MOV     DI, Data.x1
	SHR     DI, 3
	ADD     DI, AX
	ADD     DI, ActivePOfs
	MOV     CX, Data.x1
	AND     CX, 0007
	MOV     Data.Bit, 128
	SHR     Data.Bit, CL
	POP     DX
	MOV     CX, Data.x2
	SUB     CX, Data.x1
	MOV     SI, Data.Bit
	MOV     AX, Data.DivXY2
	NEG     AX
	MOV     Data.msLo, AX
	MOV     Data.msHi, 0
	MOV     AX, SI
@@G3_1:
@@Z0:
	PUSH    CX
	MOV     BX, Data.mHi
	ADD     Data.msHi, BX
	MOV     BX, Data.mLo
	ADD     Data.msLo, BX
	JS      @@Z5
	INC     Data.msHi
	MOV     BX, Data.DivXY
	SUB     Data.msLo, BX
@@Z5:
	OR      Data.msHi, 0
	JZ      @@Z1
	MOV     CX, Data.msHi
	AND     AX, Data.LnStyle
	OUT     DX, AL
@@Z2:
	INC     BYTE PTR [ES:DI]
	ADD     DI, Data.diff
	LOOP    @@Z2
	ROR     SI, 1
	JNC     @@Z3
	MOV     SI, 80h
	INC     DI
@@Z3:
	MOV     AX, SI
	MOV     Data.msHi, 0
	POP     CX
	LOOP    @@Z0
	JMP     @@E
@@Z1:
	ROR     SI, 1
	JNC     @@Z4
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	INC     DI
	MOV     AX, 0
	MOV     SI, 80h
@@Z4:
	OR      AX, SI
	MOV     Data.msHi, 0
	POP     CX
	LOOP    @@Z0
@@E:
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	RETN
@@En:
	POP     DX
	RETN
END;

procedure P_Line_Multi_T; ASSEMBLER;
ASM
	POP     Data.SaveBit
	POP     Data.y1
	POP     Data.y2
	POP     Data.x1
	POP     Data.x2
	MOV     AX, Data.Thickness
	SHR     AX, 1
	MOV     BX, Data.x2
	SUB     BX, Data.x1
	JNS     @@1
	NEG     BX
@@1:
	MOV     CX, Data.y2
	SUB     CX, Data.y1
	JNS     @@2
	NEG     CX
@@2:
	CMP     BX, CX
	JG      @@3
	SUB     Data.x1, AX
	SUB     Data.x2, AX
	MOV     CX, Data.Thickness
@@L1:
	PUSH    CX
	PUSH    OFFSET  @@B
	PUSH    Data.x2
	PUSH    Data.x1
	PUSH    Data.y2
	PUSH    Data.y1
	PUSH    Data.Fa
	JMP     [ProgRec.P_LineD]
@@B:
	POP     CX
	INC     Data.x1
	INC     Data.x2
	LOOP    @@L1
	RETN
@@3:
	SUB     Data.y1, AX
	SUB     Data.y2, AX
	MOV     CX, Data.Thickness
@@L2:
	PUSH    CX
	PUSH    OFFSET  @@B2
	PUSH    Data.x2
	PUSH    Data.x1
	PUSH    Data.y2
	PUSH    Data.y1
	PUSH    Data.Fa
	JMP     [ProgRec.P_LineD]
@@B2:
	POP     CX
	INC     Data.y1
	INC     Data.y2
	LOOP    @@L2
	RETN
END;

procedure P_HL_No; assembler;
Asm
	PUSH    Data.xa
	PUSH    Data.xe
	PUSH    Data.ya
	MOV     AX, MetaOrigin.X
	MOV     BX, MetaOrigin.Y
	ADD     Data.xa, AX
	ADD     Data.xe, AX
	ADD     Data.ya, BX
	MOV     AX, ClipRect.A.x
	MOV     BX, ClipRect.A.y
	MOV     CX, ClipRect.B.x
	MOV     DX, ClipRect.B.y
	CMP     Data.Ya, BX
	JL      @@L4
	CMP     Data.Ya, DX
	JNL     @@L4
	CMP     Data.Xa, CX
	JNL     @@L4
	CMP     Data.Xa, AX
	JG      @@T1
	MOV     Data.Xa, AX
@@T1:
	CMP     Data.Xe, AX
	JL      @@L4
	CMP     Data.Xe, CX
	JL      @@T2
	MOV     Data.Xe, CX
	DEC     Data.Xe
@@T2:
	MOV     DX, 03CEh
	MOV     AX, Data.FFa
	OUT     DX, AX
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, Data.WriteMode
	OUT     DX, AX
	MOV     AL, 08h
	OUT     DX, AL
	INC     DX
	PUSH    DX
	MOV     AX, ActivePSeg
	MOV     ES, AX
	MOV     AX, Data.Ya
	MUL     BytesPerLine.word
	MOV     BX, Data.Xa
	SHR     BX, 3
	ADD     AX, BX
	MOV     DI, AX
	ADD     DI, ActivePOfs
	MOV     AX, Data.Xa
	SHR     AX, 3
	MOV     CX, Data.Xe
	SHR     CX, 3
	SUB     CX, AX
	OR      CX, CX
	JNZ     @@L1
	MOV     DX, $FFFF
	MOV     CX, Data.Xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.Xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	AND     DH, DL
	MOV     AL, DH
	POP     DX
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	JMP     @@L4
@@L1:
	MOV     DX, $FFFF
	MOV     CX, Data.Xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.Xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	MOV     SI, DX
	POP     DX
	MOV     AX, SI
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	INC     DI
	MOV     AX, Data.Xa
	SHR     AX, 3
	MOV     CX, Data.Xe
	SHR     CX, 3
	SUB     CX, AX
	DEC     CX
	JZ      @@L2
	MOV     AX, Data.LnStyle
	MOV     AL, 0FFh
	OUT     DX, AL
	CLD
	PUSH    SI
	MOV     SI, DI
	REP     STOSB
	POP     SI
@@L2:
	MOV     AX, SI
	MOV     AL, AH
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	MOV     AL, $FF
	OUT     DX, AL
	DEC     DX
	MOV     AL, $01
	OUT     DX, AL
	INC     DX
	MOV     AL, $00
	OUT     DX, AL
@@L4:
	POP     Data.ya
	POP     Data.xe
	POP     Data.xa
End;

procedure P_HL_Multio; assembler;
Asm
	PUSH    Data.xa
	PUSH    Data.xe
	PUSH    Data.ya
	MOV     AX, MetaOrigin.X
	MOV     BX, MetaOrigin.Y
	ADD     Data.xa, AX
	ADD     Data.xe, AX
	ADD     Data.ya, BX
	MOV     AX, ClipRect.A.x
	MOV     BX, ClipRect.A.y
	MOV     CX, ClipRect.B.x
	MOV     DX, ClipRect.B.y
	CMP     Data.Ya, BX
	JL      @@L4
	CMP     Data.Ya, DX
	JNL     @@L4
	CMP     Data.Xa, CX
	JNL     @@L4
	CMP     Data.Xa, AX
	JG      @@T1
	MOV     Data.Xa, AX
@@T1:
	CMP     Data.Xe, AX
	JL      @@L4
	CMP     Data.Xe, CX
	JL      @@T2
	MOV     Data.Xe, CX
	DEC     Data.Xe
@@T2:
	MOV     DX, 03CEh
	MOV     AX, Data.FFa
	OUT     DX, AX
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, Data.WriteMode
	OUT     DX, AX
	MOV     AL, 08h
	OUT     DX, AL
	INC     DX
	PUSH    DX
	MOV     AX, ActivePSeg
	MOV     ES, AX
	MOV     AX, Data.Ya
	MUL     BytesPerLine.word
	MOV     BX, Data.Xa
	SHR     BX, 3
	ADD     AX, BX
	MOV     DI, AX
	ADD     DI, ActivePOfs
	MOV     AX, Data.Xa
	SHR     AX, 3
	MOV     CX, Data.Xe
	SHR     CX, 3
	SUB     CX, AX
	OR      CX, CX
	JNZ     @@L1
	MOV     DX, $FFFF
	MOV     CX, Data.Xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.Xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	AND     DH, DL
	MOV     AL, DH
	POP     DX
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	JMP     @@L4
@@L1:
	MOV     DX, $FFFF
	MOV     CX, Data.Xa
	AND     CL, $7
	SHR     DL, CL
	MOV     CX, Data.Xe
	NOT     CL
	AND     CL, $7
	SHL     DH, CL
	MOV     SI, DX
	POP     DX
	MOV     AX, SI
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	INC     DI
	MOV     AX, Data.Xa
	SHR     AX, 3
	MOV     CX, Data.Xe
	SHR     CX, 3
	SUB     CX, AX
	DEC     CX
	JZ      @@L2
	MOV     AX, Data.LnStyle
	MOV     AL, 0FFh
	OUT     DX, AL
	CLD
	PUSH    SI
	MOV     SI, DI
	REP     SEGES MOVSB
	POP     SI
@@L2:
	MOV     AX, SI
	MOV     AL, AH
	AND     AX, Data.LnStyle
	OUT     DX, AL
	INC     BYTE PTR [ES:DI]
	MOV     AL, $FF
	OUT     DX, AL
	DEC     DX
	MOV     AL, $01
	OUT     DX, AL
	INC     DX
	MOV     AL, $00
	OUT     DX, AL
@@L4:
	POP     Data.ya
	POP     Data.xe
	POP     Data.xa
End;

procedure P_Point_Multio; ASSEMBLER;
ASM
	MOV     BX, Data.xp
	MOV     AX, Data.yp
	ADD     BX, MetaOrigin.X
	ADD     AX, MetaOrigin.Y
	CMP     BX, ClipRect.B.x
	JNL     @@E
	CMP     BX, ClipRect.A.x
	JL      @@E
	CMP     AX, ClipRect.B.y
	JNL     @@E
	CMP     AX, ClipRect.A.y
	JL      @@E
	MUL     BytesPerLine.word
	MOV     DI, BX
	SHR     DI, 3
	ADD     DI, AX
	AND     BX, 7
	MOV     CX, BX
	MOV     BX, 80h
	SHR     BX, CL
	MOV     DX, 03CEh
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, Data.WriteMode
	OUT     DX, AX
	MOV     AX, Data.Fa
	OUT     DX, AX
	MOV     AH, BL
	MOV     AL, 8
	OUT     DX, AX
	MOV     AX, ActivePSeg
	MOV     ES, AX
	ADD     DI, ActivePOfs
	INC     BYTE PTR [ES:DI]
@@E:
End;

procedure Call_FillCircle; ASSEMBLER;
ASM
	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    7
	JMP     NEAR PTR Save
@@Dr:
	MOV     AX, MetaState
	POP     Data.Y
	POP     Data.X
	POP     Data.Ym2
	POP     Data.Xm2
	POP     Data.FFa
	POP     Data.Fa
	AND     AX, ms_Draw
	JZ      @@E
	PUSH    Data.Y
	PUSH    Data.X
	MOV     AX, Data.X
	MUL     ScreenF
	DIV     Data.DivConst
	MOV     Data.X, AX
	MOV     AX, Data.ym2
	ADD     AX, Data.x
	CMP     AX, Data.LastY1
	JE      @@N1
	MOV     Data.LastY1, AX
	MOV     Data.ya, AX
	MOV     AX, Data.xm2
	SUB     AX, Data.y
	SHL     Data.Y, 1
	MOV     Data.xa, AX
	ADD     AX, Data.y
	MOV     Data.xe, AX
	MOV     AX, Data.ym2
	CMP     AX, Data.ya
	JE      @@M1
	CALL    [ProgRec.P_HL_o]
@@M1:
	MOV     AX, Data.ya
	MOV     Data.yp, AX
	MOV     AX, Data.xa
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.xe
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	SHL     Data.x, 1
	MOV     AX, Data.x
	SUB     Data.ya, AX
	CALL    [ProgRec.P_HL_o]
@@M2:
	MOV     AX, Data.ya
	MOV     Data.yp, AX
	MOV     AX, Data.xa
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.xe
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	JMP     @@No1
@@N1:
	MOV     Data.ya, AX
	MOV     AX, Data.xm2
	SUB     AX, Data.y
	SHL     Data.Y, 1
	MOV     Data.xa, AX
	ADD     AX, Data.y
	MOV     Data.xe, AX
	MOV     AX, Data.ya
	MOV     Data.yp, AX
	MOV     AX, Data.xa
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.xe
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	SHL     Data.x, 1
	MOV     AX, Data.x
	SUB     Data.ya, AX
	MOV     AX, Data.ya
	MOV     Data.yp, AX
	MOV     AX, Data.xa
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.xe
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
@@No1:
	POP     Data.X
	POP     Data.Y
	PUSH    Data.Y
	PUSH    Data.X
	DEC     Data.Y
	MOV     AX, Data.Y
	MUL     ScreenF
	DIV     Data.DivConst
	MOV     Data.Y, AX
	MOV     AX, Data.ym2
	ADD     AX, Data.y
	CMP     AX, Data.LastY2
	JE      @@N2
	CMP     AX, Data.LastY1
	JE      @@N2
	MOV     Data.LastY2, AX
	MOV     Data.ya, AX
	MOV     AX, Data.xm2
	SUB     AX, Data.x
	MOV     Data.xa, AX
	SHL     Data.x, 1
	ADD     AX, Data.x
	MOV     Data.xe, AX
	CALL    [ProgRec.P_HL_o]
@@M3:
	MOV     AX, Data.ya
	MOV     Data.yp, AX
	MOV     AX, Data.xa
	MOV     Data.xp, AX
	INC     Data.yp
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.xe
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	SHL     Data.y, 1
	MOV     AX, Data.y
	SUB     Data.ya, AX
	CALL    [ProgRec.P_HL_o]
@@M4:
	MOV     AX, Data.ya
	MOV     Data.yp, AX
	MOV     AX, Data.xa
	MOV     Data.xp, AX
	DEC     Data.yp
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.xe
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	JMP     @@No2
@@N2:
	MOV     Data.ya, AX
	MOV     AX, Data.xm2
	SUB     AX, Data.x
	MOV     Data.xa, AX
	SHL     Data.x, 1
	ADD     AX, Data.x
	MOV     Data.xe, AX
	MOV     AX, Data.ya
	MOV     Data.yp, AX
	MOV     AX, Data.xa
	MOV     Data.xp, AX
{        INC    Data.yp}
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.xe
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	SHL     Data.y, 1
	MOV     AX, Data.y
	SUB     Data.ya, AX
	MOV     AX, Data.ya
	MOV     Data.yp, AX
	MOV     AX, Data.xa
	MOV     Data.xp, AX
{        DEC    Data.yp}
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.xe
	MOV     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
@@No2:
	POP     Data.X
	POP     Data.Y
@@E:
	RETN
End;

procedure Call_Circle; ASSEMBLER;
ASM

	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    7
	JMP     NEAR PTR Save
@@Dr:
	MOV     AX, MetaState
	POP     Data.Y
	POP     Data.X
	POP     Data.Ym2
	POP     Data.Xm2
	POP     Data.FFa
	POP     Data.Fa
	AND     AX, ms_Draw
	JZ      @@E
	PUSH    Data.Y
	PUSH    Data.X
	MOV     AX, Data.Y
	MUL     ScreenF
	DIV     Data.DivConst
	MOV     Data.Y, AX
	MOV     AX, Data.xm2
	ADD     AX, Data.x
	MOV     Data.xp, AX
	MOV     AX, Data.ym2
	ADD     AX, Data.y
	MOV     Data.yp, AX
	CALL    [ProgRec.P_Point_o]
	SHL     Data.x, 1
	SHL     Data.y, 1
	MOV     AX, Data.y
	SUB     Data.yp, AX
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.x
	SUB     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.y
	ADD     Data.yp, AX
	CALL    [ProgRec.P_Point_o]
	POP     Data.x
	POP     Data.Y
	PUSH    Data.Y
	PUSH    Data.X
	MOV     AX, Data.X
	MUL     ScreenF
	DIV     Data.DivConst
	MOV     Data.X, AX
	MOV     AX, Data.xm2
	ADD     AX, Data.y
	MOV     Data.xp, AX
	MOV     AX, Data.ym2
	ADD     AX, Data.x
	MOV     Data.yp, AX
	CALL    [ProgRec.P_Point_o]
	SHL     Data.X, 1
	SHL     Data.Y, 1
	MOV     AX, Data.x
	SUB     Data.yp, AX
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.y
	SUB     Data.xp, AX
	CALL    [ProgRec.P_Point_o]
	MOV     AX, Data.x
	ADD     Data.yp, AX
	CALL    [ProgRec.P_Point_o]
	POP     Data.X
	POP     Data.Y
@@E:
	RETN
End;

procedure PutPixel; ASSEMBLER;
ASM
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	PUSH    OFFSET @@1
	MOV     AH, Color
	PUSH    AX
	MOV     AX, DrawOrigin.X
	MOV     BX, DrawOrigin.Y
	ADD     x, AX
	ADD     y, BX
	PUSH    y
	PUSH    x
	JMP     [ProgRec.P_Point]
@@1:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	CALL    RestoreRegs
@@BGIr:
END;

function GetPixel; ASSEMBLER;
ASM
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	PUSH    OFFSET @@1
	MOV     AX, DrawOrigin.x
	MOV     BX, DrawOrigin.y
	ADD     x, AX
	ADD     y, BX
	PUSH    y
	PUSH    x
	JMP     [ProgRec.P_GetP]
@@1:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	PUSH    AX
	CALL    RestoreRegs
	POP     AX
@@BGIr:
END;

procedure HoriLine; ASSEMBLER;
ASM
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	MOV     AX, x1
	CMP     AX, x2
	JL      @@S
	XCHG    AX, x2
	MOV     x1, AX
@@S:
	PUSH    OFFSET @@1
	PUSH    Data.xa
	PUSH    Data.xe
	PUSH    Data.ya
	PUSH    Data.Fa
	MOV     AX, DrawOrigin.X
	MOV     BX, DrawOrigin.Y
	ADD     x1, AX
	ADD     y1, BX
	ADD     x2, AX
	PUSH    x1
	PUSh    x2
	PUSH    y1
	JMP     [ProgRec.P_HL]
@@1:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	CALL    RestoreRegs
@@BGIr:
END;

procedure VertLine; ASSEMBLER;
ASM
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	MOV     AX, y1
	CMP     AX, y2
	JL      @@S
	XCHG    AX, y2
	MOV     y1, AX
@@S:
	PUSH    OFFSET @@1
	MOV     AX, DrawOrigin.X
	MOV     BX, DrawOrigin.Y
	ADD     x1, AX
	ADD     y1, BX
	ADD     y2, BX
	PUSH    y2
	PUSH    y1
	PUSH    x1
	PUSH    Data.Fa
	JMP     [ProgRec.P_VL]
@@1:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	CALL    RestoreRegs
@@BGIr:
END;

procedure Line; ASSEMBLER;
ASM
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	PUSH    OFFSET  @@1
	MOV     AX, DrawOrigin.X
	MOV     BX, DrawOrigin.Y
	ADD     x1, AX
	ADD     y1, BX
	ADD     x2, AX
	ADD     y2, BX
	PUSH    x2
	PUSH    x1
	PUSH    y2
	PUSH    y1
	PUSH    Data.Fa
	JMP     [ProgRec.P_Line]
@@1:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	CALL    RestoreRegs
@@BGIr:
END;

procedure MoveTo; ASSEMBLER;
ASM
	MOV     AX, x
	MOV     Data.xl, AX
	MOV     AX, y
	MOV     Data.yl, AX
End;

procedure MoveRel; ASSEMBLER;
ASM
	MOV     AX, x
	ADD     Data.xl, AX
	MOV     AX, y
	ADD     Data.yl, AX
END;

procedure LineTo; ASSEMBLER;
ASM
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	MOV     AX, Data.xl
	MOV     BX, x
	MOV     Data.xl, BX
	MOV     CX, Data.yl
	MOV     DX, y
	MOV     Data.yl, DX
	CMP     AX, BX
	JL      @@S
	XCHG    AX, BX
	XCHG    CX, DX
@@S:
	PUSH    OFFSET  @@1
	ADD     AX, DrawOrigin.X
	ADD     BX, DrawOrigin.X
	ADD     CX, DrawOrigin.Y
	ADD     DX, DrawOrigin.Y
	PUSH    BX
	PUSH    AX
	PUSH    DX
	PUSH    CX
	PUSH    Data.Fa
	JMP     [ProgRec.P_Line]
@@1:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	CALL    RestoreRegs
@@BGIr:

END;

procedure LineRel; ASSEMBLER;
ASM
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	MOV     AX, Data.xl
	MOV     BX, AX
	ADD     BX, x
	MOV     Data.xl, BX
	MOV     CX, Data.yl
	MOV     DX, CX
	ADD     DX, y
	MOV     Data.yl, DX
	CMP     AX, BX
	JL      @@S
	XCHG    AX, BX
	XCHG    CX, DX
@@S:
	PUSH    OFFSET  @@1
	ADD     AX, DrawOrigin.X
	ADD     BX, DrawOrigin.X
	ADD     CX, DrawOrigin.Y
	ADD     DX, DrawOrigin.Y
	PUSH    BX
	PUSH    AX
	PUSH    DX
	PUSH    CX
	PUSH    Data.Fa
	JMP     [ProgRec.P_Line]
@@1:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	CALL    RestoreRegs
@@BGIr:
END;


procedure Rectangle; ASSEMBLER;
ASM
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	MOV     AX, x1
	CMP     AX, x2
	JL      @@S1
	MOV     BX, x2
	MOV     x1, BX
	MOV     x2, AX
@@S1:
	MOV     AX, y1
	CMP     AX, y2
	JL      @@S2
	MOV     BX, y2
	MOV     y1, BX
	MOV     y2, AX
@@S2:
	MOV     AX, DrawOrigin.X
	MOV     BX, DrawOrigin.Y
	ADD     x1, AX
	ADD     x2, AX
	ADD     y1, BX
	ADD     y2, BX
	PUSH    OFFSET   @@1
	PUSH    Data.xa
	PUSH    Data.xe
	PUSH    Data.ya
	PUSH    Data.Fa
	PUSH    x1
	PUSH    x2
	PUSH    y1
	JMP     [ProgRec.P_HL]
@@1:
	MOV     AX, y2
	CMP     AX, y1
	JE      @@E
	PUSH    OFFSET   @@2
	PUSH    Data.xa
	PUSH    Data.xe
	PUSH    Data.ya
	PUSH    Data.Fa
	PUSH    x1
	PUSH    x2
	PUSH    y2
	JMP     [ProgRec.P_HL]
@@2:
	MOV     AX, y2
	SUB     AX, y1
	CMP     AX, 1
	JNG     @@E
	INC     y1
	DEC     y2
	PUSH    OFFSET  @@3
	PUSH    y2
	PUSH    y1
	PUSH    x1
	PUSH    Data.Fa
	JMP     [ProgRec.P_VL]
@@3:
	PUSH    OFFSET  @@4
	PUSH    y2
	PUSH    y1
	PUSH    x2
	PUSH    Data.Fa
	JMP     [ProgRec.P_VL]
@@4:
@@E:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	CALL    RestoreRegs
@@BGIr:
END;

procedure Bar; ASSEMBLER;
ASM
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	MOV     AX, x1
	CMP     AX, x2
	JL      @@S1
	MOV     BX, x2
	MOV     x1, BX
	MOV     x2, AX
@@S1:
	MOV     AX, y1
	CMP     AX, y2
	JL      @@S2
	MOV     BX, y2
	MOV     y1, BX
	MOV     y2, AX
@@S2:
	MOV     AX, DrawOrigin.X
	MOV     BX, DrawOrigin.Y
	ADD     x1, AX
	ADD     x2, AX
	ADD     y1, BX
	ADD     y2, BX
	PUSH    OFFSET @@1
	PUSH    Data.xa
	PUSH    Data.xe
	PUSH    Data.ya
	PUSH    Data.ye
	PUSH    Data.FFa
	PUSH    x1
	PUSH    x2
	PUSH    y1
	PUSH    y2
	JMP     [ProgRec.P_Bar]
@@1:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	CALL    RestoreRegs
@@BGIr:
END;

procedure Circle;ASSEMBLER;
ASM
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	TEST    r, 08000h
	JZ      @@S
	NEG     r
@@S:
	CMP     r, 1
	JNG     @@E
	MOV     AX, DrawOrigin.X
	MOV     BX, DrawOrigin.Y
	ADD     xm, AX
	ADD     ym, BX
	MOV     AX, xm
	MOV     Data.xm2, AX
	MOV     AX, ym
	MOV     Data.ym2, AX
	MOV     DX, 03CEh
	MOV     AL, 0
	MOV     AX, Data.Fa
	OUT     DX, AX
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, r
	MOV     Data.y, AX
	SHL     AX, 1
	MOV     BX, 3
	SUB     BX, AX
	MOV     DX, BX
	MOV     Data.x, 0
	PUSH    DX
	PUSH    OFFSET  @@B1
	PUSH    Data.Fa
	PUSH    Data.FFa
	PUSH    Data.xm2
	PUSH    Data.ym2
	PUSH    Data.x
	PUSH    Data.y
	JMP     NEAR PTR Call_Circle
@@B1:
	MOV     AX, r
	MOV     BX, 7071
	MUL     BX
	DIV     Data.DivConst
	MOV     CX, AX
	INC     CX
	POP     DX
@@2:
	PUSH    CX
	CMP     DX, 0
	JG      @@3
	MOV     AX, Data.x
	SHL     AX, 2
	ADD     DX, AX
	ADD     DX, 2
	JMP     @@4
@@3:
	MOV     AX, Data.x
	SUB     AX, Data.y
	SHL     AX, 2
	ADD     DX, AX
	ADD     DX, 6
	DEC     Data.y
@@4:
	PUSH    DX
	PUSH    OFFSET  @@B2
	PUSH    Data.Fa
	PUSH    Data.FFa
	PUSH    Data.xm2
	PUSH    Data.ym2
	PUSH    Data.x
	PUSH    Data.y
	JMP     NEAR PTR Call_Circle
@@B2:
	POP     DX
	POP     CX
	INC     Data.x
	LOOP    @@2
@@E:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	CALL    RestoreRegs
@@BGIr:
END;

procedure FillCircle;ASSEMBLER;
ASM
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	TEST    r, 08000h
	JZ      @@S
	NEG     r
@@S:
	CMP     r, 1
	JNG     @@E
	MOV     Data.LastY1, -30000
	MOV     Data.LastY2, -30000
	MOV     AX, DrawOrigin.X
	MOV     BX, DrawOrigin.Y
	ADD     xm, AX
	ADD     ym, BX
	PUSH    DS
	PUSH    Data.LnStyle
	MOV     Data.LnStyle, 0FFFFh
	MOV     AX, xm
	MOV     Data.xm2, AX
	MOV     AX, ym
	MOV     Data.ym2, AX
	JMP     @@1
@@1:
	MOV     AX, r
	MOV     Data.y, AX
	SHL     AX, 1
	MOV     BX, 3
	SUB     BX, AX
	MOV     DX, BX
	MOV     Data.x, 0
	PUSH    DX
	PUSH    OFFSET  @@B1
	PUSH    Data.Fa
	PUSH    Data.FFa
	PUSH    Data.xm2
	PUSH    Data.ym2
	PUSH    Data.x
	PUSH    Data.y
	JMP     NEAR PTR Call_FillCircle
@@B1:
	MOV     AX, r
	MOV     BX, 7071
	MUL     BX
	DIV     Data.DivConst
	MOV     CX, AX
	CMP     DX, 5400
	JNA     @@Kor
	INC     CX
@@Kor:
	INC     CX
	POP     DX
@@2:
	PUSH    CX
	CMP     DX, 0
	JNL     @@3
	MOV     AX, Data.x
	SHL     AX, 2
	ADD     DX, AX
	ADD     DX, 2
	JMP     @@4
@@3:
	MOV     AX, Data.x
	SUB     AX, Data.y
	SHL     AX, 2
	ADD     DX, AX
	ADD     DX, 6
	DEC     Data.y
@@4:
	PUSH    DX
	PUSH    OFFSET  @@B2
	PUSH    Data.Fa
	PUSH    Data.FFa
	PUSH    Data.xm2
	PUSH    Data.ym2
	PUSH    Data.x
	PUSH    Data.y
	JMP     NEAR PTR Call_FillCircle
@@B2:
	POP     DX
	POP     CX
	INC     Data.x
	LOOP    @@2
	POP     Data.LnStyle
	POP     DS
@@E:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	CALL    RestoreRegs
@@BGIr:
END;

procedure SetColor; ASSEMBLER;
ASM
	MOV     AH, Color
	MOV     AL, 0
	MOV     Data.Fa, AX
END;

procedure SetFillStyle;
Begin
  Data.FFa:=Color shl 8;
  Data.FillStyle:=FillPattern[FillStyle];
End;

procedure SetLineStyle;
Begin
  if LineStyle>3 then Data.LnStyle:=Pattern
		 else Data.LnStyle:=LnPattern[LineStyle];
  Data.Thickness:=Thickness;
  if Thickness = 1 then ProgRec.P_Line:=ProgRec.P_LineD
		   else ProgRec.P_Line:=Ofs(P_Line_Multi_T);
End;

procedure DoNormalMode; near; Assembler;
ASM
	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    1
	JMP     NEAR PTR Save
@@Dr:
	mov     Data.WriteMode, 0003h
	retn
End;

procedure DoXorMode; near; Assembler;
ASM
	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    1
	JMP     NEAR PTR Save
@@Dr:
	mov     Data.WriteMode, 1803h
	retn
End;

procedure DoOrMode; near; Assembler;
ASM
	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    1
	JMP     NEAR PTR Save
@@Dr:
	mov     Data.WriteMode, 1003h
	retn
End;

procedure DoAndMode; near; Assembler;
ASM
	MOV     AX, MetaState
	AND     AX, ms_Record
	JZ      @@Dr
	PUSH    OFFSET @@Dr
	PUSH    1
	JMP     NEAR PTR Save
@@Dr:
	mov     Data.WriteMode, 0803h
	retn
End;


procedure SetWriteMode;
Begin
  Case Mode of
    NormalPut, CopyPut:
    ASM
	MOV     ProgRec.P_VL, OFFSET P_VL_Multi
	MOV     ProgRec.P_HL, OFFSET P_HL_N
	MOV     ProgRec.P_Bar, OFFSET P_Bar_N
	MOV     ProgRec.P_Point, OFFSET P_Point_Multi
	MOV     ProgRec.P_GetP, OFFSET P_GetP_Multi
	MOV     ProgRec.P_LineD, OFFSET P_Line_Multi
	MOV     ProgRec.P_HL_o, OFFSET P_HL_No
	MOV     ProgRec.P_Point_o, OFFSET P_Point_Multio
	CALL	DoNormalMode
    END;
    XorPut:
    ASM
	MOV     ProgRec.P_VL, OFFSET P_VL_Multi
	MOV     ProgRec.P_HL, OFFSET P_HL_Multi
	MOV     ProgRec.P_Bar, OFFSET P_Bar_Multi
	MOV     ProgRec.P_Point, OFFSET P_Point_Multi
	MOV     ProgRec.P_GetP, OFFSET P_GetP_Multi
	MOV     ProgRec.P_LineD, OFFSET P_Line_Multi
	MOV     ProgRec.P_HL_o, OFFSET P_HL_Multio
	MOV     ProgRec.P_Point_o, OFFSET P_Point_Multio
	CALL	DoXorMode
    END;
    OrPut:
    ASM
	MOV     ProgRec.P_VL, OFFSET P_VL_Multi
	MOV     ProgRec.P_HL, OFFSET P_HL_Multi
	MOV     ProgRec.P_Bar, OFFSET P_Bar_Multi
	MOV     ProgRec.P_Point, OFFSET P_Point_Multi
	MOV     ProgRec.P_GetP, OFFSET P_GetP_Multi
	MOV     ProgRec.P_LineD, OFFSET P_Line_Multi
	MOV     ProgRec.P_HL_o, OFFSET P_HL_Multio
	MOV     ProgRec.P_Point_o, OFFSET P_Point_Multio
	CALL	DoOrMode
    END;
    AndPut:
    ASM
	MOV     ProgRec.P_VL, OFFSET P_VL_Multi
	MOV     ProgRec.P_HL, OFFSET P_HL_Multi
	MOV     ProgRec.P_Bar, OFFSET P_Bar_Multi
	MOV     ProgRec.P_Point, OFFSET P_Point_Multi
	MOV     ProgRec.P_GetP, OFFSET P_GetP_Multi
	MOV     ProgRec.P_LineD, OFFSET P_Line_Multi
	MOV     ProgRec.P_HL_o, OFFSET P_HL_Multio
	MOV     ProgRec.P_Point_o, OFFSET P_Point_Multio
	CALL	DoAndMode
    END;
  END;
End;

procedure ClearDevice; ASSEMBLER;
ASM
	MOV     DX, 03CEh
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, 0003
	OUT     DX, AX
	MOV     AX, 0000
	OUT     DX, AX
	MOV     AX, 0FF08h
	OUT     DX, AX
	MOV     AX, ActivePSeg
	MOV     ES, AX
	MOV     DI, 0
	MOV     CX, 8000h
	MOV     AX, 0
	REP     STOSW
END;

procedure ClearPage; ASSEMBLER;
ASM
	MOV     DX, 03CEh
	MOV     AX, 0F01h
	OUT     DX, AX
	MOV     AX, 0003
	OUT     DX, AX
	MOV     AX, 0000
	OUT     DX, AX
	MOV     AX, 0FF08h
	OUT     DX, AX
	MOV     AX, ActivePSeg
	MOV     ES, AX
	MOV     DI, ActivePOfs
	MOV     AX, SizeY
	MUL     BytesPerLine.word
	MOV     CX, AX
	MOV     AX, 0
	REP     STOSB
END;

{$endif  }

function GetBuffer;
Var h:Pointer;
Begin
  if Size>65520 then Size:=65520;
  h:=MemAllocSeg(Size+8);
  if h<>nil then ASM
      LES       DI, h
      MOV       CX, Size
      MOV       AX, 0
      REP       STOSB
      MOV       DI, 0
      MOV       AX, Size
      MOV       WORD PTR [ES:DI], AX
      MOV       WORD PTR 2[ES:DI], 1
      MOV       WORD PTR 4[ES:DI], 10
      MOV       WORD PTR 6[ES:DI], AX
      MOV       BX, EndPtr
      MOV       WORD PTR 8[ES:DI], BX
  End
  ELSE Begin
    UserParams(me_Memory);
    DefaultErrorProc;
  End;
  Data.Error:=me_NoError;
  GetBuffer:=h;
End;

procedure SetBuffer;
Begin
  if Buffer=nil then Begin
    UserParams(me_Buffer);
    DefaultErrorProc;
    Exit;
    ValidBuffer:=0;
  End
  ELSE DrawPtr:=Buffer;
  Data.Error:=me_NoError;
  ValidBuffer:=1;
End;

procedure DrawBuffer; ASSEMBLER;
ASM
	MOV     AX, ms_Record
	NOT     AX
	AND     MetaState, AX
	MOV     Data.SaveBP, BP
	TEST    MetaState, ms_BGI
	JZ      @@BGIs
	CALL    SaveRegs
@@BGIs:
	CMP     ScanBackPtr, 1
	JE      @@Dr
	MOV     BackPtr, OFFSET @@Ba
	MOV     EndPtr, OFFSET @@En
	MOV     ExtPtr, OFFSET @@EX
	MOV     ScanBackPtr, 1
	JMP     @@E
@@Dr:
	TEST    ValidBuffer, 1
	JNZ     @@S
	MOV     AX, me_Buffer
	CALL    DefaultErrorProc
	JMP     @@E
@@S:
	TEST    ValidStack, 1
	JNZ     @@S2
	MOV     AX, me_Stack
	CALL    DefaultErrorProc
	JMP     @@E
@@S2:
	CLD
	MOV     BX, DS
	LES     DI, Stack
{	MOV     CX, 32760
	MOV     AX, 0
	REP     STOSW}
	LES     DI, Stack
	MOV     DI, 0
	LDS     SI, Buffer
	MOV     CX, WORD PTR 4[DS:SI]
	SUB     DI, CX
	MOV     AX, WORD PTR 2[DS:SI]
	CMP     AX, 1
	JE      @@NR
	SUB     CX, 10
	ADD     SI, 8
	LODSW
	SUB     DI, 12
	PUSH    DI
	REP     MOVSB
@@NR:
	STOSW
	MOV     AX, SS
	STOSW
	MOV     AX, SP
	SUB     AX, 2
	STOSW
	POP     DI
	PUSH    ES
	POP     SS
	MOV     SP, DI
	MOV     DS, BX
@@L:
	RETN
@@EX:
	POP     AX
	POP     BX
	POP     DI
	POP     SI
	MOV     BP, SP
	ADD     BP, DI
	SUB     SP, SI
	SUB     SP, DI
	PUSH    BX
	PUSH    AX
	RETF
@@Ba:
	JMP     @@L
@@En:
	POP     AX
	POP     BX
	MOV     SS, AX		{ MK }
	MOV     SP, BX
@@E:
	TEST    MetaState, ms_BGI
	JZ      @@BGIr
	CALL    RestoreRegs
@@BGIr:
	MOV     BP, Data.SaveBP
End;

procedure FreeBuffer;
Var Size:Word;
Begin
  if Buffer=nil then Begin
    UserParams(me_Buffer);
    DefaultErrorProc;
    Exit;
  End;
  if Buffer=DrawPtr then ValidBuffer:=0;
  ASM
      LES       DI, Buffer
      MOV       AX, WORD PTR [ES:DI]
      MOV       Size, AX
  End;
  FreeMem(Buffer,Size+8);
  Data.Error:=0;
End;

procedure ClearBuffer;
Begin
  if Buffer=nil then Begin
    UserParams(me_Buffer);
    DefaultErrorProc;
    Exit;
  End;
  ASM
	LES     DI, Buffer
	MOV     WORD PTR [ES:DI],10
  End;
End;

procedure Save; ASSEMBLER;
ASM
	cld
	POP     AX
	TEST    ValidBuffer, 1
	JNZ     @@S
	MOV     AX, me_Buffer
	CALL    DefaultErrorProc
	RETN
@@S:
	LES     DI, DrawPtr
	MOV     SI, SP
	PUSH    DS
	MOV     DX, BackPtr
	PUSH    SS
	POP     DS
	MOV     CX, AX
	MOV     BX, AX
	SHL     BX, 1
	ADD     BX, 2
	CMP     WORD PTR 6[ES:DI], BX
	JB      @@Er
	ADD     DI, WORD PTR 4[ES:DI]
	REP     MOVSW
	MOV     AX, DX
	STOSW
	MOV     DI, 0
	INC     WORD PTR 2[ES:DI]
	ADD     WORD PTR 4[ES:DI], BX
	SUB     WORD PTR 6[ES:DI], BX
	POP     DS
	RETN
@@Er:
	POP     DS
	MOV     AX, me_Full
	CALL    DefaultErrorProc
	RETN
END;

procedure SaveExt; ASSEMBLER;
ASM
	TEST    ValidBuffer, 1
	JNZ     @@W1
	MOV     AX, me_Buffer
	CALL    DefaultErrorProc
	JMP     @@E
@@W1:
	MOV     Data.SaveBP, BP
	MOV     BP, SP
	INC     WORD PTR SS:[BP+4]
	AND     WORD PTR SS:[BP+4], 0FFFEh
	INC     WORD PTR SS:[BP+8]
	AND     WORD PTR SS:[BP+8], 0FFFEh
	MOV     CX, [BP+6]
	MOV     DX, CX
	LES     DI, DrawPtr
	MOV     BX, CX
	ADD     BX, 1038
	ADD     BX, [BP+4]
	CMP     BX, 6[ES:DI]
	JNA     @@W2
	MOV     AX, me_Full
	CALL    DefaultErrorProc
	JMP     @@E
@@W2:
	MOV     DI, 4[ES:DI]
	MOV     AX, ExtPtr
	STOSW
	MOV     AX, [BP]
	STOSW
	MOV     AX, [BP+2]
	STOSW
	MOV     AX, [BP+4]
	STOSW
	MOV     AX, [BP+8]
	STOSW
	PUSH    DS
	PUSH    SS
	POP     DS
	MOV     SI, SP
	ADD     SI, 12
	ADD     SI, [BP+8]
	SUB     SI, [BP+4]
	MOV     CX, [BP+4]
	OR      CX, CX
	JZ      @@M1
	REP     MOVSB
@@M1:
	POP     DS
	MOV     AX, BP
	STOSW
	MOV     AX, BackPtr
	STOSW
	MOV     AX, CS
	STOSW
	PUSH    DS
	PUSH    SS
	POP     DS
	MOV     SI, SP
	ADD     SI, 18
	ADD     SI, [BP+8]
	MOV     CX, [BP+6]
	REP     MOVSB
	POP     DS
	ADD     DX, 16
	ADD     DX, [BP+4]
	LES     DI, DrawPtr
	SUB     6[ES:DI], DX
	ADD     4[ES:DI], DX
	INC     WORD PTR 2[ES:DI]
@@E:
	POP     AX
	POP     BX
	ADD     SP, 6
	PUSH    BX
	PUSH    AX
	MOV     BP, Data.SaveBP
	RETF
END;

procedure SetMetaState;
Begin
  MetaState:=State
End;

procedure GetBufferInfo;
Var h: TBufferInfo;
Begin
  if Buffer=nil then Begin
    UserParams(me_Buffer);
    DefaultErrorProc;
    h.Count:=0; h.Free:=0;
    BufferInfo:=h;
    Exit;
  End;
  ASM
	LES     DI, Buffer
	MOV     AX, WORD PTR 2[ES:DI]
	MOV     h.Count, AX
	MOV     AX, WORD PTR 6[ES:DI]
	MOV     h.Free, AX
  END;
BufferInfo:=h;
End;

function FullBuffer;
Var h:Word;
Begin
  if Buffer=nil then Begin
    UserParams(me_Buffer);
    DefaultErrorProc;
    FullBuffer:=true;
    Exit;
  End;
  ASM
	LES     DI, Buffer
	MOV     AX, WORD PTR 6[ES:DI]
	MOV     h, AX
  END;
  if h>Data then FullBuffer:=False
	    else FullBuffer:=True;

End;

function MetaFunctions; ASSEMBLER;
ASM
	MOV     AX, ScanBackPtr
	AND     AX, ValidBuffer
	AND     AX, ValidStack
END;

{ 
}

procedure SetRGBColor; ASSEMBLER;
ASM
	MOV     AX, 1010h
	MOV     BL, Color
	MOV     BH, 0
	MOV     CH, G
	MOV     CL, B
	MOV     DH, R
	INT     10h
END;

procedure SetRGBColorEntry;
Begin
  MColors^[Color,1]:=R;
  MColors^[Color,2]:=G;
  MColors^[Color,3]:=B;
END;

procedure GetRGBColorEntry;
Begin
  R:=MColors^[Color,1];
  G:=MColors^[Color,2];
  B:=MColors^[Color,3];
END;

procedure SetRGBColors; ASSEMBLER;
ASM
	LES     DX, Colors
	MOV     AX, ES
	OR      DX, AX
	JNZ     @@1
	LES     DX, MColors
@@1:
	MOV     BL, Start
	MOV     BH, 0
	MOV     CL, Count
	MOV     CH, 0
	MOV     AX, 1012h
	INT     10h
END;

procedure GetRGBColors; ASSEMBLER;
ASM
	LES     DX, Colors
	MOV     AX, ES
	OR      DX, AX
	JNZ     @@1
	LES     DX, MColors
@@1:
	MOV     BL, Start
	MOV     BH, 0
	MOV     CL, Count
	MOV     CH, 0
	MOV     AX, 1017h
	INT     10h
END;

procedure SetPalette; ASSEMBLER;
ASM
	MOV     AX, 1000h
	MOV     BH, Color
	MOV     BL, Palette
	INT     10h
END;

function GetPalette; ASSEMBLER;
ASM
	MOV     AX, 1007h
	MOV     BL, Palette
	INT     10h
	MOV     AX, BX
END;

procedure GetRGBColor;
Var hR, hB, hG: Byte;
Begin
  ASM
	MOV     AX, 1015h
	MOV     BL, Color
	MOV     BH, 0
	INT     10h
	MOV     hR, DH
	MOV     hG, CH
	MOV     hB, CL
  END;
  R:=hR;
  G:=hG;
  B:=hB;
End;

procedure SetPaletteEntry;
Begin
  MPalettes^[Palette]:=Color;
End;

function GetPaletteEntry;
Begin
  GetPaletteEntry:=MPalettes^[Palette];
End;

procedure SetPalettes; ASSEMBLER;
ASM
	MOV     AX, 1002h
	LES     DX, Palettes
	MOV     BX, ES
	OR      DX, BX
	JNZ     @@1
	LES     DX, MPalettes
@@1:
	INT     10h
END;

procedure GetPalettes; ASSEMBLER;
ASM
	MOV     AX, 1009h
	LES     DX, Palettes
	MOV     BX, ES
	OR      DX, BX
	JNZ     @@1
	LES     DX, MPalettes
@@1:
	INT     10h
END;

procedure SetBorder; ASSEMBLER;
ASM
	MOV     AX, 1001h
	MOV     BH, Color
	INT     10h
END;

function GetBorder; ASSEMBLER;
ASM
	MOV     AX, 1008h
	INT     10h
	MOV     AX, BX
END;

procedure Copyright; ASSEMBLER;
ASM
	RET
	DB      "MetaGr (C) Daniel Mahrenholz"
END;

procedure SaveRegs; ASSEMBLER;
ASM
	PUSHF
	CLD
	MOV     DI, OFFSET Data.UserRegArea
	MOV     AX, DS
	MOV     ES, AX
	MOV     DX, 03CEH
	MOV     AL, 3
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	DEC     DX
	STOSB
	MOV     AL, 1
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	DEC     DX
	STOSB
	MOV     AL, 8
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	DEC     DX
	STOSB
	MOV     AL, 5
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	STOSB
	MOV     DX, 03C4H
	MOV     AL, 2
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	STOSB
	POPF
End;

procedure RestoreRegs; ASSEMBLER;
ASM
	PUSHF
	CLD
	MOV     SI, OFFSET Data.UserRegArea
	MOV     DX, 03CEH
	MOV     AH, 3
	LODSB
	XCHG    AH, AL
	OUT     DX, AX
	MOV     AH, 1
	LODSB
	XCHG    AH, AL
	OUT     DX, AX
	MOV     AH, 8
	LODSB
	XCHG    AH, AL
	OUT     DX, AX
	INC     SI
	MOV     DX, 03C4H
	MOV     AH, 2
	LODSB
	XCHG    AH, AL
	OUT     DX, AX
	POPF
END;

function ChMetaParams;
Begin
  case Lo(Cmd) of
    gcpColor:
    begin
      ChMetaParams := SizeOf(Word);
      case Hi(Cmd) of
	Hi(gcpSetParams):
	  Data.Fa := Byte(Buf) * 256;
	Hi(gcpGetParams):
	  Word(Buf) := Data.Fa div 256;
      end
    end;
    gcpLineStyle:
    begin
      ChMetaParams := 4;
      case Hi(Cmd) of
	Hi(gcpSetParams):
	  Move(Buf, Data.LnStyle, 4);
	Hi(gcpGetParams):
	  Move(Data.LnStyle, Buf, 4);
      end
    end;
    gcpSolidThLn:
    begin
      ChMetaParams := 2;
      case Hi(Cmd) of
	Hi(gcpSetParams):
	  SetLineStyle(0, 0, Word(Buf));
      end
    end;
  else ChMetaParams := 0;
  end
End;

procedure InitMetaGr;
Begin
  if Stack=nil then Stack:=MemAllocSeg(65520);
  if Stack<>nil then ValidStack:=1
    ELSE ASM
	MOV     AX, me_Stack
	CALL    DefaultErrorProc
    END;
End;

procedure DoneMetaGr;
Begin
 if Stack<>nil then Begin
   FreeMem(Stack, 65520);
   Stack:=nil;
   ValidStack:=0;
 End;
End;

Procedure InitDataRec;
Begin
  Data.DivConst:=10000;
  Data.Fa:=3840;
  Data.FFa:=3840;
  CopyRight;
  MetaState:=ms_Draw;
  @ErrorProc:=nil;
  Stack:=nil;
End;

procedure SetMetaOrigin; ASSEMBLER;
ASM
	MOV     AX, x
	MOV     MetaOrigin.x, AX
	MOV     AX, y
	MOV     MetaOrigin.y, AX
END;

procedure SetMetaOriginP; ASSEMBLER;
ASM
	MOV     AX, P.x
	MOV     MetaOrigin.x, AX
	MOV     AX, P.y
	MOV     MetaOrigin.y, AX
END;

procedure SetMetaClipRect; ASSEMBLER;
ASM
	PUSH    DS
	POP     ES
	MOV     DI, OFFSET MetaClipRect
	CLD
	MOV     AX, x1
	STOSW
	MOV     AX, y1
	STOSW
	MOV     AX, x2
	STOSW
	MOV     AX, y2
	STOSW
END;

procedure SetMetaClipRectR; ASSEMBLER;
ASM
	PUSH    DS
	PUSH    DS
	POP     ES
	MOV     DI, OFFSET MetaClipRect
	LDS     SI, R
	MOV     CX, 4
	REP     MOVSW
	POP     DS
END;

BEGIN
  New(MColors);
  New(MPalettes);
  DrawBuffer(nil);
{$ifndef metagr_bgi}
  SetWriteMode(NormalPut);
  SetLineStyle(solidLn, 0, 1);
{$endif}
  SetMetaOrigin(0,0);
  SetMetaClipRectR(ClipRect);
  InitDataRec;
  If qMetaExtSave > qExtSave then Begin
    qExtSave:= qMetaExtSave;
     ExtSave:= @SaveExt
  End;
{$ifndef metagr_bgi}
  If qMetaLine > qLineProc then Begin
    qLineProc := qMetaLine;
     LineProc := Line
  End;
  If qChMetaParams > qChParamsProc then Begin
    qChParamsProc := qChMetaParams;
     ChParamsProc :=  ChMetaParams
  End;
{$else}
  GlobalOptions := GlobalOptions and not ofBuffer
{$endif}
END.

