{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Location/Polynom.pas             [x] Protected mode

  Polynom algebra demonstration. EFLIB delivers a complete polynom
  class that features all the standard arithmetics for polynoms.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFMATH, EFSTREAM;


var P, Q : tPolynomial;

begin
     WriteLn ('*** Polynomial algebra ***');

     with P do begin

          Initialize (3); { 3rd order polynomial, ie. 4 coefficients }

          SetCoefficient (1,  1); { 1 }
          SetCoefficient (2, -1); { -x }
          SetCoefficient (3, -4); { -4x^3 }
          SetCoefficient (4,  5); { 5x^4 }

          Write ('P = ');
          StreamWrite (StdIO); WriteLn;

          with Q do begin

               Initialize (2); { 2nd order polynomial }

               SetCoefficient (1, 0); { 0 }
               SetCoefficient (2, 2); { 2x }
               SetCoefficient (3, 1); { x^2 }

               Write ('Q = ');
               StreamWrite (StdIO); WriteLn;

               P.Add (@Q);

               Write ('P + Q = ');
               P.StreamWrite (StdIO); WriteLn;


          end;

          Intercept;

     end;

end.