{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Queues/Queue1.pas       [x] Protected mode

  Demonstration of the queue ADT.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDATA, EFTEST;


var MyQueue : tQueue; Index, Number : integer;

begin
     MemPush; { EFTEST }

     { Initializes queue and stores 25 integer numbers in structure }
     with MyQueue do begin

          Initialize (SizeOf(Integer));
                      { Element size }

          { Queue operations:

            Enqueue (Data) - add an element to the queue.
            Dequeue (Data) - retrieve "the oldest" element and delete it.
            Skip (Data) - erase "the oldest" element. }

          { Place numbers in queue }
          for Index := 1 to 25 do Enqueue (Index);

          { Dequeue numbers until the queue
            is empty. }
          while not IsEmpty do begin
                Dequeue (Number);
                Write (Number : 5);
          end;


          WriteLn;
          Intercept;
     end;

     MemPop; { EFTEST }
end.