/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* zip.h  -  ZIP functions header file */

#ifndef ZIP_HEADER
#define ZIP_HEADER    1

typedef struct ZIP_local_header {
            long Signature;
            int version;
            int BitFlag;
            int CompressionMethod;
            unsigned int FileTime;
            unsigned int FileDate;
            long CRC32;
            long CompressedSize;
            long UnCompressedSize;
            int FileNameLength;
            int ExtraFieldLength;
        };

typedef struct ZIP_central_record {
            long Signature;
            int VersionMadeBy;
            int VersionNeeded;
            int BitFlag;
            int CompressionMethod;
            unsigned int FileTime;
            unsigned int FileDate;
            long CRC32;
            long CompressedSize;
            long UnCompressedSize;
            int FileNameLength;
            int CommentFieldLength;
            int DiskStartNumber;
            int InternalAttributes;
            long ExternalAttributes;
            long LocalHeaderOffset;
        };

typedef struct ZIP_end_central_record {
            long Signature;
            int ThisDiskNumber;
            int CentralDiskNumber;
            int EntriesCentral;
            long SizeCentral;
            long OffsetCentral;
            int ZipfileCommentLength;
        };

#define MAX_ZIP_VERSION         10
#define ZIPSignatureLocal       0x04034B50l
#define ZIPSignatureCentral     0x02014B50l
#define ZIPSignatureEndCentral  0x06054B50l
#define nextZIPlocal(Z)         (Z.FileNameLength + Z.ExtraFieldLength + Z.CompressedSize)
#define ZIPversion(Zversion)    (Zversion & 0x00FF)
#define _ZIPmajor(Zversion)     (ZIPversion(Zversion) / 10)
#define _ZIPminor(Zversion)     (ZIPversion(Zversion) % 10)

/* function prototypes */

#endif              /* ZIP_HEADER */
