.ds RF Jun 07, 1991
.TL
NET User Reference Manual (NOS Version)
.AU
Phil Karn, KA9Q
.nr LL 6.5i
.NH 1
The NET.EXE Program
.LP
The MS-DOS executable file \fBnet.exe\fP provides Internet (TCP/IP),
NET/ROM and AX.25
facilities.  Because it has an internal multitasking operating system,
\fBnet.exe\fP can act simultaneously as a client, a server and a packet switch
for all three sets of protocols. That is, while a local user accesses remote
services, the system can also provide those same services to remote users
while also switching IP, NET/ROM and AX.25 packets and frames between other
client and server nodes.
.LP
The keyboard and display is used by the local operator to control both host
and gateway level functions, for which a number of commands are provided.
.NH 2
Installation
.LP
\fBNet.exe\fP uses the following directory structure:
.DS
/spool
/spool/help
/spool/mail
/spool/mqueue
/spool/rqueue
/spool/news
.DE
.LP
By default, the /spool directory is placed in the root directory of the
current drive. However, a subdirectory may be specified with the 
\fB-d\fP command-line option described below. If a subdirectory is
given, the
\fBalias, autoexec.net, dialer, domain.txt\fP and \fBftpusers\fP
configuration files must also be located there.
.LP
The "/spool" directory and its sub-directories are used by the bbs,
SMTP and NNTP services.
The \fBareas, forward.bbs, history, mail.log, rewrite\fP and \fBsignatur\fP
configuration files are located here.
.NH 2
net [-b] [-s <sockets>] [-d <directory>] [<startup file>]
.NH 3
-b
.LP
The \fB-b\fP option specifies the use of BIOS for console output;
the default is to write directly to the video display buffer. Use
this option if you are running under a windowing package and have
trouble with output "bleeding through" on top of other windows.
.NH 3
-s
.LP
The \fB-s\fP option specifies the size of the
\fIsocket\fP array to be allocated within \fBnet.exe\fP. This limits the number
of network connections that may exist simultaneously.
The default is 40.
.NH 3
-d
.LP
The \fB-d\fP option allows the user to specify a directory for the
configuration and spool files; it defaults to the root directory of the system.
.NH 3
Startup file
.LP
After all command-line options, the name of a startup file may be specified.
If no startup file is specified, \fBnet.exe\fP attempts to open a file named
\fBautoexec.net\fP in the configuration directory of the current drive.
If the file exists,
it is read and executed as though its contents were typed on the
console as commands.
(See the \fBCommands\fP chapter.)
This feature is useful for attaching communication
interfaces, configuring network addresses, and starting the various services.
.NH 1
Console modes
.LP
The console may be in one of two modes: \fIcommand mode\fP and
\fIconverse mode\fP.
In \fIcommand mode\fP, the prompt \fBnet>\fP is displayed and any of the
commands described in the \fBCommands\fP chapter may be entered.
In \fIconverse mode\fP,
keyboard input is processed according to the \fIcurrent session\fP.
.LP
Sessions come in many types, including \fITelnet, FTP, AX25,
NETROM, Ping, More, Hopcheck\fP and \fITip\fP.
In a Telnet, AX25, NETROM, or Tip session, keyboard input is sent to the
remote system and any output from the remote system is displayed on the
console.  In a FTP session, keyboard input is first examined to see if
it is a known local command; if so it is executed locally.  If not, it
is "passed through" to the remote FTP server.
(See the \fBFTP Subcommands\fP chapter).
In a Ping session the user may test the path to a
remote site, and in a More session, the user may examine a local
file. A Hopcheck session is used to trace the path taken by packets
to reach a specified destination. A Tip session provides a "dumb terminal"
service that bypasses all network protocols.
.LP
The keyboard also has \fIcooked\fP and \fIraw\fP states.
In \fIcooked\fP state, input
is line-at-a-time; the user may use the line editing characters ^U, ^R
and backspace to erase the line, redisplay the line and erase the last
character, respectively.  Hitting either return or line feed passes the
complete line up to the application.
In \fIraw\fP state, each character is
immediately passed to the application as it is typed.
.LP
The keyboard is always in \fIcooked\fP state in command mode.
It is also \fIcooked\fP in converse mode on an AX25, FTP or NET/ROM session.
In a Telnet session it depends on
whether the remote end has issued (and the local end has accepted) the
Telnet WILL ECHO option (see the \fBecho\fP command).
.LP
On the IBM-PC, the user may escape back to \fIcommand mode\fP
by hitting the F10 key.
On other systems, the user must enter the \fIescape\fP character,
which is by default control-] (hex 1d, ASCII GS).
(Note that this is distinct from the ASCII character of the same name).
The \fIescape\fP character can be changed (see the \fBescape\fP command).
.LP
In the IBM PC version, each session (including the command "session")
has its own screen.
When a new session is created,
the command display is saved in memory and the screen is cleared.
When the command escape key (usually F10) is hit,
the current session screen is saved and the command screen is restored.
When a session is resumed,
its screen is restored exactly as it appeared when it was last current.
.NH 1
Commands
.LP
This chapter describes the commands recognized in command mode,
or within a startup file such as \fBautoexec.net\fP.
These are given in the following notation:
.DS
command
command literal_parameter
command subcommand <parameter>
command [<optional_parameter>]
command a | b
.DE
.LP
Many commands take subcommands or parameters, which may be optional or
required. In general, if a required subcommand or parameter is omitted,
an error message will summarize the available subcommands or required
parameters.  (Giving a '?' in place of the subcommand will also generate the
message.  This is useful when the command word alone is a valid command.) If
a command takes an optional value parameter, issuing the command without the
parameter generally displays the current value of the variable. (Exceptions
to this rule are noted in the individual command descriptions.)
.LP
Two or more parameters separated by vertical bar(s) denote a choice between
the specified values.  Optional parameters are shown enclosed in [brackets],
and a parameter enclosed in <angle brackets> should be replaced with an
actual value or string.  For example, the notation \fB<hostid>\fP denotes an
actual host or gateway, which may be specified in one of two ways:
as a numeric IP address in dotted decimal notation (eg. 44.0.0.1), or
as a symbolic name listed in the file \fBdomain.txt\fP.
.LP
All commands and many subcommands may be abbreviated. You only need
type enough of a command's name to distinguish it from others that
begin with the same series of letters. Parameters, however, must be
typed in full.
.LP
Certain FTP subcommands (eg. \fBput, get, dir\fP, etc) are recognized
only in converse mode with the appropriate FTP session; they are not
recognized in command mode.
(See the \fBFTP Subcommands\fP chapter.)
.LP
Note that certain commands may have been configured out of a given
copy of \fBnet.exe\fP to save disk and memory.
If a command has been configured out, it will not appear in the list
produced by the "?" command, nor will it be recognized by the command
interpreter.
.NH 2
<CR>
.LP
Entering a carriage return (empty line) while in command mode puts you in
converse mode with the current session. If there is no current session,
\fBnet.exe\fP remains in command mode.
.NH 2
!
.LP
An alias for the \fBshell\fP command.
.NH 2
#
.LP
Commands starting with the hash mark (#) are ignored. This is mainly useful
for comments in the \fBautoexec.net\fP file.
.NH 2
abort [<session #>]
.LP
Abort a FTP \fBget, put\fP or \fBdir\fP operation in progress. If issued without
an argument, the current session is aborted. (This command works only
on FTP sessions.) When receiving a file, \fBabort\fP
simply resets the data connection; the next incoming data packet will generate
a TCP RST (reset) response to clear the remote server.  When
sending a file, \fBabort\fP sends a premature end-of-file. Note that in both
cases \fBabort\fP will leave a partial copy of the file on the destination
machine, which must be removed manually if it is unwanted.
.NH 2
arp
.LP
Display the Address Resolution Protocol table that maps IP addresses
to their subnet (link) addresses on subnetworks capable of broadcasting.
For each IP address entry the subnet type (eg. Ethernet, AX.25), subnet
address and time to expiration is shown. If the link address is currently
unknown, the number of IP datagrams awaiting resolution is also shown.
.NH 3
arp add <hostid> ethernet | ax25 <ethernet address> | <ax25_address>
.LP
Add a permanent entry to the table. It will not time out
as will an automatically-created entry, but must be removed with the
\fBarp drop\fP command.
.NH 3
arp publish <hostid> ethernet | ax25 <ethernet address> | <ax25_address>
.LP
This command is similar to the \fBarp add\fP command, but
system will also respond to any ARP request it sees on the network that seeks
the specified address.  \fIUse this feature with great care.\fP
.NH 3
arp drop <hostid> ax25 | ethernet
.LP
Remove the specified entry from the ARP table.
.NH 3
arp flush
.LP
Drop all automatically-created entries in the ARP table. Permanent
entries are not affected.
.NH 2
asystat
.LP
Display statistics on attached asynchronous communications interfaces
(8250 or 16550A), if any. The display for each port consists of three
lines. The first line gives the port label and the configuration flags;
these indicate whether the port is a 16550A chip, the \fItrigger character\fP
if any,
whether CTS flow control is enabled,
whether RLSD (carrier detect) line control is enabled,
and the speed in bits per second.
(Receiving the \fItrigger character\fP causes the driver
to signal upper layer software that data is ready;
it is automatically set to the appropriate frame end
character for SLIP, PPP and NRS lines.)
.LP
The second line of the status display shows receiver (RX) event counts: the
total number of receive interrupts, received characters, receiver overruns
(lost characters) and the receiver \fIhigh water mark\fP.
The high water mark is
the maximum number of characters ever read from the device during a single
interrupt. This is useful for monitoring system interrupt latency margins as
it shows how close the port hardware has come to overflowing due to the
inability of the CPU to respond to a receiver interrupt in time. 8250 chips
have no FIFO, so the high water mark cannot go higher than 2 before overruns
occur. The 16550A chip, however, has a 16-byte receive FIFO which the
software programs to interrupt the CPU when the FIFO is one-quarter full.
The high water mark should typically be 4 or 5 when a 16550A is used; higher
values indicate that the CPU has at least once been slow to respond
to a receiver interrupt.
.LP
When the 16550A is used, a count of FIFO timeouts is also displayed on the
RX status line. These are generated automatically by the 16550A when three
character intervals go by with more than 0 but less than 4 characters in the
FIFO. Since the characters that make up a SLIP or NRS frame are normally
sent at full line speed,
this count will usually be a lower bound on the number of frames received
on the port, as only the last fragment of a frame generally results
in a timeout (and then only when the frame is not a multiple of 4 bytes
long.)
.LP
Finally, the software fifo overruns and high water mark are displayed.
These indicate whether the <bufsize> parameter on the attach command
needs to be adjusted (see the \fBAttach Commands\fP chapter).
.LP
The third line shows transmit (TX) statistics,
including a total count of transmit interrupts, transmitted characters,
the length of the transmit queue in bytes,
the number of status interrupts,
and the number of THRE timeouts.
The status interrupt count will be zero
unless CTS flow control or RLSD line control has been enabled.
The THRE timeout is a stopgap measure to catch lost transmit interrupts,
which seem to happen when there is a lot of activity
(ideally, this will be zero).
.NH 2
attach <hw type> ...
.LP
Configure and attach a hardware interface to the system.
Detailed instructions for each driver are in the \fBAttach Commands\fP chapter.
An easy way to obtain a summary of the parameters required for a given device
is to issue a partial attach command (eg. \fBattach packet\fP).
This produces a usage message giving the complete command format.
.NH 2
ax25 ...
.LP
These commands are used to control the AX.25 amateur radio link level
protocol.
.NH 3
ax25 blimit [<count>]
.LP
Display or set the AX25 retransmission backoff limit. Normally each
successive AX25 retransmission is delayed by twice the value of the
previous interval; this is called \fIbinary exponential backoff\fP.
When the backoff reaches the blimit setting it is held at that value,
which defaults to 30.
To prevent the possibility of "congestive collapse" on a loaded channel,
blimit should be set at least as high as the number of stations sharing
the channel.
Note that this is applicable only on actual AX25 connections; UI frames
will never be retransmitted by the AX25 layer.
.NH 3
ax25 dest
.LP
Display the AX25 destination monitoring database. Each callsign seen in
the destination field of
an AX25 frame is displayed (most recent first), along with the time
since it was last referenced. The time since the same callsign was last
seen in the source field of an AX25 frame on the same interface is also
shown. If the callsign has never been seen in the source field of
a frame, then this field is left blank. (This indicates that the
destination is either a multicast address or a "hidden station".)
.NH 3
ax25 digipeat [on | off]
.LP
Display or set the digipeater enable flag.
.NH 3
ax25 flush
.LP
Clear the AX.25 "heard" list (see \fBax25 heard\fP).
.NH 3
ax25 heard
.LP
Display the AX.25 "heard" list. For each interface that is configured to
use AX.25, a list of all callsigns heard through that interface is
shown, along with a count of the number of packets heard from each station
and the interval, in hr:min:sec format, since each station was last heard.
The list is sorted in most-recently-heard order.
The local station is included in the listing; the packet count reflects
the number of packets transmitted. This count will be correct whether
or not the modem monitors its own transmissions.
.NH 3
ax25 irtt [<milliseconds>]
.LP
Display or set the initial value of smoothed round trip time to be used
when a new AX25 connection is created. The value is in milliseconds.
The actual round trip time will be learned by measurement once the
connection has been established.
.NH 3
ax25 kick <axcb>
.LP
Force a retransmission on the specified AX.25 control block.
.NH 3
ax25 maxframe [<count>]
.LP
Establish the maximum number of frames that will be allowed to remain
unacknowledged at one time on new AX.25 connections. This number cannot
be greater than 7.
.NH 3
ax25 mycall [<call>]
.LP
Display or set the local AX.25 address.  The standard format is used
(eg. KA9Q-0 or WB6RQN-5).
This command must be given before any \fBattach\fP commands
using AX.25 mode are given.
.NH 3
ax25 paclen [<size>]
.LP
Limit the size of I-fields on new AX.25 connections.  If IP
datagrams or fragments larger than this are transmitted, they will be
transparently fragmented at the AX.25 level, sent as a series of I
frames, and reassembled back into a complete IP datagram or fragment at
the other end of the link. To have any effect on IP datagrams,
this parameter should be less than or equal to
the MTU of the associated interface.
.NH 3
ax25 pthresh [<size>]
.LP
Display or set the poll threshold to be used for new AX.25 Version 2
connections.  The poll threshold controls retransmission behavior as
follows. If the oldest unacknowledged I-frame size is less than the poll
threshold, it will be sent with the poll (P) bit set if a timeout occurs.
If the oldest unacked I-frame size is equal to or greater than the
threshold, then a RR or RNR frame, as appropriate, with the poll bit set
will be sent if a timeout occurs.
.LP
The idea behind the poll threshold is that the extra time needed to send a
"small" I-frame instead of a supervisory frame when polling after a timeout
is small, and since there's a good chance the I-frame will have to be sent
anyway (i.e., if it were lost previously) then you might as well send it as
the poll. But if the I-frame is large, send a supervisory (RR/RNR) poll
instead to determine first if retransmitting the oldest unacknowledged
I-frame is necessary; the timeout might have been caused by a lost
acknowledgement.  This is obviously a tradeoff, so experiment with the
poll threshold setting. The default is 128 bytes, one half the default
value of \fBpaclen\fP.
.NH 3
ax25 reset <axcb>
.LP
Delete the AX.25 connection control block at the specified address.
.NH 3
ax25 retry [<count>]
.LP
Limit the number of successive unsuccessful retransmission attempts on
new AX.25 connections. If this limit is exceeded, link re-establishment
is attempted. If this fails \fBretry\fP times, then the connection
is abandoned and all queued data is deleted. A value of 0 means "infinity";
the retry limit is disabled.
retry 
.NH 3
ax25 route
.LP
Display the AX.25 routing table that
specifies the digipeaters to be used in reaching a given station.
.NH 4
ax25 route add <target> [digis ... ]
.LP
Add an entry to the AX.25 routing table.  An automatic \fBax25
route add\fP is executed if digipeaters are specified in an AX25 \fBconnect\fP
command, or if a connection is received from a remote station via
digipeaters. Such automatic routing table entries won't override locally
created entries, however.
.NH 4
ax25 route drop <target>
.LP
Drop an entry from the AX.25 routing table.
.NH 3
ax25 status [<axcb>]
.LP
Without an argument, display a one-line summary of each AX.25 control block.
If the address of a particular control block is specified, the contents of
that control block are dumped in more detail. Note that the send queue units
are frames, while the receive queue units are bytes.
.NH 3
ax25 t3 [<milliseconds>]
.LP
Display or set the AX.25 idle "keep alive" timer. Value is in milliseconds.
.NH 3
ax25 version [1 | 2]
.LP
Display or set the version of the AX.25 protocol to attempt to use on
new connections. The default is 1 (the version
that does not use the poll/final bits).
.NH 3
ax25 window [<size>]
.LP
Set the number of bytes that can be pending on an AX.25 receive queue
beyond which I frames will be answered with RNR (Receiver Not Ready)
responses.  This presently applies only to suspended interactive AX.25
sessions, since incoming I-frames containing network (IP, NET/ROM) packets
are always processed immediately and are not placed on the receive queue.
However, when an AX.25 connection carries both interactive
and network packet traffic, an RNR generated because of
backlogged interactive traffic will also stop network
packet traffic from being sent.
.NH 2
BOOTP
.LP
The bootp client and server are added to KA9Q to provide automatic
configuration capabilities.  With this suite of extensions, a KA9Q host
can automatically configure its IP address, subnet mask, broadcast
address, host name, the default gateway, the name servers, and default
boot file.  This simplifies host configuration.
.LP
The bootp server supports dynamic IP address assignment.  If a bootp
request is made by a host to the server, and the server doesn't have a
static record for the PC making the request, an IP address may be
assigned from a list of dynamic addresses.  This simplifies server
configuration, so that machines don't require prior IP address
assignment.  This is useful in environments such as university
dormitories, where network service is provided, and the computers
configurations change frequently.  When the server list of free
addresses reaches a minimum threshold, it will begin attempts to
reclaim the address.
.LP
The bootp client and server code are written according to RFC 951 and
1048.
.NH 3
bootp  [<net_name>] [silent] [noisy]
.LP
Send a request to a bootp server, and wait for a reply.  On receipt
of the server reply, the information is used to configure the host.  If
a reply is not received, the command will time out. Without arguments,
\fBbootp\fP sends a request to the first interface in the interface list.
.LP
This command requires that there exist a routing entry for the
IP broadcast address
255.255.255.255 pointing to the appropriate interface. If the
interface uses ARP, there must also be an ARP entry that maps that address
to the appropriate link level broadcast address.
For example, if you have an Ethernet interface named "ethernet", use the
following commands before the \fBbootp\fP command:
.IP
route add 255.255.255.255 ethernet
.sp
arp add 255.255.255.255 ether ff:ff:ff:ff:ff:ff
.LP
The following \fBbootp\fP subcommands are available:
.NH 4
bootp <net_name>
.LP
Send a request over the specified network.
.NH 4
bootp silent
.LP
Set bootp so that it will not print the configuration.
.NH 4
bootp noisy
.LP
Set bootp so that it will print the configuration.
.NH 3
bootpd ...
.LP
This command starts and stops the bootp server, and sets the
configuration for the information it will provide in replies.  If the
file \fBbootptab\fP exists, it will read the file for configuration
information.  On receipt of a request, if \fBbootptab\fP has been changed,
the server will reread the file for the changed configuration.
The following subcommands are available:
.NH 4
bootpd start
.LP
Start the bootp server, reading from the file bootptab
for configuration information.
.NH 4
bootpd stop
.LP
Stop the bootp server.
.NH 4
bootpd dns
.LP
Print the address of the domain name servers supplied in replies.
.NH 4
bootpd dns <IP addr of domain name server>...
.LP
Set the addresses.
.NH 4
bootpd dynip
.LP
Print the range and use of the dynamic IP address.
.NH 4
bootpd dynip <net_name> <IP address> <IP address>
.LP
Set the range of IP address to be used for network
netname.  These address will be supplied to hosts that
are not found in the static record.
.NH 4
bootpd dynip <netname> off
.LP
Turn off dynamic ip for network interface netname.
.NH 4
bootpd host
.LP
Print the information in the static host table.
.NH 4
bootpd host <hostname>  ethernet|ax25 <ethernet addr>|<ax25 addr> <ip addr> [boot file]
.LP
Add a host to the host table.  The LANSTAR packet
drivers provide an Ethernet interface to upper layer
applications, so configure a LANSTAR network as an
Ethernet.
.NH 4
bootpd rmhost <hostname>
.LP
Remove host <hostname> from the static host tables.
.NH 4
bootpd homedir
.LP
Print the default directory for the bootp file name
used when the bootp file is not specified in the static
host record, and when dynamic addresses are supplied.
Default is the null string.
.NH 4
bootpd homedir <directory name>
.LP
Set the default directory.
.NH 4
bootpd defaultfile
.LP
Print the default file for the bootp file name used
when the bootp file is not specified in the static host
record, and when dynamic addresses are supplied.
Default is the null string.
.NH 4
bootpd defaultfile <filename>
.LP
Set the default file.
.NH 4
bootpd logfile
.LP
Print the status of logging to a log file.
.NH 4
bootpd logfile <filename | default> on|off
.LP
Sets the file for logging to <filename> or the default,
bootplog.  Turn logging to that file on or off.
.NH 4
bootpd logscreen
.LP
Print the status of logging to the screen.
.NH 4
bootpd logscreen on|off
.LP
Turn logging to the screen on or off.
.NH 2
cd [<dirname>]
.LP
Change the current working directory, and display the new setting.
Without an argument, \fBcd\fP simply displays the current directory
without change.
The \fBpwd\fP command is an alias for \fBcd\fP.
.NH 2
close [<session>]
.LP
Close the specified session; without an argument, close the current session.
On an AX.25 session, this command initiates a disconnect.  On a FTP or
Telnet session, this command sends a FIN (i.e., initiates a close) on the
session's TCP connection.  This is an alternative to asking the remote
server to initiate a close (\fBQUIT\fP to FTP, or the logout command appropriate
for the remote system in the case of Telnet).  When either FTP or Telnet
sees the incoming half of a TCP connection close, it automatically responds
by closing the outgoing half of the connection.  Close is more graceful than
the \fBreset\fP command, in that it is less likely to leave the remote TCP in a
"half-open" state.
.NH 2
connect <iface> <callsign> [<digipeater> ... ]
.LP
Initiate a "vanilla" AX.25 session to the specified call sign using the
specified interface. Data sent on this session goes out in
conventional AX.25 packets with no upper layer protocol.  The de-facto
presentation standard format is used, in that each packet holds one line
of text, terminated by a carriage return.  A single AX.25 connection may
be used for terminal-to-terminal, IP and NET/ROM traffic.
The three types of data are automatically separated by their
AX.25 Level 3 Protocol IDs.
.LP
Up to 7 optional digipeaters may be given; note that the word \fBvia\fP is NOT
needed. If digipeaters are specified, they are automatically added to the
AX25 routing table as though the \fBax25 route add\fP command had been given
before issuing the \fBconnect\fP command.
.NH 2
delete <filename>
.LP
Delete a \fBfilename\fP in the current working directory.
.NH 2
detach <iface>
.LP
Detach a previously attached interface from the system. All IP routing
table entries referring to this interface are deleted, and forwarding
references by any other interface to this interface are removed.
.NH 2
dialer <iface> [<dialer-file> [<seconds> [<tests> [<hostid>]]]]
.LP
Setup an autodialer session for the interface.
Whenever the interface is idle for the interval in <seconds>,
the autodialer will ping the <hostid>.
If there is no answer after <tests> attempts,
or the interface is otherwise known to be down,
the autodialer will execute the special commands contained in the <dialer-file>.
.LP
The <dialer-file> may have any valid name,
and must be located in the configuration directory
(see the \fBInstallion\fP section).
The commands in the file are described in the \fBDialer Subcommands\fP chapter.
.LP
If the <dialer-file> is missing,
any previous dialer command process will be removed.
If <seconds> is missing,
the <dialer-file> will be executed immediately without any further tests.
If <tests> is missing,
the default is 2.
If <hostid> is missing
and the interface uses the PPP encapsulation,
the PPP LCP echo will be used instead.
.NH 2
dir [<dirname>]
.LP
List the contents of the specified directory on the console. If no argument
is given, the current directory is listed. Note that this command works
by first listing the directory into a temporary file, and then creating
a \fBmore\fP session to display it. After this completes, the temporary
file is deleted.
.NH 2
disconnect [<session #>]
.LP
An alias for the \fBclose\fP command (for the benefit of AX.25 users).
.NH 2
domain ...
.LP
These commands control the operation of the Internet
Domain Name Service (DNS).
.NH 3
domain addserver <hostid>
.LP
Add one or more domain name server(s) to the list of name servers.
.NH 3
domain dropserver <hostid>
.LP
Remove one or more domain name server(s) from the list of name servers.
.NH 3
domain listservers
.LP
List the currently configured domain name servers, along with statistics
on how many queries and replies have been exchanged with each one,
response times, etc.
.NH 3
domain query <hostid>
.LP
Send a query to a domain server asking for all resource records
associated with this <hostid>, and list the records.
.NH 3
domain retry [<count>]
.LP
Display or set the number of attempts to reach each server on the list
during one call to the resolver.
If this count is exceeded,
a failure indication is returned.
If set to 0, the list will cycle forever;
this may be useful for unattended operation.
The default is 3.
.NH 3
domain suffix [<domain suffix>]
.LP
Display or specify the default domain name suffix to be appended to
a host name when it contains no periods. For example, if the suffix is
set to \fBampr.org\fP and the user enters \fBtelnet ka9q\fP, the domain
resolver will attempt to find \fBka9q.ampr.org\fP. If the host name being
sought contains one or more periods, however, the default suffix is NOT
applied (eg. \fBtelnet foo.bar\fP would NOT be turned into
\fBfoo.bar.ampr.org\fP).
.NH 3
domain trace [on | off]
.LP
Display or set the flag controlling the tracing of domain server
requests and responses. Trace messages will be seen only if a domain name
being sought is not found in the local cache file, \fBdomain.txt\fP.
.NH 3
domain cache ...
.LP
These commands are used for the use of the resource record file \fBdomain.txt\fP,
and the local memory cache.
.NH 4
domain cache clean [on | off]
.LP
Display or set the flag controlling the removal of resource records
from the \fBdomain.txt\fP file whose time-to-live has reached zero.
.LP
When clean is off (the default), expired records will be retained;
if no replacement can be obtained from another domain name server,
these records will continue to be used.
.LP
When clean is on, expired records will be removed from the file
whenever any new record is added to the file.
.NH 4
domain cache list
.LP
List the current contents of the local memory cache.
.NH 4
domain cache size [<count>]
.LP
Display or set the nominal maximum size of the local memory cache.
The default is 20.
.LP
(Note: The cache may be temporarily larger when waiting for new records
to be written to the \fBdomain.txt\fP file.)
.NH 4
domain cache wait [<seconds>]
.LP
Display or set the interval in seconds to wait for additional activity
before updating the \fBdomain.txt\fP file.  The default is 300 seconds
(5 minutes).
.NH 2
echo [accept | refuse]
.LP
Display or set the flag controlling client Telnet's response to a
remote WILL ECHO offer.
.LP
The Telnet presentation protocol specifies that in the absence of a negotiated
agreement to the contrary, neither end echoes data received from the other.
In this mode, a Telnet client session echoes keyboard input locally and nothing
is actually sent until a carriage return is typed. Local line editing is also
performed: backspace deletes the last character typed, while control-U deletes
the entire line.
.LP
When communicating from keyboard to keyboard the standard local echo mode is
used, so the setting of this parameter has no effect. However, many
timesharing systems (eg. UNIX) prefer to do their own echoing of typed input.
(This makes screen editors work right, among other things). Such systems send
a Telnet WILL ECHO offer immediately upon receiving an incoming Telnet
connection request. If \fBecho accept\fP is in effect, a client Telnet
session will
automatically return a DO ECHO response. In this mode, local echoing and
editing is turned off and each key stroke is sent immediately (subject to the
congestion control algorithms in TCP).  While this mode is just fine across an
Ethernet, it is clearly inefficient and painful across slow paths like packet
radio channels. Specifying \fBecho refuse\fP causes an incoming WILL ECHO
offer to be answered with a DONT ECHO; the client Telnet session remains
in the local echo mode.  Sessions already in the remote echo mode are
unaffected. (Note: Berkeley Unix has a bug in that it will still echo input
even after the client has refused the WILL ECHO offer. To get around this
problem, enter the \fBstty -echo\fP command to the shell once you have
logged in.)
.NH 2
eol [unix | standard]
.LP
Display or set Telnet's end-of-line behavior when in remote echo mode.
In standard mode, each key is sent as-is. In unix mode, carriage returns
are translated to line feeds.  This command is not necessary with all UNIX
systems; use it only when you find that a particular system responds to
line feeds but not carriage returns.  Only SunOS release 3.2 seems to
exhibit this behavior; later releases are fixed.
.NH 2
escape [<char>]
.LP
Display or set the current command-mode escape character in hex.
(This command is not provided on the IBM-PC; on the PC, the escape char is
always F10.)
.NH 2
etherstat
.LP
Display 3-Com Ethernet controller statistics (if configured).
.NH 2
exit
.LP
Exit the \fBnet.exe\fP program and return to MS-DOS.
.NH 2
finger <user@hostid> [<user@hostid> ...]
.LP
Issue a network finger request for user \fBuser\fP at host \fBhostid\fP. This
creates a client session which may be interrupted, resumed, reset, etc,
just like a Telnet client session.
.NH 2
ftp <hostid>
.LP
Open an FTP control channel to the specified remote host and enter converse
mode on the new session.  Responses from the remote server are displayed
directly on the screen. See the \fBFTP Subcommands\fP chapter for descriptions
of the commands available in a FTP session.
.NH 2
help
.LP
Display a brief summary of top-level commands.
.NH 2
hop ...
.LP
These commands are used to test the connectivity of the network.
.NH 3
hop check <hostid>
.LP
Initiate a \fIhopcheck\fP session to the specified host. This uses a series
of UDP "probe" packets with increasing IP TTL fields to determine the
sequence of gateways in the path to the specified destination. This
function is patterned after the UNIX \fItraceroute\fP facility.
.LP
ICMP message tracing should be turned off before this command is
executed (see the \fBicmp trace\fP command).
.NH 3
hop maxttl [<hops>]
.LP
Display or set the maximum TTL value to be used in hop check sessions.
This effectively bounds the radius of the search.
.NH 3
hop maxwait [<seconds>]
.LP
Display or set the maximum interval that a hopcheck session
will wait for responses at each stage of the trace. The default is 5 seconds.
.NH 3
hop queries [<count>]
.LP
Display or set the number of UDP probes that will be sent at each stage
of the trace. The default is 3.
.NH 3
hop trace [on | off]
.LP
Display or set the flag that controls the display of additional information
during a hop check session.
.NH 2
hostname [<name>]
.LP
Display or set the local host's name. By convention this should be the same
as the host's primary domain name. This string
is used only in the greeting messages
of the various network servers;
note that it does NOT set the system's IP address.
.LP
If <name> is the same as an <iface> (see the \fBAttach commands\fP chapter),
this command will search for a CNAME domain resource record
which corresponds to the IP address of the <iface>.
.NH 2
hs
.LP
Display statistics about the HS high speed HDLC driver (if configured
and active).
.NH 2
icmp ...
.LP
These commands are used for the Internet Control Message Protocol service.
.NH 3
icmp echo [on | off]
.LP
Display or set the flag controlling
the asynchronous display of ICMP Echo Reply packets.
This flag must be on for one-shot pings to work (see the \fBping\fP command.)
.NH 3
icmp status
.LP
Display statistics about the
Internet Control Message Protocol (ICMP), including the number of ICMP
messages of each type sent or received. 
.NH 3
icmp trace [on | off]
.LP
Display or set the flag controlling
the display of ICMP error messages. These informational
messages are generated by Internet routers in response to routing,
protocol or congestion problems. This option should be turned
off before using the \fBhop check\fP facility because it
relies on ICMP Time Exceeded messages, and the asynchronous
display of these messages will be mingled with \fBhop check\fP command output.
.NH 2
ifconfig
.LP
Display a list of interfaces, with a short status for each.
.NH 3
ifconfig <iface>
.LP
Display an extended status of the interface.
.NH 3
ifconfig <iface> broadcast <address>
.LP
Set the broadcast address for the interface.
The <address> takes the form of an IP address
with 1's in the host part of the address.
This is related to the \fBnetmask\fP sub-command.
See also the \fBarp\fP command.
.NH 3
ifconfig <iface> encapsulation <name>
.LP
Not fully implemented.
.NH 3
ifconfig <iface> forward <forward-iface>
.LP
Set a forwarding interface for multiple channel interfaces.
To remove the forward, set <forward-iface> to <iface>.
.NH 3
ifconfig <iface> ipaddress <hostid>
.LP
Set the IP address for this interface.
It is standard Internet practice that each interface has its own address.
For hosts with only one interface, the interface address is usually the
same as the host address.
See also the \fBhostname\fP and \fBip address\fP commands.
.NH 3
ifconfig <iface> linkaddress <hardware-dependant>
.LP
Set the hardware dependant address for this interface.
.NH 3
ifconfig <iface> mtu <mtu>
.LP
Set the MTU for this interface.
See the \fBSetting ... MTU, MSS and Window\fP chapter for more information.
.NH 3
ifconfig <iface> netmask <address>
.LP
Set the sub-net mask for this interface.
The <address> takes the form of an IP address
with 1's in the network and subnet parts of the address,
and 0's in the host part of the address.
This is related to the \fBbroadcast\fP sub-command.
See also the \fBroute\fP command.
.NH 3
ifconfig <iface> rxbuf <?>
.LP
Not yet implemented.
.NH 2
ip ...
.LP
These commands configure the Internet Protocol (IP) service.
.NH 3
ip address [<hostid>]
.LP
Display or set the default local IP address. This command must be given before
an \fBattach\fP command if it is to be used as the default IP address for
the interface.
.NH 3
ip rtimer [<seconds>]
.LP
Display or set the IP reassembly timeout. The default is 30 seconds.
.NH 3
ip status
.LP
Display Internet Protocol (IP) statistics, such as total packet counts
and error counters of various types.
.NH 3
ip ttl [<hops>]
.LP
Display or set the time-to-live value placed in each outgoing IP datagram.
This limits the number of switch hops the datagram will be allowed to
take. The idea is to bound the lifetime of the packet should it become caught
in a routing loop, so make the value slightly larger than the number of
hops across the network you expect to transit packets.
The default is set at compilation time to the official recommended value
for the Internet.
.NH 2
isat [on | off]
.LP
Display or set the AT flag.
Currently, there is no sure-fire way to determine the type of clock-chip
being used.  If an AT type clock is in use, this command will allow
measurement of time in milliseconds, rather than clock ticks
(55 milliseconds per clock tick).
.NH 3
kick [<session>]
.LP
Kick all sockets associated with a session;
if no argument is given, kick the current session.
Performs the same function as the \fBax25 kick\fP and \fBtcp kick\fP commands,
but is easier to type.
.NH 2
log [stop | <filename>]
.LP
Display or set the \fBfilename\fP for logging server sessions. If
\fBstop\fP is given as the argument, logging is terminated
(the servers themselves are unaffected).
If a file name is given as an argument, server session log
entries will be appended to it.
.NH 2
mbox
.LP
Display the status of the mailbox server system (if configured).
.NH 2
memory ...
.LP
These commands are used to display memory allocation statistics.
.NH 3
memory free
.LP
Display the storage allocator free list. Each entry consists of a
starting address, in hex, and a size, in decimal bytes.
.NH 3
memory ibuffs
.LP
Display or set the number of buffers on the interrupt buffer pool.
The default is 5.
.NH 3
memory ibufsize
.LP
Display or set the size of each buffer on the interrupt buffer pool.
Since the interrupt buffer pool consists of fixed-size buffers, the
value chosen must be large enough to satisfy the needs of the most
demanding driver. The default is 2048.
.NH 3
memory sizes
.LP
Display a histogram of storage allocator request sizes. Each histogram
bin is a binary order of magnitude (i.e., a factor of 2).
.NH 3
memory status
.LP
Display a summary of storage allocator statistics. The first line
shows the base address of the heap, its total size, the amount of heap
memory available in bytes and as a percentage of the total heap size,
and the amount of memory left over (i.e., not placed on the heap at startup)
and therefore available for \fBshell\fP subcommands.
.LP
The second line shows the total number of calls to allocate and free blocks
of memory, the difference of these two values (i.e., the number of allocated
blocks outstanding), the number of allocation requests that were denied
due to lack of memory, and the number of calls to free() that attempted to
free garbage
(eg. by freeing the same block twice or freeing a garbled pointer).
.LP
The third line shows the number of calls to malloc and free that occurred
with interrupts off. In normal situations these values should be zero.
The fourth line shows statistics for the special pool of fixed-size buffers
used to satisfy requests for memory at interrupt time. The variables
shown are the number of buffers currently in the pool, their size, and
the number of requests that failed due to exhaustion of the pool.
.NH 2
mkdir <dirname>
.LP
Create a sub-directory in the current working directory.
.NH 2
mode <iface> [vc | datagram]
.LP
Control the default transmission mode on the specified AX.25 interface. 
In \fBdatagram\fP mode, IP packets are encapsulated in AX.25 UI frames and
transmitted without any other link level mechanisms, such as connections
or acknowledgements. 
.LP
In \fBvc\fP (virtual circuit) mode, IP packets are encapsulated in AX.25 I
frames and are acknowledged at the link level according to the AX.25
protocol.  Link level connections are opened if necessary.
.LP
In both modes, ARP is used to map IP to AX.25 addresses.  The defaults
can be overridden with the type-of-service (TOS) bits in the IP header. 
Turning on the "reliability" bit causes I frames to be used, while
turning on the "low delay" bit uses UI frames.  (The effect of turning
on both bits is undefined and subject to change).
.LP
In both modes, IP-level fragmentation is done if the datagram is larger
than the interface  MTU.  In virtual circuit mode, however, the resulting
datagram (or fragments) is further fragmented at the AX.25 layer if it
(or they) are still larger than the AX.25 \fBpaclen\fP parameter. In AX.25
fragmentation, datagrams are broken into several I frames and reassembled
at the receiving end before being passed to IP. This is preferable to
IP fragmentation whenever possible because of decreased overhead (the IP
header isn't repeated in each fragment) and increased robustness (a
lost fragment is immediately retransmitted by the link layer).
.NH 2
more <file> [<file> ...]
.LP
Display the specified file(s) a screen at a time. To proceed to the next
screen, press the space bar; to cancel the display, hit the 'q' key.
The \fBmore\fP command creates a session that you can suspend and resume
just like any other session.
.NH 2
param <iface> [<param> [value]] ...
.LP
Invoke a device-specific control routine.  The following parameter names
are recognized by the parameter command, but not all are supported by
each device type. Most commands deal only with half-duplex packet
radio interfaces.
.DS 
TxDelay - transmit keyup delay
Persist - P-persistence setting
SlotTime - persistence slot time setting
txTail - transmit done holdup delay
FullDup - enable/disable full duplex
Hardware - hardware specific command
TxMute - experimental transmit mute command
DTR - control Data Terminal Ready (DTR) signal to modem
RTS - control Request to Send (RTS) signal to modem
Speed - set line speed
EndDelay
Group
Idle
Min
MaxKey
Wait
Down - drop modem control lines
Up - raise modem control lines
Return - return a KISS TNC to command mode
.DE
.LP
Depending on the interface, some parameters can be read back by
omitting a new value. This is not possible with KISS TNCs as there
are no KISS commands for reading back previously sent parameters.
.LP
On a KISS TNC interface, the \fBparam\fP command generates and sends control
packets to the TNC.  Data bytes are treated as decimal.  For example,
\fBparam ax0 txdelay 255 \fP will set the keyup timer (type field = 1)
on the KISS TNC configured as ax0 to 2.55 seconds (255 x .01 sec).  On
all \fBasy\fP interfaces (slip, kiss/ax25, nrs, ppp)
the \fBparam <iface> speed\fP command allows the baud rate to be
read or set.
.LP
The implementation of this command for the various interface drivers is
incomplete and subject to change. 
.NH 2
ping <hostid> [<length> [<seconds> [<incflag>]]]
.LP
Ping (send ICMP Echo Request packets to) the specified host. By default
the data field contains only a small timestamp to aid in determining
round trip time; if the optional \fBlength\fP argument is given,
the appropriate number of data bytes (consisting of hex 55) are added to the
ping packets.
.LP
If interval is specified, pings will be repeated indefinitely
at the specified number of seconds;
otherwise a single, "one shot" ping is done.
Responses to one-shot pings appear asynchronously on the command screen,
while repeated pings create a session that may be suspended and resumed.
Pinging continues until the session is manually reset.
.LP
The \fBincflag\fP option causes a repeated ping to increment the
target IP address for each ping; it is an experimental feature for searching
blocks of IP addresses for active hosts.
.NH 2
ppp ...
.LP
These commands are used to configure Point to Point Protocol interfaces.
.LP
This implementation of PPP is designed to be as complete as possible.
Because of this, the number of options can be rather daunting.
However, a typical PPP configuration might include the following commands:
.DS
attach asy 0x3f8 4 ppp pp0 4096 1500 9600 r
dial pp0 dialer.pp0 30
#
ppp pp0 quick
ppp pp0 lcp open
#
route add default pp0
.DE
.NH 3
ppp <iface>
.LP
Display the status of the PPP interface.
.NH 3
ppp <iface> quick
.LP
Quick setup for the PPP link.
By popular demand, this command is a shortcut for the following commands:
.DS
ppp pp0 ipcp local compress tcp 16 1
ppp pp0 ipcp open
ppp pp0 lcp local accm 0
ppp pp0 lcp local acfc on
ppp pp0 lcp local pfc on
ppp pp0 lcp local magic on
.DE
.NH 3
ppp <iface> lcp ...
.LP
These commands are used for the LCP [Link Control Protocol]
configuration.
.NH 4
ppp <iface> lcp close
.LP
Shutdown the PPP interface.
.NH 4
ppp <iface> lcp local ...
.LP
These commands control the configuration of the local side of the link.
If an option is specified, the parameters will be used
as the initial values in configuration requests.
If not specified, that option will not be requested.
.LP
For each of these options,
the \fBallow\fP parameter will permit the remote
to include that option in its response,
even when the option is not included in the request.
By default, all options are allowed.
.NH 5
ppp <iface> lcp local accm [ <bitmap> | allow [on | off] ]
.LP
Display or set the Async Control Character Map.
The default is 0xffffffff.
.NH 5
ppp <iface> lcp local authenticate [ pap | none | allow [on | off] ]
.LP
Display or set the authentication protocol.
The default is \fBnone\fP.
.NH 5
ppp <iface> lcp local acfc [ on | off | allow [on | off] ]
.LP
Display or set the option to compress the address and control fields of
the PPP HLDC-like header.
This is generally desirable for slow asynchronous links,
and undesirable for fast or synchronous links.
The default is off.
.NH 5
ppp <iface> lcp local pfc [ on | off | allow [on | off] ]
.LP
Display or set the option to compress the protocol field of
the PPP HLDC-like header.
This is generally desirable for slow asynchronous links,
and undesirable for fast or synchronous links.
The default is off.
.NH 5
ppp <iface> lcp local magic [ on | off | <value> | allow [on | off] ]
.LP
Display or set the initial Magic Number.
The default is off (zero).
.NH 5
ppp <iface> lcp local mru [ <size> | allow [on | off] ]
.LP
Display or set the Maximum Receive Unit.
The default is 1500.
.NH 5
ppp <iface> lcp local default
.LP
Reset the options to their default values.
.NH 4
ppp <iface> lcp listen
.LP
Wait for the physical layer to come up,
then wait for configuration negotiation from the remote.
The \fBopen\fP command is preferred.
.NH 4
ppp <iface> lcp open
.LP
Wait for the physical layer to come up,
then initiate configuration negotiation.
.NH 4
ppp <iface> lcp remote ...
.LP
These commands control the configuration of the remote side of the link.
The options are identical to those of the local side.
If an option is specified, the parameters will be used
in responses to the remote's configuration requests.
If not specified, that option will be accepted if it is allowed.
.LP
For each of these options,
the \fBallow\fP parameter will permit the remote
to specify that option in its request.
By default, all options are allowed.
.NH 4
ppp <iface> lcp timeout [<seconds>]
.LP
Display or set the interval to wait between configuration
or termination attempts.
The default is 3 seconds.
.NH 4
ppp <iface> lcp try ...
.LP
These commands are used for the various counters.
.NH 5
ppp <iface> lcp try configure [<count>]
.LP
Display or set the number of configuration requests sent.
The default is 20.
.NH 5
ppp <iface> lcp try failure [<count>]
.LP
Display or set the number of bad configuration requests allowed from the remote.
The default is 10.
.NH 5
ppp <iface> lcp try terminate [<count>]
.LP
Display or set the number of termination requests sent before shutdown.
The default is 2.
.NH 3
ppp <iface> ipcp ...
.LP
These commands are used for the IPCP [Internet Protocol Control Protocol]
configuration.
.LP
The \fBclose, listen, open, timeout\fP and \fBtry\fP sub-commands
are identical to the LCP (described above).
.NH 4
ppp <iface> ipcp local ...
.LP
These commands control the configuration of the local side of the link.
If an option is specified, the parameters will be used
as the initial values in configuration requests.
If not specified, that option will not be requested.
.LP
For each of these options,
the \fBallow\fP parameter will permit the remote
to include that option in its response,
even when the option is not included in the request.
By default, all options are allowed.
.NH 5
ppp <iface> ipcp local address [ <hostid> | allow [on | off] ]
.LP
Display or set the local address for negotiation purposes.
If an address of 0 is specified,
the other side of the link will supply the address.
By default, no addresses are negotiated.
.NH 5
ppp <iface> ipcp local compress [ tcp <slots> [<flag>] | none | allow [on | off] ]
.LP
Display or set the compression protocol.
The default is \fBnone\fP.
.LP
The \fBtcp\fP <slots> specifies the number of "conversation" slots,
which must be 1 to 255.
(This may be limited at compilation time to a smaller number.)
A good choice is in the range 4 to 16.
.LP
The \fBtcp\fP <flag> is 0 (don't compress the slot number)
or 1 (OK to compress the slot number).
KA9Q can handle compressed slot numbers, so the default is 1.
.NH 4
ppp <iface> ipcp remote ...
.LP
These commands control the configuration of the remote side of the link.
The options are identical to those of the local side.
If an option is specified, the parameters will be used
in responses to the remote's configuration requests.
If not specified, that option will be accepted if it is allowed.
.LP
For each of these options,
the \fBallow\fP parameter will permit the remote
to specify that option in its request.
By default, all options are allowed.
.NH 4
ppp <iface> ipcp pool [<ip-address> [<count>]]
.LP
Specify a pool of addresses to be assigned to the <iface>.
The <count> is the number of addresses in the pool;
the default is 1.
.LP
The addresses will be used in rotation.
Overlapping series of addresses may be assigned to more than one <iface>,
and conflicts will be resolved.
.NH 3
ppp <iface> pap ...
.LP
These commands are used for the PAP [Password Authentication Protocol]
configuration.
.LP
The \fBtimeout\fP and \fBtry\fP sub-commands
are identical to the LCP (described above).
However, the terminate counter is unused.
.NH 4
ppp <iface> pap user [ <username> [<password>] ]
.LP
Display or set the username (the password may be set, but not displayed).
When the username is specified, but no password is supplied,
the \fBftpusers\fP file is searched for the password.
When a username/password is unknown or rejected,
a session will appear at the console to prompt for a new username/password.
.NH 3
ppp <iface> trace [<flags>]
.LP
Display or set the flags that control the logging of information
during PPP link configuration.
.LP
The flag value is 0 for none, 1 for basic, and 2 for general.
Values greater than 2 are usually not compiled,
and are described in the appropriate source files where they are defined.
.NH 2
ps
.LP
Display all current processes in the system. The fields are as follows:
.LP
\fBPID\fP - Process ID (the address of the process descriptor).
.LP
\fBSP\fP - The current value of the process stack pointer.
.LP
\fBstksize\fP - The size of the stack allocated to the process.
.LP
\fBmaxstk\fP - The apparent peak stack utilization of this process. This is
done in a somewhat heuristic fashion, so the numbers should be treated
as approximate. If this number reaches or exceeds the stksize figure,
the system is almost certain to crash; the \fBnet.exe\fP program
should be recompiled to give the process a larger allocation when it is started.
.LP
\fBevent\fP - The event this task is waiting for, if it is not runnable.
.LP
\fBfl\fP - Process status flags. There are three: I (Interrupts enabled),
W (Waiting for event) and S (Suspended). The I
flag is set whenever a task has executed a pwait() call (wait for
event) without first disabling hardware interrupts. Only tasks that
wait for hardware interrupt events will turn off this flag; this is
done to avoid critical sections and missed interrupts. The W flag
indicates that the process is waiting for an event; the \fBevent\fP
column will be non-blank. Note that although there may be several
runnable processes at any time (shown in the \fBps\fP listing as those
without the W flag and with blank event fields) only one
process is actually running at any one instant (The Refrigerator
Light Effect says that the \fBps\fP command is always the one running
when this display is generated.)
.NH 2
pwd [<dirname>]
.LP
An alias for the \fBcd\fP command.
.NH 2
record [off | <filename>]
.LP
Append to \fBfilename\fP all data received on the current
session.  Data sent on the current session is also written into the file
except for Telnet sessions in remote echo mode.  The command \fBrecord
off\fP stops recording and closes the file.
.NH 2
remote [-p <port>] [-k <key>] [-a <kickaddr>] <hostid> exit | reset | kick
.LP
Send a UDP packet to the specified host commanding it
to exit the \fBnet.exe\fP program, reset the processor,
or force a retransmission on TCP connections.  For this
command to be accepted, the remote system must be running the \fBremote\fP
server and the port number specified in the \fBremote\fP command must match
the port number given when the server was started on the remote system.
If the port numbers do not match, or if the remote server is not running
on the target system, the command packet is ignored.  Even if the
command is accepted there is no acknowledgement.
.LP
The \fBkick\fP command forces a retransmission timeout on all
TCP connections that the remote node may have with the local node.
If a connection is idle, a current ACK packet (without data) is sent.
If the -a option is used, connections to the specified host are
kicked instead. No key is required for the kick subcommand.
.LP
The \fBexit\fP and \fBreset\fP subcommands are mainly useful for
restarting the \fBnet.exe\fP program on a remote
unattended system after the configuration file has been updated.  The
remote system should invoke the \fBnet.exe\fP program automatically upon booting,
preferably in an infinite loop.  For example, under MS-DOS the boot disk
should contain the following in \fBautoexec.net\fP:
.DS
.ft CW
:loop
net
goto :loop
.ft P
.DE
.LP
.NH 2
remote -s <key>
.LP
The \fBexit\fP and \fBreset\fP subcommands of remote require a password.
The password is set
on a given system with the \fB-s\fP option, and it is specified in a command
to a remote system with the \fB-k\fP option. If no password is set with the
\fB-s\fP option, then the \fBexit\fP and \fBreset\fP subcommands are disabled.
.LP
Note that \fBremote\fP is an experimental feature in NOS; it is \fInot\fP
yet supported by any other TCP/IP implementation.
.NH 2
rename <oldfilename> <newfilename>
.LP
Rename \fBoldfilename\fP to \fBnewfilename\fP.
.NH 2
reset [<session>]
.LP
Reset the specified session; if no argument is given, reset the current
session.  This command should be used with caution since it does not
reliably inform the remote end that the connection no longer exists.  (In
TCP a reset (RST) message will be automatically generated should the remote
TCP send anything after a local reset has been done.  In AX.25 the DM
message performs a similar role.  Both are used to get rid of a lingering
half-open connection after a remote system has crashed.)
.NH 2
rip ...
.LP
These commands are used for the RIP service.
.NH 3
rip accept <gateway>
.LP
Remove the specified gateway from the RIP filter table, allowing future
broadcasts from that gateway to be accepted.
.NH 3
rip add <hostid> <seconds> [<flags>]
.LP
Add an entry to the RIP broadcast table. The IP routing table will be sent
to \fBhostid\fP every interval seconds. If
\fBflags\fP is specified as 1, then "split horizon" processing will
be performed
for this destination. That is, any IP routing table entries pointing to the
interface that will be used to send this update will be removed from the
update.  If split horizon processing is not specified, then all routing
table entries except those marked "private" will be sent in each update.
(Private entries are never sent in RIP packets).
.LP
Triggered updates are always done. That is, any change in the routing table
that causes a previously reachable destination to become unreachable will
trigger an update that advertises the destination with metric 15, defined to
mean "infinity".
.LP
Note that for RIP packets to be sent properly to a broadcast address, there
must exist correct IP routing and ARP table entries that will first steer
the broadcast to the correct interface and then place the correct link-level
broadcast address in the link-level destination field. If a standard IP
broadcast address convention is used (eg. 128.96.0.0 or 128.96.255.255)
then chances are you already have the necessary IP routing table entry, but
unusual subnet or cluster-addressed networks may require special attention.
However, an \fBarp add\fP command will be required to translate this address to
the appropriate link level broadcast address.  For example,
.sp
.DS I 0
.ft CW
arp add 128.96.0.0 ethernet ff:ff:ff:ff:ff:ff
.ft P
.DE
.sp
for an Ethernet network, and
.sp
.DS I 0
.ft CW
arp add 44.255.255.255 ax25 qst-0
.ft P
.DE
.sp
for an AX25 packet radio channel.
.NH 3
rip drop <dest>
.LP
Remove an entry from the RIP broadcast table.
.NH 3
rip merge [on | off]
.LP
This flag controls an experimental feature for consolidating redundant
entries in the IP routing table. When rip merging is enabled, the table is
scanned after processing each RIP update. An entry is considered redundant
if the target(s) it covers would be routed identically by a less "specific"
entry already in the table. That is, the target address(es) specified
by the entry in question must also match the target addresses of the
less specific entry and the two entries must have the same interface
and gateway fields. For example, if the routing table contains
.sp
.DS I 0
.ft CW
Dest            Len Interface    Gateway          Metric  P Timer  Use
1.2.3.4         32  ethernet0    128.96.1.2       1       0 0      0
1.2.3           24  ethernet0    128.96.1.2       1       0 0      0
.ft
.DE
.sp
then the first entry would be deleted as redundant since packets sent to
1.2.3.4 will still be routed correctly by the second entry. Note that the
relative metrics of the entries are ignored.
.NH 3
rip refuse <gateway>
.LP
Refuse to accept RIP updates from the specified gateway by adding the
gateway to the RIP filter table. It may be later removed with the \fBrip
accept\fP command.
.NH 3
rip request <gateway>
.LP
Send a RIP Request packet to the specified gateway, causing it to reply
with a RIP Response packet containing its routing table.
.NH 3
rip status
.LP
Display RIP status, including a count of the number of packets sent
and received, the number of requests and responses, the number of
unknown RIP packet types, and the number of refused RIP updates from hosts
in the filter table. A list of the addresses and intervals
to which periodic RIP updates are being sent is also shown, along with
the contents of the filter table.
.NH 3
rip trace [0 | 1 | 2]
.LP
This variable controls the tracing of incoming and outgoing RIP packets.
Setting it to 0 disables all RIP tracing. A value of 1 causes changes
in the routing table to be displayed, while packets that cause no changes
cause no output. Setting the variable to 2 produces maximum output,
including tracing of RIP packets that cause no change in the routing table.
.NH 2
rmdir <dirname>
.LP
Remove a sub-directory from the current working directory.
.NH 2
route
.LP
With no arguments, \fBroute\fP displays the IP routing table.
.NH 3
route add <dest_hostid>[/bits] | default <iface> [<gateway_hostid> [<metric>]]
.LP
This command adds an entry to the routing table. It requires at least two
more arguments, the hostid of the target destination and the name of
the interface to which its packets should be sent.  If the destination is
not local, the gateway's hostid should also be specified. (If the interface
is a point-to-point link, then \fBgateway_hostid\fP may be omitted even if the
target is non-local because this field is only used to determine the
gateway's link level address, if any.  If the destination is directly
reachable, \fBgateway_hostid\fP is also unnecessary since the destination
address is used to determine the interface link address).
.LP
The optional \fB/bits\fP suffix to the destination host id specifies how
many leading bits in the host id are to be considered significant in the
routing comparisons.  If not specified, 32 bits (i.e., full significance) is
assumed.  With this option, a single routing table entry may refer to
many hosts all sharing a common bit string prefix in their IP addresses. 
For example, ARPA Class A, B and C networks would use suffixes of /8,
/16 and /24 respectively; the command
.DS I 0
.ft CW
route add 44/8 sl0 44.64.0.2
.ft P
.DE
.LP
causes any IP addresses beginning with "44" in the first 8 bits to be
routed to 44.64.0.2; the remaining 24 bits are "don't-cares".
.LP
When an IP address to be routed matches more than one entry in the routing
table, the entry with largest \fBbits\fP parameter (i.e., the "best" match)
is used. This allows individual hosts or blocks of hosts to be exceptions
to a more general rule for a larger block of hosts.
.LP
The special destination \fBdefault\fP is used to route datagrams to
addresses not matched by any other entries
in the routing table; it is equivalent to specifying a
\fB/bits\fP suffix of /0 to any destination hostid.  Care must be taken with
default entries since two nodes with default entries pointing at each
other will route packets to unknown addresses back and forth in a loop
until their time-to-live (TTL) fields expire.  (Routing loops for
specific addresses can also be created, but this is less likely to occur
accidentally). The best way to use default routes is to pick one node
in your network that has the "best" connections to the world outside
your network. Create a spanning tree with that node as the root and have
each node install a default route pointing in the direction of that node,
\fIwith the exception of the root node.\fP
.LP
Here are some examples of the \fBroute\fP command:
.DS I 0
.ft CW
# Route datagrams to IP address 44.0.0.3 to SLIP line #0.
# No gateway is needed because SLIP is point-to point.
route add 44.0.0.3 sl0 

# Route all default traffic to the gateway on the local Ethernet
# with IP address 44.0.0.1
route add default ec0 44.0.0.1

# The local Ethernet has an ARPA Class-C address assignment;
# route all IP addresses beginning with 192.4.8 to it
route add 192.4.8/24 ec0

# The station with IP address 44.0.0.10 is on the local AX.25 channel
route add 44.0.0.10 ax0
.ft P
.DE
.NH 3
route addprivate <dest hostid>[/bits] | default <iface> [<gateway hostid> [<metric>]]
.LP
This command is identical to \fBroute add\fP except that it also marks the new
entry as private; it will never be included in outgoing RIP updates.
.NH 3
route drop <dest hostid>
.LP
\fBroute drop\fP deletes an entry from the table. If a packet arrives for the
deleted address and a default route is in effect, it will be used.
.NH 2
session [<session #>]
.LP
Without arguments, displays the list of current sessions, including
session number, remote TCP or AX.25 address and the associated socket
index.  An asterisk (*) is shown next to the current
session; entering a blank line at this point puts you in converse mode with
that session.  Entering a session number as an argument to the \fBsession\fP
command will put you in \fIconverse\fP mode with that session.  If the Telnet
server is enabled, the user is notified of an incoming request and a
session number is automatically assigned.  The user may then select the
session normally to converse with the remote user as though the session
had been locally initiated. 
.NH 2
shell
.LP
Suspends \fBnet.exe\fP and executes a sub-shell
("command processor" under MS-DOS).
When the sub-shell exits, \fBnet.exe\fP resumes
(under MS-DOS, enter the \fBexit\fP command).
Background activity (FTP servers, etc) is also suspended
while the subshell executes. Note that this will fail unless there is
sufficient unused memory for the sub-shell and whatever command the user
tries to run.
.NH 2
smtp ...
.LP
These commands control the operation of the Simple Mail Transfer Protocol
(that is, mail).
.NH 3
smtp gateway [<hostid>]
.LP
Displays or sets the host to be used as a "smart" mail relay. Any mail sent
to a host not in the host table will instead be sent to the gateway for
forwarding.
.NH 3
smtp kick
.LP
Run through the outgoing mail queue and attempt to deliver any pending mail.
This command allows the user to "kick" the mail system manually.
Normally, this command is periodically invoked by a timer
whenever \fBnet.exe\fP is running.
.NH 3
smtp maxclients [<count>]
.LP
Displays or sets the maximum number of simultaneous outgoing SMTP sessions
that will be allowed. The default is 10; reduce it if network congestion
is a problem.
.NH 3
smtp timer [<seconds>]
.LP
Displays or sets the interval between "kicks" (scans) of the outbound
mail queue. For example, \fBsmtp timer 600\fP will cause the system to check
for outgoing mail every 10 minutes and attempt to deliver anything it finds,
subject of course to the \fBsmtp maxclients\fP limit. Setting a value of zero
disables
queue scanning altogether, note that this is the default!  This value is
recommended for stand alone IP gateways that never handle mail, since it
saves wear and tear on the floppy disk drive.
.NH 3
smtp trace [<value>]
.LP
Displays or sets the trace flag in the SMTP client, allowing you to
watch SMTP's conversations as it delivers mail.  Zero (the default)
disables tracing.
.NH 2
socket [<socket #>]
.LP
Without an argument, displays all active sockets, giving their index
and type, the address of the associated protocol control block and the
and owner process ID and name. If the index to an active socket is
supplied, the status display for the appropriate protocol is called.
For example, if the socket refers to a TCP connection, the display will
be that given by the \fBtcp status\fP command with the protocol control
block address.
.NH 2
start ax25 | discard | echo | ftp | netrom | remote | smtp | telnet | ttylink
.LP
Start the specified Internet server, allowing remote connection requests.
.NH 2
stop ax25 | discard | echo | ftp | netrom | remote | smtp | telnet | ttylink
.LP
Stop the specified Internet server, rejecting any further remote connect
requests. Existing connections are allowed to complete normally.
.NH 2
tcp ...
.LP
These commands are used for the Transmission Control Protocol service.
.NH 3
tcp irtt [<milliseconds>]
.LP
Display or set the initial round trip time estimate, in milliseconds, to be
used for new TCP connections until they can measure and adapt to the
actual value.  The default is 5000 milliseconds (5 seconds).
Increasing this when operating
over slow channels will avoid the flurry of retransmissions that would
otherwise occur as the smoothed estimate settles down at the correct
value. Note that this command should be given before servers are started in
order for it to have effect on incoming connections.
.LP
TCP also caches measured round trip times and mean
deviations (MDEV) for current and recent destinations. Whenever a new
TCP connection is opened, the system first looks in this cache. If the
destination is found, the cached IRTT and MDEV values are used. If not,
the default IRTT value mentioned above is used, along with a MDEV of 0.
This feature is fully automatic, and it can improve performance greatly
when a series of connections are opened and closed to a given destination
(eg. a series of FTP file transfers or directory listings).
.NH 3
tcp kick <tcb_addr>
.LP
If there is unacknowledged
data on the send queue of the specified TCB, this command forces
an immediate retransmission. 
.NH 3
tcp mss [<size>]
.LP
Display or set the TCP Maximum Segment Size in bytes that will be sent on all
outgoing TCP connect request (SYN segments).  This tells the remote end the
size of the largest segment (packet) it may send. Changing MSS affects
only future connections; existing connections are unaffected.
.NH 3
tcp reset <tcb_addr>
.LP
Deletes the TCP control block at the specified address.
.NH 3
tcp rtt <tcb_addr> <rtt> <mdev>
.LP
Replaces the automatically computed round trip time and mean deviation
values in the specified TCB
with new values in milliseconds.  This command is useful to speed up
recovery from a series of lost packets since it provides a manual bypass
around the normal backoff retransmission timing mechanisms. 
.NH 3
tcp status [<tcb_addr>]
.LP
Without arguments, displays several TCP-level statistics, plus a summary of
all existing TCP connections, including TCB address, send and receive queue
sizes, local and remote sockets, and connection state. If \fBtcb_addr\fP is
specified, a more detailed dump of the specified TCB is generated, including
send and receive sequence numbers and timer information.
.NH 3
tcp window [<size>]
.LP
Displays or sets the default receive window size in bytes to be used by TCP
when creating new connections. Existing connections are unaffected.
.NH 2
telnet <hostid>
.LP
Creates a Telnet session to the specified host and enters converse mode.
.NH 2
tip <iface>
.LP
Creates a \fBtip\fP session that
connects to the specified interface in "dumb terminal" mode.
The interface must have already been attached with the \fBattach\fP command.
Any packet
traffic (IP datagrams, etc) routed to the interface while this session
exists will be discarded.
To close a \fBtip\fP session, use the \fBreset\fP command. It
will then revert to normal \fBslip, nrs\fP or \fBkiss\fP mode operation.
.LP
This feature is primarily useful for manually establishing SLIP connections.
At present, only the built-in "com" ports can be used with this command.
.NH 2
trace [<iface> [off | <btio> [<tracefile>]]]
.LP
Controls packet tracing by the interface drivers. Specific bits enable
tracing of the various interfaces and the amount of information produced.
Tracing is controlled on a per-interface basis; without arguments, \fBtrace\fP
gives a list of all defined interfaces and their tracing status.
Output can be limited to a single interface by specifying it, and the
control flags can be change by specifying them as well. The flags are
given as a hexadecimal number which is interpreted as follows:
.DS I 0
.ft CW
    O - Enable tracing of output packets if 1, disable if 0
    I - Enable tracing of input packets if 1, disable if 0
    T - Controls type of tracing:
	0 - Protocol headers are decoded, but data is not displayed
	1 - Protocol headers are decoded, and data (but not the
	    headers themselves) are displayed as ASCII characters,
	    64 characters/line. Unprintable characters are displayed
	    as periods.
	2 - Protocol headers are decoded, and the entire packet
	    (headers AND data) is also displayed in hexadecimal
	    and ASCII, 16 characters per line.
    B - Broadcast filter flag. If set, only packets specifically addressed
	to this node will be traced; broadcast packets will not be displayed.
.ft
.DE
If \fBtracefile\fP is not specified, tracing will be to the console.
.NH 2
udp status
.LP
Displays the status of all UDP receive queues.
.NH 2
upload [<filename>]
.LP
Opens \fBfilename\fP and sends it on the current session as though it were
typed on the terminal.
.NH 2
watch
.LP
Displays the current software stopwatch values, with min and max readings
for each. This facility allows a programmer to measure the execution time
of critical sections of code with microsecond resolution.
This command is supported only on the IBM PC, and the meaning of each
stopwatch value depends on where the calls have been inserted for test
purposes; the distribution copy of \fBnet.exe\fP usually has no stopwatch calls.
.NH 2
?
.LP
Same as the \fBhelp\fP command.
.NH 1
Attach Commands
.LP
This chapter details the attach commands for the various hardware interface
drivers. Not all of these drivers may be configured into every \fBnet.exe\fP
binary; a list of the available types may be obtained by entering the
command \fBattach ?\fP.
.LP
Some parameters are accepted by several drivers. They are:
.NH 3
<bufsize>
.LP
For asynchronous devices (eg. COM ports operating in SLIP or NRS mode)
this parameter specifies the size of the receiver's ring buffer.
It should be large enough to hold incoming data at full line speed for
the longest time that the system may be busy in MS-DOS or the BIOS doing
a slow I/O operation (eg. to a floppy disk). A kilobyte is usually more
than sufficient.
.LP
For synchronous devices (eg. the \fBscc, hs, pc100, hapn\fP
and \fBdrsi\fP interfaces operating in HDLC mode),
the bufsize parameter specifies the largest packet
that may be received on the interface.  This should be set by mutual
agreement among stations sharing the channel. For standard AX.25 with a
maximum I-frame data size of 256 bytes, a value of 325 should provide an
adequate safety margin. On higher speed channels (eg. 56kb/s) larger
values (eg. 2K bytes) will provide much better performance and allow
full-sized Ethernet packets to be carried without fragmentation.
.NH 3
<ioaddr>
.LP
The base address of the interface's control registers, in hex.
.NH 3
<vector>
.LP
The interface's hardware interrupt (IRQ) vector, in hex.
.NH 3
<iface>
.LP
The name (an arbitrary character string)
to be assigned to this interface. It is used to refer to the
interface in \fBifconfig\fP and \fBroute\fP commands and in \fBtrace\fP output.
.NH 3
<mtu>
.LP
The Maximum Transmission Unit size, in bytes.  Datagrams
larger than this limit will be fragmented at the IP layer into smaller
pieces. For AX.25 UI frames, this limits the size of the information field.
For AX.25 I frames, however, the \fBax25 paclen\fP parameter is also
relevant.  If
the datagram or fragment is still larger than \fBpaclen\fP, it is also
fragmented at the AX.25 level (as opposed to the IP level) before
transmission.  (See the \fBax25 paclen\fP command for further information).
.NH 3
<speed>
.LP
The speed in bits per second (eg. 2400).
.NH 2
attach 3c500 <ioaddr> <vector> arpa <iface> <qlen> <mtu> [<ip_addr>]
.LP
Attach a 3Com 3C501 Ethernet interface.  \fBqlen\fP is the maximum allowable
transmit queue length.  If the \fBip_addr\fP parameter is not given, the value
associated with a prior \fBip address\fP command will be used.
.LP
The use of this driver is not recommended; use the packet driver interface
with the loadable 3C501 packet driver instead.
.NH 2
attach asy <ioaddr> <vector> ax25 | nrs | ppp | slip <iface> <bufsize> <mtu>
<speed> [<crv>]
.LP
Attach a standard PC "com port" (asynchronous serial port),
using the National 8250 or 16550A chip.
Standard values on the IBM PC and clones for \fBioaddr\fP and \fBvector\fP
are 0x3f8 and 4 for COM1,
and 0x2f8 and 3 for COM2.
If the port uses a 16550A chip, it will be detected
automatically and the FIFOs enabled.
.NH 3
ax25
.LP
Similar to \fBslip\fP, except that an AX.25 header and a KISS TNC
control header are added to the front of the datagram before SLIP
encoding.  Either UI (connectionless) or I (connection-oriented) AX.25
frames can be used; see the \fBmode\fP command for details. 
.NH 3
nrs
.LP
Use the NET/ROM asynchronous framing technique for communication with
a local NET/ROM TNC.
.NH 3
ppp
.LP
Point-to-Point-Protocol.
Encapsulates datagrams in an HDLC-like frame.
This is a new Internet standard for point-to-point communication,
compatible with CCITT standards.
.NH 3
slip
.LP
Serial Line Internet Protocol.
Encapsulates IP datagrams directly in SLIP frames without a link
header. This is for operation on point-to-point lines and is compatible
with 4.2BSD UNIX SLIP.
.NH 3
<crv>
.LP
The optional flags are a string of characters "crv":
\fBc\fP enables RTS/CTS detection,
\fBr\fP enables RLSD (Carrier Detect) physical line sensing,
\fBv\fP enables Van Jacobson TCP/IP Header Compression,
and is valid only for SLIP.
.NH 2
attach drsi <ioaddr> <vector> ax25 <iface> <bufsize> <mtu> <ch_a_speed>
<ch_b_speed>
.LP
N6TTO driver for the Digital Radio Systems PCPA 8530 card.
Since there are two channels on the board, two interfaces are attached.
They will be named \fBiface\fP with 'a' and 'b' appended.
\fBbufsize\fP is the receiver buffer size in bytes;
it must be larger than the largest frame to be received.
\fBch_a_speed\fP and \fBch_b_speed\fP are the speeds, in bits/sec,
for the A and B channels, respectively.
.NH 2
attach eagle <ioaddr> <vector> ax25 <iface> <bufsize> <mtu> <speed>
.LP
WA3CVG/NG6Q driver for the Eagle Computer card (Zilog 8530).
.NH 2
attach hapn <ioaddr> <vector> ax25 <iface> <bufsize> <mtu> csma | full
.LP
KE3Z driver for the Hamilton Amateur Packet Network adapter (Intel 8273).
The \fBcsma | full\fP parameter specifies whether the port should operate in
carrier sense multiple access (CSMA) mode or in full duplex.
.NH 2
attach hs <ioaddr> <vector> ax25 <iface> <bufsize> <mtu> <keyup_delay> <p>
.LP
Attach a DRSI PCPA or Eagle Computer interface card
using a special "high speed" 8530 driver.
This driver uses busy-wait loops to send and receive
each byte instead of interrupts, making it usable with high speed modems
(such as the WA4DSY 56kb/s modem) on slow systems.
This does have the side effect of "freezing"
the system whenever the modem transmitter or receiver is active.
This driver can operate only in CSMA mode, and it is recommended that
no other interfaces requiring small interrupt latencies be attached to
the same machine.
.LP
The \fBkeyup_delay\fP parameter specifies the transmitter keyup delay in
milliseconds. The \fBp\fP value specifies the transmitter persistence
value in the range 1-255; the corresponding slot time is fixed at one
hardware clock tick, about 55 ms on the PC.
.LP
As with the other 8530 drivers, this driver actually attaches two interfaces,
one for each 8530 channel.
.NH 2
attach packet <intvec> <iface> <txqlen> <mtu>
.LP
Attach a separate software "packet driver" meeting the
FTP Software, Inc, Software Packet Driver specification.
The driver must have already been installed as a TSR
(e.g., by invocation in autoexec.bat).
Packet drivers in the Ethernet, ARCNET,
SLIP, SLFP, and KISS/AX25 classes are supported.
.LP
\fBintvec\fP is the software interrupt vector used for communication to the
packet driver, and \fBtxqlen\fP is the maximum number of packets that will
be allowed on the transmit queue.
.NH 2
attach pc100 <ioaddr> <vector> ax25 <iface> <bufsize> <speed>
.LP
Driver for the PACCOMM PC-100 (Zilog 8530) card.
Only AX.25 operation is supported.
.NH 2
attach scc <devices> init <addr> <spacing> <Aoff> <Boff> <Dataoff> <intack>
<vec> [p|r]<clock> [<hdwe>] [<param>]
.LP
PE1CHL driver to initialize a generic SCC (8530) interface board
prior to actually attaching it. The parameters are as follows:
.NH 3
<devices>
.LP
The number of SCC chips to support.
.NH 3
<addr>
.LP
The base address of the first SCC chip (hex).
.NH 3
<spacing>
.LP
The spacing between the SCC chip base addresses.
.NH 3
<Aoff>
.LP
The offset from a chip's base address to its channel A control register.
.NH 3
<Boff>
.LP
The offset from a chip's base address to its channel B control register.
.NH 3
<Dataoff>
.LP
The offset from each channel's control register to its data register.
.NH 3
<intack>
.LP
The address of the INTACK/Read Vector port. If none,
specify 0 to read from RR3A/RR2B.
.NH 3
<vec>
.LP
The CPU interrupt vector for all connected SCCs.
.NH 3
<clock>
.LP
The clock frequency (PCLK/RTxC) of all SCCs in hertz.
Prefix with 'p' for PCLK, 'r' for RTxC clock (for baudrate gen).
.NH 3
<hdwe>
.LP
Optional hardware type. The following values are currently supported:
1 - Eagle card, 2 - PACCOMM PC-100, 4 - PRIMUS-PC card (DG9BL), 8 - DRSI
PCPA card.
.NH 3
<param>
.LP
Optional extra parameter. At present, this is used only with the PC-100
and PRIMUS-PC cards to set the modem mode. The value 0x22 is used with
the PC-100 and 0x2 is used with the PRIMUS-PC card.
.LP  
The \fBattach scc ... init\fP command must be given
before the interfaces are actually attached with the following command.
.NH 2
attach scc <chan> slip | kiss | nrs | ax25 <iface> <mtu> <speed> <bufsize> [<call>]
.LP
Attach an initialized SCC port to the system. The parameters are as follows:
.NH 3
<chan>
.LP
The SCC channel number to attach, 0 or 1 for the first chip's A or B port,
2 or 3 for the second chip's A or B port, etc.
.NH 3
slip | kiss | nrs | ax25
.LP
The operating mode of the interface. \fBslip, kiss\fP
and \fBnrs\fP all operate the
port hardware in asynchronous mode; \fBslip\fP
is Internet-standard serial line
IP mode, \fBkiss\fP generates SLIP frames containing KISS TNC commands and
AX.25 packets and \fBnrs\fP uses NET/ROM local serial link framing conventions
to carry NET/ROM packets. Selecting \fBax25\fP mode puts the interface into
synchronous HDLC mode that is suitable for direct connection to a half duplex
radio modem.
.NH 3
<speed>
.LP
The interface speed in bits per second (eg. 1200).
Prefix with 'd' when an external divider
is available to generate the TX clock. When the clock source is PCLK,
this can be a /32 divider between TRxC and RTxC. When the clock is at RTxC,
the TX rate must be supplied at TRxC. This is needed only for full duplex
synchronous operation. When this arg is given as 'ext', the transmit and
receive clocks are external, and the internal baud rate generator (BRG)
and digital phase locked loop (DPLL) are not used.
.NH 2
Attach Examples
.LP
Here are some examples of the attach command:
.LP
.DS I 0
.ft CW
# Attach a 3Com Ethernet controller using the standard 3Com address and
# vector (i.e., as it comes out of the box) to use ARPA-standard encapsulation.
# The receive queue is limited to 5 packets, and outgoing packets larger
# than 1500 bytes will be fragmented
attach 3c500 0x300 3 arpa ec0 5 1500

# Attach the PC asynch card normally known as "com1" (the first controller)
# to operate in point-to-point slip mode at 9600 baud, calling it "sl0".
# A 1024 byte receiver ring buffer is allocated. Outgoing packets larger
# than 256 bytes are fragmented.
attach asy 0x3f8 4 slip sl0 1024 256 9600

# Attach the secondary PC asynch card ("com2") to operate in AX.25 mode
# with an MTU of 576 bytes at 9600 baud with a KISS TNC, calling it "ax0".
# By default, IP datagrams are sent in UI frames
attach asy 0x2f8 3 ax25 ax0 1024 576 9600

# Attach the packet driver loaded at interrupt 0x7e
# The packet driver is for an Ethernet interface
attach packet 0x7e ethernet 8 1500
.ft P
.DE
.LP
.NH 1
FTP Subcommands
.LP
During converse mode with an FTP server, everything typed on the console is
first examined to see if it is a locally-known command. If not, the line is
passed intact to the remote server on the control channel. If it is one of
the following commands, however, it is executed locally. (Note that this
generally involves other commands being sent to the remote server on the
control channel.)
.NH 2
dir [<file> | <directory> [<local file>]]
.LP
Without arguments,
\fBdir\fP requests that a full directory listing of the remote
server's current directory be sent to the terminal.  If one argument is
given, this is passed along in the LIST command; this can be a specific
file or subdirectory that is meaningful to the remote file system. If two
arguments are given, the second is taken as the local file into which the
directory listing should be put (instead of being sent to the console).
The PORT command is used before the LIST command is sent.
.NH 2
get <remote file> [<local file>]
.LP
Asks the remote server to send the file specified in the first argument.
The second argument, if given, will be the name of the file on the local
machine; otherwise it will have the same name as on the remote machine.
The PORT and RETR commands are sent on the control channel.
.NH 2
hash
.LP
A synonym for the \fBverbose 3\fP command.
.NH 2
ls [<file> | <directory> [<local file>]]
.LP
\fBls\fP is identical to the \fBdir\fP command except that the "NLST"
command is
sent to the server instead of the "LIST" command. This results in an
abbreviated directory listing, i.e., one showing only the file names
themselves without any other information.
.NH 2
mget <file> [<file> ...]
.LP
Fetch a collection of files from the server. File names may include
wild card characters; they will be interpreted and expanded into a
list of files by the remote
system using the NLST command. The files will have the same name on
the local system that they had on the server.
.NH 2
mkdir <remote directory>
.LP
Creates a directory on the remote machine.
.NH 2
mput <file> [<file> ...]
.LP
Send a collection of files to the server. File names may include
wild card characters; they will be expanded locally into a list
of files to be sent. The files will have the same name on the
server as on the local system.
.NH 2
put <local file> [<remote file>]
.LP
Asks the remote server to accept data, creating the file named in the
first argument. The second argument, if given, will be the name of the file
on the remote machine; otherwise it will have the same name as on the local
machine.  The PORT and STOR commands are sent on the control channel.
.NH 2
rmdir <remote directory>
.LP
Deletes a directory on the remote machine.
.NH 2
type [a | i | l <bytesize>]
.LP
Tells both the local client and remote server the type of file that is
to be transferred.  The default is 'a', which means ASCII (i.e., a text
file).  Type 'i' means \fIimage\fP, i.e., binary.  In ASCII mode, files are
sent as varying length lines of text in ASCII separated by cr/lf
sequences; in IMAGE mode, files are sent exactly as they appear in the
file system.  ASCII mode should be used whenever transferring text
between dissimilar systems (eg. UNIX and MS-DOS) because of their
different end-of-line and/or end-of-file conventions.  When exchanging
text files between machines of the same type, either mode will work but
IMAGE mode is usually faster.  Naturally, when exchanging raw
binary files (executables, compressed archives, etc) IMAGE mode must be
used.  Type 'l' (logical byte size) is used when exchanging binary files
with remote servers having oddball word sizes (eg. DECSYSTEM-10s and 20s).
Locally it works exactly like IMAGE, except that it notifies the
remote system how large the byte size is. \fBbytesize\fP is typically 8.
The type command sets the local transfer mode and generates the TYPE
command on the control channel. 
.NH 2
verbose [0 | 1 | 2 | 3]
.LP
Set or display the level of message output in file transfers.
\fBVerbose 0\fP gives the least output, and \fBverbose 3\fP the most,
as follows:
.DS I 0
0 - Display error messages only.
1 - Display error messages plus a one-line summary after each transfer
    giving the name of the file, its size, and the transfer time and rate.
2 - Display error and summary messages plus the progress messages generated
    by the remote FTP server. (This setting is the default.)
3 - Display all messages. In addition, a "hash mark" (#) is displayed for
    every 1,000 bytes sent or received.
.DE
If a command is sent to the
remote server because it is not recognized locally, the response
is always displayed, regardless of the setting of \fBverbose\fP.
This is necessary for commands like \fBpwd\fP (display working directory),
which would
otherwise produce no message at all if \fBverbose\fP were set to 0 or 1.
.NH 1
Dialer Subcommands
.LP
Each dialer command may (should) have a different dialer file.
The file resides in the configuration directory,
as specified in the \fBInstallation\fP section (see chapter 1).
A typical dialer file might be:
.DS
# Set the speed, and toggle DTR to ensure modem is in command mode.
control down
wait 3000
speed 2400
control up
wait 3000
# Dial, and wait for connection
send "atdt555-1212\\r"
wait 45000 "CONNECT " speed
wait 2000
# PAD specific initialization
send "\\r"
wait 15000 "Terminal ="
send "ppp\\r"
wait 10000 "\\r\\n"
.DE
.NH 3
control down | up
.LP
Control \fBasy\fP interface.
The \fBdown\fP option drops DTR and RTS.
The \fBup\fP option asserts DTR and RTS.
.NH 3
send "string" [<milliseconds>]
.LP
This dialer command will write the specified string to the interface.
The string quote marks are required,
and the string may not contain embedded control characters.
However, the standard C string escape sequences are recognized
(\\0 should not be used).
.LP
There may be a wait of <milliseconds> between each character.
This is used when the dialer cannot process a string at modem speeds.
.NH 3
speed [ 9600 | 4800 | 2400 | 1200 | 300 ]
.LP
This dialer command will set the speed of the interface to one of the
available speeds.
If the speed is missing,
the speed will be displayed in the dialer session window.
.NH 3
wait <milliseconds> [ "test string" ] [ speed ]
.LP
If only the time is specified,
the dialer pauses for the desired number of milliseconds.
.LP
Otherwise, the dialer reads until the test string is detected on the interface.
If the string is not detected within the desired time,
the autodialer will reset.
The string quote marks are required,
and the string may not contain embedded control characters.
However, the standard C string escape sequences are recognized
(\\0 should not be used).
.LP
Finally, if the \fIspeed\fP parameter is specified,
the dialer will continue to read characters until a non-digit is detected.
The string read is converted to an integer,
and used to set the interface speed.
If the trailing non-digit is not detected within the desired time,
or the integer value is not a valid speed,
the autodialer will reset.
The \fIspeed\fP feature is useful for reading back the CONNECT <speed>
message generated by Hayes-compatible modems.
.NH 1
The /ftpusers File
.LP
Since MS-DOS is a single-user operating system (some might say it is
a glorified bootstrap loader), it provides
no access control; all files can be read, written or deleted by the
local user.  It is usually undesirable to give such open access to a
system to remote network users.  \fBNet.exe\fP therefore provides its own
access control mechanisms.
.LP
The file \fB/ftpusers\fP controls remote FTP and mailbox access.
The FTP default
is \fIno\fP access; if this file does not exist, the FTP server will be
unusable.  A remote user must first "log in" to the system with the USER
and PASS commands, giving a valid name and password listed in \fB/ftpusers\fP,
before he or she can transfer files. 
.LP
Each entry in \fB/ftpusers\fP consists of a single line of the form
.DS I 0
.ft CW
username password /path permissions
.ft P
.DE
.LP
There must be exactly four fields, and there must be exactly one space
between each field.  Comments may be added after the last field. 
Comment lines begin with '#' in column one. 
.LP
\fBusername\fP is the user's login name.
.LP
\fBpassword\fP is the required password.  Note that this is in
plain text; therefore it is not a good idea to give general read
permission to the root directory.  A password of '*' (a single asterisk)
means that any password is acceptable. 
.LP
\fB/path\fP is the allowable prefix on accessible files.  Before any
file or directory operation, the current directory and the user-
specified file name are joined to form an absolute path name in
"canonical" form (i.e., a full path name starting at the root, with "./"
and "../" references, as well as redundant /'s, recognized and removed). 
The result MUST begin with the allowable path prefix; if not, the
operation is denied.  This field must always begin with a
"/", i.e., at the root directory. 
.LP
\fBpermissions\fP is a decimal number granting permission for read,
create and write operations.  If the low order bit (0x1) is set, the
user is allowed to read a file subject to the path name prefix
restriction.  If the next bit (0x2) is set, the user is allowed to
create a new file if it does not overwrite an existing file.  If the
third bit (0x4) is set, the user is allowed to write a file even if it
overwrites an existing file, and in addition he may delete files.  Again,
all operations are allowed subject to the path name prefix restrictions. 
Permissions may be combined by adding bits, for example, 0x3 (= 0x2 + 0x1)
means that the user is given read and create permission, but not
overwrite/delete permission.
.LP
For example, suppose \fB/ftpusers\fP on machine
pc.ka9q.ampr.org contains the line
.DS I 0
.ft CW
friendly test /testdir 7
.ft P
.DE
.LP
A session using this account would look like this:
.DS I 0
.ft CW
net> ftp pc.ka9q.ampr.org
Resolving pc.ka9q.ampr.org... Trying 128.96.160.1...
FTP session 1 connected to pc.ka9q.ampr.org
220 pc.ka9q.ampr.org FTP version 900418 ready at Mon May 7 16:27:18 1990
Enter user name: friendly
331 Enter PASS command
Password: test [not echoed]
230 Logged in
ftp>
.ft P
.DE
.LP
The user now has read, write, overwrite and delete privileges for any file
under /testdir; he may not access any other files.
.LP
Here are some more sample entries in \fB/ftpusers\fP:
.DS I 0
.ft CW
karn foobar / 7         # User "karn" with password "foobar" may read,
                        # write, overwrite and delete any file on the
                        # system.

guest bletch /g/bogus 3 # User "guest" with password "bletch" may read
                        # any file under /g/bogus and its subdirectories,
                        # and may create a new file as long as it does
                        # not overwrite an existing file. He may NOT
                        # delete any files.

anonymous * /public 1   # User "anonymous" (any password) may read files
                        # under /public and its subdirectories; he may
                        # not create, overwrite or delete any files.
.ft
.DE
.LP
This last entry is the standard convention for keeping a repository of
public files; in particular, the username "anonymous" is an established
ARPA convention. 
.NH 1
The \fBdomain.txt\fP File
.LP
\fBNet.exe\fP translates domain names (eg. "pc.ka9q.ampr.org") to IP addresses
(eg. 128.96.160.3) through the use of an Internet Domain Name resolver and
a local "cache" file, \fBdomain.txt\fP.
Whenever the user specifies a domain name,
the local cache is searched for the desired entry.
If it is present, it is used;
if not, and if domain name server(s) have been configured,
a query is sent over the network to the current server.
If the server responds,
the answer is added to the \fBdomain.txt\fP file for future use.
If the server does not respond, any additional servers on the list are
tried in a round-robin fashion until one responds,
or the retry limit is reached (see the \fBdomain retry\fP command).
If \fBdomain.txt\fP does not contain the
desired entry and there are no configured domain name servers,
then the request immediately fails.
.LP
If a domain name server is available, and if all references to host-ids in
your /\fBautoexec.net\fP file are in IP address format, then it is
possible to start with a completely empty \fBdomain.txt\fP file
and have \fBnet.exe\fP build it for you.
However, you may wish to add your own entries to \fBdomain.txt\fP,
either because you prefer to use symbolic domain names in your
/\fBautoexec.net\fP file
or you don't have access to a domain server and you need to create entries
for all of the hosts you may wish to access.
.LP
Each entry takes one line,
and the fields are separated by any combination of tabs or spaces.
For example:
.DS I 0
pc.ka9q.ampr.org.	IN	A	128.96.160.3
.DE
\fBIN\fP is the \fIclass\fP of the record.
It means \fIInternet\fP, and it will be found in all entries.
\fBA\fP is the \fItype\fP of the record, and it means that this is
an \fIaddress\fP record.
Domain name \fBpc.ka9q.ampr.org\fP therefore has Internet
address 128.96.160.3.
.LP
Another possible entry is the \fBCNAME\fP (Canonical Name) record.
For example:
.DS I 0
ka9q.ampr.org.		IN	CNAME	pc.ka9q.ampr.org.
.DE
This says that domain name "ka9q.ampr.org" is actually an alias for the
system with (primary, or \fIcanonical\fP) domain name "pc.ka9q.ampr.org."
When a domain name having a \fBCNAME\fP
record is given to \fBnet.exe\fP, the system
automatically follows the reference to the canonical name and returns the
IP address associated with that entry.
.LP
Entries added automatically by \fBnet.exe\fP will have an additional field between
the domain name and the class (\fBIN\fP) field.  For example:
.DS I 0
pc.ka9q.ampr.org.	3600	IN	A	128.96.160.3
.DE
This is the \fItime-to-live\fP value, in seconds, associated with the record
received from the server. Clients (such as \fBnet.exe\fP) caching these records are
supposed to delete them after the time-to-live interval has expired,
allowing for the possibility that the information in the record may become
out of date.
.LP
This implementation of \fBnet.exe\fP will decrement the TTL to zero, but will not
delete the record unless the "clean" flag is on
(see the \fBdomain cache clean\fP command).
When a remote server is not available, the old entry will be used.
.LP
When the \fITTL\fP value is missing (as in the examples above),
the record will never expire, and must be managed by hand.
Since \fBdomain.txt\fP is a plain text file,
it may be easily edited by the user to add, change or delete records.
.LP
Additional types of records include MX (mail exchanger),
NS (name server) and SOA (start of
authority) may appear in \fBdomain.txt\fP from remote server responses. Only
MX is currently used by \fBnet.exe\fP (in the mailbox). The others
are retained for future development
(such as the incorporation of a smarter resolver or a full-blown
domain name server).
.NH 1
Setting Bufsize, Paclen, Maxframe, MTU, MSS and Window
.LP
Many \fBnet.exe\fP users are confused by these parameters and do not know how to
set them properly. This chapter will first review these parameters and
then discuss how to choose values for them. Special emphasis is given to
avoiding interoperability problems that may appear when communicating
with non-\fBnet.exe\fP implementations of AX.25.
.NH 2
Hardware Parameters
.LP
.NH 3
Bufsize
.LP
This parameter is required by most of \fBnet.exe\fP's built-in HDLC drivers
(eg. those for the DRSI PCPA and the Paccomm PC-100). It specifies the size
of the buffer to be allocated for each receiver port. HDLC frames
larger than this value cannot be received.
.LP
There is no default \fBbufsize\fP; it must be specified in the \fBattach\fP
command for the interface.
.NH 2
AX25 Parameters
.NH 3
Paclen
.LP
Paclen limits the size of the data field in an AX.25 I-frame. This
value does \fInot\fP include the AX.25 protocol header (source,
destination and digipeater addresses).
.LP
Since unconnected-mode (datagram) AX.25 uses UI frames, this parameter
has no effect in unconnected mode.
.LP
The default value of \fBpaclen\fP is 256 bytes.
.NH 3
Maxframe
.LP
This parameter controls the number of I-frames that \fBnet.exe\fP may send
on an AX.25 connection before it must stop and wait for an acknowledgement.
Since the AX.25/LAPB sequence number field is 3 bits wide, this number
cannot be larger than 7.
.LP
Since unconnected-mode (datagram) AX.25 uses UI frames that do not have
sequence numbers, this parameter does \fInot\fP apply to unconnected
mode.
.LP
The default value of \fBmaxframe\fP in \fBnet.exe\fP is 1.
.NH 2
IP and TCP Parameters
.NH 3
MTU
.LP
The MTU (Maximum Transmission Unit) is an interface parameter that
limits the size of the largest IP
datagram that it may handle.  IP datagrams routed to
an interface that are larger than its MTU are each split into two or more
\fIfragments\fP.
Each fragment has its own IP header and is handled by the network
as if it were a distinct IP datagram, but when it arrives at
the destination it is held by the IP layer until all of the other fragments
belonging to the original datagram have arrived. Then they are reassembled
back into the complete, original IP datagram. 
The minimum acceptable interface MTU is 28
bytes: 20 bytes for the IP (fragment) header, plus 8 bytes of data.
.LP
There is no default MTU in \fBnet.exe\fP; it must be explicitly specified for
each interface as part of the \fBattach\fP command.
.NH 3
MSS
.LP
MSS (Maximum Segment Size) is a TCP-level parameter that limits the
amount of data that the \fIremote\fP TCP will send in a single TCP
packet. MSS values are exchanged in the SYN (connection request)
packets that open a TCP connection. In the \fBnet.exe\fP implementation of TCP,
the MSS actually used by TCP is further reduced in order to avoid
fragmentation at the local IP interface. That is, the local TCP asks IP
for the MTU of the interface that will be used to reach the
destination. It then subtracts 40 from the MTU value to allow for the
overhead of the TCP and IP headers. If the result is less than the MSS
received from the remote TCP, it is used instead.
.LP
The default value of \fBMSS\fP is 512 bytes.
.NH 3
Window
.LP
This is a TCP-level parameter that controls how much data the local TCP
will allow the remote TCP to send before it must stop and wait for an
acknowledgement. The actual window value used by TCP when deciding how
much more data to send is referred to as the \fIeffective window\fP.
This is the smaller of two values: the window advertised by the remote
TCP minus the unacknowledged data in flight, and the \fIcongestion
window\fP, an automatically computed time-varying estimate of how much
data the network can handle.
.LP
The default value of \fBWindow\fP is 2048 bytes.
.NH 2
Discussion
.LP
.NH 3
IP Fragmentation vs AX.25 Segmentation
.LP
IP-level fragmentation often makes it possible to interconnect two
dissimilar networks, but it is best avoided whenever possible.
One reason is that when a single IP fragment is lost, all other fragments
belonging to the same datagram are effectively also lost and
the entire datagram must be retransmitted by the source.
Even without loss, fragments require the allocation of temporary buffer
memory at the destination, and it is never easy
to decide how long to wait for missing fragments before
giving up and discarding those that have already arrived.
A reassembly timer controls this process.
In \fBnet.exe\fP it is (re)initialized with the \fBip rtimer\fP parameter
(default 30 seconds) whenever progress is made in reassembling a datagram
(i.e., a new fragment is received).
It is not necessary that all of the fragments belonging to a datagram
arrive within a single timeout interval, only that the interval between
fragments be less than the timeout.
.LP
Most subnetworks that carry IP have MTUs of 576 bytes or more, so
interconnecting them with subnetworks having smaller values can result in
considerable fragmentation. For this reason, IP implementors working with
links or subnets having unusually small packet size limits are encouraged
to use
\fItransparent fragmentation\fP,
that is, to devise schemes to break up large IP
datagrams into a sequence of link or subnet frames that are immediately
reassembled on the other end of the link or subnet into the original, whole IP
datagram without the use of IP-level fragmentation. Such a
scheme is provided in AX.25 Version 2.1.  It can break
a large IP or NET/ROM datagram into a series of \fBpaclen\fP-sized
AX.25 segments (not to be confused with TCP segments),
one per AX.25 I-frame, for transmission and reassemble them into
a single datagram at the other end of the link before handing it up to the
IP or NET/ROM module.  Unfortunately, the segmentation procedure is a new
feature in AX.25 and is not yet widely implemented;
in fact, \fBnet.exe\fP is so far
the only known implementation. This creates some interoperability problems
between \fBnet.exe\fP and non-\fBnet.exe\fP nodes, in particular, standard
NET/ROM nodes being used to carry IP datagrams. This problem is discussed
further in the section on setting the MTU.
.NH 3
Setting paclen and bufsize
.LP
The more data you put into an AX.25 I frame, the smaller the AX.25
headers are in relation to the total frame size. In other words, by
increasing \fBpaclen\fP, you lower the AX.25 protocol overhead. Also, large
data packets reduce the overhead of keying up a transmitter, and this
can be an important factor with higher speed modems. On the other hand,
large frames make bigger targets for noise and interference. Each link
has an optimum value of \fBpaclen\fP that is best discovered by experiment.
.LP
Another thing to remember when setting \fBpaclen\fP is that the AX.25 version
2.0 specification limits it to 256 bytes. Although \fBnet.exe\fP can handle
much larger values, some other AX.25 implementations (including
digipeaters) cannot and this
may cause interoperability problems. Even \fBnet.exe\fP may have trouble with
certain KISS TNCs because of fixed-size buffers. The original KISS TNC
code for the TNC-2 by K3MC can handle frames limited in size only by
the RAM in the TNC, but some other KISS TNCs cannot.
.LP
\fBNet.exe\fP's built-in HDLC drivers (SCC, PC-100, DRSI, etc) allocate receive
buffers according to the maximum expected frame size, so it is
important that these devices be configured with the correct
\fBbufsize\fP. To do this, you must know the size of the largest
possible frame that can be received. The \fBpaclen\fP parameter
controls only the size of the data field in an I-frame and not the
total size of the frame as it appears on the air. The AX.25 spec allows
up to 8 digipeaters, so the largest possible frame is (\fBpaclen\fP + 72)
bytes. So you should make \fBbufsize\fP at least this large.
.LP
Another important consideration is that the more recent versions of NOS
improve interrupt response by maintaining a special pool of buffers for use
by the receive routines.  These buffers are configured by the
\fBmemory nibufs\fP and \fPmemory ibufsize\fP commands.
\fBibufsize\fP defaults to 2048 bytes. The setting of \fBibufsize\fP
limits \fBbufsize\fP; in fact, attempting to set a larger value may
cause the driver not to work at all. This situation can be detected by
running the \fBmemory status\fP command and looking for a non-zero count
of \fBIbuffail\fP events, although these events can also occur
occasionally during normal operation.
.LP
One of the drawbacks of AX.25 that there is no way for one station to tell
another how large a packet it is willing to accept.  This requires the
stations sharing a channel to agree beforehand on a maximum packet size.
TCP is different, as we shall see.
.NH 3
Setting Maxframe
.LP
For best performance on a half-duplex radio channel, \fBmaxframe\fP should
always be set to 1. The reasons are explained in the paper \fILink Level
Protocols Revisited\fP by Brian Lloyd and Phil Karn, which appeared in the
proceedings of the ARRL 5th Computer Networking Conference in 1986.
.NH 3
Setting MTU
.LP
TCP/IP header overhead considerations similar to those of the AX.25 layer
when setting \fBpaclen\fP apply when choosing an MTU.  However, certain
subnetwork types supported by \fBnet.exe\fP have well-established MTUs, and
these should
always be used unless you know what you're doing: 1500 bytes for Ethernet,
and 508 bytes for ARCNET.
The MTU for PPP is automatically negotiated, and defaults to 1500.
Other subnet types, including SLIP and AX.25, are
not as well standardized.
.LP
SLIP has no official MTU, but the most common
implementation (for BSD UNIX) uses an MTU of 1006 bytes.  Although
\fBnet.exe\fP has no hard wired limit on the size of a received SLIP frame,
this is not true for other systems.
Interoperability problems may therefore result if larger MTUs are used in
\fBnet.exe\fP.
.LP
Choosing an MTU for an AX.25 interface is more complex. When the interface
operates in datagram (UI-frame) mode, the \fBpaclen\fP parameter does not
apply. The MTU effectively becomes the \fBpaclen\fP of the link.  However,
as mentioned earlier, large packets sent on AX.25 \fIconnections\fP are
automatically segmented into I-frames no larger than \fBpaclen\fP bytes.
Unfortunately, as also mentioned earlier, \fBnet.exe\fP is so far the only known
implementation of the new AX.25 segmentation procedure. This is fine as long
as all of the NET/ROM nodes along a path are running \fBnet.exe\fP, but since the main
reason \fBnet.exe\fP supports NET/ROM is to allow use of existing NET/ROM networks,
this is unlikely.
.LP
So it is usually important to avoid AX.25 segmentation when running IP over
NET/ROM.  The way to do this is to make sure that packets larger
than \fBpaclen\fP are never handed to AX.25.  A NET/ROM transport header is
5 bytes long and a NET/ROM network header takes 15 bytes, so 20 bytes must
be added to the size of an IP datagram when figuring the size of the AX.25
I-frame data field. If \fBpaclen\fP is 256, this leaves 236 bytes for the IP
datagram. This is the default MTU of the \fBnetrom\fP pseudo-interface, so
as long as \fBpaclen\fP is at least 256 bytes, AX.25 segmentation can't
happen. But if smaller values of \fBpaclen\fP are used, the \fBnetrom\fP MTU
must also be reduced with the \fBifconfig\fP command.
.LP
On the other hand, if you're running IP directly on top of AX.25, chances
are all of the nodes are running \fBnet.exe\fP and support AX.25 segmentation.
In this case there is no reason not to use a larger MTU and let
AX.25 segmentation do its thing. If you choose
an MTU on the order of 1000-1500 bytes, you can largely avoid IP-level
fragmentation and reduce TCP/IP-level header overhead on file transfers
to a very low level.
And you are still free to pick whatever \fBpaclen\fP value is
appropriate for the link.
.NH 3
Setting MSS
.LP
The setting of this TCP-level parameter is somewhat less critical than the
IP and AX.25 level parameters already discussed, mainly because it is
automatically lowered according to the MTU of the local interface when a
connection is created. Although this is, strictly speaking, a protocol
layering violation (TCP is not supposed to have any knowledge of the
workings of lower layers) this technique does work well in practice.
However, it can be fooled; for example, if a routing change occurs after the
connection has been opened and the new local interface has a smaller MTU
than the previous one, IP fragmentation may occur in the local system.
.LP
The only drawback to setting a large MSS is that it might cause avoidable
fragmentation at some other point within the network path if it includes a
"bottleneck" subnet with an MTU smaller than that of the local interface.
(Unfortunately, there is presently no way to know when this is the case.
There is ongoing work within the Internet Engineering Task Force on a "MTU
Discovery" procedure to determine the largest datagram that may be sent over
a given path without fragmentation, but it is not yet complete.)
Also, since the MSS you specify is sent to the remote system, and not all
other TCPs do the MSS-lowering procedure yet, this might cause the remote
system to generate IP fragments unnecessarily.
.LP
On the other hand, a too-small MSS can result in a considerable performance
loss, especially when operating over fast LANs and networks that can handle
larger packets. So the best value for MSS is probably 40 less than the
largest MTU on your system, with the 40-byte margin allowing for the TCP and
IP headers. For example, if you have a SLIP interface with a 1006 byte MTU
and an Ethernet interface with a 1500 byte MTU, set MSS to 1460 bytes. This
allows you to receive maximum-sized Ethernet packets, assuming the path to
your system does not have any bottleneck subnets with smaller MTUs.
.NH 3
Setting Window
.LP
A sliding window protocol like TCP cannot transfer more than one window's
worth of data per round trip time interval. So this TCP-level parameter
controls the ability of the remote TCP to keep a long "pipe" full. That is,
when operating over a path with many hops, offering a large TCP window will
help keep all those hops busy when you're receiving data. On the other hand,
offering too large a window can congest the network if it cannot buffer all
that data. Fortunately, new algorithms for dynamic controlling the
effective TCP flow control window have been developed over the past few
years and are now widely deployed.
\fBNet.exe\fP includes them, and you can watch them
in action with the \fBtcp status <tcb>\fP or \fBsocket <sockno>\fP commands.
Look at the \fBcwind\fP (congestion window) value.
.LP
In most cases it is safe to set the TCP window to a small integer
multiple of the MSS (eg. 4 times), or larger if necessary to fully utilize a
high bandwidth*delay product path. One thing to keep in mind, however, is
that advertising a certain TCP window value declares that the system has
that much buffer space available for incoming data.
\fBNet.exe\fP does not actually preallocate this space;
it keeps it in a common pool and may well "overbook" it,
exploiting the fact that many TCP connections are idle for long periods
and gambling that most applications will read incoming data from an active
connection as soon as it arrives, thereby quickly freeing the buffer memory.
However, it is possible to run \fBnet.exe\fP out of memory if excessive TCP window
sizes are advertised and either the applications go to sleep indefinitely
(eg. suspended Telnet sessions) or a lot of out-of-sequence data arrives.
It is wise to keep an eye on the amount of available memory and to decrease
the TCP window size (or limit the number of simultaneous connections) if it
gets too low.
.LP
Depending on the channel access method and link level protocol, the use
of a window setting that exceeds the MSS may cause an increase in channel
collisions. In particular, collisions between data packets and returning
acknowledgements during a bulk file transfer
may become common. Although this is, strictly speaking,
not TCP's fault, it is possible to work around the problem at the TCP level
by decreasing the window so that the protocol operates in stop-and-wait mode.
This is done by making the window value equal to the MSS.
.NH 2
Summary
.LP
In most cases, the default values provided by \fBnet.exe\fP for each of these
parameters
will work correctly and give reasonable performance. Only in special
circumstances such as operation over a very poor link or experimentation
with high speed modems should it be necessary to change them.
.NH 1
Mail Forwarding
.NH 2
Intended audience
.LP
This section is
intended for the NOS system operator desiring to
enable the forwarding of mail to other systems. They are NOT intended
as a user guide for the mail capabilities of NOS.
.NH 2
Background
.LP
This section of the NOS docs deals with the intricacies of mail
forwarding. You should read and understand this documentation
thoroughly before attempting to forward mail through your NOS box to
the AX.25 BBS world, otherwise you might grossly misconfigure your
system and be the unhappy recipient of flames from BBS sysops.
.LP
This section does NOT deal with the minutae of the mailbox and its
various commands; it assumes that you understand concepts such as user
areas (both public and private) and how to list and send mail. If you
need help with these, please look elsewhere in the NOS docs.
.LP
Apart from the usual domain.txt and other files necessary for ordinary
functionality of NOS, three files are important in the mail forwarding
process. These are: /spool/forward.bbs, /alias and /spool/rewrite.
The contents of these will now be addressed individually.
.NH 2
/spool/forward.bbs
.LP
This file describes the actions taken by NOS in forwarding to AX.25
BBSes. The file contains a series of forwarding records, each record
being separated by a line containing two or more hyphens. The template
for a forwarding record is:

.nf
BBS callsign
Connection route
Connection commands                <zero or more lines>
List of areas to be forwarded      <one per line>
------------                       <end of record>
.fi
.NH 2
BBS callsign
.LP
This is simply the ordinary call of the remote BBS. A typical (but not
random!) entry might be simply the line:

sm0rgv

The callsign may be followed, on the same line, by a comma separated
list of valid intervals when forwarding is to take place. Each valid
interval is a four digit number: the first two digits are the
beginning hour of the valid interval, the last two digits are the
final hour of the valid interval. For example, if the first line of a
forwarding record looks like:

sm0rgv 0006,1414

then forwarding to sm0rgv will take place only during hours numbered
00, 01, 02, 03, 04, 05, 06 and 14. Ticks of the mbox timer outside of
these times will not cause mail to be forwarded to sm0rgv. The default
interval for forwarding is 0023.
.NH 2
Connection route
.LP
This is the method by which communication is to be established with
the remote BBS. The first token on the line is the type of protocol to
be used. This is one of ax25, netrom or tcp. Following this is
whatever further information the chosen protocol requires to make the
connection. An example connection route for a simple ax25 connection
on interface ax0 is:

ax25 ax0 g3dlh

.NH 2
Connection commands
.LP
Connection commands may, optionally, follow the connection route.
These take the form of a full stop (period), followed by the command
which will be transmitted once the connection defined in the first
line of the connection route is established.

For example, suppose that we wish to establish a netrom connection
with sm0rgv-2, through the netrom node #sth67. Then the connection
route and connection command portion of the record would look like:

.nf
netrom #sth67
 .c sm0rgv-2     [ Please note that the full stop would be placed at
                   the beginning of the line; I have placed it here
                   indented by one column simply so that gateways
                   which handle this message do not complain at
                   having a line beginning with a full stop; this
                   convention is followed throughout this documentation]
.fi
.LP
If the station is reached through digipeating, then the digipeater
callsigns should be in the ax25 route to the destination callsign.
That is, if you wish to forward traffic to w0ljf, using k2na as a
digipeater, then you should have the line:

ax25 route add w0ljf k2na

in your autoexec file.

.NH 2
List of areas to be forwarded
.LP
This is a list, one per line, of entries in the /spool/mail directory
which will be forwarded to the remote BBS. An entry of the form:

callsign

will cause the file /spool/mail/callsign.txt to be scanned for unread
messages. Any such messages are sent to the remote BBS and deleted
from the file.

One can also forward user areas using this mechanism. To do this,
simply place a line containing the name of the area in the record. So,
to forward amsat bulletins to the BBS, one would have a line:

amsat

This will search the /spool/mail/amsat.txt file; any messages
contained therein which have not been forwarded to the BBS in question
will be forwarded. They will NOT be deleted. The determining factor as
to whether or not entries are deleted is that if the filename is
present in the /spool/areas file, then there is NO deletion, otherwise
there is.

Please note that ONLY FILES IN /spool/mail are checked. In particular,
the outbound SMTP mail queue is NOT checked.
.NH 2
Changing the recipient address
.LP
Normally, NOS uses the information in the To: header line to determine
the parameters used by the "S" command during BBS forwarding. As the
To: header is unchanged by all /alias and /spool/rewrite machinations,
the mail will be sent to the BBS addressed precisely as the originator
of the message typed it. Occasionally, one might want to change this
behaviour. In this case, a line of the form:

area  new_address

in the list of areas to be forwarded will replace the originally typed
destination with the string new_address instead.
.NH
/alias
.LP
The alias file is used to map LOCAL names to other names, which may be
either local or remote; additionally, from a single input message, the
alias file permits one to produce multiple output messages. Thus,
typical uses for the /alias file are: converting one local name to
another, converting a local name to a remote name, and exploding a
mail message so that it is passed on to several recipients.

The format of a record in the alias file is very simple:

.nf
aliasname	recipient1 recipient2 recipient3
<tab> or <SP>	recipient4 ... recipientN

.fi
.LP
There is no separation between records in the /alias file other than a newline.

The aliasname is a local username; that is, it does not contain an "@"
symbol. When the alias file is processed, if the destination of the
message matches precisely the aliasname, then the mail is redirected
to ALL of the alieased recipients.

Scanning of the /alias file is performed by the SMTP server. The SMTP
timer (which controls the SMTP client) is kicked whenever the mailbox
or SMTP server queues something for delivery by SMTP. Mail transport
within a single NOS system is performed through the SMTP client/server
mechanism. The result of these facts is that as soon as a piece of
mail is entered to the mailbox, the SMTP client is kicked and attempts
to deliver the mail (which has already been scanned by the rewrite
mechanism \(em see below). If the mail is local to the NOS system
(i.e. no "@" sign in the address), then the /alias file will be
scanned and the name mappings take place.

A few lines in the /alias file might look something like:

.nf
bdale	bdale@n3eua
local	fred@k0yum bdale@n3eua bill@ai0c.co.usa.na
	n5op@n5op jim@k0jtz n0esg@n0esg
g4bki	g4bki@gb7bil._2712.gbr.eu

.fi
.LP
The system must know how to deliver traffic to each of the individual
addresses in the style in which they are entered in the /alias file.
If the system does not know how to deliver one of the new addresses,
then it will send it to the SMTP gateway station defined by the 'smtp
gateway' command.

Note that it is reasonable, and sometimes desireable, to have alias
records of the form:

area	area dest1 dest2 ...

As the /alias file is scanned only once (see below), this does not
result in an infinite recursion.
.NH
/spool/rewrite
.LP

The rewrite file is used to perform a one-to-one mapping between
destination addresses as received by NOS and destination addresses as
actually used by NOS. Each record within the rewrite file comprises a
single line, containing either two or three entries separated by
spaces. The first field is the template field; if a destination
address matches the template, it is replaced by the second field. The
third field, which is optional, is the single letter "r", which, if
present, tells NOS to rescan the rewrite file, using the new
destination address to attempt to match against the templates.

A template may contain asterisks. These stand for a match of any
number of characters (including zero). In the second field, the
character "$", followed by a single digit in the range 1 to 9,
represents the string that matched the respective asterisk in the
template. By way of example, suppose that there is a line in the
rewrite file which looks like:

*@* $1%$2@g1emm.ampr.org

Then, any traffic reaching the system through the mailbox or the SMTP
server, but which is supposed to go to a remote system, will be
redirected to go through g1emm.ampr.org. Suppose that a user logs on,
and sends a message to n0gbe@nq0i. Then the rewrite file attempts to
match "n0gbe@nq0i" against the entry *@*. It matches, and assignes $1
the value n0gbe, and $2 the value nq0i. The mail file as written to
the disk will no longer be to n0gbe@nq0i, but, rather, to
n0gbe%nq0i@g1emm.ampr.org. [The nomenclature
station1%station2@station3 means the final destination is
station1@station2, and this traffic is to be routed through the
gateway station3.]

As soon as a template match is found, the conversion is performed and
scanning is stopped, unless the third "r" field is present, in which
case scanning restarts from the top of the file.

N.B. It is a good idea to have a line of the form:

*@*.ampr.org $1@$2.ampr.org

at the beginning of your rewrite file. This will cause all amprnet
traffic to be caught early in the rewrite scan, and no further
scanning (and, hence, no unexpected substitutions) will take place.
.NH 2
Scanning procedure
.LP
The two files which are used to determine the disposition of traffic
are scanned under slightly different circumstances. Note that neither
the /alias nor the /spool/rewrite scan makes any actual changes to the
contents of the traffic. In particular, the To: field remains exactly
as it was first entered into the system.

There are four possible entry routes for traffic into the system:
SMTP, through the mailbox by a user, through the mailbox by a BBS, and
via an external program (like BM) or creation of the files manually.
NOS determines if a piece of traffic was entered into the system by a
BBS by looking for a BBS system ID (like the "[NET-H$]" block issued
by NOS) on the incoming connection prior to messages being uploaded.
.NH 2
Traffic received by SMTP server
.LP
1. The rewrite file is scanned and any changes applied (unless the
traffic was recieved through the local mailbox; in that case, this
step does not occur);
.br
2. If the traffic appears to be local then the alias file is scanned
and any changes or explosions applied.
.br
3. Any copies local to the system are delivered; copies for remote
delivery are placed in the SMTP queue.
.NH 2
Traffic received by mailbox from user
.LP
1. The rewrite file is scanned and any changes applied;
.br
2. The traffic is passed to the SMTP client.
.NH 2
Traffic received by mailbox from BBS
.LP
1. The rewrite file is scanned and any changes applied;
.br
2. The traffic is passed to the SMTP client.
.NH 2
Traffic entered by external mechanism
.LP
1. No scanning occurs;
.br
2. The traffic is passed to the SMTP client.
.NH 2
Headers
.LP
Appropriate RFC-822 headers are added to all incoming traffic. Traffic
entering through the mailbox recieves a full complement of RFC-822
headers; traffic coming through the SMTP server has only a "Received:"
header applied. On forwarding to a BBS, if an item of traffic contains
BBS R: headers, the RFC-822 header is converted to an appropriate R:
line at the time that NOS forwards the message. (This change only
occurs for BBS forwarding; forwarding by SMTP retains the RFC-822
headers.)
.NH 2
Bulletin Identifiers (BIDs)
.LP
The AX.25 BBS system has evolved a reasonably efficient way of
reducing overhead when forwarding bulletins. When a bulletin is
originated on a BBS, it is given a unique bulletin identifier (BID).
This BID should (theoretically) travel with the bulletin, and should
never be changed during the distribution of the bulletin. Each system
keeps track of all received BIDs. If a forwarding station wishes to
forward a bulletin to a BBS, then the receiving station checks its
local list of known BIDs and informs the transmitting station if it
already posesses the bulletin in question. The NOS mailbox conforms to
this protocol. Received BIDs are stored in the file /spool/history,
and are encoded in the Message-ID: header line of the message by NOS.
Messages forwarded from areas listed in the /areas file will have
their BID (re)generated from the Message-ID: line. Note that ALL
messages from public areas are forwarded with a BID, whether or not
the message was produced with the "SB" command. Like other BBSes, NOS
will inform a transmitting station not to transmit a bulletin if it is
one that NOS already has locally; likewise, it understands similar
messages from other stations to which it tries to forward.

Note that the BID mechanism is not a part of the SMTP world. If you
are forwarding bulletins through SMTP, there is no mechanism by which
the receiving station can reject the attempted delivery of a bulletin,
even if it already exists on the recipient system. (Note that a
possible workaround is to deliver bulletins to TCP/IP stations using
TCP instead of SMTP. Alternatively, one could use NNTP, as NNTP
commands utilise the Message-ID: line, from which the BID is derived.)
The BID is preserved no matter which mechanism is used to deliver the
bulletin.

.NH 2
Traffic in practice
.LP
Now, the big question is, how does one set up these various files to
perform intelligent manipulation of mail? A number of examples follow.
Note that, often, there is more than one way to accomplish an
objective. The following are merely examples (and not necessarily the
most efficient method possible for any given case). The format used
will be:

typed destination -> intended destination

followed by the necessary entries in the alias (/alias), rewrite
(/spool/rewrite) and forwarding (/spool/forward.bbs) files.

.NH 2
Using familiar names \(em SMTP destination
.LP
.nf
bdale -> bdale@n3eua.ampr.org

alias:
bdale	bdale@n3eua.ampr.org

rewrite:
forward:

.NH 2
Exploding local mail
.LP
.nf
sysops -> nq0i, n5op@n5op.ampr.org

alias:
sysops	nq0i n5op@n5op@ampr.org

rewrite:
forward:

.NH 2
Using familiar names \(em BBS forwarding
.LP
.nf
g4bki -> g4bki@gb7bil._2712.gbr.eu, to be forwarded by ai0c

alias:
rewrite:
forward:
ai0c
ax25 ax1 ai0c
g4bki g4bki@gb7bil._2712.gbr.eu
ai0c

.NH 2
Handling incoming bulletins by subject
.LP
.nf
tcpip@* -> nq0i, tcpip, bdale@n3eua.ampr.org, ai0c@ai0c [a BBS]

alias:
tcpip	nq0i tcpip bdale@n3eua.ampr.org ai0c

rewrite:
tcpip@* tcpip

forward:
ai0c
ax25 ai0c
ai0c

.fi
Let's walk through the above example. An incoming item comes in
addressed to TCPIP@ALLUS. A scan is made through the rewrite file, and
a match is found. The item is redirected to tcpip. The alias file is
scanned; a total of four copies of the item exist after this, three in
local areas tcpip, nq0i and ai0c, and one on the SMTP queue (for
bdale@n3eua.ampr.org). When the mailbox timer next ticks, the mail in
the local ai0c area will be forwarded on the ax1 interface to ai0c.

.NH 2
Routing based on Hierarchical addressing

.LP
.nf
Wyoming -> KE7VS (SMTP)
Nebraska -> AG0N (BBS over the NETROM, NETROM ID WNBBS)
Europe -> W0LJF (BBS over AX.25)

alias:
rewrite:
*.noam            $1.na r
*.us              $1.usa.na r
*.usa             $1.usa.na r

*.ne              $1.ne.usa.na r
*.wy              $1.wy.usa.na r

*@*.*.wy.usa.na   $1%$2.$3.wy.usa.na@ke7vs
*@*.wy.usa.na     $1%$2.wy.usa.na@ke7vs

*.ne.usa.na     ag0n

*.eu            w0ljf

forward:
ag0n
netrom ax0 wnbbs
ag0n
----------
w0ljf
ax25 ax1 w0ljf
w0ljf
----------

.fi
Why is the example rewrite file apparently so complicated? This is to
handle poorly constructed hierarchical addresses in a reasonable way.
A full U.S. hierarchical address has the form:
callsign@BBS.#localid.state.usa.na. Many states have no #localid
field. In the example rewrite file above, the first three lines
convert non-standard, but frequently used, U.S. designators to the
more standard format. It is common for users not to use a full
hierarchical address if the destination is relatively local. For
eample, a user might easily use only .wy instead of the full
.wy.usa.na if he is geographically close to Wyoming. The second
grouping of two lines handles this problem. Note the third, "r", field
in all the entries so far.

The remainder of the file handles properly formatted hierarchical
addresses. The two Wyoming entries handle the cases with and without a
#localid field. Differentiation between these cases is not necessary
for BBS forwarding.
.NH 2
General bulletin handling
.LP
The details of bulletin handling will vary somewhat from place to
place, as there are several distinct styles of bulletin handling
currently in use in the AX.25 BBS world. In general, it is necessary
to arrange one's system so that it accepts bulletins from BBSes,
forwards them to one or more stations, and also handles intelligently
bulletins input by users into NOS.

Suppose that we sish to handle bulletins @JUNK. We are to deposit them
locally in the junk area, and also forward to BBS g4bki. We also know
that we generally receive @JUNK bulletins from g4amj, a local BBS
which handles much bulletin traffic.
.nf
alias:
rewrite:
*@junk   junk

forward:
g4bki
ax25 ax1 g4bki
g4bki
junk
----------
g4amj
ax25 ax1 g4amj
g4amj
junk
----------

.fi
All incoming @JUNK traffic is written to the junk area (which should
be an explicit entry in the /spool/areas file). Each tick of the
mailbox timer, NOS scans the junk area for traffic not forwarded to
g4bki or g4amj and attempts to deliver unforwarded bulletins. Usually,
g4amj will respond with a "Have it" message and the bulletin will not
be forwarded. Any bulletins @JUNK deposited locally by users will
automatically be sent to both g4bki and g4amj.
.NH
Questions and Answers
.LP
Q. Under what circumstances does NOS request reverse forwarding from a BBS?

A. NOS requests a reverse forward after completing any forwards of its
own to the BBS. If no traffic was queued for a given BBS, then no
connection is attempted, so no reverse forward request is issued.

Q. What kinds of message types does the NOS mbox support?

A. Basically, NOS supports all two letter commands starting with an
"S". If the mailbox has not received an SID banner (the "[NET-H$]")
from a connected station, then an SF command will send a followup to
the address specified on the command line. The SR command will send a
reply to the current message. One can also issue the command "SR
<number>", where <number> is the number of the message to which you
want to generate a reply. All other variations cause an
X-BBS-Msg-Type: header to be added to the message. When a message with
such a line is forwarded to a BBS, it is sent to the BBS with the
appropriate message type as the second letter in the "S" command to
the BBS.

If NOS has received a valid SID, then ALL S commands are handled by
the X-BBS-Msg-Type: mechanism outlined above.
.bp
.NH
Logic map of the mailbox

.LP
.nf
============== AX.25 === NET/ROM === Ethernet === Loopback =================
       |                   |                   |                   |
       |                   |                   |                   |
+--------------+    +--------------+    +--------------+    +--------------+
|              |    |              |    |              |    |              |
|   Mailbox    |    | SMTP client  |    | SMTP server  |    | BBS Forward  |
|              |    |              |    |              |    |              |
+--------------+    +--------------+    +--------------+    +--------------+
       |                   ^                   |                   ^
       |                   |                   |                   |
       v                   |                   v                   |
+--------------+    +--------------+    +--------------+    +--------------+
|              |    |              |    |              |    |              |
| Add RFC822   |    | Use MX or A  |    | Add Received |    | Add own R:   |
| header suite |    | type records |    | line         |  +>| line         |
|              |    |              |    |              |  | |              |
+--------------+    +--------------+    +--------------+  | +--------------+
       |                   ^                   |          |        ^
       |                   |                   |          |        |
       v                   |                   v          |        |
+--------------+    +--------------+    +--------------+  | +--------------+
|              |    |              |    |              |  | |              |
| Get Rewrite  |    | Use optional |    | Apply Rewrite|  | | Strip RFC822 |
| file address |    | SMTP gateway |    | file address |  | | header suite |
|              |    |              |    |              |  | |              |
+--------------+    +--------------+    +--------------+  | +--------------+
       |                   ^                   |          |        ^
       |                   |                   |          |        | Yes
       v                   |                   v          |        |
+--------------+           |            +--------------+  | +--------------+
|              |   No      |            |              |  | |              |
| Local addr?  |-------+   |            | Alias file   |  +-| Any R: lines?|
|              |       |   |            |              | No |              |
+--------------+       |   |            +--------------+    +--------------+
       |               |   |                |  |  |                ^
       | Yes           |   |                |  |  |                |
       v               |   |                v  v  v                |
+--------------+       v   |            +--------------+    +--------------+
|              |    +--------------+    |              |    |              |
| Apply Rewrite|    |              | No | Local        |Yes | /spool/mail/ |
| file address |--->| SMTP queue   |<---| address?     |--->| directory    |
|              |    |              |    |              |    |              |
+--------------+    +--------------+    +--------------+    +--------------+
.fi
.NH 1
Credits
.LP
Several people have contributed to this manual. I would particularly
like to thank Bill Simpson and Michael Westerhof, KA9WSB,
for their significant editorial contributions to this document.
Deborah Swanberg wrote the original BOOTP documentation,.
and G4AMJ/NQ0I and SM0RGV contributed the section on mail forwarding.
.LP
Although I am the primary author of this software package, many others have
contributed substantial additions and refinements.
Here is a partial list; additions and corrections are welcome.
See the individual source code files for additional authorship details.
.NH 2
ARCNET
.LP
Written by Russ Nelson of Clarkson University.
.NH 2
Autodialer
.LP
Bill Simpson substantially rewrote my original version and created
a much improved control file format.
.NH 2
Bootstrap Protocol (BOOTP)
.LP
Written by Deborah Swanberg of the University of Michigan.
.NH 2
Domain resolver
.LP
Bill Simpson substantially extended my original version, adding record
caching and automatic expiration.
.NH 2
DRSI driver
.LP
Written by Stu Phillips, N6TTO.
.NH 2
Eagle 8530 board driver
.LP
Written by Art Goldman, WA3CVG, and Richard Bisbey, NG6Q.
.NH 2
HAPN 8273 HDLC board driver
.LP
Written by Jon Bloom, KE3Z, with fixes by John Tanner, VK2ZXQ.
.NH 2
Hop Check utility
.LP
Written by Katie Stevens of UC Davis; enhancements by Bill Simpson.
.NH 2
Mailbox server & SMTP
.LP
My original, primitive SMTP server was
vastly enhanced and expanded by Bdale Garbee, N3EUA and Dave Trulli,
NN2Z. Anders Klemets, SM0RGV, wrote the first "mailbox" specifically
for AX.25; he then expanded it into a full-blown bulletin board system
and integrated it with the SMTP facilities.
.NH 2
NET/ROM
.LP
The original NET/ROM code was done by Dan Frank, W9NK. It was ported
to the NOS platform by Anders Klemets, SM0RGV.
.NH 2
Netnews Transfer Protocol (NNTP)
.LP
Written by Anders Klements, SM0RGV, with help from Bernie Roehl and
Gerard Van Der Grinten, PA0GRI.
.NH 2
Packet Drivers
.LP
Although not really part of this package, the Clarkson Packet Driver
Collection by Russ Nelson of Clarkson University has enormously enhanced
the utility of this package by allowing it to use virtually every PC
Ethernet controller board on the market.
.NH 2
PI 8530 DMA HDLC driver
.LP
Written by Dave Perry, VE3IFB.
.NH 2
Post Office Protocol (POP)
.LP
Originally authored by Mike Stockett, WA7DYX. Updates and modifications
by Allen Gwinn, N5CKP, Gerard Van Der Grinten, PA0GRI, and Mark Edwards,
WA6SMN.
.NH 2
Point to Point Protocol (PPP)
.LP
Written by Katie Stevens of UC Davis, based on the original
implementation by Drew Perkins of CMU. Updated by Bill Simpson and
Glenn McGregor of the University of Michigan.
.NH 2
Routing Information Protocol (RIP)
.LP
Original (pre-NOS) version written by Al Broscious N3FCT.
.NH 2
SCC - Generic 8530 driver
.LP
Originally written for the old "NET" code
by Rob Janssen, PE1CHL. Ported to NOS by Ken Mitchum, KY3B.
.NH 2
Socket-level stream compression
.LP
Written by Anders Klemets, SM0RGV
.NH 2
TCP/IP Header Compression
.LP
Adapted from Van Jacobson's original BSD UNIX implementation by
Katie Stevens of UC Davis. Updated by Bill Simpson.
