(*
** switchar.pas
**
** This program changes the system switch character.  It uses
** the undocumented system call int 21H, function 37H.
*)

program switchar;

type
  regpack = record
    ax,bx,cx,dx,bp,si,di,ds,es,flags: integer;
  end;

var
  recpack: regpack;
  argumentstr: string[80];
  old_switchar: char;
  new_switchar: char;


function getswitchar: char;

begin
  recpack.ax := $37 shl 8;
  msdos(recpack);
  getswitchar := chr(recpack.dx and $00ff)
end;


procedure setswitchar(new_char: char);

begin
  with recpack do begin
    ax := ($37 shl 8) + 1;
    dx := ord(new_char)
  end;
  msdos(recpack)
end;


begin { main }
  lowvideo;
  if paramcount <> 1 then begin
    writeln('This program changes the system switch character.');
    writeln('Usage: switchar char');
    halt
  end;
  argumentstr := paramstr(1);
  if length(argumentstr) <> 1 then begin
    writeln('switchar: expecting single character argument');
    halt
  end;
  old_switchar := getswitchar;
  writeln('Old switch char = ', old_switchar);
  setswitchar(argumentstr[1]);
  new_switchar := getswitchar;
  writeln('New switch char = ', new_switchar)
end.
