/* below are the necessary declarations for people who want to define their
own actions. The basic type on the MSH stack is a refobj, i.e. a pointer to an
obj. An obj is basically a character string, excepted a reference count has
been added for efficiency of memory management. All values (including numeric
values) are represented as character strings.
   The routines Free and Push take care of management of that reference count,
so to manage it you only have to call them, mimicking the examples given
in userdefs.c */

#define OVERHEAD 10
typedef struct{int rc;char val[OVERHEAD];}obj;
/* actually val is any length: 10+sizeof(int)=12 which is the smallest size
   which may be allocated in BC's compact model */
typedef obj *refobj;

typedef enum{FALSE,TRUE} bool;

#define ERROR_ 0x1
#define WARNING_ 0x2
#define FILE_ 0x20
extern void (cdecl *efns)(int /* errcode */,char *,...);
/* This is the function to call to signal an error. The arguments from the
   second onwards are the same as in the printf family of functions, which
   gives you a lot of flexibility in building your error message.
   The default value given to efns is a function which pops a window for
   errcode=WARNING_ and aborts MSH for ERROR_ .
   You can define your own function and assign a pointer to it to efns:
   then your function will get called in case of any error */


void _fastcall Free(refobj s);

void _fastcall Push(refobj s);
refobj _fastcall Pop(void);

void _fastcall Pushstring(char *s); /* makes a refobj from s and Pushes it */

void _fastcall Pushlong(long l); /* Pushes a refobj holding the long's representation */
long _fastcall Poplong(void);    /* Pops one refobj, Frees it; returns the long it held */

void _fastcall Pushbool(bool b); /* same as Pushstring(b?"true":"") ; saves mallocs
			  as it uses pre-allocated strings */
bool _fastcall Popbool(void);    /* returns FALSE for "" and TRUE for any other string */

/* The basic template for an action which pops 2 things and pushes one is:

    void foo(void)
    { refobj a1=Pop(),a2=Pop(),res;
      ... do your stuff, using a1->val and a2->val and
          building res along the way ...
      Push(res);Free(a1);Free(a2);
    }

The functions Pushstring, Pushlong, Poplong, Pushbool, Popbool take care of
much of the details of management.
*/

void _fastcall testalloc(void *w);
/* a routine which tests the result of malloc;
                            see example of use in userdefs.c */
