/*
  From: Bob Jarvis
    To: Jerry Coffin			Date: 17 Dec 91  21:53:34
  Subj: file redirection
  Conf: `PC Assembly Language'

In a message of <15 Dec 91  12:15:04>, Jerry Coffin (1:128/60) writes:
 >not equal it unless they have redirected to the same file.  It would
 >appear, therefore, that accurately determining whether input or output
 >has been redirected requires using DOS function 52h to find the
 >system file table, and tracking through it to find whether the file
 >associated with the handle in question is actually connected to a file
 >named CON.  ( PLEASE prove me wrong on this, though. )

Perhaps the following code will help:
*/
/* 
 * isconsole() - determines if a file handle is associated with the console.
 *
 *    Returns:
 *       0           Handle is not associated with the console
 *       non-zero    Handle is associated with the console
 */

#include <dos.h>

#define IS_DEVICE          0x0080
#define IS_FASTCONSOLE     0x0010
#define IS_CONSOUT         0x0002
#define IS_CONSIN          0x0001

int isconsole(int handle)
   {
   union REGS regs;

   regs.h.ah = 0x44;       /* IOCTL service                          */
   regs.h.al = 0;          /* subfunction 0 - get device information */
   regs.x.bx = handle;

   int86(0x21, &regs, &regs);

   if(regs.x.dx & IS_DEVICE)
      if((regs.x.dx & IS_FASTCONSOLE) || 
            (regs.x.dx & IS_CONSOUT)  ||
            (regs.x.dx & IS_CONSIN))
         return(~0);

   return(0);
   }

#include <stdio.h>

main()
   {
   if(isconsole(fileno(stdout)))
      printf("stdout is associated with the console");
   else
      printf("stdout is *not* associated with the console\n");
   }
