procedure PLANE;
{ procedure will form a plane by breaking up one quad into many smaller
  quads }

var
   Firstnode, Lastnode:   integer;       { first, last node # in the solid }
   Node:                  integer;       { node # }
   Surf:                  integer;       { surface # }
   X, Y:                  integer;       { index to position in plane }
   Xc, Yc, Zc: array[1..4] of real;      { coords of 4 corners of plane }
   Num:                   integer;       { #inputted vals on line }
   Comment:               text80;        { comment at end of line }
   Realvar:               vartype;       { genl. input array }
   i:                     integer;       { genl. index }
   Nx, Ny:                integer;       { #quads to form in X, Y directions }
   Material:              integer;       { material number of solid }
   Firstnodelastrow:      integer;       { node # in last X row }
   Firstnodethisrow:      integer;       { node # in this X row }
   Scale:                 vector;        { scale factors }
   Shift:                 vector;        { shift distances }
   Rotate:                vector;        { rotation angles }
   X12slice:              real;          { X slice from pt. 1 to pt. 2 }
   Y12slice:              real;          { Y slice from pt. 1 to pt. 2 }
   Z12slice:              real;          { Z slice from pt. 1 to pt. 2 }
   X43slice:              real;          { X slice from pt. 4 to pt. 3 }
   Y43slice:              real;          { Y slice from pt. 4 to pt. 3 }
   Z43slice:              real;          { Z slice from pt. 4 to pt. 3 }
   Xslice:                real;          { X slice within column }
   Yslice:                real;          { Y slice within column }
   Zslice:                real;          { Z slice within column }
   Firstx:                real;          { First X in column }
   Firsty:                real;          { First Y in column }
   Firstz:                real;          { First Z in column }
   Lastx:                 real;          { Last X in column }
   Lasty:                 real;          { Last Y in column }
   Lastz:                 real;          { Last Z in column }

begin
{$ifdef BIGMEM}
with ptra^ do with ptrb^ do with ptrc^ do
begin
{$endif}
  Line_num := Line_num + 1;
  Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
  if (Num <> 3) or (Realvar[1] < 1) or (Realvar[2] < 1) OR
       (Realvar[3] < 1) or (Realvar[3] > Nmatl) then begin
    writeln ('Bad input for plane (line ', Line_num, ')');
    if (Num <> 3) then
      writeln ('Expecting 3 numeric entries');
    if (Realvar[1] < 1) then
      writeln ('NX must be greater than 0');
    if (Realvar[2] < 1) then
      writeln ('NY must be greater than 0');
    if (Realvar[3] < 0) or (Realvar[3] > Nmatl) then
      writeln ('Matl. must be between 1 and ',Nmatl);
    close (Infile);
    halt;
  end;
  Nx := round(Realvar[1]);
  Ny := round(Realvar[2]);
  Material := round(Realvar[3]);

  Line_num := Line_num + 1;
  Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
  if (Num <> 6) or (Realvar[1] < 0) or (Realvar[2] < 0) or (Realvar[3] < 0)then begin
    writeln ('Bad input for shifting or scaling (line ', Line_num, ')');
    if (Num <> 6) then
      writeln ('Expecting 6 numeric entries')
    else
      writeln ('Scaling factors must be a positive real number');
    close (Infile);
    halt;
  end;
  Scale[1] := Realvar[1];
  Scale[2] := Realvar[2];
  Scale[3] := Realvar[3];
  Shift[1] := Realvar[4];
  Shift[2] := Realvar[5];
  Shift[3] := Realvar[6];

  Line_num := Line_num + 1;
  Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
  if (Num <> 3) then begin
    writeln ('Bad input for rotations (line ', Line_num, ')');
    writeln ('Expecting 3 numeric entries');
    close (Infile);
    halt;
  end;
  Rotate[1] := Realvar[1];
  Rotate[2] := Realvar[2];
  Rotate[3] := Realvar[3];

  for i := 1 to 4 do begin
    Line_num := Line_num + 1;
    Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
    if (Num <> 3) then begin
      writeln ('Bad input: expecting 3 coords for node ',i,' (Line ',
        Line_num, ')');
      close (Infile);
      halt;
    end;
    Xc[i] := Realvar[1];
    Yc[i] := Realvar[2];
    Zc[i] := Realvar[3];
  end; { for Outln }

  Firstnode := Nnodes + 1;
  Node := Nnodes;
  Surf := Nsurf;

  X12slice := (Xc[2] - Xc[1]) / Nx;
  Y12slice := (Yc[2] - Yc[1]) / Nx;
  Z12slice := (Zc[2] - Zc[1]) / Nx;
  X43slice := (Xc[3] - Xc[4]) / Nx;
  Y43slice := (Yc[3] - Yc[4]) / Nx;
  Z43slice := (Zc[3] - Zc[4]) / Nx;

  Firstnodelastrow := Firstnode;

  for X := 0 to Nx do begin
    Firstnodethisrow := Node + 1;
    for Y := 0 to Ny do begin
      Node := Node + 1;
      if (Node > MAXNODES) then begin
        writeln ('Exceeded MAXNODES=',MAXNODES,' in plane surface ',
          '(line ',Line_num,' of input).');
        close (Infile);
        halt;
      end;
      if (Y = 0) then begin
        Firstx := Xc[1] + X12slice * X;
        Firsty := Yc[1] + Y12slice * X;
        Firstz := Zc[1] + Z12slice * X;
        Lastx  := Xc[4] + X43slice * X;
        Lasty  := Yc[4] + Y43slice * X;
        Lastz  := Zc[4] + Z43slice * X;
        Xslice := (Lastx - Firstx) / Ny;
        Yslice := (Lasty - Firsty) / Ny;
        Zslice := (Lastz - Firstz) / Ny;
        World[Node][1] := Firstx;
        World[Node][2] := Firsty;
        World[Node][3] := Firstz;
      end else begin
        World[Node][1] := Firstx + Xslice * Y;
        World[Node][2] := Firsty + Yslice * Y;
        World[Node][3] := Firstz + Zslice * Y;
      end; { if (Y = 0) }

      { Now connect the surface }
      if (X <> 0) and (Y <> 0) then begin
        Surf := Surf + 1;
        if (Surf > Realmaxsurf) then begin
          writeln ('Exceeded MAXSURF=',Realmaxsurf,' in plane surface ',
            '(line ',Line_num,' of input).');
          close (Infile);
          halt;
        end;
        Connect[(Surf-1)*Maxvert+1] := Firstnodelastrow + Y - 1;
        Connect[(Surf-1)*Maxvert+2] := Firstnodethisrow + Y - 1;
        Connect[(Surf-1)*Maxvert+3] := Firstnodethisrow + Y;
        Connect[(Surf-1)*Maxvert+4] := Firstnodelastrow + Y;
        if (Maxvert > 4) then
          Connect[(Surf-1)*Maxvert+5] := 0;
        Matl[Surf] := Material;
      end; { if (X <> 0) and (Y <> 0) }
    end; { for Y }
    Firstnodelastrow := Firstnodethisrow;
  end; { for X }

  Lastnode := Node;
  Nnodes := Node;
  Nsurf := Surf;

  rotatenodes (Firstnode, Lastnode, Rotate);
  shiftnodes (Firstnode, Lastnode, Shift);
  scalenodes (Firstnode, Lastnode, Scale);
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure PLANE }
