procedure INITIAL;
{ Initialize global variables; read in the data file if specified on
  the command line.
}

begin
{$ifdef DEBUG}
  assign(Dbgfile, 'SURFMODL.DBG');
  rewrite(Dbgfile);
{$endif}
  { Initialize all the parameters that not get set in readcfg: }
  Xeye := 100.0;
  Yeye := -70.0;
  Zeye := 75.0;
  Xfocal := 0.0;
  Yfocal := 0.0;
  Zfocal := 0.0;
  Nlite := 1;
  Xlite[1] := 100.0;
  Ylite[1] := 30.0;
  Zlite[1] := 0.0;
  Intensity[1] := 0.7;
  Magnify := 1.0;
  Viewtype := 0;
  Interpolate := FALSE;
  Epsilon := 0.3;
  Shadowing := FALSE;
  XYadjust := 1.0;
  Showaxes := 0;
  Xaxislen := 0.2;
  Yaxislen := 0.2;
  Zaxislen := 0.2;
  ShowAllBorders := 0;
  Axiscolor := 1;
  Nwindow := 1;
  Textcol := 1;
  BGcol := 0;
  Graphcol := 1;
  RevVideo := FALSE;
  ShowTitle := FALSE;
  Nsurf := 0;
  Nnodes := 0;
  Nmatl := 0;
  Lastplot := 0;

  Filemask := ' ';
  Inifile := ' ';
{$ifndef PLAYPAL }
  Save_cmmd := '';
{$endif}
  Viewchanged := TRUE;

  Fileread := FALSE;

{$ifndef INICVT}

{$ifdef USE_IFF}
  readcfg ('SURFIFF.CFG', TRUE);
{$else}
  readcfg ('SURFMODL.CFG', TRUE);
{$endif}

  setsys;

{$ifndef PLAYPAL}
  case paramcount of
    4..50: begin
      writeln ('usage: SURFMODL [filename] [menu choice]');
      halt;
    end;
    1,2,3: readfile (paramstr(1));
  end;  {case paramcount}
{$endif} {PLAYPAL}

{$endif} {INICVT}

end;  { procedure INITIAL }
