{routines and types for doing dithering in colour and in monochrome }


type dithtype = array[1..4] of integer;

const Dither: array[1..4] of dithtype = (
   (11,  5, 15,  1),
   (16,  6,  2,  9),
   ( 3, 10, 14,  8),
   ( 7, 12,  4, 13));


procedure DITHPLOT (X, Y, Ishade, Color1, Color2: integer);
{ dithered pixel plot command }
var Xmod, Ymod: integer;    { X & Y coords modulo 4. This is the place in }
                            { the dither matrix }
begin
  Xmod := X mod 4 + 1;
  Ymod := Y mod 4 + 1;
  if (Ishade >= Dither[Xmod][Ymod]) then
    gplot (X, Y, Color1)
  else
    gplot (X, Y, Color2);
end; { procedure DITHPLOT }


procedure DITHDRAW (X1, X2, Y, Ishade, Color1, Color2: integer);
{ dithered horizontal line drawing routine }
var X:          integer;        { X coord along line }
var Xmod, Ymod: integer;    { X & Y coords modulo 4. This is the place in }
                            { the dither matrix }

begin
  Ymod := Y mod 4 + 1;
  for X := X1 to X2 do begin
    Xmod := X mod 4 + 1;
    if (Ishade >= Dither[Xmod][Ymod]) then
      gplot (X, Y, Color1)
    else
      gplot (X, Y, Color2);
  end; { for X }
end; { procedure DITHDRAW }


procedure INTRPLOT (X, Y, Mat: integer; Shade: real);
{ Plot procedure with interpolated shading }
var Pcolor: integer;        { color to set pixel }
    Fmod: integer;          { mod for fill pixel setting }
    Ishade: integer;        { integer version of shade (0..64) for dithering }
    Tshade: real;           { temp for Shade }
    Color1, Color2: integer;{ 2 colors that bracket the shade }

begin
  if (Dorandom) then
    Tshade := Shade + Random * Randshade
  else
    Tshade := Shade;
  if (Ncolors >= 3) and (Mono) then begin
    { Use system's colors as shades of grey }
    colormod (Tshade, grSys, Color[Mat], Pcolor, Fmod);
    { Now finally set the pixel to the desired shade }
    shplot (X, Y, Pcolor, Fmod);
  end else begin
    { Use dithered shading }
    findcolors (Mat, Color[Mat], Tshade, Color1, Color2);
    Ishade := trunc (Tshade * 16.0);
    { Make sure the color is legitimate }
    dithplot (X, Y, Ishade, Color1, Color2);
  end; { if Ncolors... }
end; { procedure INTRPLOT }


procedure INTRDRAW (X1, X2, Y, Mat: integer; Shade1, Shade2: real);
{ Draw procedure with interpolated shading from point 1 to point 2 }
var X: integer;
    Shfact: real;           { factor for shade interpolation }
    Firstsh: boolean;       { flag first time through }
    Shade: real;            { shade at pixel }

begin
  Firstsh := TRUE;
  if (X2 = X1) then
    Shfact := 0.0
  else
    Shfact := (Shade2 - Shade1) / (X2 - X1);

  for X := X1 to X2 do begin
    if (Shfact = 0.0) then
      if (Firstsh) then begin
        Shade := Shade1;
        Firstsh := FALSE;
      end else
        Shade := Shade2
    else
      Shade := Shade1 + (X-X1) * Shfact;

    { Plot this pixel with shading }
    intrplot (X, Y, Mat, Shade);
  end; { for X }
end; { procedure INTRDRAW }
