/*-------------------------------------------------------------------------
	22 Feb 2000
-------------------------------------------------------------------------*/

#include "help.h"
#include "Grid.h"
#include "labels.h"
#include "disk2.h"
#include <dos.h>

//----------------------------------------------------------------------
//Given a date such as 2 June 1999 in the format of 2, 6, 1999
//This program return the number of bigdays this date is and also it
//returns a string containing the name of the day it falls on ie., "Sunday".

long int GetDay(char *daystr, int dd, int mm, int yyyy)
{


	char *dchar[7] = {
	"Sunday", "Monday", "Tuesday", "Wednesday",
	"Thursday", "Friday", "Saturday"};

	int NumDays[12]={
// jan feb mar apr may jun jul aug sep oct nov dec
	31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

	int PrevDays[12] ={
//  j   f   m   a   m   j     j   a    s    o    n    d}
	0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};


	long int bigday, temp, year, pyear, day, month, lp;

	lp =0;
	if(!(yyyy %4)) lp =1;
	if(!(yyyy %100)) lp =0;
	if(!(yyyy %400)) lp =1;


	pyear = yyyy -1;
	temp = (pyear *365) + (pyear /4) - (pyear /100) + (pyear /400);
	bigday = temp + PrevDays[mm-1];
	if(mm >2) bigday += lp;
	bigday += dd;
	int daynum = bigday %7;
	strcpy(daystr, dchar[daynum]);

	return bigday;
}

//--------------------------------------------------------------------------
//This function receives the version date
//It then computes the number of days the program is old
//it then gets the current date based on the computer clock
//and fills in the values for the structure TDate
//for day, month, year, progage, day_str, month_str
//hour, minute, second
int GetDate(TDate *b, int dd, int mm, int yyyy)
{

 char *mchar[12] ={
		"January",
		"February",
		"March",
		"April",
		"May",
		"June",
		"July",
		"August",
		"September",
		"October",
		"November",
		"December"};

	struct date d;
	struct time t;
	char day_str[12], month_str[14];
	long int big1, big2;

	getdate(&d);
	gettime(&t);

	b->year = d.da_year;
	b->month = d.da_mon;
	b->date = d.da_day;
	b->hour = t.ti_hour;
	b->minute = t.ti_min;
	b->second = t.ti_sec;
	strcpy(b->month_str, mchar[b->month-1]);
	big2 = GetDay(b->day_str, b->date, b->month, b->year);

	big1 = GetDay(day_str, dd, mm, yyyy);
	b->progage = big2 - big1;

	return 0;
}
//-----------------------------------------------------------------------


void Help::About(Disk *a)
{
  char tempbuf[10][81];

  int t, m, x, y, maxlen;
  int avglen;
  char *pchar[10];

	struct TDate b;
	GetDate(&b, 23, 2, 2000);
	strcpy(&tempbuf[0][0], "Matrix Spreadsheet");
	strcpy(&tempbuf[1][0], "Version 2.0");
	strcpy(&tempbuf[2][0], "Compiled on 23 February 2000");
	strcpy(&tempbuf[3][0], " ");
	strcpy(&tempbuf[4][0], "(c) Michael Finnegan");
	strcpy(&tempbuf[5][0], "http://members.xoom.com/finnegam/");
	strcpy(&tempbuf[6][0], "");
	strcpy(&tempbuf[7][0], " ");
	strcpy(&tempbuf[8][0], "Today is ");
	strcpy(&tempbuf[9][0], "This version was compiled ");


	sprintf(linebuf1, "%s, %d %s %d ", b.day_str, b.date, b.month_str, b.year);
	m = 0; //assume AM
	if(b.hour >12)
	{
		b.hour -=12;
		m =1; //PM
		  }
	else
	{
		if(b.hour == 12)
		m=1;
	}
	if(!m) sprintf(linebuf2, "(%2d:%2d a.m.)", b.hour, b.minute);
	else sprintf(linebuf2, "(%2d:%2d p.m.)", b.hour, b.minute);
	if(b.hour < 10) linebuf2[1] = '0';
	if(b.minute <10) linebuf2[4] ='0';
	strcat(linebuf1, linebuf2);
	strcat(&tempbuf[8][0], linebuf1);



	if(b.progage >1)
	{
		sprintf(linebuf1,"%d days ago.", b.progage);
		strcat(&tempbuf[9][0], linebuf1);
	}
	else if(b.progage ==1)
		strcat(&tempbuf[9][0], "yesterday.");

	else if(b.progage ==0)
		strcat(&tempbuf[9][0],"today.");


	else
	{
		sprintf(&tempbuf[8][0],"The computer's clock may be incorrect because it says");
		sprintf(&tempbuf[9][0], "today is %s, %d %s %d", b.day_str, b.date, b.month_str, b.year);
	}

	maxlen =0;
	for(t = 0; t<10; t++)
	{
		m = strlen(&tempbuf[t][0]);
		if(maxlen < m) maxlen = m;
		pchar[t] = &tempbuf[t][0];
	}

	//center allign all the 9 lines in the about box
	for(t =1; t <7; t++)
	{
		memset(linebuf1, ' ', 78);
		m = strlen(&tempbuf[t][0]);
		y = maxlen/2 - (m/2);
		if(y>0)
		{
			linebuf1[y] =0;
			strcat(linebuf1, &tempbuf[t][0]);
			strcpy(&tempbuf[t][0], linebuf1);
		}

	}


	a->CursorOn();

		  //a->repeatflg =1;
			/*int ShowDialogBox(char *txtlines[], int numlines,
													int buttonsbits,
													int f_maxviewlines,
													int cursorstyle=1,
													int getout=0, int repeatflg=0);

		 */
		  a->ShowDialogBox(&pchar[0], 9, 1, 9,0);
		  //SetCursor(a, 1);
		  //DispStatusLine(a);
}
//-----------------------------------------------------------------------
void Help::Functions(Disk *a)
{
  char tempbuf[81];

	char *pchar[6] = {"Matrix functions",

	" Matrix supports over 40 functions.",
	" To learn how to use them read the",
	" manual file included in the archive",
	" with this program."
	};


	strcpy(tempbuf, "Enter=Cancel  Use cursor keys to scroll through the help list.");
	a->WriteLine(tempbuf, 1, 24, 78, gbc[3]*16+gfc[3]);
	gotoxy(40, 20);
	a->CursorOn();
	a->ShowDialogBox(&pchar[0], 4, 1, 4, 0);
	//SetCursor(a, 1);
	//DispStatusLine(a);


}
//-----------------------------------------------------------------------
//In case a Borland math or string functions messes up the screen
//this should redraw it.
void Help::ReDrawScreen(Disk *a, Grid *g)
{
	a->ClrScr(0,0, 79,24, BLACK*16+LIGHTGRAY);
	g->DrawBorder(g->homex, g->homey);
	g->ReDrawSheet(1);
	g->DispCell(1);
	a->ShowMouse();
}
//-------------------------------------------------------------------------






