/**********************************************************/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/*
CAUTION: Compile using LARGE memory model!!!!!
*/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/**********************************************************/

#include <stdio.h>

#include "xsnd.h"

/**********************************************************/
/* basic block length (samples per block):
too sort ==> too much interrupts per second. */
#define N 200

/* sampling rate */
/*#define SRATE 8000*/
#define SRATE 7500  /* shareware version only supports this */

/* samples to record */
#define NSAMPLES 31345

/* raw binary audio file to play */
#define FNAME "audio.raw"

/**********************************************************/

int main( void )
{
	FILE *f;
	int err;
	UINT32 nrec;  /* samples left to rec */
	INT16 * p;  /* far pointer to 16 bit integer */

	printf("This programs just records a fixed number of mono\n"
		"16 bit signed audio samples to a file named " FNAME ".\n"
		"Use the example named PLAY.C to play this file.\n"
		"Press ENTER to continue...");
	fgetc(stdin);

	f = fopen(FNAME,"wb");
	if (f==NULL) {
		printf("can't open file!\n");
		return 1;
	}

	/* sane state for SB16 */
	xsnd16_initialize();

	/* allocate SB16 resources */
	/* The interrupt time callback is not used. Pooling mode
	is used instead. */
	err=xsnd16_open(XSND_RECORD,  /* record */
			SRATE,       /* sampling rate */
			XSND_MONO,   /* mono recording */
			N,          /* block length */
			4,          /* number of blocks */
			NULL);    /* no user callback */

	if (err) {    /* if error */
		printf("can't open sb16!\n");
		return 1;
	}

	nrec = NSAMPLES; /* initialize samples left */

	/* first we add as many free blocks to the recording queue as
	possible. */
	while (!xsnd16_addblk());

	xsnd16_start();  /* start recording */

	while (1) {
		/* try to get a recorded block (NULL if not ready yet) */
		p = xsnd16_getblk();

		/* if we got a valid block, save it */
		if (p) {
			if (nrec>N) {  /* save the whole block if nrec>N */
				fwrite(p,sizeof(INT16),N,f);
				nrec -= N;
			}
			else {  /* save the last block (posibly sorter than N) */
				fwrite(p,sizeof(INT16),(UINT16)nrec,f);
				break;
			}
		/* after saving the block, put it again to the recording queue */
		xsnd16_addblk();
		}
	}

	/* free resources */
	xsnd16_close();
	fclose(f);

	return 0;
}

/**********************************************************/
