/**********************************************************/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/*
CAUTION: Compile using LARGE memory model!!!!!
*/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/**********************************************************/

#include <stdio.h>

#include "xsnd.h"

/**********************************************************/
/* basic block length (samples per block) */
#define N 400

/* sampling rate */
/*#define SRATE 8000*/
#define SRATE 7500  /* shareware version only supports this */

/* raw binary audio file to play */
#define FNAME "audio.raw"

/**********************************************************/

int main( void )
{
	FILE *f;
	int err;
	size_t n;
	INT16 * p;	/* far ponter to 16 bit integer  */


	printf("This programs just plays the 16 bit mono signed audio file\n"
		"called " FNAME ".\n"
		"Press ENTER to continue...");
	fgetc(stdin);

	f = fopen(FNAME,"rb");
	if (f==NULL) {
		printf("can't open file!\n");
		return 1;
	}

	/* hardware reset the card. Needed to bring SB16 to sane state */
	xsnd16_initialize();

	/* allocate SB resources */
	/* In this example the interrupt time callback is not used, and
	pooling mode is used instead. */
	err=xsnd16_open(XSND_PLAY,  /* playback */
			SRATE,  /* sampling rate */
			XSND_MONO,  /* mono playback */
			N,   /* basic block length */
			4,   /* number of blocks to allocate */
			NULL);  /* no user callback */


	if (err) { /* xsnd16_open() return != 0 if error */
		printf("can't open sb16!\n");
		return 1;
	}
	xsnd16_start();  /* begins D/A conversion */

	while (1) {
		/* get a pointer to next free block (NULL if none) */
		p = xsnd16_getblk();

		if (p) {  /* if we got a valid pointer */
			n = fread(p,sizeof(INT16),N,f);  /* read block from file */
			if (n==N)  /* if max. block size could be read */
				xsnd16_addblk();  /* queue the block */
			else {   /* if block is shorter than max. block size */
				xsnd16_addlastblk(n);  /* add a last and shorter block */
				break;  /* and exit */
			}
		}
	}

	/* do not end playback process until all the blocks have been
	played, i.e., until xsnd16_addlastblk actually blocks the process */
	while (!xsnd16_blocked()) {
		/* nothing */
	}

	/* free resources */
	xsnd16_close();
	fclose(f);

	return 0;
}

/**********************************************************/
