/*
 *  Routines to do windowing on the data (in various forms)
 *
 *  Copyright (C) 1995  Philip VanBaren
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "specgram.h"
#include "extern.h"

short *p1,*p3,*p4;        /* Various indexing pointers */
short *sample16;
unsigned char *sample8;

long back1,back2;       /* Variables for differencing */
long back1b,back2b;


void window_data_normal(void)
{
   int i;

   /* Perform windowing directly on the data (no differencing) */
   p1=fftdata;
   p3=wind;
   p4=fftdata2;

   if(sample_size==8)
   {
      sample8=(unsigned char *)buffer+buffer_offset*(stereo+1);
      if(stereo_diff)
      {
         for(i=0;i<fftlen;i++)
         {
            /* Sample values for stereo difference mode */
            register int left=*(sample8++)-128;
            register int right=*(sample8++)-128;
            *(p1++)=(int)(((long)(left+right) * (long)(*p3)) >> 16);
            *(p4++)=(int)(((long)(left-right) * (long)(*p3)) >> 15);
            p3++;
         }
      }
      else if(stereo)
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(((long)(*sample8) * (long)(*p3)) >> 15);
            sample8++;
            *(p4++)=(int)(((long)(*sample8) * (long)(*p3)) >> 15);
            sample8++;
            p3++;
         }
      }
      else
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(( ((long)(*sample8)-128L)  * (long)(*p3)) >> 7);
            sample8++;
            p3++;
         }
      }
   }
   else /* 16 bit mode */
   {
      sample16=(short *)buffer+buffer_offset*(stereo+1);
      if(stereo_diff)
      {
         for(i=0;i<fftlen;i++)
         {
            /* Sample values for stereo difference mode */
            register short left=*(sample16++);
            register short right=*(sample16++);
            *(p1++)=(int)(((long)(left+right) * (long)(*p3)) >> 16);
            *(p4++)=(int)(((long)(left-right) * (long)(*p3)) >> 15);
            p3++;
         }
      }
      else if(stereo)
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(((long)(*sample16) * (long)(*p3)) >> 15);
            sample16++;
            *(p4++)=(int)(((long)(*sample16) * (long)(*p3)) >> 15);
            sample16++;
            p3++;
         }
      }
      else
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(((long)(*sample16) * (long)(*p3)) >> 15);
            sample16++;
            p3++;
         }
      }
   }
}

void window_data_first_difference(void)
{
   int i;
   /* Perform windowing on the first difference of the data */
   p1=fftdata;
   p3=wind;
   p4=fftdata2;

   if(sample_size==8)
   {
      sample8=(unsigned char *)buffer+buffer_offset*(stereo+1);
      back1=*sample8;
      back1b=*(sample8+1);
      if(stereo_diff)
      {
         for(i=0;i<fftlen;i++)
         {
            /* Sample values for stereo difference mode */
            register int left=*(sample8++)-128;
            register int right=*(sample8++)-128;
            *(p1++)=(int)(((long)(left+right-back1) * (long)(*p3)) >> 16);
            *(p4++)=(int)(((long)(left-right-back1b) * (long)(*p3)) >> 15);
            back1=left+right;
            back1b=left-right;
            p3++;
         }
      }
      else if(stereo)
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(((long)(*sample8-back1) * (long)(*p3)) >> 15);
            back1=*sample8;
            sample8++;
            *(p4++)=(int)(((long)(*sample8-back1b) * (long)(*p3)) >> 15);
            back1b=*sample8;
            sample8++;
            p3++;
         }
      }
      else
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(( (long)(*sample8-back1) * (long)(*p3)) >> 7);
            back1=*sample8;
            sample8++;
            p3++;
         }
      }
   }
   else /* 16 bit mode */
   {
      sample16=(short *)buffer+buffer_offset*(stereo+1);
      back1=*sample16;
      back1b=*(sample16+1);
      if(stereo_diff)
      {
         for(i=0;i<fftlen;i++)
         {
            /* Sample values for stereo difference mode */
            register int left=*(sample16++);
            register int right=*(sample16++);
            *(p1++)=(int)(((long)(left+right-back1) * (long)(*p3)) >> 16);
            *(p4++)=(int)(((long)(left-right-back1b) * (long)(*p3)) >> 15);
            back1=left+right;
            back1b=left-right;
            p3++;
         }
      }
      else if(stereo)
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(((long)(*sample16-back1) * (long)(*p3)) >> 15);
            back1=*sample16;
            sample16++;
            *(p4++)=(int)(((long)(*sample16-back1b) * (long)(*p3)) >> 15);
            back1b=*sample16;
            sample16++;
            p3++;
         }
      }
      else
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(((long)(*sample16-back1) * (long)(*p3)) >> 15);
            back1=*sample16;
            sample16++;
            p3++;
         }
      }
   }
}

void window_data_second_difference(void)
{
   int i;
   /* Perform windowing on the second difference of the data */
   p1=fftdata;
   p3=wind;
   p4=fftdata2;

   if(sample_size==8)
   {
      sample8=(unsigned char *)buffer+buffer_offset*(stereo+1);
      back1=back2=*sample8;
      back1b=back2b=*(sample8+1);
      if(stereo_diff)
      {
         for(i=0;i<fftlen;i++)
         {
            /* Sample values for stereo difference mode */
            register int left=*(sample8++)-128;
            register int right=*(sample8++)-128;
            *(p1++)=(int)(((long)(left+right-2*back1+back2) * (long)(*p3)) >> 16);
            *(p4++)=(int)(((long)(left-right-2*back1b+back2b) * (long)(*p3)) >> 15);
            back2=back1;
            back1=left+right;
            back2b=back1b;
            back1b=left-right;
            p3++;
         }
      }
      else if(stereo)
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(((long)(*sample8-2*back1+back2) * (long)(*p3)) >> 15);
            back2=back1;
            back1=*sample8;
            sample8++;
            *(p4++)=(int)(((long)(*sample8-2*back1b+back2b) * (long)(*p3)) >> 15);
            back2b=back1b;
            back1b=*sample8;
            sample8++;
            p3++;
         }
      }
      else
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(( (long)(*sample8-2*back1+back2) * (long)(*p3)) >> 7);
            back2=back1;
            back1=*sample8;
            sample8++;
            p3++;
         }
      }
   }
   else /* 16 bit mode */
   {
      sample16=(short *)buffer+buffer_offset*(stereo+1);
      back1=back2=*sample16;
      back1b=back2b=*(sample16+1);
      if(stereo_diff)
      {
         for(i=0;i<fftlen;i++)
         {
            /* Sample values for stereo difference mode */
            register short left=*(sample16++);
            register short right=*(sample16++);
            *(p1++)=(int)(((long)(left+right-2*back1+back2) * (long)(*p3)) >> 16);
            *(p4++)=(int)(((long)(left-right-2*back1b+back2b) * (long)(*p3)) >> 15);
            back2=back1;
            back1=left+right;
            back2b=back1b;
            back1b=left-right;
            p3++;
         }
      }
      else if(stereo)
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(((long)(*sample16-2*back1+back2) * (long)(*p3)) >> 15);
            back2=back1;
            back1=*sample16;
            sample16++;
            *(p4++)=(int)(((long)(*sample16-2*back1b+back2b) * (long)(*p3)) >> 15);
            back2b=back1b;
            back1b=*sample16;
            sample16++;
            p3++;
         }
      }
      else
      {
         for(i=0;i<fftlen;i++)
         {
            *(p1++)=(int)(((long)(*sample16-2*back1+back2) * (long)(*p3)) >> 15);
            back2=back1;
            back1=*sample16;
            sample16++;
            p3++;
         }
      }
   }
}

