#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <string.h>
#include <mem.h>
#include <math.h>
#define	TWO_PI	((double)2.0 * M_PI)

typedef unsigned char DacPalette256[256][3];
unsigned char far *VGAmem;
struct text_info tiGFX;
struct REGPACK regp;
union  REGS reg;
int Linecolor=1,WritePage=0,HighSpeed=0,Triggerbuffer=999,winX=1;
int minX=0,minY=0,maxx=320,maxy=200;

DacPalette256 Hallo;

/* Globals */

int	samples, power;
double	real[2048], imag[2048], max, min, Pegel=10,FFTmax;
FILE	*fpi, *fpo;

/* Prototypes and forward declarations */

void	fft(void), max_amp(void);
int	permute(int);
double	magnitude(int);
void dspwrite ( unsigned char );
unsigned char dspread ( void );
unsigned Buffer[2048];
unsigned SBuffer[5003];
unsigned char far *data;
unsigned char far *aligned;
unsigned char far aligned_physical;

/* Setvgapalette256 sets the entire 256 color palette */
/* PalBuf contains RGB values for all 256 colors      */
/* R,G,B values range from 0 to 63	              */
/* Usage:					      */
/*  DacPalette256 dac256;			      */
/*						      */
/* setvgapalette256(&dac256);			      */
void setvgapalette256(DacPalette256 *PalBuf)
{
  regp.r_ax = 0x1012;
  regp.r_bx = 0;
  regp.r_cx = 256;
  regp.r_es = FP_SEG(PalBuf);
  regp.r_dx = FP_OFF(PalBuf);
  intr(0x10,&regp);
}



void Grafik(int GFXmode)  // 13,      14,     17mono,   18,      19vga,  -1,3
{                         //320x200, 640x200, 640x480, 640x480, 320x200, text
VGAmem=(char far *)MK_FP(0xa000,0);
if (GFXmode>=0)
  {
   gettextinfo(&tiGFX);
   regp.r_ax = GFXmode;
   intr(0x10,&regp);
  }
if (GFXmode<0)
  {
   regp.r_ax = tiGFX.currmode;
   intr(0x10,&regp);
  }
}



void Putpixel(int x, int y)
{
 reg.h.ah = 0x0c;
 reg.h.al = Linecolor;
 reg.h.bh = WritePage;
 reg.x.cx = x;
 reg.x.dx = y;
 int86(0x10,&reg,&reg);
}



void singlecolor256(int nr,int r,int g,int b)
{
 reg.h.ah = 0x10;
 reg.h.al = 0x10;
 reg.x.bx = nr;
 reg.h.ch = g;
 reg.h.cl = b;
 reg.h.dh = r;
 int86(0x10,&reg,&reg);
}



void singlecolor16(int nr,int r,int g,int b)
{
 reg.h.ah=0x10;
 reg.h.al=0x07;
 reg.h.bl=nr;
 int86(0x10,&reg,&reg);
 nr=reg.h.bh;
 reg.h.ah = 0x10;
 reg.h.al = 0x10;
 reg.x.bx = nr;
 reg.h.ch = g;
 reg.h.cl = b;
 reg.h.dh = r;
 int86(0x10,&reg,&reg);
}



int Read(int Pout)
{
 int Wert;
 outportb(0x224,Pout);
 delay(1);
 Wert=inportb(0x225);
 delay(1);
 return Wert;
}


void Write(int Pout,int Wert)
{
 outportb(0x224,Pout);
 delay(1);
 outportb(0x225,Wert);
 delay(1);
}



void MakePalette()
{
 int frag;
 for(frag=0;frag<256;frag++)
   {
    if(frag<32)
	       {
		Hallo[frag][0]=0;
		Hallo[frag][1]=0;
		Hallo[frag][2]=2*frag;
	       }
    if((frag>=32)&&(frag<96))
			     {
			      Hallo[frag][0]=0;
			      Hallo[frag][1]=(frag-32);
			      Hallo[frag][2]=(95-frag);
			     }
    if((frag>=96)&&(frag<128))
			      {
			       Hallo[frag][0]=2*(frag-96);
			       Hallo[frag][1]=63;
			       Hallo[frag][2]=0;
			      }
    if((frag>=128)&&(frag<192))
			       {
				Hallo[frag][0]=63;
				Hallo[frag][1]=(191-frag);
				Hallo[frag][2]=(frag-128);
			       }
    if(frag>=192)
   	         {
	          Hallo[frag][0]=63;
		  Hallo[frag][1]=0;
		  Hallo[frag][2]=0;
		  if(frag<223)Hallo[frag][2]=2*(222-frag);
	         }
   }
 setvgapalette256(&Hallo);
}


//------------------------------------------------------------------------------
void dspwrite ( unsigned char c )
{
    while(inportb(0x022C)&0x80);
    outportb(0x022C,c);
}
//------------------------------------------------------------------------------
void sbinit ( void )
{
    unsigned short x;
    inportb(0x022E);
    outportb(0x0226,0x01);
    inportb(0x0226);
    inportb(0x0226);
    inportb(0x0226);
    inportb(0x0226);
    outportb(0x0226,0x00);
    for(x=0;x<100;x++)
    {
        if(inportb(0x022E)&0x80)
        {
            if(inportb(0x022A)==0xAA) break;
        }
    }
    if(x==100)
    {
        printf("SoundBlaster PRO  not found at 0220h\n");
        exit(1);
    }
}
//------------------------------------------------------------------------------
void sbmalloc ( void )
{
    unsigned long physical;
    data=farmalloc(80000L);
    if(data==NULL)
    {
        printf("Memory Allocation Error\n");
        exit(1);
    }
    physical=((unsigned long)FP_OFF(data))+(((unsigned long)FP_SEG(data))<<4);
    physical+=0x0FFFFL;
    physical&=0xF0000L;
    aligned_physical=(physical>>16)&15;
    aligned=MK_FP(((unsigned short)aligned_physical<<12)&0xF000,0);
}
//------------------------------------------------------------------------------
void sbsettc ( unsigned char tc )
// tc = time constant = 256L - (1000000UL/samples per second)
{
    inportb(0x022E);
    dspwrite(0x40);
    dspwrite(tc);
}
//------------------------------------------------------------------------------
void sbrec ( unsigned short len )
// len = number of bytes to record to unsigned char *aligned (<=65000)
{
    len--;
    outportb(0x0A,0x05);
    outportb(0x0C,0x00);
    outportb(0x0B,0x45);
    outportb(0x02,0);
    outportb(0x02,0);
    outportb(0x83,aligned_physical);
    outportb(0x03,(unsigned char)(len&0xFF));
    outportb(0x03,(unsigned char)((len>>8)&0xFF));
    outportb(0x0A,0x01);
    dspwrite(0x24);
    dspwrite((unsigned char)(len&0xFF));
    dspwrite((unsigned char)((len>>8)&0xFF));
}
//------------------------------------------------------------------------------
void sbrec2 ( unsigned short len )
// len = number of bytes to record to unsigned char *aligned (<=65000)
{
    len--;
    outportb(0x0A,0x05);
    outportb(0x0C,0x00);
    outportb(0x0B,0x45);
    outportb(0x02,0);
    outportb(0x02,0);
    outportb(0x83,aligned_physical);
    outportb(0x03,(unsigned char)(len&0xFF));
    outportb(0x03,(unsigned char)((len>>8)&0xFF));
    outportb(0x0A,0x01);
    dspwrite(0x48);
    dspwrite((unsigned char)(len&0xFF));
    dspwrite((unsigned char)((len>>8)&0xFF));
    dspwrite(0x99);
}
//------------------------------------------------------------------------------
unsigned short dmacount ( void )
{
    unsigned short x;
    x=inportb(0x03);
    x|=inportb(0x03)<<8;
    if(x==0xFFFF) inportb(0x022E);
    return(x);
}
//------------------------------------------------------------------------------
void recording(int e,int f)
{
 int m,n=Triggerbuffer -e,o;
 int Smax=0,Spos=0;
 if(HighSpeed)sbrec2(Triggerbuffer); else sbrec(Triggerbuffer);
 while(dmacount()!=0xFFFF);
 for(m=0;m<n;m++)
    {
     o= *(aligned+m);
     if(o>Smax)Smax=o,Spos=m&32766;
    }
 if(f>0)for(m=0;m<e;m++)
           {
            o = *(aligned+Spos+m) - f;
            if(o<0)o=0;
            if(o>199)o=199;
            SBuffer[m]=o;
           }
 else for(m=0;m<e;m++)SBuffer[m] = *(aligned+Spos+m) - f;
}



void lineX00(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-1,v,w=abs(dy);
 if(w<2)
        {
         *(VGAmem+((x-1)>>3)+80*y1)&=255-(1<<(7-((x-1)&7)));
         *(VGAmem+(x>>3)+80*y2)&=255-(1<<(7-(x&7)));
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=v-y1;
              w /=dy;
              *(VGAmem+((m+w)>>3)+80*v)&=255-(1<<(7-((m+w)&7)));
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=v-y2;
          w /=dy;
          *(VGAmem+((x-w)>>3)+80*v)&=255-(1<<(7-((x-w)&7)));
         }
     }
}



void lineX01(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-1,v,w=abs(dy);
 if(w<2)
        {
         *(VGAmem+((x-1)>>3)+80*y1)|=1<<(7-((x-1)&7));
         *(VGAmem+(x>>3)+80*y2)|=1<<(7-(x&7));
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=v-y1;
              w /=dy;
              *(VGAmem+((m+w)>>3)+80*v)|=1<<(7-((m+w)&7));
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=v-y2;
          w /=dy;
          *(VGAmem+((x-w)>>3)+80*v)|=1<<(7-((x-w)&7));
         }
     }
}



int cool0()
{
unsigned t;
int i;
Triggerbuffer=5000;
Grafik(18);
for(i=0;i<2000;i++)Buffer[i]=0;
Linecolor=2;
for(i=0;i<640;i+=10)for(t=0;t<480;t+=2)Putpixel(i,t);
for(i=0;i<480;i+=10)for(t=0;t<640;t+=2)Putpixel(t,i);
Linecolor=6;
for(i=0;i<480;i+=40)for(t=0;t<640;t+=2)Putpixel(t,i);
for(i=0;i<640;i+=40)for(t=0;t<480;t+=2)Putpixel(i,t);
for(t=0;t<480;t+=2)Putpixel(639,t);
for(t=0;t<640;t+=2)Putpixel(t,479);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,1);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,0);
singlecolor16(1,63,63,63);
nochmal:
    recording(1280,(-232));
    lineX00(1,Buffer[0],Buffer[1]);
    for(i=1;i<640;i++)
                      {
                       lineX00(i+1,Buffer[i],Buffer[i+1]);
                       lineX01(i,SBuffer[2*(i-1)],SBuffer[2*i]);
                      }
    for(i=0;i<640;i++)Buffer[i]=SBuffer[2*i];
    lineX00(1,Buffer[1000],Buffer[1001]);
    for(i=1;i<640;i++)
                      {
                       lineX00(i+1,Buffer[i+1000],Buffer[i+1001]);
                       lineX01(i,SBuffer[2*(i-1)+1]-240,SBuffer[2*i+1]-240);
                      }
    for(i=0;i<640;i++)Buffer[i+1000]=SBuffer[2*i+1]-240;
    if(!kbhit())goto nochmal;
i=getch();
if((i==13)||(i==32)) { getch(); goto nochmal; }
return i;
}



void lineX21(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-2,v,w=abs(dy);
 if(w<3)
        {
         m=(y1+y2)/2;
         *(VGAmem+((x-2)>>3)+80*y1)|=1<<(7-((x-2)&7));
         *(VGAmem+((x-1)>>3)+80*m)|=1<<(7-((x-1)&7));
         *(VGAmem+((x)>>3)+80*y2)|=1<<(7-((x)&7));
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=(v-y1)*2;
              w /=dy;
              *(VGAmem+((m+w)>>3)+80*v)|=1<<(7-((m+w)&7));
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=(v-y2)*2;
          w /=dy;
          *(VGAmem+((x-w)>>3)+80*v)|=1<<(7-((x-w)&7));
         }
     }
}



void lineX20(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-2,v,w=abs(dy);
 if(w<3)
        {
         m=(y1+y2)/2;
         *(VGAmem+((x-2)>>3)+80*(y1))&=255-(1<<(7-((x-2)&7)));
         *(VGAmem+((x-1)>>3)+80*(m))&=255-(1<<(7-((x-1)&7)));
         *(VGAmem+((x)>>3)+80*(y2))&=255-(1<<(7-((x)&7)));
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=(v-y1)*2;
              w /=dy;
              *(VGAmem+((m+w)>>3)+80*v)&=255-(1<<(7-((m+w)&7)));
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=(v-y2)*2;
          w /=dy;
          *(VGAmem+((x-w)>>3)+80*v)&=255-(1<<(7-((x-w)&7)));
         }
     }
}




int cool2()
{
unsigned t;
int i;
Triggerbuffer=3000;
Grafik(18);
for(i=0;i<2000;i++)Buffer[i]=0;
Linecolor=2;
for(i=0;i<640;i+=10)for(t=0;t<480;t+=2)Putpixel(i,t);
for(i=0;i<480;i+=10)for(t=0;t<640;t+=2)Putpixel(t,i);
Linecolor=6;
for(i=0;i<480;i+=40)for(t=0;t<640;t+=2)Putpixel(t,i);
for(i=0;i<640;i+=40)for(t=0;t<480;t+=2)Putpixel(i,t);
for(t=0;t<480;t+=2)Putpixel(639,t);
for(t=0;t<640;t+=2)Putpixel(t,479);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,1);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,0);
singlecolor16(1,63,63,63);
nochmal:
    recording(640,(-232));
    lineX20(2,Buffer[0],Buffer[2]);
    for(i=2;i<640;i+=2)
                      {
                       lineX20(i+2,Buffer[i],Buffer[i+2]);
                       lineX21(i,SBuffer[i-2],SBuffer[i]);
                      }
    for(i=0;i<640;i+=2)Buffer[i]=SBuffer[i];
    lineX20(2,Buffer[1000],Buffer[1002]);
    for(i=2;i<640;i+=2)
                      {
                       lineX20(i+2,Buffer[i+1000],Buffer[i+1002]);
                       lineX21(i,SBuffer[i-1]-240,SBuffer[i+1]-240);
                      }
    for(i=0;i<640;i+=2)Buffer[i+1000]=SBuffer[i+1]-240;
    if(!kbhit())goto nochmal;
i=getch();
if((i==13)||(i==32)) { getch(); goto nochmal; }
return i;
}



int cool3()
{
unsigned t;
int i;
Triggerbuffer=1500;
Grafik(18);
for(i=0;i<2000;i++)Buffer[i]=0;
Linecolor=2;
for(i=0;i<640;i+=10)for(t=0;t<480;t+=2)Putpixel(i,t);
for(i=0;i<480;i+=10)for(t=0;t<640;t+=2)Putpixel(t,i);
Linecolor=6;
for(i=0;i<480;i+=40)for(t=0;t<640;t+=2)Putpixel(t,i);
for(i=0;i<640;i+=40)for(t=0;t<480;t+=2)Putpixel(i,t);
for(t=0;t<480;t+=2)Putpixel(639,t);
for(t=0;t<640;t+=2)Putpixel(t,479);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,1);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,0);
singlecolor16(1,63,63,63);
nochmal:
    recording(1280,(-232));
    lineX00(1,Buffer[0],Buffer[1]);
    for(i=1;i<640;i++)
                      {
                       lineX00(i+1,Buffer[i],Buffer[i+1]);
                       lineX01(i,SBuffer[2*(i-1)],SBuffer[2*i]);
                      }
    for(i=0;i<640;i++)Buffer[i]=SBuffer[2*i];
    lineX00(1,Buffer[1000],Buffer[1001]);
    for(i=1;i<640;i++)
                      {
                       lineX00(i+1,Buffer[i+1000],Buffer[i+1001]);
                       lineX01(i,SBuffer[2*(i-1)+1]-240,SBuffer[2*i+1]-240);
                      }
    for(i=0;i<640;i++)Buffer[i+1000]=SBuffer[2*i+1]-240;
    if(!kbhit())goto nochmal;
i=getch();
if((i==13)||(i==32)) { getch(); goto nochmal; }
return i;
}



int cool4()
{
unsigned t;
int i;
Triggerbuffer=800;
Grafik(18);
for(i=0;i<2000;i++)Buffer[i]=0;
Linecolor=2;
for(i=0;i<640;i+=10)for(t=0;t<480;t+=2)Putpixel(i,t);
for(i=0;i<480;i+=10)for(t=0;t<640;t+=2)Putpixel(t,i);
Linecolor=6;
for(i=0;i<480;i+=40)for(t=0;t<640;t+=2)Putpixel(t,i);
for(i=0;i<640;i+=40)for(t=0;t<480;t+=2)Putpixel(i,t);
for(t=0;t<480;t+=2)Putpixel(639,t);
for(t=0;t<640;t+=2)Putpixel(t,479);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,1);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,0);
singlecolor16(1,63,63,63);
nochmal:
    recording(640,(-232));
    lineX20(2,Buffer[0],Buffer[2]);
    for(i=2;i<640;i+=2)
                      {
                       lineX20(i+2,Buffer[i],Buffer[i+2]);
                       lineX21(i,SBuffer[i-2],SBuffer[i]);
                      }
    for(i=0;i<640;i+=2)Buffer[i]=SBuffer[i];

    lineX20(2,Buffer[1000],Buffer[1002]);
    for(i=2;i<640;i+=2)
                      {
                       lineX20(i+2,Buffer[i+1000],Buffer[i+1002]);
                       lineX21(i,SBuffer[i-1]-240,SBuffer[i+1]-240);
                      }
    for(i=0;i<640;i+=2)Buffer[i+1000]=SBuffer[i+1]-240;
    if(!kbhit())goto nochmal;
i=getch();
if((i==13)||(i==32)) { getch(); goto nochmal; }
return i;
}



//----------------------------------------------------------------------------


/* The program */
//samples = How many Real/Imag Numbers...
//power =  log10((double)samples) / log10((double)2.0);


void fft()
{
	unsigned i1, i2, i3, i4, y;
	int	 loop, loop1, loop2;
	double	 a1, a2, b1, b2, z1, z2, v;

	/* Scale the data */

	for (loop = 0; loop < samples; loop++)  {
		real[loop] /= (double)samples;
		imag[loop] /= (double)samples;
	}

	i1 = samples >> 1;
	i2 = 1;
	v = TWO_PI * ((double)1.0 / (double)samples);

	for (loop = 0; loop < power; loop++)  {
		i3 = 0;
		i4 = i1;

		for (loop1 = 0; loop1 < i2; loop1++)  {
			y = permute(i3 / i1);
			z1 =  cos(v * y);
			z2 = -sin(v * y);

			for (loop2 = i3; loop2 < i4; loop2++)  {
				a1 = real[loop2];
				a2 = imag[loop2];

				b1 = z1*real[loop2+i1] - z2*imag[loop2+i1];
				b2 = z2*real[loop2+i1] + z1*imag[loop2+i1];

				real[loop2]      = a1 + b1;
				imag[loop2]      = a2 + b2;

				real[loop2 + i1] = a1 - b1;
				imag[loop2 + i1] = a2 - b2;
			}

			i3 += (i1 << 1);
			i4 += (i1 << 1);
		}

		i1 >>= 1;
		i2 <<= 1;
	}
}

/*
 *	Find maximum amplitude
 */

void max_amp()
{
	double	mag;
	int	loop;

	max = (double)0.0;
	for (loop = 0; loop < samples; loop++)  {
		if ((mag = magnitude(loop)) > max)
			max = mag;
	}
}

/*
 *	Calculate Power Magnitude
 */

double magnitude(int n)
{
	n = permute(n);
	return (sqrt(real[n] * real[n] + imag[n] * imag[n]));
}

/*
 *	Bit reverse the number
 *
 *	Change 11100000b to 00000111b or vice-versa
 */

int permute(int index)
{
	int  n1, result, loop;
	n1 = samples;
	result = 0;
	for (loop = 0; loop < power; loop++)
               {
		n1 >>= 1;			/* n1 / 2.0 */
		if (index < n1)continue;
		result += (int) pow((double)2.0, (double)loop);
		index -= n1;
	       }
	return result;
}



void windows()
{
 int t;
 double w = 2.0 * M_PI / samples;
 double p90 = M_PI / 2.0;
 for(t=0;t<samples;t++) real[t]*=(1.0+sin(w*t-p90));   //cos!
}
//---------------------------------------------------------------------------
void mode17line1(int x,double vol)
{
 unsigned f,g;
 char far *h = VGAmem + x/8;
 vol=vol*Pegel;
 if(vol>239.0) vol = 239.0;
 f=239 - (int)vol;
 x=255-(1<<(7-(x&7)));
 f=80*f;
 for(g=0;g<f;g+=80)*(h+g)&=x;
 x=255-x;
 for(;g<19200;g+=80)*(h+g)|=x;
}



void mode17line(int x,double vol)
{
 unsigned f,g;
 char far *h = VGAmem + x/8;
 vol=vol*Pegel;
 if(vol>238.0) vol = 238.0;
 f=479 - (int)vol;
 x=255-(1<<(7-(x&7)));
 f=80*f;
 for(g=19200;g<f;g+=80)*(h+g)&=x;
 x=255-x;
 for(;g<=38400;g+=80)*(h+g)|=x;
}



int cool8()
{
 int i,t,n,n2;
 double v;
 long m=0;
 samples=1024;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=1000;i<8000;i++) m=m+ *(aligned+i);
 m=m/7000;    //Zero calibration!
 n2=samples/2;
 Grafik(17);
nochmal:
 if(HighSpeed) sbrec2(2*samples); else sbrec(2*samples);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+2*i) - (int)m; }
 if(winX)windows();
 fft();
 for(t=0;t<n2;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode17line(64+t,v);
    }
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+2*i+1) - (int)m; }
 if(winX)windows();
 fft();
 for(t=0;t<n2;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode17line1(64+t,v);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32)) {winX^=1; goto nochmal;}
return i;
}





void mode17bar(int x,double vol)
{
 unsigned e,g;
 char far *h = VGAmem + x;
 vol=vol*Pegel;
 if(vol>238) vol = 238;
 g=479 - (int)vol;
 g=g*80;
 for(e=19200;e<g;e+=80)*(h+e)=0;
 for(;g<=38400;g+=80)*(h+g)=254;
}



void mode17bar1(int x,double vol)
{
 unsigned e,g;
 char far *h = VGAmem + x;
 vol=vol*Pegel;
 if(vol>239) vol = 239;
 g=239 - (int)vol;
 g=g*80;
 for(e=0;e<g;e+=80)*(h+e)=0;
 for(;g<19200;g+=80)*(h+g)=254;
}



int cool7()
{
 unsigned u;
 int i,t;
 double v;
 long m=0;
 samples=256;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=1000;i<8000;i++) m=m+ *(aligned+i);
 m=m/7000;    //Zero calibration!
 Grafik(17);
 singlecolor16(15,0,63,0);
nochmal:

 if(HighSpeed) sbrec2(2*samples); else sbrec(2*samples);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+2*i) - (int)m; }
 if(winX)windows();
 fft();
 for(t=0;t<80;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode17bar(t,v);
    }
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+2*i+1) - (int)m; }
 if(winX)windows();
 fft();
 for(t=0;t<80;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode17bar1(t,v);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32)) {winX^=1; goto nochmal;}
return i;
}



void mode19bar0(int x,double vol)
{
 unsigned e,g;
 char far *h = VGAmem + x*3;
 vol=vol*Pegel;
 if(vol>98) vol = 98;
 g=199 - (int)vol;
 g=g*320;
 for(e=32000;e<g;e+=320) *(h+e)=0, *(h+e+1)=0;
 e=235-g/320;
 for(;g<=64000;g+=320) *(h+g)=e, *(h+g+1)=e, e--;
}



void mode19bar1(int x,double vol)
{
 unsigned e,g;
 char far *h = VGAmem + x*3;
 vol=vol*Pegel;
 if(vol>99) vol = 99;
 g=99 - (int)vol;
 g=g*320;
 for(e=0;e<g;e+=320) *(h+e)=0, *(h+e+1)=0;
 e=235-g/320;
 for(;g<32000;g+=320) *(h+g)=e, *(h+g+1)=e, e--;
}



int cool6()
{
 unsigned u;
 int i,t;
 double v;
 long m=0;
 samples=256;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=1000;i<8000;i++) m=m+ *(aligned+i);
 m=m/7000;    //Zero calibration!
 Grafik(19);
 MakePalette();
nochmal:
 if(HighSpeed) sbrec2(2*samples); else sbrec(2*samples);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+2*i) - (int)m; }
 if(winX)windows();
 fft();
 for(t=0;t<107;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode19bar0(t,v);
    }
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+2*i+1) - (int)m; }
 if(winX)windows();
 fft();
 for(t=0;t<107;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode19bar1(t,v);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32)) {winX^=1; goto nochmal;}
return i;
}



void mode13bar(int x,double vol)
{
 unsigned e,g;
 char far *h = VGAmem + x + 4;
 vol=vol*Pegel;
 if(vol>98) vol = 98;
 g=199 - (int)vol;
 g=g*40;
 for(e=4000;e<g;e+=40)*(h+e)=0;
 for(;g<=8000;g+=40)*(h+g)=254;
}



void mode13bar1(int x,double vol)
{
 unsigned e,g;
 char far *h = VGAmem + x + 4;
 vol=vol*Pegel;
 if(vol>99) vol = 99;
 g=99 - (int)vol;
 g=g*40;
 for(e=0;e<g;e+=40)*(h+e)=0;
 for(;g<4000;g+=40)*(h+g)=254;
}



int cool5()
{
 unsigned u;
 int i,t;
 double v;
 long m=0;
 samples=64;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=1000;i<8000;i++) m=m+ *(aligned+i);
 m=m/7000;    //Zero calibration!
 Grafik(13);
 singlecolor16(15,0,10,63);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,15);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,1);
nochmal:
 if(HighSpeed) sbrec2(200); else sbrec(200);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+2*i+70) - (int)m; }
 if(winX)windows();
 fft();
 for(t=0;t<32;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode13bar(t,v);
    }
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+2*i+71) - (int)m; }
 if(winX)windows();
 fft();
 for(t=0;t<32;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode13bar1(t,v);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32)) {winX^=1; goto nochmal;}
return i;
}



void Menue(int o)
{
textcolor(14);
cprintf("--------------------------------------\n\r");
cprintf("Soundblaster Pro  -  Stereo FFTSCOPE !\n\r");
cprintf("--------------------------------------\n\n\r");
textcolor(2);
cprintf("Freeware written 1994 by Lars Otte\n\n\r");
textcolor(8);
if(o)
 {
  cprintf("Samplerate:%5.0lf",FFTmax/2.0);
  if(winX)cprintf(", Window");
  if(HighSpeed)cprintf(", HighSpeed");
  printf("\n\n1. Trigger-Oszilloscope DIV=%1.3lfms\n\n",(20000.0/FFTmax));
  printf("2. Trigger-Oscilloscope DIV=%1.3lfms\n\n",(10000.0/FFTmax));
  printf("3. Fast-Oszilloscope, DIV=%1.3lfms\n\n",(20000.0/FFTmax));
  printf("4. Fast-Oscilloscope, DIV=%1.3lfms\n\n",(10000.0/FFTmax));
  printf("5. FFT-Scope  fmax = %5.0lfHz\n\n",0.5*0.5*FFTmax);
  printf("6. FFT-Scope  fmax = %5.0lfHz\n\n",0.5*0.417969*FFTmax);
  printf("7. FFT-Scope  fmax = %5.0lfHz\n\n",0.5*0.3125*FFTmax);
  printf("8. FFT-Scope  fmax = %5.0lfHz",0.5*0.5*FFTmax);
 }
else
    {
     printf("SoundBlaster Adress = 220h\n\n");
     printf("SoundBlaster IRQ is not used\n\n");
     printf("SoundBlaster DMA-channel = 1\n\n");
    }
}



void main()
{
 long ra,ca;
 int w=32;
directvideo=0;
clrscr();
Menue(0);
printf("Samplerate > 14999  use the Highspeed_Mode!\n\n");
printf("Samplerate: ");
scanf("%ld",&ra);
sbinit();
Write(0x0c,Read(0x0c)|0x28);
Write(0x20,0x1b);   //disable Feedback-danger over mic & line
sbmalloc();
ca= 256L - ( 1000000L / ra);
if(ra>=15000) ca=(65536L - (256000000L / ra))>>8,HighSpeed=1;
if(HighSpeed) ra=256000000L/(65536L-(ca<<8));
else ra=1000000L/(259L-ca);
FFTmax=(double)ra;
sbsettc(ca);
dspwrite(0xa8);
Grafik(13);
Menue(1);

nochmal:
if(w==49)w=cool0();
if(w==50)w=cool2();
if(w==51)w=cool3();
if(w==52)w=cool4();
if(w==53)w=cool5();
if(w==54)w=cool6();
if(w==55)w=cool7();
if(w==56)w=cool8();
if(w=='+')
         {
          ca=ca&255;
          ca++;
          HighSpeed=0;
          if(ca>189)HighSpeed=1;
          if(HighSpeed) ra=256000000L/(65536L-(ca<<8));
          else ra=1000000L/(259L-ca);
          FFTmax=(double)ra;
          sbsettc(ca);
          dspwrite(0xa8);
          if(ra>100000)ca--;
         }
if(w=='-')
         {
          ca=ca&255;
          if(ca>0)ca--;
          HighSpeed=0;
          if(ca>189)HighSpeed=1;
          if(HighSpeed) ra=256000000L/(65536L-(ca<<8));
          else ra=1000000L/(259L-ca);
          FFTmax=(double)ra;
          sbsettc(ca);
          dspwrite(0xa8);
         }
Grafik(13);
Menue(1);
if((w<'1')||(w>'8'))w=getch();
if(w!=27)goto nochmal;
dspwrite(0xa0);
Grafik(-1);
Menue(0);
}

