/* Print video state table returned by int 10h function 1Bh */
/* (c) Nigel Salt 1991                                      */
/* Microsoft C V6                                           */
/* -------------------------------------------------------- */
#include <dos.h>
#include <stdio.h>
void main(void);

#pragma pack(1)
/* Pack pragma needed to avoid padding of vb structure */

typedef unsigned int  word;
typedef unsigned char byte;
typedef struct
{
  byte modesupp[7];
  byte scansupp; /* 0,1,2=200,350,400 */
  byte numchblocks;
  byte maxactblocks;
  byte flagsupp;
  byte miscsupp;
  byte res1[2];
  byte flags2supp;
  byte res2;

} STATEFUN, far *STATEFUNPTR;

struct VIDBUFF
{
  STATEFUNPTR   functabptr;
  byte          vidmode;
  word          numcols;
  word          regenlen;
  word          regenstart;
  byte          curspos[8][2];
  byte          cursflin;
  byte          curselin;
  byte          actpage;
  word          portadd;
  byte          cur3x8;
  byte          cur3x9;
  byte          numrows;
  word          bytesperchar;
  byte          ActDispCombCode;
  byte          AltDispCombCode;
  word          numcolors;
  byte          numpages;
  byte          numscan; /* 0,1,2,3 = 200,350,400,480 */
  byte          primchblock;
  byte          secchblock;
  byte          flags;
    /* 0 always on
       1 gray summing on
       2 mono display attached
       3 default pallette loading disabled
       4 cursor emulation enabled
       5 0=intensity 1=blinking
       6/7 reserved
    */
  char          res1[3];
  byte          vidmem; /* 0,1,2,3 = 64K,128K,192K,256K */
  byte          flags2;
    /* 0 512 char set active
       1 dynamic save present
       2 alpha font override
       3 graphics font override
       4 pallette override
       5 DCC override
       6/7 reserved
    */
  char          res2[13];
} vb;
void main(void)
{
  int i,j;
  word mask;
  union REGS iregs,oregs;
  struct SREGS segregs;
  void far *vbptr;
  vbptr=(void far *)&vb;
  segregs.es=FP_SEG(vbptr);
  iregs.x.di=FP_OFF(vbptr);
  iregs.h.ah=0x1b;
  iregs.x.bx=0;
  int86x(0x10,&iregs,&oregs,&segregs);
  printf("\nVideo state information from int 10h func 1b");
  printf("\nCopyright (c) 1991 Nigel Salt");
  printf("\n=============================");
  printf("\nMode:              \t%u",vb.vidmode);
  printf("\nNumCols:           \t%u",vb.numcols);
  printf("\nRegenLen:          \t%u",vb.regenlen);
  printf("\nCursPos[0]:        \t%.3d\t%.3d\t(Row,Col)",vb.curspos[0][1],vb.curspos[0][0]);
  printf("\nCursPos[1]:        \t%.3d\t%.3d\t(Row,Col)",vb.curspos[1][1],vb.curspos[1][0]);
  printf("\nCursPos[2]:        \t%.3d\t%.3d\t(Row,Col)",vb.curspos[2][1],vb.curspos[2][0]);
  printf("\nCursPos[3]:        \t%.3d\t%.3d\t(Row,Col)",vb.curspos[3][1],vb.curspos[3][0]);
  printf("\nCursPos[4]:        \t%.3d\t%.3d\t(Row,Col)",vb.curspos[4][1],vb.curspos[4][0]);
  printf("\nCursPos[5]:        \t%.3d\t%.3d\t(Row,Col)",vb.curspos[5][1],vb.curspos[5][0]);
  printf("\nCursPos[6]:        \t%.3d\t%.3d\t(Row,Col)",vb.curspos[6][1],vb.curspos[6][0]);
  printf("\nCursPos[7]:        \t%.3d\t%.3d\t(Row,Col)",vb.curspos[7][1],vb.curspos[7][0]);
  printf("\nCursStart:         \t%u",vb.cursflin);
  printf("\nCursEnd:           \t%u",vb.curselin);
  printf("\nCurrPage:          \t%u",vb.actpage);
  printf("\nPortAdd:           \t%Xh",vb.portadd);
  printf("\n3x8Reg:            \t%u",vb.cur3x8);
  printf("\n3x9Reg:            \t%u",vb.cur3x9);
  printf("\nNumRows:           \t%u",vb.numrows);
  printf("\nBytesPerChar:      \t%u",vb.bytesperchar);
  printf("\nActDispCombCode:   \t%u",vb.ActDispCombCode);
  printf("\nAltDispCombCode:   \t%u",vb.AltDispCombCode);
  printf("\nNumColors:         \t%u",vb.numcolors);
  printf("\nNumPages:          \t%u",vb.numpages);
  printf("\nScanLines          \t");
  switch(vb.numscan)
    {
    case 0:
      printf("200");
      break;
    case 1:
      printf("350");
      break;
    case 2:
      printf("400");
      break;
    case 3:
      printf("480");
      break;
    }
  printf("\nPrimCharBlock:     \t%u",vb.primchblock);
  printf("\nSecCharBlock:      \t%u",vb.secchblock);

  printf("\nVideo memory:      \t");
  switch (vb.vidmem)
    {
    case 0:
      printf("64K");
      break;
    case 1:
      printf("128K");
      break;
    case 2:
      printf("192K");
      break;
    case 3:
      printf("256K");
      break;
    case 4:
      printf("512K");
      break;
    case 5:
      printf("1024K");
      break;
    }
  printf("\nFlags:");
  if (vb.flags&2)  printf("\n\tGray summing on");
  if (vb.flags&4)  printf("\n\tMono display attached");
  if (vb.flags&8)  printf("\n\tDefault pallete load disabled");
  if (vb.flags&16) printf("\n\tCursor emulation enabled");
  printf("\n\t%s",(vb.flags&32,"Blinking","intensity"));
  if (vb.flags2&1) printf("\n\t512 char set active");
  if (vb.flags2&2) printf("\n\tDynamic save present");
  if (vb.flags2&4) printf("\n\tAlpha font override");
  if (vb.flags2&8) printf("\n\tGraphics font override");
  if (vb.flags2&16) printf("\n\tPallette override");
  if (vb.flags2&32) printf("\n\tDisplay Comb Code override");
  printf("\n\nState supported table information");
  printf("\n=================================");
  printf("\nModes supported:\n\t");
  for (i=0;i<7;i++)
    {
    mask=1;
    for (j=0;j<8;j++)
      {
      if (vb.functabptr->modesupp[i]&mask)
        printf("%u ",i*8+j);
      mask*=2;
      }
    }
  printf("\nScan lines supported:\n\t");
  if (vb.functabptr->scansupp&1) printf("200 ");
  if (vb.functabptr->scansupp&2) printf("350 ");
  if (vb.functabptr->scansupp&4) printf("400 ");
  if (vb.functabptr->scansupp&8) printf("480 ");
  printf("\nTextModeCharBlocks:\t%u",vb.functabptr->numchblocks);
  printf("\nMaxActCharBlocks:  \t%u",vb.functabptr->maxactblocks);
  printf("\nFlags:");
  if (vb.functabptr->flagsupp&2)  printf("\n\tGray summing supported");
  if (vb.functabptr->flagsupp&4)  printf("\n\tCharacter font loading supported");
  if (vb.functabptr->flagsupp&8)  printf("\n\tDef pallete load enable/disable supported");
  if (vb.functabptr->flagsupp&16) printf("\n\tCursor emulation supported");
  if (vb.functabptr->flagsupp&32) printf("\n\tEGA pallette present");
  if (vb.functabptr->flagsupp&64) printf("\n\tColor pallette present");
  if (vb.functabptr->flagsupp&128) printf("\n\tColor paging supported");
  
  if (vb.functabptr->miscsupp&1)  printf("\n\tLight pen supported");
  if (vb.functabptr->miscsupp&2)  printf("\n\tSave/rest via fun 1Ch supported");
  if (vb.functabptr->miscsupp&4)  printf("\n\tIntensity/blink supported");
  if (vb.functabptr->miscsupp&8)  printf("\n\tDisplay Comb Code supported");
  
  if (vb.functabptr->flags2supp&1)   printf("\n\t512 char set supported");
  if (vb.functabptr->flags2supp&2)   printf("\n\tDynamic save area supported");
  if (vb.functabptr->flags2supp&4)   printf("\n\tAlpha font override supported");
  if (vb.functabptr->flags2supp&8)   printf("\n\tGraphics font override supported");
  if (vb.functabptr->flags2supp&16)  printf("\n\tPallette override supported");
  if (vb.functabptr->flags2supp&32)  printf("\n\tDCC extension supported");

}
