/* FONTSEL - Selects temporarily another DOS character font         */
/* Freeware version                                                 */
/* By Marcio Afonso Arimura Fialho                                  */
/* http://pessoal.iconet.com.br/jlfialho                            */
/* e-mail: jlfialho@iconet.com.br or (alternate) jlfialho@yahoo.com */
// ver 1.8

// To be able to recompile it, read COMPILE.TXT

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <crt.h>
#include <ctype.h>
#include <conio.h>

#define EGA 3 //EGA color video adapters
#define VGA 9 //VGA/SVGA+ color video adapters

#define VIDEOADAPTER VGA
	//if your adapter is EGA, replace VIDEOADAPTER

int changechar_rows=25;

char *errormsg="\nType\tFONTSEL /?\t for help\n";

void fontsel_errormsg (char *inp1, char *inp2, char *inp3)
 {
	printf ("\nERROR: Invalid value for %s. Expected => (/%s - /%s)%s",
	inp1,inp2,inp3,errormsg);
 }

int chrup(int chr) //upcases input letter
 {
	if (chr>0x60 && chr<0x7b)
		chr-=0x20;
	return chr;
 }

#include "asctoi.c"

int hextobin (int c) //converts an hexadecimal character to integer
 {
	c=chrup (c);
	if(c>='0' && c<='9')
		return c-'0';
	if(c>='A' && c<='F')
		return c-('A'-10);
	return -1; //error code
 }

#include "readname.c"

#include "ascii_f.c"

unsigned char *buffer;

void main (int n, char *ent[4])
 {
	int c0,c1; //counters
	int cm; //input argument counter
	int a0,a1; //auxiliar variables
	int flags=0;
	//description of bitfields when set:
		//bit  0 -> /I option -> selects negative of font
		//bit  1 -> Source font pathname has been given
		//bit  2 -> unused
		//bit  3 -> changes current character cell width to 8 or 9 pixels wide
		//bit  4 -> Displays selected character set at the end of the program
		//bit  5 -> Recalculates character cell height
		//bit  6 -> Selects a new video mode
		//bit  7 -> Must be set when the selected mode is a graphics mode
		//bit  8 -> Selects the number of screen lines
		//bit  9 -> Flips patterns horizontally
		//bit 10 -> Flips patterns verticall
		//bit 11 -> Selects block (font) specifier that controls the display of fonts
		//bit 12 -> Fills the screen with a color given by filcolor
		//bit 13 -> Sets color/attribute bit 7 as background intensity/blink enable bit, according to textblnk_cmd

	int textblnk_cmd;
	int boxwidth_cmd=0;
	int filcolor=7; //screen fill color
	int ascii_color=1;
	int newmode; //new video mode
	long src_offset=0; //start loading font from offset in font file
	int startpos=0; //index of the first character to be replaced
	int endpos=255; //index of the last character to be replaced
	int blkspec=0; //value for block specifier in call to crtfontspec
	FILE *source;
	int cont;
	char licos[128];
	char temp [128];
	unsigned char *aux;
	char c;

	printf ("FONTSEL ver 1.8 - DOS FONT SELECTOR - By Mrcio Afonso Arimura Fialho\n");
	if (n<2)
	 {
		printf (errormsg);
		return;
	 }

	changechar_height=16;

	for (cm=1;cm<n;cm++)
	 {
		if (*ent[cm]=='/')
		 {
			c=chrup(*(ent[cm]+1));
			switch (c)
			 {
				case 'I': flags|=0x0001; break;
				case '8': boxwidth_cmd=1;
				case '9': flags|=0x0008; break;
				case 'D': ascii_color=0;
				case 'A': flags|=0x0010; break;
				case 'R': flags|=0x0020; break;
				case 'M':
					flags|=0x0040;
					a0=strlen(ent[cm]);
					if (a0>2)
					 {
						if (asctoi(&newmode,ent[cm]+2,16))
							goto m_error;
						if (newmode&0xFF00) //if (unsigned)a1>256
							goto m_error;
					 }
					 else
					 {
					  m_error:
						fontsel_errormsg("mode","M0","MFF");
						return;
					 }
				 break;
				case 'G': flags|=0x0080; break;
				case 'L':
					flags|=0x0100;
					a0=strlen(ent[cm]);
					if (a0>2)
					 {
						if (asctoi(&changechar_rows,ent[cm]+2,10))
							goto l_error;
						if (changechar_rows&0xFF00)
							goto l_error;
					 }
					 else
					 {
					  l_error:
						printf ("\nERROR: Invalid number of scroll lines. Expected => (/L0 - /L255)%s",errormsg);
						return;
					 }
					break;
				case 'H':
					a0=strlen(ent[cm]);
					if (a0==2)
					 {
						printf ("\nWarning: Box height assumed to be 16 (default)");
						break;
					 }

					if (asctoi(&changechar_height,ent[cm]+2,10))
						goto h_error;
					if ((unsigned)changechar_height>32U)
						goto h_error;
					break;
				  h_error:
					fontsel_errormsg("box height","H0","H32");
					return;

				case 'O':
					a0=strlen(ent[cm]);
					if (a0==2)
					 {
						printf ("\nWarning: Offset assumed to be 0 (default).");
						break;
					 }
					for (c0=2;c0<a0;c0++)
					 {
						a1=*(ent[cm]+c0);
						if (a1<'0' || a1>'9')
							goto o_error;
						src_offset*=10L;
						src_offset+=(long)(a1-'0');
					 }
					for (c0=2;*(ent[cm]+c0)=='0' && *(ent[cm]+c0+1);c0++);
					ltoa(src_offset,temp,10);
					if(strcmp(temp,ent[cm]+c0)) //verifies if the conversion was sucessful (no overflow)
					 {
					  o_error:
						fontsel_errormsg("offset","O0","O2147483647");
						return;
					 }
				 break;
				case 'S':
					a0=strlen(ent[cm]);
					if (a0>2)
					 {
						if (asctoi(&startpos,ent[cm]+2,16))
							goto s_error;
						if (startpos&0xFF00)
							goto s_error;
					 }
					 else
					 {
					  s_error:
						fontsel_errormsg("the index of the first character to be loaded","S0","SFF");
						return;
					 }
				 break;
				case 'E':
					a0=strlen(ent[cm]);
					if (a0>2)
					 {
						if (asctoi(&endpos,ent[cm]+2,16))
							goto e_error;
						if (endpos&0xFF00)
							goto e_error;
					 }
					 else
					 {
					  e_error:
						fontsel_errormsg("the index of the last character to be loaded","E0","EFF");
						return;
					 }
				 break;
				case 'F':
					a0=chrup(*(ent[cm]+2));
					switch (a0)
					 {
						case 'H': flags|=0x0200; break;
						case 'V': flags|=0x0400; break;
						default:	goto unknow_op;
					 }
				 break;
				case 'C':
					flags|=0x0800;
					a0=strlen(ent[cm]);
					if (a0>2)
					 {
						if (asctoi(&blkspec,ent[cm]+2,16))
							goto c_error;
						if (blkspec&0xFF00)
							goto c_error;
					 }
					 else
					 {
					  c_error:
						fontsel_errormsg("the block specifier","C0","CFF");
						return;
					 }
				 break;
				case 'B':
					a0=strlen(ent[cm]);
					if (a0>2)
					 {
						if (asctoi(&changechar_blk,ent[cm]+2,16))
							goto b_error;
						if (changechar_blk&0xFF00)
							goto b_error;
					 }
					 else
					 {
					  b_error:
						fontsel_errormsg("the block to load font","B0","BFF");
						return;
					 }
				 break;

				case 'X':
					switch (chrup(*(ent[cm]+2)))
					 {
						case 'C':
							a1=strlen (ent[cm]);
							if (a1>2)
							 {
								if (asctoi(&filcolor,ent[cm]+3,16) )
									goto xc_error;
								if (filcolor&0xFF00)
									goto xc_error;
								flags|=0x1000;
							 }
							 else
							 {
								break; //option /XC is ignored if no complement is given
							  xc_error:
								fontsel_errormsg("screen fill color","XC0","XCFF");
								return;
							 }
						 break;
						case 'B':
							flags|=0x2000;
							switch (*(ent[cm]+3))
							 {
								case '0': textblnk_cmd=0; break;
								case '1': textblnk_cmd=1; break;
								default:
									goto unknow_op;
							 }
						 break;
						default: goto unknow_op;
					 }
				 break;

				hlp:
				case '?':
					printf ("\
 * * * FREEWARE VERSION - MAY BE DISTRIBUTED FREELY * * *\n\
Syntax: FONTSEL [option [option...]] <fontname[.fnt]> [option [option...]]\n\n\
fontname is the file containing the DOS-FONT in raw format (no control data)\n\
\t(default extension => .fnt)\n\
options:\n\
/I\t   => selects the negative of the font\n\
/8\t   => box width 8 (VGA/SVGA only)\n\
/9\t   => box width 9 (VGA/SVGA only)\n\
/A\t   => displays the font's character set with light colors\n\
/D\t   => displays the font's character set with dark colors\n\
/R\t * => recalculates the box height\n\
/M??\t   => selects a video mode (must be in hexadecimal notation)\n\
/G\t   => use when selecting a graphics mode\n\
/L???\t   => selects the number of scroll lines (valid => 0-255)\n\
/H???\t   => font character height (default=16 valid => 0-32)\n\
/O???...   => load font file from offset (default=0 valid => 0-2147483647)\n\
/S??\t * => first character to be loaded (valid => 0-FF (in hexadecimal))\n\
/E??\t * => last character to be loaded (valid => 0-FF (in hexadecimal))\n\
/FH\t   => Flips patterns Horizontally\n\
/FV\t   => Flips patterns Vertically\n\
/B??\t * => Block to load font patterns (valid => 0-FF (in hexadecimal))\n\
\t\t- - - Hit any key to continue - - -");
					getch ();
					printf("\n\n\
/C??\t * => Block (Font) specifier (controls the display of fonts\n\
\t      stored in video's RAM) (valid => 0-FF (in hexadecimal))\n\
/XC??\t * => Screen color in hexadecimal (valid => 0-FF)\n\
/XB0\t   => Set color bit 7 as background intensity bit\n\
/XB1\t   => Set color bit 7 as text blink enable bit\n\
/?\t   => this help screen\n\n\
\t\t * => disabled when option /G is selected\n\n\
\tFor further help, read README.1ST\n");
					return;
				unknow_op:
				default:
					printf ("\nERROR: Unknow option%s",errormsg);
					return;
			 }
		 }
		 else
		 {
			if (flags&0x0002)
			 {
				printf ("\nERROR: Unexpected char '%c' in command line%s",*(ent[cm]),errormsg);
				return;
			 }
			flags|=0x0002;
			readfname (licos,ent[cm],".FNT"); //appends extension .FNT in file
							  //name, if filename has no extension
		 }
	 }
	if (!(flags&0x0002))
	 {
		printf ("\nERROR: No font file supplied%s",errormsg);
		return;
	 }

	buffer=(unsigned char*)malloc(256*changechar_height);
	source=fopen (licos,"rb");
	if(source==NULL)
	 {
		printf ("\nERROR: FILE DOES NOT EXIST OR COULDN'T BE OPEN FOR READ%s",errormsg);
		fcloseall();
		return;
	 }

	fseek(source,src_offset,0);

	for (cont=0;cont<changechar_height*256;cont++)
	 {
		if (!(flags&0x0001))
			buffer[cont]=(unsigned char)fgetc (source);
		 else
			buffer[cont]=~(unsigned char)fgetc (source);
	 }
	fclose (source);

	if (flags&0x0200) //flips patterns horizontally
	 {
		aux=buffer;
		for (c0=0;c0<changechar_height*256;c0++,aux++)
			for (a1=1,c1=0;c1<4;c1++)
			 {
				if ((*aux)&a1)
					a0=1;
				 else
					a0=0;
				if ((*aux)&(0x80/a1))
					(*aux)|=a1;
				 else
					(*aux)&=~a1;
				if (a0)
					(*aux)|=(0x80/a1);
				 else
					(*aux)&=~(0x80/a1);
				a1*=2;
			 }
	 }

	if (flags&0x0400) //flips patterns vertically
	 {
		for (c1=0;c1<256;c1++)
		 {
			aux=buffer + c1 * changechar_height;
			for (c0=0;c0<(changechar_height/2);c0++)
			 {
				a0=*(aux+changechar_height-1-c0);
				*(aux+changechar_height-1-c0)=*(aux+c0);
				*(aux+c0)=a0;
			 }
		 }
	 }

	if (flags&0x0020)
	 {
		setcrtmode (3);
		changechar_func=CHANGCHR_RECALC;
	 }

	if (flags&0x0040)
	 {
		setcrtmode (newmode);
		crt_detect (VIDEOADAPTER);
	 }

	if (!(flags&0x0080))
	 {
		if (startpos>endpos)
		 {
			printf ("\nERROR: First character to be loaded index is greater than\
 last character to be\nloaded index.%s",errormsg);
		 }
		changechar (buffer,startpos,(endpos-startpos)+1);
	 }
	 else
	 {
		crt_direct=1;
		if (!(flags&0x0100))
			changechar_rows=vmode_y;
		goto jmp_100h;
	 }

	if (flags&0x0100)
	  jmp_100h:
		changecharg(buffer,changechar_rows);

	if (flags&0x0008)
		setchrboxwidth(boxwidth_cmd);

	if (flags&0x0800)
		crtfontspec(blkspec);

	if (flags&0x1000 && !(flags&0x0090))
	 {
		crt_detect(VIDEOADAPTER);
		fillscr(' ',filcolor);
	 }

	if (flags&0x0010)
		ascii_f (filcolor,ascii_color);

	if (flags&0x2000)
		settextblink(textblnk_cmd);

	free(buffer);
 }
//0123456789