'GPRNT100.BAS
'
'Graphical print 1.00 -- written by Lloyd Chang
'
'required: VGA (Video Graphics Adapter)
'
'purpose: Prints 5 by 5 characters created by Charm in SCREEN 13
'         There can be up to 64 characters across and
'         40 characters down.
'         It's better than the standard 8 by 8 character set
'         which allows only 40 characters across and
'         25 characters down.
'
'global variables used: CursorX% = Horizontal position of the cursor
'                                  valid range (0 to 63)
'                       CursorY% = Vertical positon of the cursor
'                                  valid range (0 to 39)
'                       CurrentColour% = Current color number
'                                        valid range (0 to 255)
'
'note: To print a carriage return (ENTER KEY), type GPRINT ""
'
'files that should accompany this program: 5X5CHARS.MAP
'                                          CHARM100.BAS
'                                          FILE_ID.DIZ
'                                          INDEX.TXT
'
DECLARE SUB LoadCharSet ()
DECLARE SUB COLOUR (Dummy%)
DECLARE SUB GPRINT (Dummy$)
DEFINT A-Z
COMMON SHARED CursorX%, CursorY%, CurrentColour%
DIM SHARED CharSet(0 TO 255, 1 TO 5, 1 TO 5) AS INTEGER
LoadCharSet 'Loads the 5x5 character set
SCREEN 13 'Initializes screen 13
COLOUR 15 'Sets current color to color number 15
GPRINT "Testing..." 'Prints the phrase "Testing..."
GPRINT "" 'Prints a carriage return
COLOUR 7
GPRINT "This should on the line under " + CHR$(34) + "Testing..." + CHR$(34)

DEFSNG A-Z
SUB COLOUR (Dummy%)
SELECT CASE Dummy%
  CASE IS > 255
    Dummy% = 255
  CASE IS < 0
    Dummy% = 0
END SELECT
CurrentColour% = Dummy%
END SUB

DEFINT A-Z
SUB GPRINT (Dummy$)
SELECT CASE LEN(Dummy$)
  CASE IS = 0
    CursorX% = 0
    CursorY% = CursorY% + 1
    SELECT CASE CursorY%
      CASE IS < 0
        CursorY% = 0
      CASE IS > 39
        CursorX% = 63
        CursorY% = 39
    END SELECT
  CASE ELSE
    SELECT CASE CursorX%
      CASE IS < 0
        CursorX% = 0
      CASE IS > 63
        CursorX% = 63
    END SELECT
    SELECT CASE CursorY%
      CASE IS < 0
        CursorY% = 0
      CASE IS > 39
        CursorY% = 39
    END SELECT
    Count% = 1
    DO
      Parse$ = MID$(Dummy$, Count%, 1)
      Count% = Count% + 1
      FOR CountY% = 1 TO 5
        FOR CountX% = 1 TO 5
          SELECT CASE CharSet(ASC(Parse$), CountY%, CountX%)
            CASE IS = 1
              PSET ((CursorX% * 5) + (CountX% - 1), (CursorY% * 5) + (CountY% - 1)), CurrentColour%
          END SELECT
      NEXT CountX%, CountY%
      CursorX% = CursorX% + 1
      SELECT CASE CursorX%
        CASE IS > 63
          CursorX% = 0
          CursorY% = CursorY% + 1
      END SELECT
      SELECT CASE CursorY%
        CASE IS > 39
          CursorX% = 63
          CursorY% = 39
      END SELECT
    LOOP UNTIL Count% > LEN(Dummy$)
END SELECT
END SUB

DEFSNG A-Z
SUB LoadCharSet
CharacterSet$ = SPACE$(5 * 5 * 256)
FFile% = FREEFILE
OPEN "5x5Chars.Map" FOR BINARY AS FFile%
GET #FFile%, , CharacterSet$
CLOSE #FFile%
FOR CountC% = 0 TO 255
  FOR CountY% = 1 TO 5
    FOR CountX% = 1 TO 5
      CharSet(CountC%, CountY%, CountX%) = ASC(MID$(CharacterSet$, ((CountC% * 25) + ((CountY% - 1) * 5) + CountX%), 1))
NEXT CountX%, CountY%, CountC%
END SUB

