'CHARM100.BAS
'
'Character mapper 1.00 -- written by Lloyd Chang
'
'recommended: Having ansi.sys loaded into memory
'             VGA (Video Graphics Adapter)
'
'note: If a left arrow and the string [1;32;40m appears,
'      it is because ansi.sys was not loaded into memory.
'
'required: EGA (Enhanced Graphics Adapter)
' 
'to do: save in binary (to save space) instead of hexdecimal
'
'purpose: Charm (sounds cheezy) is a character mapper.
'         It currently lets the user edit a 5 pixel by 5 pixel
'         character set.  The character set is saved into the
'         file 5x5chars.map when the user presses [Q] or [q].
'         The programs LCHARSET.BAS, COLOUR.BAS, and GPRINT.BAS
'         are sub-routines that lets the user print 5x5 characters
'         in SCREEN 13.
'
'lingo: nul = null (a dummy character containing nothing)
'       bel = bell ("BEEP" for the PC speaker)
'       tab = tab (typically represents eight space characters)
'        lf = line feed (designating the end of a line)
'        cr = carriage return (represents the [ENTER] key)
'        ff = the hexdecimal equivalent of the decimal number 255
'
'files that should accompany this program: 5X5CHARS.MAP
'                                          FILE_ID.DIZ
'                                          GPRNT100.BAS
'                                          INDEX.TXT
'
DECLARE SUB LoadCharSet ()
DEFINT A-Z
DIM SHARED CharSet(0 TO 255, 1 TO 5, 1 TO 5) AS INTEGER
SCREEN 7
OPEN "CONS:" FOR OUTPUT AS #1
OPEN "5x5chars.map" FOR BINARY AS #2
LoadCharSet
CharSetX% = 1
CharSetY% = 1
COLOR 6
LOCATE 10, 1
PRINT "Keys are [UP], [RIGHT], [DOWN], [LEFT],"
PRINT "         [+], [-], [ENTER], [Q], [q]"
PRINT
COLOR 7
PRINT "Do not press ctrl-break while you are in"
PRINT "the QuickBASIC programming environment!!"
PRINT
COLOR 9
PRINT "charm 1.00"
COLOR 8
LOCATE 17, 1
FOR Count% = 0 TO 255
  SELECT CASE Count%
    CASE 1 TO 6, 8, 14 TO 27, 32 TO 255
      PRINT CHR$(Count%);
    CASE 11, 12
      PRINT #1, CHR$(Count%) + "  ";
    CASE ELSE
      PRINT CHR$(32);
  END SELECT
NEXT Count%
COLOR 5
LOCATE 25, 1
PRINT "X:";
COLOR 4
LOCATE 25, 7
PRINT "Y:";
DO
  GOSUB Display
  GOSUB ReadKey
LOOP

Display:
FOR CountY% = 1 TO 5
  FOR CountX% = 1 TO 5
    SELECT CASE CharSetY%
      CASE IS = CountY%
        SELECT CASE CharSetX%
          CASE IS = CountX%
            COLOR 11
            LOCATE CountY%, 7
            PRINT RIGHT$(STR$(CountY%), LEN(STR$(CountY%)) - 1);
            LOCATE 7, CountX%
            PRINT RIGHT$(STR$(CountX%), LEN(STR$(CountX%)) - 1);
        END SELECT
      CASE ELSE
        SELECT CASE CharSetX%
          CASE IS <> CountX%
            COLOR 3
            LOCATE CountY%, 7
            PRINT RIGHT$(STR$(CountY%), LEN(STR$(CountY%)) - 1);
            LOCATE 7, CountX%
            PRINT RIGHT$(STR$(CountX%), LEN(STR$(CountX%)) - 1);
        END SELECT
    END SELECT
NEXT CountX%, CountY%
COLOR 2
LOCATE 25, 13
PRINT RIGHT$(STR$(Char%), LEN(STR$(Char%)) - 1) + ": ";
COLOR 10
SELECT CASE Char%
  CASE 1 TO 6, 8, 14 TO 27, 32 TO 254
    PRINT CHR$(Char%) + SPACE$(10);
  CASE 0
    PRINT "nul" + SPACE$(8);
  CASE 7
    PRINT "bel" + SPACE$(8);
  CASE 9
    PRINT "tab" + SPACE$(8);
  CASE 10
    PRINT "lf" + SPACE$(9);
  CASE 11, 12, 28, 29, 30, 31
    PRINT #1, CHR$(27) + "[1;32;40m" + CHR$(Char%) + "  ";
  CASE 13
    PRINT "cr" + SPACE$(9);
  CASE 255
    PRINT "ff ";
END SELECT
COLOR 13
LOCATE 25, 3
PRINT RIGHT$(STR$(CharSetX%), LEN(STR$(CharSetX%)) - 1);
COLOR 12
LOCATE 25, 9
PRINT RIGHT$(STR$(CharSetY%), LEN(STR$(CharSetY%)) - 1);
FOR CountY% = 1 TO 5
FOR CountX% = 1 TO 5
PSET (84 + CountX%, 21 + CountY%), CharSet(Char%, CountY%, CountX%)
PSET (94 + (CountX% * 3), 19 + (CountY% * 3)), CharSet(Char%, CountY%, CountX%)
PSET (94 + (CountX% * 3) + 1, 19 + (CountY% * 3)), CharSet(Char%, CountY%, CountX%)
PSET (94 + (CountX% * 3) + 2, 19 + (CountY% * 3)), CharSet(Char%, CountY%, CountX%)
PSET (94 + (CountX% * 3), 19 + (CountY% * 3) + 1), CharSet(Char%, CountY%, CountX%)
PSET (94 + (CountX% * 3) + 1, 19 + (CountY% * 3) + 1), CharSet(Char%, CountY%, CountX%)
PSET (94 + (CountX% * 3) + 2, 19 + (CountY% * 3) + 1), CharSet(Char%, CountY%, CountX%)
PSET (94 + (CountX% * 3), 19 + (CountY% * 3) + 2), CharSet(Char%, CountY%, CountX%)
PSET (94 + (CountX% * 3) + 1, 19 + (CountY% * 3) + 2), CharSet(Char%, CountY%, CountX%)
PSET (94 + (CountX% * 3) + 2, 19 + (CountY% * 3) + 2), CharSet(Char%, CountY%, CountX%)
COLOR 1
SELECT CASE CharSet(Char%, CountY%, CountX%)
  CASE 0
    LOCATE CountY%, CountX%
    PRINT CHR$(32);
  CASE 1
    LOCATE CountY%, CountX%
    PRINT CHR$(219);
END SELECT
NEXT CountX%, CountY%
RETURN

ReadKey:
  KEYIN$ = INKEY$
  SELECT CASE KEYIN$
    CASE CHR$(0) + CHR$(&H48)
      SELECT CASE CharSetY%
        CASE IS > 1
          CharSetY% = CharSetY% - 1
      END SELECT
    CASE CHR$(0) + CHR$(&H4D)
      SELECT CASE CharSetX%
        CASE IS < 5
          CharSetX% = CharSetX% + 1
      END SELECT
    CASE CHR$(0) + CHR$(&H50)
      SELECT CASE CharSetY%
        CASE IS < 5
          CharSetY% = CharSetY% + 1
      END SELECT
    CASE CHR$(0) + CHR$(&H4B)
      SELECT CASE CharSetX%
        CASE IS > 1
          CharSetX% = CharSetX% - 1
      END SELECT
    CASE CHR$(13)
      CharSet(Char%, CharSetY%, CharSetX%) = ABS(CharSet(Char%, CharSetY%, CharSetX%) - 1)
    CASE "+"
      SELECT CASE Char%
        CASE IS < 255
          Char% = Char% + 1
      END SELECT
    CASE "-"
      SELECT CASE Char%
        CASE IS > 0
          Char% = Char% - 1
      END SELECT
    CASE "Q", "q"
      LOCATE 25, 1
      PRINT "Saving" + SPACE$(34);
      LOCATE , 7
      FOR CountC& = 0 TO 255
        SELECT CASE (CountC& + 1) MOD 8
          CASE 0
          PRINT ".";
        END SELECT
        FOR CountY& = 1 TO 5
          FOR CountX& = 1 TO 5
            BYTE$ = CHR$(CharSet(CountC&, CountY&, CountX&))
            PUT #2, ((CountC& * 25) + ((CountY& - 1) * 5) + CountX&), BYTE$
      NEXT CountX&, CountY&, CountC&
      CLOSE 1, 2
      END
  END SELECT
RETURN

SUB LoadCharSet
CharacterSet$ = SPACE$(5 * 5 * 256)
FFile% = FREEFILE
OPEN "5x5Chars.Map" FOR BINARY AS FFile%
GET #FFile%, , CharacterSet$
CLOSE #FFile%
FOR CountC% = 0 TO 255
  FOR CountY% = 1 TO 5
    FOR CountX% = 1 TO 5
      CharSet%(CountC%, CountY%, CountX%) = ASC(MID$(CharacterSet$, ((CountC% * 25) + ((CountY% - 1) * 5) + CountX%), 1))
NEXT CountX%, CountY%, CountC%
END SUB

