   WaverlyStreet QuickRef Project Assistant (tm) version 3.01 User's Manual
-----------------------------------------------------------------------------
Topics:

1)     What can I expect to get out of QuickRef?
2)     In a nutshell...
3)     What do I have to put into using QuickRef?
4)     Setup options
5)     Adding projects
6)     Single project screen
7)     Switch between time and money modes
8)     Add records - edit / delete records
9)     "To-Do" items
10)    Using Budgets
11)    Keeping notes
12)    The Macro utility, and cutting and pasting between projects
13)    Reports
14)    Big reports (from multiple QuickRef users on a network)
15)    Purge older records from a project
16)    Closing out a finished project
17)    Viewing your archived records
18)    Completely removing a project
19)    Project list
20)    The file browser, and text editors
21)    Network notes
22)    Planning for network use (IMPORTANT!)
23)    Installation, and "What the heck are all those files?"
24)    Limitations
25)    Utility programs

(If you have not already done so, you may want to print this manual on paper.
         Press "P" if viewing it from the QuickRef help utility.)

-----------------------------------------------------------------------------
1)  What can I expect to get out of QuickRef?
-----------------------------------------------------------------------------
Fast, accurate, easy reports about the time and money you have invested in
your work; both long-term, and things you've done just recently.

Quick access to your notes concerning whatever you have going on, and handy
reminders about things you have to do.

-----------------------------------------------------------------------------
2)  In a nutshell...
-----------------------------------------------------------------------------
QuickRef keeps short (quick) line item records of time and money expenditures
grouped by projects (or categories, or tasks, or clients... or whatever name
you use to think of groups of activity).

These line items include a date and a short note field. Reports can be
generated for selected projects, selected dates. Single line items can be
found in thousands of others by searching for key words or numbers.

Special line items that serve as reminders ("to-do" items) may be inserted in
with both the time and money records so that you cannot forget to do important
things.

A free-form text "journal" or record file may be kept, linked to each specific
project.

With version 3, you may also establish a budget figure for each project, and
QuickRef will instantly tell you how you are doing in relation to the budget
on one or a group of projects.

To install the program, please use one of the included installation
utilities, SETUP.EXE (for Windows) or DOS_INST.EXE (for DOS). These will
create the directories and install the files needed for the basic operation of
the program.

If you are installing version 3 to replace an earlier version, you must read
UPGRADE.TXT carefully and follow all the instructions!

-----------------------------------------------------------------------------
3)  What do I have to put into using QuickRef?
-----------------------------------------------------------------------------
Well... all the raw information. Unfortunately, there's no around that!

However, QuickRef has been designed from the ground up with quick and easy
data entry as the primary goal. It is based on the premise that it must be
quick to use, otherwise it won't get used at all. From DOS, you can start
QuickRef, make a couple of entries, and get back out in a just few seconds.
Run it in the background in Windows or some other multi-task environment
(recommended) and it's even quicker.

-----------------------------------------------------------------------------
4)  Setup Options
-----------------------------------------------------------------------------
When you first start QuickRef, please go into the setup area by pressing F10
at the main screen. You will find the following options:

User Name        : Change this to either your or your company name

User Initials    : Enter your initials here (don't leave blank!)

Passcode         : optional

Track time cost  : If set to "Y" then QuickRef will calculate the cost of
                   time, based on worker rates (pay rates) and include this
                   cost in report data. Note: to use this feature, you must
                   build a "worker" database.

Sub Divisions    : Both time and money records may be tagged with a
                   sub-division label. You may have up to nine divisions for
                   each. Toggle through the four options available.

Screen Colors    : Hey, have fun!

Current Data Path: Directory where records on current projects will be kept.
                   The default is C:\QUICKREF\CURRENT\
                   Caution! Do not share a network data path with someone
                   else unless it will NEVER be the case that you are both in
                   the program at the same time! (It may seem to work OK, but
                   eventual file corruption is inevitable.)

Archive Data Path: Directory where records on closed projects will be kept.
                   The default is C:\QUICKREF\ARCHIVE\
                   Again, don't share a network directory!

Current Mirror   : (optional) For network use - enter in a DOS file path where
                   you want to "mirror" your current records, so that other
                   users on your office LAN may look at them. Must be in the
                   format: [Mirror Parent]\[user initials]\CURRENT\

Archive Mirror   : (optional) For network use - a mirror of your archives.
                   Must be in the format:
                   [Mirror Parent]\[user initials]\ARCHIVE\

Mirror Parent    : (optional) The parent directory of all QuickRef user's
                   mirror directories. Required for the "Big Report"
                   multiple-user reporting function.

(Please see sections 21, 22, & 23 of this manual for additional information on
installation and network usage.)

Lines per page   : The number of lines you want for your printer to print
                   before starting a new page.

Date format      : Select MM-DD-YYYY or DD-MM-YYYY

word for PROJECT : Although QuickRef is called a "project management" program,
                   you might want to use it for something where the word
                   "project" just doesn't quite "seem right". Well, change it!
                   For example, if you are tracking time spent with clients,
                   change "Project" to "Client". This re-definition carries
                   through in all program functions, reports, etc.

word for STATUS  : (see above) Maybe "Type" or "Region"...

word for LOCATION: (see above) Maybe "Dept." or "Store" or "Bldg.", etc...

money character  : Default is US dollar sign ($). Change to anything you want.

Print this configuration information

                   Print your configuration on paper. This is handy when you
                   are setting up multiple users and want to make sure you are
                   consistent with directory names, etc.

-----------------------------------------------------------------------------
5)  Adding Projects
-----------------------------------------------------------------------------
Press the right arrow key, then <INSERT>. Add a name, then a project number.
Duplicate numbers not allowed.

-----------------------------------------------------------------------------
6)  Single project screen
-----------------------------------------------------------------------------
When the program first starts, records for ALL projects are shown. To narrow
your view to only those records for a particular project, press the right
arrow, then point to and select a project. The "header" information for that
project is shown at the top of the screen. Press <F3> to change it. Note that
the budget field only appears on screen if the budget amount is not zero.

-----------------------------------------------------------------------------
7)  Switch between TIME and MONEY modes
-----------------------------------------------------------------------------
Press <F8> at either the main screen or the single project screen to toggle
between modes. Note the indicator in the bottom right corner of the screen.

-----------------------------------------------------------------------------
8)  Add Records - edit / delete records
-----------------------------------------------------------------------------
Make sure you are in the mode (TIME/MONEY) that you want.

From main screen, press <INSERT>, then select a project. From single project
screen, just press <INSERT>. Press <ENTER> to accept current date, or type in
a new one. (Note - if record is for the current year, then you only need enter
the month and the day and press <ENTER>. If for another year, you must type in
the entire four-digit number - ie: 1997). When correct date is shown, press
<ENTER>. Type in a numeric value to indicate either hours or money, and press
<ENTER>. Indicate whether the amount is actual or an estimate. Type in a note,
or use the up and down arrow keys to scroll through past notes. When the note
is as you want it, press <ENTER>. Finally, confirm the new entry.

To either edit or delete a record, pick it from the screen by pointing to it
and pressing <ENTER>.

-----------------------------------------------------------------------------
9)  "To-Do" items
-----------------------------------------------------------------------------
If, when making a new entry, you leave the amount field blank (either time or
money), then the entry will appear as a reminder. These will be printed as
"to-do" items on "Snapshot" reports.

-----------------------------------------------------------------------------
10) Using Budgets (new feature - version 3.0)
-----------------------------------------------------------------------------
If desired, projects may have a budget figure attached to them. To do this,
press F3 at the single project screen, to edit the "header" information. Point
to "budget", press ENTER, type in a figure, and press ENTER once again. Once
you save the revised header, you will see the budget amount displayed at the
top of the screen.

Now when you do a snapshot report, the total of actual and estimated money
records, and the cost of time (if you are using that feature) will be compared
to the budget, and you will be shown how much over or under budget you are
(both in real terms and as a percentage).

Comparison reports handle budgets a bit differently. Select projects for the
report as before. When prompted to "Exclude projects without budgets (y/N)",
press "Y". Since it would be meaningless to mix projects with budgets with
ones that don't have budgets, this option then automatically excludes any
project with no budget (even if you selected it before). The report tells you
how the selected projects, as a group, compare to their combined budgets.

One important point: if a project with a budget is canceled, and you file it
away in the archives as "dead", be sure to clear the budget field (re-set it
to zero). Otherwise, future comparison reports will be distorted by having a
combined budget figure inflated by "dead" project budgets!

-----------------------------------------------------------------------------
11) Keeping notes
-----------------------------------------------------------------------------
One of the most useful things QuickRef does is allow keeping a note file
attached to each project.

To view and/or work on your notes, press <F9> at the single project screen. If
the file browser cannot find a note file it will offer to create one. The new
note file will consist of the project number, project name, user name, and the
note file's DOS path and file name.

Use the import utility to place standard "boiler plate" (checklists, forms,
etc.) at the beginning of new note files. Just press <I> while in the browser,
then type a file name. If the file to be imported is NOT located in the
QUICKREF directory, you need to type the full DOS path to the file too. (The
file STANDARD.FRM is the default import file name).

Press <S> to have the browser search the current file for a single word.

To edit your notes, press <E> while in the browser, to start your own external
text editor (see below).

Note files can be included in "Snapshot" reports or printed on their own.

-----------------------------------------------------------------------------
12) The Macro utility, and cutting and pasting records between projects
-----------------------------------------------------------------------------
QuickRef has a couple of functions that allow quick automatic insertion of
multiple records into a given project; the Macro utility, and cut & paste.

You may have the program automatically insert pre-defined sets of records by
creating and playing back Macro Files. To run the macro utility, press <F3> at
the main screen. Select "Make a new Macro" and press <ENTER>. Your external
text editor should start, and display a template macro file called (oddly
enough), "TEMPLATE.MCR". Please print out the template file and study it.

Macros are great when you regularly do projects that are more or less the same
each time around. Put in all the "to-do" items and money items that are
required, and you will remember to do everything, over and over again!

Things to keep in mind about macro records: 1) Records inserted by macro are
always labeled as "estimates" - you have to manually change the label to
"actual". 2) They do not have any worker or subdivision identification built
in; again, you have to do that manually by editing the record after it is
inserted.

You may create as many macro files as you wish, and they may contain as many
line items and TIME/MONEY mode changes as you wish. If you are only going to
use one macro, or if you use one a lot more often than others, name it
"STANDARD.MCR" to avoid having to type a filename each time.

Another way to insert multiple records is to cut (copy) them from one project
and then paste them into another. To do this, go to the single project screen
for the project from which you want to COPY. Press <F5>, and all records for
the mode (TIME/MONEY) currently displayed will be placed into a buffer. Now go
to the single project screen for the project to which you wish to PASTE. Press
<F7>, and then <ENTER> to paste the contents of the buffer to the project
currently displayed. You may cut from any data set; your current or archive,
and also from anyone's network mirror, current or archive. If you are tracking
time costs, and/or are using subdivisions, and are cutting records from
someone else's mirror, be aware that the pasted records will contain the
worker identification and subdivision tags from the ORIGINALS, which may or
may not be the same as your own local worker and subdivision data (see section
on planning for network use).

-----------------------------------------------------------------------------
13) Reports
-----------------------------------------------------------------------------
QuickRef creates two basic report types, "Snapshot" reports on single
projects, and larger reports that combine projects and compare them to each
other. In either case, note that you may edit the report before printing it.
You may create reports from either your own data, another person's data that
has been placed in a network mirror directory, or archived records on closed
projects.

To generate a "Snapshot", you need to be at a single project screen. Press
<F4>, and answer the prompts that follow.

To generate comparison reports, you must be at the main screen. Press <F4>.
Press <A> to select all projects, <S> to select only certain projects. If you
chose to select projects, there are more choices to be made:

     Press <W> to select by word. What this does is prompt you for a word, and
     then it searches all the project header information to find it. When a
     match is found, the header is displayed, and you must confirm whether or
     not to include it.

     Press <N> to search by project number. A string of eight stars are
     displayed, which you may edit to look for project numbers that match. For
     example, suppose your numbering system uses a single letter code in the
     third place to identify various types of projects, and you wish to have a
     report on projects of type "t". Change the line of stars to look like
     this -> **t***** and press <ENTER>.

     Finally, you may also simply pick projects from the main list one at a
     time. Press <O> to do this. Scroll through the projects and press <ENTER>
     to select.

     Whichever search method is employed, you are shown a list of selected
     projects. If you wish to add more, press <INSERT>. If you wish to remove
     one, point to it and press <ENTER>. When the list is as you want it,
     press <ESC> to continue.

Once you have selected projects, you must specify a range of dates to include.
Again, press <A> to select all dates, <S> to specify dates. Pressing <T> will
create a special quick "report" that includes nothing but "to-do" items.

Next, indicate summary or full report. Full reports include all time and money
line items (and so can get to be rather long).

There are a few more prompts (depending on whether or not you are tracking
time cost), and then the report is displayed on screen.

-----------------------------------------------------------------------------
14) Big Reports (from multiple QuickRef users on a network)
-----------------------------------------------------------------------------
If you are set up on an office network, you may create "Big Reports" that
include records from any number of users. Press <B> at the main screen, then
<Y> to confirm your choice.

The Big Report data is placed in a temporary directory of your choosing, the
default being C:\. (If you have a large RAM drive set up, use that.)

Next, type the initials of the first user to be included. The _first_ user is
quite significant - their header information takes precedence over subsequent
users when more than one user has records for the same project number.

Now specify the next user's initials. The data and header files from the two
network mirrors are combined. When you are finished adding users, you are
returned to the main screen.

The composite data files can be viewed and used for reporting just like your
normal LOCAL ARCHIVE data set. Actually, as you leave the Big Report screen,
your default LOCAL ARCHIVE path is temporarily changed to be the same as the
temporary directory you specified, so you can quickly get there by pressing
<A> then <ENTER>.

Note that if you are trying to track time costs, your worker data file must
contain entries for everyone whose records are contained in the composite
data.

-----------------------------------------------------------------------------
15) Purge older records from a project
-----------------------------------------------------------------------------
Some projects go on forever (or a long time anyway), and the resultant
accumulation of old records can slow down program operation. So from time to
time you may wish to transfer records older than a certain date from the
current data to the archive data.

At the single project screen, press F10 to purge. Supply a cut-off date, and
follow the other prompts. Only the line item records for the current mode
(time/money) are transferred; not line items from the other mode (time/money).
Project notes may optionally be purged too.

-----------------------------------------------------------------------------
16) Closing out a finished project
-----------------------------------------------------------------------------
Once a project is finished, you will want to transfer it's records from your
current data area to the archive area. First of all, make sure that you have
created an archive directory, and that you have correctly specified it in
SETUP.

To close out a project: Activate the project selection box (right arrow at the
main screen). Press <DEL>. Point to the project you wish to close and press
<ENTER>. Answer the prompts, and it's done. Verify that the records are being
transferred correctly by pressing "A" back at the main screen, to view your
archive directory.

-----------------------------------------------------------------------------
17) Viewing your archive records
-----------------------------------------------------------------------------
Press <A> at the main screen to switch to your archive directory. The program
title and directory listing on the bottom of the screen will change to the
"warning box" colors, to remind you that you are not in your usual files.

Press <A> again (or the left arrow key) to return to your current data.

-----------------------------------------------------------------------------
18) Completely removing a project
-----------------------------------------------------------------------------
In order to completely remove a project's records from the system, it must
first have been transferred to the archive directory. Change to the archive
directory (<A> at the main screen...), and proceed as if you were closing the
project out. This time, however, the project is completely removed!

Print a report first! THIS IS YOUR LAST CHANCE!!!!!

Note: unless a project is a mistake or a "test" project, don't remove it. Huge
archive files do not hinder normal program operation.

-----------------------------------------------------------------------------
19) Project list
-----------------------------------------------------------------------------
Print a quick list of all your projects by pressing <P> when the "Select
Projects" window is "on".

-----------------------------------------------------------------------------
20) The FILE BROWSER & text editors
-----------------------------------------------------------------------------
All reports and project note files are initially sent to a built-in viewer,
for on-screen preview. All viewer control options are shown at the bottom of
the screen. The viewer is capable of displaying huge files (in excess of
32,000 lines in length) with great speed. If you are not satisfied with the
viewer's print output, print to a file instead, and then read that into your
favorite word processor. (Set the word processor margins to handle 78
columns (very wide)).

QuickRef does not include it's own text editor. To edit files, the viewer
shells out to an external editor of your choosing. Specify the text editor on
the DOS command line, or in your Windows program item, properties, command
line space, in this format:

     QR [name of editor's executable file]

     (Note the space between QR and the editor name.)

Any DOS text editor that will accept a file name to open on the command line
should work (depending on available memory). An excellent editor for the
purpose is READ by WellsCom. READ can be found at all the major software
archives and on all the major shareware CDs, generally in the DOS editor or
text directory. READ uses very little memory, has a number of nice "word
processor-like" features, and can handle very large files. If no editor is
specified on the command line, QuickRef will attempt to use EDIT. (EDIT works,
but READ is vastly superior.) One other point - the editor needs to be either
in the same directory as Quickref, or in the PATH.

-----------------------------------------------------------------------------
21) Network notes
-----------------------------------------------------------------------------
Although QuickRef is designed to operate stand-alone, it includes provisions
for sharing data with other users on a LAN. (See the end of this manual for
suggested network directory structure.) Other users may view, but not change
each other's records.

To update you own network data "mirror", press <M> at the main screen, to run
the Mirror Update utility. This simply copies all your data to the network
directories you specify in setup. ("Laptop" users might specify a floppy drive
for this, then copy the files from the disk to the server, or upload the files
via modem.)

To look at someone else's data, press <L> at the main screen. Change the
directory shown to the one you are after, and press <ENTER>. The program title
and directory listing on the bottom of the screen will change to the "warning
box" colors, to remind you that you are not in your usual files. You can
browse and generate reports just as if you were in your own data, but all data
entry and editing functions are locked out.

Note that if you wish to view time costs, your worker data file must contain
entries for everyone whose data is in the mirror directory you are viewing.

Press <L> (or <ESC> or left arrow) again to return to your normal data
directory.

-----------------------------------------------------------------------------
22) Planning for network use   (IMPORTANT!)
-----------------------------------------------------------------------------
In order to get the most out of QuickRef as a GROUP application, a certain
amount of up-front planning is required. This section outlines the important
things that need to be standardized, and offers some hints on effective group
use.

USER INITIALS

Make sure everyone has filled in their initials in SETUP. Each time and money
record contains the initials. Without the initials, it is impossible to track
the cost of time, or to do a time breakdown per worker. And even though an
individual may not be tracking time costs, an administrator doing a
department-wide "Big Report" might want to look at the activities of a single
person, or do a breakdown by worker. As long as all users are set up
correctly, with their initials in place, this can be done.

Time and Money SUBDIVISIONS

Everyone has to be using the same subdivision tags if "Big Report" breakdowns
are going to make sense and be accurate. The NAMES that individuals use for
subdivisions don't matter, but the ORDER in which they are listed DOES matter.
In other words, you must decide up front (as a group) that say, money division
#1 is going to be used for miscellaneous expenses. User "A" might like to call
this "misc. stuff", user "B" might call it "other expense". As long as both
users have this at money subdivision tag #1, all will be well when a "Big
Report" is made with combined data from "A" and "B".

At installation/setup time, give a lot of thought to exactly what it is you
wish to track with the subdivisions, and then stick to the plan from that day
forward.

DATE FORMAT

Everyone must use the same date format. Mixed date formats in "Big Reports"
will result in a lot of useless gibberish! (Note: a separate command-line
conversion utility is available to change sets of records from one format to
another. See section 25 of this manual.)

USE "MY_NOTES.TXT"

Pressing <N> at the main screen displays a file called "MY_NOTES.TXT". Use
this as a custom-made help screen, specific to your installation. Outline
macro file names and descriptions, note file "boiler plate" file names, and
whatever other information your users need to help them use the program and
work together.

SHARE THINGS WITH EACH OTHER

In particular, macro files, subdivision files, record file "boiler plate" and
the "MY_NOTES.TXT" file. These things are all contained in the local QUICKREF
directories on each user's computer. You can save a lot of duplicate effort,
and ensure consistency by creating these once and then copying them to each
user's machine.

You might make a make a batch file to do this called "QRUPDATE.BAT" that
copies whatever you want from the network parent directory to C:\QUICKREF.
Place "QRUPDATE.BAT" in each user's QUICKREF directory. Each user can run
QRUPDATE.BAT on their own whenever they want. The system administrator can
then maintain common macros, subdivisions, etc., and simply tell the other
users to update whenever appropriate.

Sample QRUPDATE.BAT:     copy f:\qrm\*.sdv c:\quickref
                         copy f:\qrm\*.mcr c:\quickref
                         copy f:\qrm\my_notes.txt c:\quickref

-----------------------------------------------------------------------------
23) Installation, and "What the heck are all those files?"
-----------------------------------------------------------------------------
The included installation utilities will create the suggested default
directories outlined below for you. Please use one of them. However, if you
don't like using installation programs, or if the installer fails for some
reason, the following will be useful:

It is recommended that the program distribution files be placed in a directory
called C:\QUICKREF (for illustration purposes, let's assume drive C:)

Subdirectories called C:\QUICKREF\CURRENT (for current data), and
C:\QUICKREF\ARCHIVE (for archives) MUST be present. (With version 2.0 and on,
the words "CURRENT" and "ARCHIVE" MUST be used!, unlike with previous
versions.)

So, here is what that might look like, including files:

Directory of C:\QUICKREF

.            <DIR>
..           <DIR>
CURRENT      <DIR>    (current data directory)
ARCHIVE      <DIR>    (archive data directory)
QRM          <DIR>    (default, LOCAL mirror parent directory)
QR       EXE          (the program)
VBDRT10  EXE          (required run-time module)
STATION  INI          (program creates this - contains SETUP information)
QUICKREF TXT          (the "about" file called at the help screen)
TEMPLATE MCR          (macro file template with instructions)
QUICKREF MAN          (this file - called from help screen)
MY_NOTES TXT          (user's own help file - called from help screen)
STANDARD MCR          (sample/default macro file)
SWAN     ICO          (nifty WaverlyStreet Windows icon)
WORKER   DAT          (worker info - only if you create it ("W" at main
                       screen))
TIME     SDV          (time sub division labels)
MONEY    SDV          (money sub division labels)


After running the program through all it's paces, your CURRENT directory
should look like this:

Directory of C:\QUICKREF\CURRENT

.            <DIR>
..           <DIR>
TIME     DAT          (time records)
PROJECTS DAT          (project header records)
MONEY    DAT          (money records)
[proj]   REC          (plain text file(s) containing your project notes where
                         [PROJ] is your project's number)

After a while (once you have closed out some projects) your archive directory
will look like this:

Directory of C:\QUICKREF\ARCHIVE

[proj]   REC          (same as above)
PROJECTS DAT          (same as above)
TIME     DAT          (same as above)
MONEY    DAT          (same as above)

If you are connected to a LAN, and wish for other QuickRef users to be able to
view your records, create "mirror" directories on the server, and specify them
in setup. When you press "M" at the main screen, the Mirror Update utility
will copy all the files from your local data directories to the mirror
directories.

Suggested network server mirror directory structure (assuming drive "F"):

     F:\QRM
           |
          F:\QRM\[user initials] - A sub directory for each user.
               |
              F:\QRM\[user initials]\CURRENT
              F:\QRM\[user initials]\ARCHIVE

Note: the installation utilities create a QRM directory and CURRENT and
ARCHIVE directories, within the LOCAL QUICKREF directory. If you are not on a
LAN, just leave this default set-up alone. However, if you ARE on a LAN, you
need to manually create new mirror directories as outlined above.

Again, the words "CURRENT" and "ARCHIVE" MUST be used!

Finally, the program creates and removes numerous temporary "scratch" files
during the course of normal operation. These files have several different
names, all with the extension ".@@@" Under certain circumstances (power
failures, etc.), the program may fail to delete these files, and you might get
some odd results such as "extra" information pasted onto reports. Once the
problem circumstances are corrected, the program should clear the stray
scratch files on it's own. At any time, however, you are safe to delete any
files with the .@@@ extension from the QuickRef file structure.

-----------------------------------------------------------------------------
24) Limitations
-----------------------------------------------------------------------------
I believe QuickRef is set up to handle more than large enough numbers of this
and that for normal usage, but just so you know, here are some limits:

The maximum number of active line items in either the TIME or the MONEY data
files is 32,767 (each may have that many). The program will warn you that you
are approaching the limit at 20,000, and again (more urgently) at 30,000. In
general, the smaller the data files, the faster the operation. (I have tested
all functions of the program with computer-generated test data files over
32,000 entries. No problems except that it gets rather slow!)

Note: If your archive records are approaching the limit, make another archive
directory and change SETUP to show it as the default. (There can be as many as
you need)

The maximum number of projects and workers is also 32,767.

Individual line item values for money should not exceed six places to the left
of the decimal point ($ 999,999.99). For time, four places (9999.99 hours).

Project subtotals for money should not exceed eight places to the left of the
decimal point ($ 99,999,999.99). For time, six places (999,999.99 hours)

Grand totals for money (all records in the system) should not exceed nine
places to the left of the decimal point ($ 999,999,999.99). For time, seven
places (9,999,999.99 hours).

(Actually, the program can handle the math required for fifteen places to the
left of the decimal, but it seems a little silly to accommodate that in the
screen and report layouts. If you are dealing with numbers that large, go buy
an accounting firm!)

The maximum number of text lines (largest report) that the file browser can
handle is also the magical 32,767.

If QuickRef is not registered, after 45 days all print output will have a
little registration reminder appended to it.

-----------------------------------------------------------------------------
25) Utility programs
-----------------------------------------------------------------------------
As QuickRef has evolved, it has been necessary to create three data conversion
utilities, to ensure that existing data works with new program features. Here
is a brief description of each:

1) QRDATES.EXE converts the dates in line-item data (TIME.DAT and MONEY.DAT)
back and forth between "American" format (MM-DD-YYYY) to "European" format
(DD-MM-YYYY). Versions prior to 2.0 only allowed the "American" format -
QRDATES fixes these older records for "European" users. QRDATES is not
included in any packaged release; it must be downloaded separately from the
WaverlyStreet web site.

2) 223_PROJ.EXE converts PROJECT.DAT files from version 2.22 and earlier to a
new format for use with version 2.23 and later. This conversion is REQUIRED -
the old records simply won't work with the new program! The new program will
automatically detect that the records need to be changed, and will offer to run
223_PROJ.EXE for you when it encounters them. If the automatic conversion
fails, 223_PROJ.EXE may be run from the command line. It must be located in
the same directory as QR.EXE. 223_PROJ.EXE is included and installed with
version 3.0; eventually I will not include it, but instead make it available
for separate download.

3) FIX_INIT.EXE would only be used upon encountering a "Time cost is
inaccurate" message in a printed report, and then only under certain
circumstances. The error message is telling you that QuickRef was unable to
match up all all records in the report with corresponding worker rate data.
The most likely cause of this would be that you have not entered your initials
in the setup area (<F10> at the main screen), and/or that you have not
created a WORKER.DAT file with a corresponding entry for yourself. The first
thing to do in this case is to check setup for the initials; if there are
none, then you may want to run FIX_INIT.EXE. If there are initials, then check
your WORKER.DAT by pressing <W> at the main screen; if there is no entry which
matches the setup screen, then try adding one, and see if that fixes the
problem. If not, then you may want to run FIX_INIT.EXE. Caution: the utility
is a rather blunt instrument! If you have been trying to track time for
several people, don't use it, as it will destroy the distinction between them.
On the other hand, if you are only tracking your own time, then FIX_INIT.EXE
should fix all your problems. FIX_INIT.EXE is included and installed with
version 3.0.

These are all separate programs, with their own documentation. You may
safely start any of them and then chose to stop without causing any harm.

-----------------------------------------------------------------------------
      Please report bugs & make suggestions to:  dgjess@infinet.com
-----------------------------------------------------------------------------
 QuickRef Project Assistant - (C) 1997-98 WaverlyStreet. All Rights Reserved
-----------------------------------------------------------------------------

