/* texttest.c -- Listing 7. */

#include <stdlib.h>
#include <stdio.h>
#include "textbuf.h"

#define NROWS 3         /* Size of test buffer */
#define NCOLS 8
/*----------------------------------------------------------------------*/
void printbuf( textbuf *b, int verify )
{
    /* Print the buffer. The cursor position is indicated by
     * parenthesizing the buffer entry at the current cursor
     * position. If "verify" is true, an error message is
     * printed if the buffer does not hold its original
     * contents (as set up in main()):  a b c d e f g h
     *                                  i j k l m n o p
     *                                  q r s t u v w x
     */

    int i, row, col, startrow, startcol, expected;

    startrow = b_row(b);
    startcol = b_col(b);

    expected = 0;
    for( row = 0; row < NROWS; ++row )
    {
        for( col = 0; col < NCOLS; ++col )
        {
            b_setrc(b, row, col);
            if( *b_current(b) == 'a' + expected++  ||  !verify )
            {
                if( startrow == row && startcol == col )
                    printf("(%c)", *b_current(b) );
                else
                    printf(" %c ", *b_current(b) );
            }
            else
                printf("something's wrong\n");

            if( b_ateol(b) )
            {
                if( b_ateob(b) )
                    printf("    <- Last line");
                printf("\n");
            }
        }
    }
    b_setrc(b, startrow, startcol);
}
/*----------------------------------------------------------------------*/
void valid_test( textbuf *b )
{
    int row, col;
    printf("\nThese indexes (r,c) are invalid in a %d by %d buffer:\n",
                                                b_nrows(b), b_ncols(b) );
    for( row = -1; row <= NROWS; ++ row )
    {
        for( col = -1; col <= NCOLS; ++ col )
            if( !b_valid( b, row, col ) )
                printf( "(%2d,%2d) ", row, col );
        printf("\n");
    }
    printf("\n");
}
/*----------------------------------------------------------------------*/
void crlf_test( textbuf *b )
{
    printf("Issuing LF:\n");
    b_lf( b );
    printbuf(b, 0);

    printf("\nIssuing CR:\n");
    b_cr( b );
    printbuf(b, 0);
}
/*----------------------------------------------------------------------*/
void clear_test( textbuf *b )
{
    printf("\nResetting cursor to (1,3):\n");
    b_setrc(b, 1, 3 );
    printbuf(b, 0);

    printf("\nDeleting three characters, using ' ' fill:\n" );
    b_delete_c(b, 3, ' ');
    printbuf(b, 0);

    printf("\nInserting three characters, using '.' fill:\n");
    b_insert_c( b, 1, '.' );
    b_insert_c( b, 2, '.' );
    printbuf(b, 0);

    printf( "\nClearing entire line, '-' fill\n" );
    b_clearline( b, '-' );
    printbuf(b, 0);

    printf( "\nDeleting line 1, moving top text down, '+' fill:\n");
    b_setrc(b, 1, 3 );
    b_closeup(b, '+');
    printbuf(b, 0);

    printf( "\nDeleting top line, moving bottom text up, '*' fill:\n");
    b_setrc(b, 0, 3 );
    b_closedown(b, '*');
    printbuf(b, 0);

    printf( "\nOpening top line, pushing text down, '%' fill:\n");
    b_opendown(b, '%');
    printbuf(b, 0);

    printf( "\nOpening middle line, pushing text up, '#' fill:\n");
    b_setrc(b, 1, 3 );
    b_openup(b, '#');
    printbuf(b, 0);

    printf( "\nClearing buffer, '@' fill:\n");
    b_clearbuf(b,'@');
    printbuf(b, 0);
}
/*----------------------------------------------------------------------*/
main()
{
    int row, col, i;
    textbuf *b;

    if( !(b = b_new( NROWS, NCOLS )) )
        printf( "Can't allocate the textbuf\n" );

    /* Initialize buffer as if it's a 1-dimensional array.
     * It's initialized to:     a b c d e f g h
     *                          i j k l m n o p
     *                          q r s t u v w x
     */

    b_setrc(b,0,0);
    for( i = 0; i < NROWS * NCOLS; ++i )
        *b_advance( b ) = 'a' + i;

    b_setrc(b, 1, 4);
    printbuf( b, 1 );

    valid_test( b );
    crlf_test ( b );
    clear_test( b );

    return 0;
}
