/* 
 * Include file for Winaux/PMaux.
 * See WPMAUX.DOC for usage
 *
 * Written by William S. Hall
 *
 */

char auxbuf[80];
void auxprt(char *str)
{

    HWND hWnd;
    int len = strlen(str);

/* use this section for windows */
#if defined(WINAUX)
  /* get the handle for winaux from win.ini */
    hWnd = (HWND)GetProfileInt((LPSTR)"Winaux", (LPSTR)"hWnd", 0);
  /* send over the buffer */
    if (IsWindow(hWnd))
	SendMessage(hWnd, WM_USER, (WORD)len, (LONG)(LPSTR)str);
#endif

/* use this section for Presentation Manager */
#if defined(PMAUX)
    char hbuf[40];
    SEL sel;
    PCH pchBuf;
    int i;

  /* get the string representation of the handle for pmaux from OS2.INI */
    WinQueryProfileString(hAB, "PMaux", "hWnd", "", hbuf, 40);
  /* convert to a handle */
    hWnd = (HWND)atol(hbuf);
    if (WinIsWindow(hAB, hWnd)) {
      /* create a shared buffer which can be read by another process */
        if (DosAllocSeg(len, &sel, SEG_GETTABLE) == 0) {
          /* make a long pointer to the buffer */
	    pchBuf = MAKEP(sel,0);
          /* load it up */
   	    for (i = 0; i < len; i++)
	        *(pchBuf+i) = *(str+i);
          /* send it over */
	    WinSendMsg(hWnd, WM_USER, (MPARAM)len, (MPARAM)sel);
          /* free the buffer */
	    DosFreeSeg(sel);
        }
        else  /* error, ring the bell */
	    WinAlarm(HWND_DESKTOP, WA_WARNING);    
    }
#endif
}
